@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.ConfigurationPolicyArgs.builder
import com.pulumi.aws.securityhub.kotlin.inputs.ConfigurationPolicyConfigurationPolicyArgs
import com.pulumi.aws.securityhub.kotlin.inputs.ConfigurationPolicyConfigurationPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages Security Hub configuration policy
 * > **NOTE:** This resource requires `aws.securityhub.OrganizationConfiguration` to be configured of type `CENTRAL`. More information about Security Hub central configuration and configuration policies can be found in the [How Security Hub configuration policies work](https://docs.aws.amazon.com/securityhub/latest/userguide/configuration-policies-overview.html) documentation.
 * ## Example Usage
 * ### Default standards enabled
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.FindingAggregator("example", {linkingMode: "ALL_REGIONS"});
 * const exampleOrganizationConfiguration = new aws.securityhub.OrganizationConfiguration("example", {
 *     autoEnable: false,
 *     autoEnableStandards: "NONE",
 *     organizationConfiguration: {
 *         configurationType: "CENTRAL",
 *     },
 * }, {
 *     dependsOn: [example],
 * });
 * const exampleConfigurationPolicy = new aws.securityhub.ConfigurationPolicy("example", {
 *     name: "Example",
 *     description: "This is an example configuration policy",
 *     configurationPolicy: {
 *         serviceEnabled: true,
 *         enabledStandardArns: [
 *             "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *             "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *         ],
 *         securityControlsConfiguration: {
 *             disabledControlIdentifiers: [],
 *         },
 *     },
 * }, {
 *     dependsOn: [exampleOrganizationConfiguration],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.FindingAggregator("example", linking_mode="ALL_REGIONS")
 * example_organization_configuration = aws.securityhub.OrganizationConfiguration("example",
 *     auto_enable=False,
 *     auto_enable_standards="NONE",
 *     organization_configuration={
 *         "configuration_type": "CENTRAL",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * example_configuration_policy = aws.securityhub.ConfigurationPolicy("example",
 *     name="Example",
 *     description="This is an example configuration policy",
 *     configuration_policy={
 *         "service_enabled": True,
 *         "enabled_standard_arns": [
 *             "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *             "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *         ],
 *         "security_controls_configuration": {
 *             "disabled_control_identifiers": [],
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_organization_configuration]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "ALL_REGIONS",
 *     });
 *     var exampleOrganizationConfiguration = new Aws.SecurityHub.OrganizationConfiguration("example", new()
 *     {
 *         AutoEnable = false,
 *         AutoEnableStandards = "NONE",
 *         OrganizationConfigurationDetails = new Aws.SecurityHub.Inputs.OrganizationConfigurationOrganizationConfigurationArgs
 *         {
 *             ConfigurationType = "CENTRAL",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 *     var exampleConfigurationPolicy = new Aws.SecurityHub.ConfigurationPolicy("example", new()
 *     {
 *         Name = "Example",
 *         Description = "This is an example configuration policy",
 *         ConfigurationPolicyDetails = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicyArgs
 *         {
 *             ServiceEnabled = true,
 *             EnabledStandardArns = new[]
 *             {
 *                 "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *                 "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *             },
 *             SecurityControlsConfiguration = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs
 *             {
 *                 DisabledControlIdentifiers = new() { },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleOrganizationConfiguration,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("ALL_REGIONS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleOrganizationConfiguration, err := securityhub.NewOrganizationConfiguration(ctx, "example", &securityhub.OrganizationConfigurationArgs{
 * 			AutoEnable:          pulumi.Bool(false),
 * 			AutoEnableStandards: pulumi.String("NONE"),
 * 			OrganizationConfiguration: &securityhub.OrganizationConfigurationOrganizationConfigurationArgs{
 * 				ConfigurationType: pulumi.String("CENTRAL"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewConfigurationPolicy(ctx, "example", &securityhub.ConfigurationPolicyArgs{
 * 			Name:        pulumi.String("Example"),
 * 			Description: pulumi.String("This is an example configuration policy"),
 * 			ConfigurationPolicy: &securityhub.ConfigurationPolicyConfigurationPolicyArgs{
 * 				ServiceEnabled: pulumi.Bool(true),
 * 				EnabledStandardArns: pulumi.StringArray{
 * 					pulumi.String("arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0"),
 * 					pulumi.String("arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0"),
 * 				},
 * 				SecurityControlsConfiguration: &securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs{
 * 					DisabledControlIdentifiers: pulumi.StringArray{},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleOrganizationConfiguration,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.aws.securityhub.OrganizationConfiguration;
 * import com.pulumi.aws.securityhub.OrganizationConfigurationArgs;
 * import com.pulumi.aws.securityhub.inputs.OrganizationConfigurationOrganizationConfigurationArgs;
 * import com.pulumi.aws.securityhub.ConfigurationPolicy;
 * import com.pulumi.aws.securityhub.ConfigurationPolicyArgs;
 * import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs;
 * import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FindingAggregator("example", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS")
 *             .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnable(false)
 *             .autoEnableStandards("NONE")
 *             .organizationConfiguration(OrganizationConfigurationOrganizationConfigurationArgs.builder()
 *                 .configurationType("CENTRAL")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var exampleConfigurationPolicy = new ConfigurationPolicy("exampleConfigurationPolicy", ConfigurationPolicyArgs.builder()
 *             .name("Example")
 *             .description("This is an example configuration policy")
 *             .configurationPolicy(ConfigurationPolicyConfigurationPolicyArgs.builder()
 *                 .serviceEnabled(true)
 *                 .enabledStandardArns(
 *                     "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *                     "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0")
 *                 .securityControlsConfiguration(ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs.builder()
 *                     .disabledControlIdentifiers()
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleOrganizationConfiguration)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:FindingAggregator
 *     properties:
 *       linkingMode: ALL_REGIONS
 *   exampleOrganizationConfiguration:
 *     type: aws:securityhub:OrganizationConfiguration
 *     name: example
 *     properties:
 *       autoEnable: false
 *       autoEnableStandards: NONE
 *       organizationConfiguration:
 *         configurationType: CENTRAL
 *     options:
 *       dependson:
 *         - ${example}
 *   exampleConfigurationPolicy:
 *     type: aws:securityhub:ConfigurationPolicy
 *     name: example
 *     properties:
 *       name: Example
 *       description: This is an example configuration policy
 *       configurationPolicy:
 *         serviceEnabled: true
 *         enabledStandardArns:
 *           - arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0
 *           - arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0
 *         securityControlsConfiguration:
 *           disabledControlIdentifiers: []
 *     options:
 *       dependson:
 *         - ${exampleOrganizationConfiguration}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Disabled Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const disabled = new aws.securityhub.ConfigurationPolicy("disabled", {
 *     name: "Disabled",
 *     description: "This is an example of disabled configuration policy",
 *     configurationPolicy: {
 *         serviceEnabled: false,
 *     },
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * disabled = aws.securityhub.ConfigurationPolicy("disabled",
 *     name="Disabled",
 *     description="This is an example of disabled configuration policy",
 *     configuration_policy={
 *         "service_enabled": False,
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disabled = new Aws.SecurityHub.ConfigurationPolicy("disabled", new()
 *     {
 *         Name = "Disabled",
 *         Description = "This is an example of disabled configuration policy",
 *         ConfigurationPolicyDetails = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicyArgs
 *         {
 *             ServiceEnabled = false,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityhub.NewConfigurationPolicy(ctx, "disabled", &securityhub.ConfigurationPolicyArgs{
 * 			Name:        pulumi.String("Disabled"),
 * 			Description: pulumi.String("This is an example of disabled configuration policy"),
 * 			ConfigurationPolicy: &securityhub.ConfigurationPolicyConfigurationPolicyArgs{
 * 				ServiceEnabled: pulumi.Bool(false),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.ConfigurationPolicy;
 * import com.pulumi.aws.securityhub.ConfigurationPolicyArgs;
 * import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disabled = new ConfigurationPolicy("disabled", ConfigurationPolicyArgs.builder()
 *             .name("Disabled")
 *             .description("This is an example of disabled configuration policy")
 *             .configurationPolicy(ConfigurationPolicyConfigurationPolicyArgs.builder()
 *                 .serviceEnabled(false)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   disabled:
 *     type: aws:securityhub:ConfigurationPolicy
 *     properties:
 *       name: Disabled
 *       description: This is an example of disabled configuration policy
 *       configurationPolicy:
 *         serviceEnabled: false
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Control Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const disabled = new aws.securityhub.ConfigurationPolicy("disabled", {
 *     name: "Custom Controls",
 *     description: "This is an example of configuration policy with custom control settings",
 *     configurationPolicy: {
 *         serviceEnabled: true,
 *         enabledStandardArns: [
 *             "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *             "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *         ],
 *         securityControlsConfiguration: {
 *             enabledControlIdentifiers: [
 *                 "APIGateway.1",
 *                 "IAM.7",
 *             ],
 *             securityControlCustomParameters: [
 *                 {
 *                     securityControlId: "APIGateway.1",
 *                     parameters: [{
 *                         name: "loggingLevel",
 *                         valueType: "CUSTOM",
 *                         "enum": {
 *                             value: "INFO",
 *                         },
 *                     }],
 *                 },
 *                 {
 *                     securityControlId: "IAM.7",
 *                     parameters: [
 *                         {
 *                             name: "RequireLowercaseCharacters",
 *                             valueType: "CUSTOM",
 *                             bool: {
 *                                 value: false,
 *                             },
 *                         },
 *                         {
 *                             name: "MaxPasswordAge",
 *                             valueType: "CUSTOM",
 *                             int: {
 *                                 value: 60,
 *                             },
 *                         },
 *                     ],
 *                 },
 *             ],
 *         },
 *     },
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * disabled = aws.securityhub.ConfigurationPolicy("disabled",
 *     name="Custom Controls",
 *     description="This is an example of configuration policy with custom control settings",
 *     configuration_policy={
 *         "service_enabled": True,
 *         "enabled_standard_arns": [
 *             "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *             "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *         ],
 *         "security_controls_configuration": {
 *             "enabled_control_identifiers": [
 *                 "APIGateway.1",
 *                 "IAM.7",
 *             ],
 *             "security_control_custom_parameters": [
 *                 {
 *                     "security_control_id": "APIGateway.1",
 *                     "parameters": [{
 *                         "name": "loggingLevel",
 *                         "value_type": "CUSTOM",
 *                         "enum": {
 *                             "value": "INFO",
 *                         },
 *                     }],
 *                 },
 *                 {
 *                     "security_control_id": "IAM.7",
 *                     "parameters": [
 *                         {
 *                             "name": "RequireLowercaseCharacters",
 *                             "value_type": "CUSTOM",
 *                             "bool": {
 *                                 "value": False,
 *                             },
 *                         },
 *                         {
 *                             "name": "MaxPasswordAge",
 *                             "value_type": "CUSTOM",
 *                             "int": {
 *                                 "value": 60,
 *                             },
 *                         },
 *                     ],
 *                 },
 *             ],
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disabled = new Aws.SecurityHub.ConfigurationPolicy("disabled", new()
 *     {
 *         Name = "Custom Controls",
 *         Description = "This is an example of configuration policy with custom control settings",
 *         ConfigurationPolicyDetails = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicyArgs
 *         {
 *             ServiceEnabled = true,
 *             EnabledStandardArns = new[]
 *             {
 *                 "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *                 "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *             },
 *             SecurityControlsConfiguration = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs
 *             {
 *                 EnabledControlIdentifiers = new[]
 *                 {
 *                     "APIGateway.1",
 *                     "IAM.7",
 *                 },
 *                 SecurityControlCustomParameters = new[]
 *                 {
 *                     new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs
 *                     {
 *                         SecurityControlId = "APIGateway.1",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs
 *                             {
 *                                 Name = "loggingLevel",
 *                                 ValueType = "CUSTOM",
 *                                 Enum = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs
 *                                 {
 *                                     Value = "INFO",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs
 *                     {
 *                         SecurityControlId = "IAM.7",
 *                         Parameters = new[]
 *                         {
 *                             new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs
 *                             {
 *                                 Name = "RequireLowercaseCharacters",
 *                                 ValueType = "CUSTOM",
 *                                 Bool = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs
 *                                 {
 *                                     Value = false,
 *                                 },
 *                             },
 *                             new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs
 *                             {
 *                                 Name = "MaxPasswordAge",
 *                                 ValueType = "CUSTOM",
 *                                 Int = new Aws.SecurityHub.Inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs
 *                                 {
 *                                     Value = 60,
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityhub.NewConfigurationPolicy(ctx, "disabled", &securityhub.ConfigurationPolicyArgs{
 * 			Name:        pulumi.String("Custom Controls"),
 * 			Description: pulumi.String("This is an example of configuration policy with custom control settings"),
 * 			ConfigurationPolicy: &securityhub.ConfigurationPolicyConfigurationPolicyArgs{
 * 				ServiceEnabled: pulumi.Bool(true),
 * 				EnabledStandardArns: pulumi.StringArray{
 * 					pulumi.String("arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0"),
 * 					pulumi.String("arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0"),
 * 				},
 * 				SecurityControlsConfiguration: &securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs{
 * 					EnabledControlIdentifiers: pulumi.StringArray{
 * 						pulumi.String("APIGateway.1"),
 * 						pulumi.String("IAM.7"),
 * 					},
 * 					SecurityControlCustomParameters: securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArray{
 * 						&securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs{
 * 							SecurityControlId: pulumi.String("APIGateway.1"),
 * 							Parameters: securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArray{
 * 								&securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs{
 * 									Name:      pulumi.String("loggingLevel"),
 * 									ValueType: pulumi.String("CUSTOM"),
 * 									Enum: &securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs{
 * 										Value: pulumi.String("INFO"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						&securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs{
 * 							SecurityControlId: pulumi.String("IAM.7"),
 * 							Parameters: securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArray{
 * 								&securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs{
 * 									Name:      pulumi.String("RequireLowercaseCharacters"),
 * 									ValueType: pulumi.String("CUSTOM"),
 * 									Bool: &securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs{
 * 										Value: pulumi.Bool(false),
 * 									},
 * 								},
 * 								&securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs{
 * 									Name:      pulumi.String("MaxPasswordAge"),
 * 									ValueType: pulumi.String("CUSTOM"),
 * 									Int: &securityhub.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs{
 * 										Value: pulumi.Int(60),
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.ConfigurationPolicy;
 * import com.pulumi.aws.securityhub.ConfigurationPolicyArgs;
 * import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs;
 * import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disabled = new ConfigurationPolicy("disabled", ConfigurationPolicyArgs.builder()
 *             .name("Custom Controls")
 *             .description("This is an example of configuration policy with custom control settings")
 *             .configurationPolicy(ConfigurationPolicyConfigurationPolicyArgs.builder()
 *                 .serviceEnabled(true)
 *                 .enabledStandardArns(
 *                     "arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0",
 *                     "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0")
 *                 .securityControlsConfiguration(ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs.builder()
 *                     .enabledControlIdentifiers(
 *                         "APIGateway.1",
 *                         "IAM.7")
 *                     .securityControlCustomParameters(
 *                         ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs.builder()
 *                             .securityControlId("APIGateway.1")
 *                             .parameters(ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs.builder()
 *                                 .name("loggingLevel")
 *                                 .valueType("CUSTOM")
 *                                 .enum_(ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs.builder()
 *                                     .value("INFO")
 *                                     .build())
 *                                 .build())
 *                             .build(),
 *                         ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs.builder()
 *                             .securityControlId("IAM.7")
 *                             .parameters(
 *                                 ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs.builder()
 *                                     .name("RequireLowercaseCharacters")
 *                                     .valueType("CUSTOM")
 *                                     .bool(ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs.builder()
 *                                         .value(false)
 *                                         .build())
 *                                     .build(),
 *                                 ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs.builder()
 *                                     .name("MaxPasswordAge")
 *                                     .valueType("CUSTOM")
 *                                     .int_(ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs.builder()
 *                                         .value(60)
 *                                         .build())
 *                                     .build())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   disabled:
 *     type: aws:securityhub:ConfigurationPolicy
 *     properties:
 *       name: Custom Controls
 *       description: This is an example of configuration policy with custom control settings
 *       configurationPolicy:
 *         serviceEnabled: true
 *         enabledStandardArns:
 *           - arn:aws:securityhub:us-east-1::standards/aws-foundational-security-best-practices/v/1.0.0
 *           - arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0
 *         securityControlsConfiguration:
 *           enabledControlIdentifiers:
 *             - APIGateway.1
 *             - IAM.7
 *           securityControlCustomParameters:
 *             - securityControlId: APIGateway.1
 *               parameters:
 *                 - name: loggingLevel
 *                   valueType: CUSTOM
 *                   enum:
 *                     value: INFO
 *             - securityControlId: IAM.7
 *               parameters:
 *                 - name: RequireLowercaseCharacters
 *                   valueType: CUSTOM
 *                   bool:
 *                     value: false
 *                 - name: MaxPasswordAge
 *                   valueType: CUSTOM
 *                   int:
 *                     value: 60
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an existing Security Hub enabled account using the universally unique identifier (UUID) of the policy. For example:
 * ```sh
 * $ pulumi import aws:securityhub/configurationPolicy:ConfigurationPolicy example "00000000-1111-2222-3333-444444444444"
 * ```
 * @property configurationPolicy Defines how Security Hub is configured. See below.
 * @property description The description of the configuration policy.
 * @property name The name of the configuration policy.
 */
public data class ConfigurationPolicyArgs(
    public val configurationPolicy: Output<ConfigurationPolicyConfigurationPolicyArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.ConfigurationPolicyArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.ConfigurationPolicyArgs =
        com.pulumi.aws.securityhub.ConfigurationPolicyArgs.builder()
            .configurationPolicy(
                configurationPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationPolicyArgs].
 */
@PulumiTagMarker
public class ConfigurationPolicyArgsBuilder internal constructor() {
    private var configurationPolicy: Output<ConfigurationPolicyConfigurationPolicyArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Defines how Security Hub is configured. See below.
     */
    @JvmName("ckupolqiisymvakc")
    public suspend fun configurationPolicy(`value`: Output<ConfigurationPolicyConfigurationPolicyArgs>) {
        this.configurationPolicy = value
    }

    /**
     * @param value The description of the configuration policy.
     */
    @JvmName("wavtggcmflndakyn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the configuration policy.
     */
    @JvmName("qfcieujxmxfojtji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines how Security Hub is configured. See below.
     */
    @JvmName("bupwaebjxebqhmjh")
    public suspend fun configurationPolicy(`value`: ConfigurationPolicyConfigurationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationPolicy = mapped
    }

    /**
     * @param argument Defines how Security Hub is configured. See below.
     */
    @JvmName("mdjebjmqkwoutrhn")
    public suspend fun configurationPolicy(argument: suspend ConfigurationPolicyConfigurationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationPolicyConfigurationPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configurationPolicy = mapped
    }

    /**
     * @param value The description of the configuration policy.
     */
    @JvmName("uiyqeynabfqftsba")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the configuration policy.
     */
    @JvmName("bkwffplyehmpyufw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ConfigurationPolicyArgs = ConfigurationPolicyArgs(
        configurationPolicy = configurationPolicy,
        description = description,
        name = name,
    )
}
