@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FindingAggregator].
 */
@PulumiTagMarker
public class FindingAggregatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FindingAggregatorArgs = FindingAggregatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FindingAggregatorArgsBuilder.() -> Unit) {
        val builder = FindingAggregatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FindingAggregator {
        val builtJavaResource = com.pulumi.aws.securityhub.FindingAggregator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FindingAggregator(builtJavaResource)
    }
}

/**
 * Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.
 * ## Example Usage
 * ### All Regions Usage
 * The following example will enable the aggregator for every region.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {linkingMode: "ALL_REGIONS"}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="ALL_REGIONS",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "ALL_REGIONS",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("ALL_REGIONS"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: ALL_REGIONS
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### All Regions Except Specified Regions Usage
 * The following example will enable the aggregator for every region except those specified in `specified_regions`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {
 *     linkingMode: "ALL_REGIONS_EXCEPT_SPECIFIED",
 *     specifiedRegions: [
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example",
 *     linking_mode="ALL_REGIONS_EXCEPT_SPECIFIED",
 *     specified_regions=[
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "ALL_REGIONS_EXCEPT_SPECIFIED",
 *         SpecifiedRegions = new[]
 *         {
 *             "eu-west-1",
 *             "eu-west-2",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("ALL_REGIONS_EXCEPT_SPECIFIED"),
 * 			SpecifiedRegions: pulumi.StringArray{
 * 				pulumi.String("eu-west-1"),
 * 				pulumi.String("eu-west-2"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS_EXCEPT_SPECIFIED")
 *             .specifiedRegions(
 *                 "eu-west-1",
 *                 "eu-west-2")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: ALL_REGIONS_EXCEPT_SPECIFIED
 *       specifiedRegions:
 *         - eu-west-1
 *         - eu-west-2
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Specified Regions Usage
 * The following example will enable the aggregator for every region specified in `specified_regions`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {
 *     linkingMode: "SPECIFIED_REGIONS",
 *     specifiedRegions: [
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example",
 *     linking_mode="SPECIFIED_REGIONS",
 *     specified_regions=[
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "SPECIFIED_REGIONS",
 *         SpecifiedRegions = new[]
 *         {
 *             "eu-west-1",
 *             "eu-west-2",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("SPECIFIED_REGIONS"),
 * 			SpecifiedRegions: pulumi.StringArray{
 * 				pulumi.String("eu-west-1"),
 * 				pulumi.String("eu-west-2"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("SPECIFIED_REGIONS")
 *             .specifiedRegions(
 *                 "eu-west-1",
 *                 "eu-west-2")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: SPECIFIED_REGIONS
 *       specifiedRegions:
 *         - eu-west-1
 *         - eu-west-2
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
 * ```
 */
public class FindingAggregator internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.FindingAggregator,
) : KotlinCustomResource(javaResource, FindingAggregatorMapper) {
    /**
     * Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
     */
    public val linkingMode: Output<String>
        get() = javaResource.linkingMode().applyValue({ args0 -> args0 })

    /**
     * List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
     */
    public val specifiedRegions: Output<List<String>>?
        get() = javaResource.specifiedRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object FindingAggregatorMapper : ResourceMapper<FindingAggregator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.FindingAggregator::class == javaResource::class

    override fun map(javaResource: Resource): FindingAggregator = FindingAggregator(
        javaResource as
            com.pulumi.aws.securityhub.FindingAggregator,
    )
}

/**
 * @see [FindingAggregator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FindingAggregator].
 */
public suspend fun findingAggregator(
    name: String,
    block: suspend FindingAggregatorResourceBuilder.() -> Unit,
): FindingAggregator {
    val builder = FindingAggregatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FindingAggregator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun findingAggregator(name: String): FindingAggregator {
    val builder = FindingAggregatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
