@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.FindingAggregatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.
 * ## Example Usage
 * ### All Regions Usage
 * The following example will enable the aggregator for every region.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {linkingMode: "ALL_REGIONS"}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="ALL_REGIONS",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "ALL_REGIONS",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("ALL_REGIONS"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: ALL_REGIONS
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### All Regions Except Specified Regions Usage
 * The following example will enable the aggregator for every region except those specified in `specified_regions`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {
 *     linkingMode: "ALL_REGIONS_EXCEPT_SPECIFIED",
 *     specifiedRegions: [
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example",
 *     linking_mode="ALL_REGIONS_EXCEPT_SPECIFIED",
 *     specified_regions=[
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "ALL_REGIONS_EXCEPT_SPECIFIED",
 *         SpecifiedRegions = new[]
 *         {
 *             "eu-west-1",
 *             "eu-west-2",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("ALL_REGIONS_EXCEPT_SPECIFIED"),
 * 			SpecifiedRegions: pulumi.StringArray{
 * 				pulumi.String("eu-west-1"),
 * 				pulumi.String("eu-west-2"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS_EXCEPT_SPECIFIED")
 *             .specifiedRegions(
 *                 "eu-west-1",
 *                 "eu-west-2")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: ALL_REGIONS_EXCEPT_SPECIFIED
 *       specifiedRegions:
 *         - eu-west-1
 *         - eu-west-2
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Specified Regions Usage
 * The following example will enable the aggregator for every region specified in `specified_regions`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {
 *     linkingMode: "SPECIFIED_REGIONS",
 *     specifiedRegions: [
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example",
 *     linking_mode="SPECIFIED_REGIONS",
 *     specified_regions=[
 *         "eu-west-1",
 *         "eu-west-2",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "SPECIFIED_REGIONS",
 *         SpecifiedRegions = new[]
 *         {
 *             "eu-west-1",
 *             "eu-west-2",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("SPECIFIED_REGIONS"),
 * 			SpecifiedRegions: pulumi.StringArray{
 * 				pulumi.String("eu-west-1"),
 * 				pulumi.String("eu-west-2"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("SPECIFIED_REGIONS")
 *             .specifiedRegions(
 *                 "eu-west-1",
 *                 "eu-west-2")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: SPECIFIED_REGIONS
 *       specifiedRegions:
 *         - eu-west-1
 *         - eu-west-2
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
 * ```
 * @property linkingMode Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
 * @property specifiedRegions List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
 */
public data class FindingAggregatorArgs(
    public val linkingMode: Output<String>? = null,
    public val specifiedRegions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.FindingAggregatorArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.FindingAggregatorArgs =
        com.pulumi.aws.securityhub.FindingAggregatorArgs.builder()
            .linkingMode(linkingMode?.applyValue({ args0 -> args0 }))
            .specifiedRegions(specifiedRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FindingAggregatorArgs].
 */
@PulumiTagMarker
public class FindingAggregatorArgsBuilder internal constructor() {
    private var linkingMode: Output<String>? = null

    private var specifiedRegions: Output<List<String>>? = null

    /**
     * @param value Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
     */
    @JvmName("fvcwscfhwvuoyyqx")
    public suspend fun linkingMode(`value`: Output<String>) {
        this.linkingMode = value
    }

    /**
     * @param value List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
     */
    @JvmName("wvxsvxevtaxqqgfy")
    public suspend fun specifiedRegions(`value`: Output<List<String>>) {
        this.specifiedRegions = value
    }

    @JvmName("bbpjlhatpkketqpy")
    public suspend fun specifiedRegions(vararg values: Output<String>) {
        this.specifiedRegions = Output.all(values.asList())
    }

    /**
     * @param values List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
     */
    @JvmName("ykwwjoiqrmhxlgkh")
    public suspend fun specifiedRegions(values: List<Output<String>>) {
        this.specifiedRegions = Output.all(values)
    }

    /**
     * @param value Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
     */
    @JvmName("pnccdemcsmqnfkwt")
    public suspend fun linkingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkingMode = mapped
    }

    /**
     * @param value List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
     */
    @JvmName("roipxgkiqtnqoxxp")
    public suspend fun specifiedRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specifiedRegions = mapped
    }

    /**
     * @param values List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
     */
    @JvmName("vqkjgsgpgnstxcih")
    public suspend fun specifiedRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.specifiedRegions = mapped
    }

    internal fun build(): FindingAggregatorArgs = FindingAggregatorArgs(
        linkingMode = linkingMode,
        specifiedRegions = specifiedRegions,
    )
}
