@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.kotlin.outputs.InsightFilters
import com.pulumi.aws.securityhub.kotlin.outputs.InsightFilters.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Insight].
 */
@PulumiTagMarker
public class InsightResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InsightArgs = InsightArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InsightArgsBuilder.() -> Unit) {
        val builder = InsightArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Insight {
        val builtJavaResource = com.pulumi.aws.securityhub.Insight(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Insight(builtJavaResource)
    }
}

/**
 * Provides a Security Hub custom insight resource. See the [Managing custom insights section](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-insights.html) of the AWS User Guide for more information.
 * ## Example Usage
 * ### Filter by AWS account ID
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleInsight = new aws.securityhub.Insight("example", {
 *     filters: {
 *         awsAccountIds: [
 *             {
 *                 comparison: "EQUALS",
 *                 value: "1234567890",
 *             },
 *             {
 *                 comparison: "EQUALS",
 *                 value: "09876543210",
 *             },
 *         ],
 *     },
 *     groupByAttribute: "AwsAccountId",
 *     name: "example-insight",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_insight = aws.securityhub.Insight("example",
 *     filters={
 *         "aws_account_ids": [
 *             {
 *                 "comparison": "EQUALS",
 *                 "value": "1234567890",
 *             },
 *             {
 *                 "comparison": "EQUALS",
 *                 "value": "09876543210",
 *             },
 *         ],
 *     },
 *     group_by_attribute="AwsAccountId",
 *     name="example-insight",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleInsight = new Aws.SecurityHub.Insight("example", new()
 *     {
 *         Filters = new Aws.SecurityHub.Inputs.InsightFiltersArgs
 *         {
 *             AwsAccountIds = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.InsightFiltersAwsAccountIdArgs
 *                 {
 *                     Comparison = "EQUALS",
 *                     Value = "1234567890",
 *                 },
 *                 new Aws.SecurityHub.Inputs.InsightFiltersAwsAccountIdArgs
 *                 {
 *                     Comparison = "EQUALS",
 *                     Value = "09876543210",
 *                 },
 *             },
 *         },
 *         GroupByAttribute = "AwsAccountId",
 *         Name = "example-insight",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewInsight(ctx, "example", &securityhub.InsightArgs{
 * 			Filters: &securityhub.InsightFiltersArgs{
 * 				AwsAccountIds: securityhub.InsightFiltersAwsAccountIdArray{
 * 					&securityhub.InsightFiltersAwsAccountIdArgs{
 * 						Comparison: pulumi.String("EQUALS"),
 * 						Value:      pulumi.String("1234567890"),
 * 					},
 * 					&securityhub.InsightFiltersAwsAccountIdArgs{
 * 						Comparison: pulumi.String("EQUALS"),
 * 						Value:      pulumi.String("09876543210"),
 * 					},
 * 				},
 * 			},
 * 			GroupByAttribute: pulumi.String("AwsAccountId"),
 * 			Name:             pulumi.String("example-insight"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .awsAccountIds(
 *                     InsightFiltersAwsAccountIdArgs.builder()
 *                         .comparison("EQUALS")
 *                         .value("1234567890")
 *                         .build(),
 *                     InsightFiltersAwsAccountIdArgs.builder()
 *                         .comparison("EQUALS")
 *                         .value("09876543210")
 *                         .build())
 *                 .build())
 *             .groupByAttribute("AwsAccountId")
 *             .name("example-insight")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleInsight:
 *     type: aws:securityhub:Insight
 *     name: example
 *     properties:
 *       filters:
 *         awsAccountIds:
 *           - comparison: EQUALS
 *             value: '1234567890'
 *           - comparison: EQUALS
 *             value: '09876543210'
 *       groupByAttribute: AwsAccountId
 *       name: example-insight
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Filter by date range
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleInsight = new aws.securityhub.Insight("example", {
 *     filters: {
 *         createdAts: [{
 *             dateRange: {
 *                 unit: "DAYS",
 *                 value: 5,
 *             },
 *         }],
 *     },
 *     groupByAttribute: "CreatedAt",
 *     name: "example-insight",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_insight = aws.securityhub.Insight("example",
 *     filters={
 *         "created_ats": [{
 *             "date_range": {
 *                 "unit": "DAYS",
 *                 "value": 5,
 *             },
 *         }],
 *     },
 *     group_by_attribute="CreatedAt",
 *     name="example-insight",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleInsight = new Aws.SecurityHub.Insight("example", new()
 *     {
 *         Filters = new Aws.SecurityHub.Inputs.InsightFiltersArgs
 *         {
 *             CreatedAts = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.InsightFiltersCreatedAtArgs
 *                 {
 *                     DateRange = new Aws.SecurityHub.Inputs.InsightFiltersCreatedAtDateRangeArgs
 *                     {
 *                         Unit = "DAYS",
 *                         Value = 5,
 *                     },
 *                 },
 *             },
 *         },
 *         GroupByAttribute = "CreatedAt",
 *         Name = "example-insight",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewInsight(ctx, "example", &securityhub.InsightArgs{
 * 			Filters: &securityhub.InsightFiltersArgs{
 * 				CreatedAts: securityhub.InsightFiltersCreatedAtArray{
 * 					&securityhub.InsightFiltersCreatedAtArgs{
 * 						DateRange: &securityhub.InsightFiltersCreatedAtDateRangeArgs{
 * 							Unit:  pulumi.String("DAYS"),
 * 							Value: pulumi.Int(5),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			GroupByAttribute: pulumi.String("CreatedAt"),
 * 			Name:             pulumi.String("example-insight"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .createdAts(InsightFiltersCreatedAtArgs.builder()
 *                     .dateRange(InsightFiltersCreatedAtDateRangeArgs.builder()
 *                         .unit("DAYS")
 *                         .value(5)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .groupByAttribute("CreatedAt")
 *             .name("example-insight")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleInsight:
 *     type: aws:securityhub:Insight
 *     name: example
 *     properties:
 *       filters:
 *         createdAts:
 *           - dateRange:
 *               unit: DAYS
 *               value: 5
 *       groupByAttribute: CreatedAt
 *       name: example-insight
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Filter by destination IPv4 address
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleInsight = new aws.securityhub.Insight("example", {
 *     filters: {
 *         networkDestinationIpv4s: [{
 *             cidr: "10.0.0.0/16",
 *         }],
 *     },
 *     groupByAttribute: "NetworkDestinationIpV4",
 *     name: "example-insight",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_insight = aws.securityhub.Insight("example",
 *     filters={
 *         "network_destination_ipv4s": [{
 *             "cidr": "10.0.0.0/16",
 *         }],
 *     },
 *     group_by_attribute="NetworkDestinationIpV4",
 *     name="example-insight",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleInsight = new Aws.SecurityHub.Insight("example", new()
 *     {
 *         Filters = new Aws.SecurityHub.Inputs.InsightFiltersArgs
 *         {
 *             NetworkDestinationIpv4s = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.InsightFiltersNetworkDestinationIpv4Args
 *                 {
 *                     Cidr = "10.0.0.0/16",
 *                 },
 *             },
 *         },
 *         GroupByAttribute = "NetworkDestinationIpV4",
 *         Name = "example-insight",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewInsight(ctx, "example", &securityhub.InsightArgs{
 * 			Filters: &securityhub.InsightFiltersArgs{
 * 				NetworkDestinationIpv4s: securityhub.InsightFiltersNetworkDestinationIpv4Array{
 * 					&securityhub.InsightFiltersNetworkDestinationIpv4Args{
 * 						Cidr: pulumi.String("10.0.0.0/16"),
 * 					},
 * 				},
 * 			},
 * 			GroupByAttribute: pulumi.String("NetworkDestinationIpV4"),
 * 			Name:             pulumi.String("example-insight"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .networkDestinationIpv4s(InsightFiltersNetworkDestinationIpv4Args.builder()
 *                     .cidr("10.0.0.0/16")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("NetworkDestinationIpV4")
 *             .name("example-insight")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleInsight:
 *     type: aws:securityhub:Insight
 *     name: example
 *     properties:
 *       filters:
 *         networkDestinationIpv4s:
 *           - cidr: 10.0.0.0/16
 *       groupByAttribute: NetworkDestinationIpV4
 *       name: example-insight
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Filter by finding's confidence
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleInsight = new aws.securityhub.Insight("example", {
 *     filters: {
 *         confidences: [{
 *             gte: "80",
 *         }],
 *     },
 *     groupByAttribute: "Confidence",
 *     name: "example-insight",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_insight = aws.securityhub.Insight("example",
 *     filters={
 *         "confidences": [{
 *             "gte": "80",
 *         }],
 *     },
 *     group_by_attribute="Confidence",
 *     name="example-insight",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleInsight = new Aws.SecurityHub.Insight("example", new()
 *     {
 *         Filters = new Aws.SecurityHub.Inputs.InsightFiltersArgs
 *         {
 *             Confidences = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.InsightFiltersConfidenceArgs
 *                 {
 *                     Gte = "80",
 *                 },
 *             },
 *         },
 *         GroupByAttribute = "Confidence",
 *         Name = "example-insight",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewInsight(ctx, "example", &securityhub.InsightArgs{
 * 			Filters: &securityhub.InsightFiltersArgs{
 * 				Confidences: securityhub.InsightFiltersConfidenceArray{
 * 					&securityhub.InsightFiltersConfidenceArgs{
 * 						Gte: pulumi.String("80"),
 * 					},
 * 				},
 * 			},
 * 			GroupByAttribute: pulumi.String("Confidence"),
 * 			Name:             pulumi.String("example-insight"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .confidences(InsightFiltersConfidenceArgs.builder()
 *                     .gte("80")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("Confidence")
 *             .name("example-insight")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleInsight:
 *     type: aws:securityhub:Insight
 *     name: example
 *     properties:
 *       filters:
 *         confidences:
 *           - gte: '80'
 *       groupByAttribute: Confidence
 *       name: example-insight
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Filter by resource tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleInsight = new aws.securityhub.Insight("example", {
 *     filters: {
 *         resourceTags: [{
 *             comparison: "EQUALS",
 *             key: "Environment",
 *             value: "Production",
 *         }],
 *     },
 *     groupByAttribute: "ResourceTags",
 *     name: "example-insight",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_insight = aws.securityhub.Insight("example",
 *     filters={
 *         "resource_tags": [{
 *             "comparison": "EQUALS",
 *             "key": "Environment",
 *             "value": "Production",
 *         }],
 *     },
 *     group_by_attribute="ResourceTags",
 *     name="example-insight",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleInsight = new Aws.SecurityHub.Insight("example", new()
 *     {
 *         Filters = new Aws.SecurityHub.Inputs.InsightFiltersArgs
 *         {
 *             ResourceTags = new[]
 *             {
 *                 new Aws.SecurityHub.Inputs.InsightFiltersResourceTagArgs
 *                 {
 *                     Comparison = "EQUALS",
 *                     Key = "Environment",
 *                     Value = "Production",
 *                 },
 *             },
 *         },
 *         GroupByAttribute = "ResourceTags",
 *         Name = "example-insight",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewInsight(ctx, "example", &securityhub.InsightArgs{
 * 			Filters: &securityhub.InsightFiltersArgs{
 * 				ResourceTags: securityhub.InsightFiltersResourceTagArray{
 * 					&securityhub.InsightFiltersResourceTagArgs{
 * 						Comparison: pulumi.String("EQUALS"),
 * 						Key:        pulumi.String("Environment"),
 * 						Value:      pulumi.String("Production"),
 * 					},
 * 				},
 * 			},
 * 			GroupByAttribute: pulumi.String("ResourceTags"),
 * 			Name:             pulumi.String("example-insight"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .resourceTags(InsightFiltersResourceTagArgs.builder()
 *                     .comparison("EQUALS")
 *                     .key("Environment")
 *                     .value("Production")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("ResourceTags")
 *             .name("example-insight")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleInsight:
 *     type: aws:securityhub:Insight
 *     name: example
 *     properties:
 *       filters:
 *         resourceTags:
 *           - comparison: EQUALS
 *             key: Environment
 *             value: Production
 *       groupByAttribute: ResourceTags
 *       name: example-insight
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub insights using the ARN. For example:
 * ```sh
 * $ pulumi import aws:securityhub/insight:Insight example arn:aws:securityhub:us-west-2:1234567890:insight/1234567890/custom/91299ed7-abd0-4e44-a858-d0b15e37141a
 * ```
 */
public class Insight internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.Insight,
) : KotlinCustomResource(javaResource, InsightMapper) {
    /**
     * ARN of the insight.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A configuration block including one or more (up to 10 distinct) attributes used to filter the findings included in the insight. The insight only includes findings that match criteria defined in the filters. See filters below for more details.
     */
    public val filters: Output<InsightFilters>
        get() = javaResource.filters().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The attribute used to group the findings for the insight e.g., if an insight is grouped by `ResourceId`, then the insight produces a list of resource identifiers.
     */
    public val groupByAttribute: Output<String>
        get() = javaResource.groupByAttribute().applyValue({ args0 -> args0 })

    /**
     * The name of the custom insight.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object InsightMapper : ResourceMapper<Insight> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.Insight::class == javaResource::class

    override fun map(javaResource: Resource): Insight = Insight(
        javaResource as
            com.pulumi.aws.securityhub.Insight,
    )
}

/**
 * @see [Insight].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Insight].
 */
public suspend fun insight(name: String, block: suspend InsightResourceBuilder.() -> Unit): Insight {
    val builder = InsightResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Insight].
 * @param name The _unique_ name of the resulting resource.
 */
public fun insight(name: String): Insight {
    val builder = InsightResourceBuilder()
    builder.name(name)
    return builder.build()
}
