@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InviteAccepter].
 */
@PulumiTagMarker
public class InviteAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InviteAccepterArgs = InviteAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InviteAccepterArgsBuilder.() -> Unit) {
        val builder = InviteAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InviteAccepter {
        val builtJavaResource = com.pulumi.aws.securityhub.InviteAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InviteAccepter(builtJavaResource)
    }
}

/**
 * > **Note:** AWS accounts can only be associated with a single Security Hub master account. Destroying this resource will disassociate the member account from the master account.
 * Accepts a Security Hub invitation.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleMember = new aws.securityhub.Member("example", {
 *     accountId: "123456789012",
 *     email: "example@example.com",
 *     invite: true,
 * });
 * const invitee = new aws.securityhub.Account("invitee", {});
 * const inviteeInviteAccepter = new aws.securityhub.InviteAccepter("invitee", {masterId: exampleMember.masterId}, {
 *     dependsOn: [invitee],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_member = aws.securityhub.Member("example",
 *     account_id="123456789012",
 *     email="example@example.com",
 *     invite=True)
 * invitee = aws.securityhub.Account("invitee")
 * invitee_invite_accepter = aws.securityhub.InviteAccepter("invitee", master_id=example_member.master_id,
 * opts = pulumi.ResourceOptions(depends_on=[invitee]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleMember = new Aws.SecurityHub.Member("example", new()
 *     {
 *         AccountId = "123456789012",
 *         Email = "example@example.com",
 *         Invite = true,
 *     });
 *     var invitee = new Aws.SecurityHub.Account("invitee");
 *     var inviteeInviteAccepter = new Aws.SecurityHub.InviteAccepter("invitee", new()
 *     {
 *         MasterId = exampleMember.MasterId,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             invitee,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleMember, err := securityhub.NewMember(ctx, "example", &securityhub.MemberArgs{
 * 			AccountId: pulumi.String("123456789012"),
 * 			Email:     pulumi.String("example@example.com"),
 * 			Invite:    pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invitee, err := securityhub.NewAccount(ctx, "invitee", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewInviteAccepter(ctx, "invitee", &securityhub.InviteAccepterArgs{
 * 			MasterId: exampleMember.MasterId,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			invitee,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Member;
 * import com.pulumi.aws.securityhub.MemberArgs;
 * import com.pulumi.aws.securityhub.InviteAccepter;
 * import com.pulumi.aws.securityhub.InviteAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("123456789012")
 *             .email("example@example.com")
 *             .invite(true)
 *             .build());
 *         var invitee = new Account("invitee");
 *         var inviteeInviteAccepter = new InviteAccepter("inviteeInviteAccepter", InviteAccepterArgs.builder()
 *             .masterId(exampleMember.masterId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(invitee)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleMember:
 *     type: aws:securityhub:Member
 *     name: example
 *     properties:
 *       accountId: '123456789012'
 *       email: example@example.com
 *       invite: true
 *   invitee:
 *     type: aws:securityhub:Account
 *   inviteeInviteAccepter:
 *     type: aws:securityhub:InviteAccepter
 *     name: invitee
 *     properties:
 *       masterId: ${exampleMember.masterId}
 *     options:
 *       dependson:
 *         - ${invitee}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub invite acceptance using the account ID. For example:
 * ```sh
 * $ pulumi import aws:securityhub/inviteAccepter:InviteAccepter example 123456789012
 * ```
 */
public class InviteAccepter internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.InviteAccepter,
) : KotlinCustomResource(javaResource, InviteAccepterMapper) {
    /**
     * The ID of the invitation.
     */
    public val invitationId: Output<String>
        get() = javaResource.invitationId().applyValue({ args0 -> args0 })

    /**
     * The account ID of the master Security Hub account whose invitation you're accepting.
     */
    public val masterId: Output<String>
        get() = javaResource.masterId().applyValue({ args0 -> args0 })
}

public object InviteAccepterMapper : ResourceMapper<InviteAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.InviteAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InviteAccepter = InviteAccepter(
        javaResource as
            com.pulumi.aws.securityhub.InviteAccepter,
    )
}

/**
 * @see [InviteAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InviteAccepter].
 */
public suspend fun inviteAccepter(
    name: String,
    block: suspend InviteAccepterResourceBuilder.() -> Unit,
): InviteAccepter {
    val builder = InviteAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InviteAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inviteAccepter(name: String): InviteAccepter {
    val builder = InviteAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
