@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.MemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Security Hub member resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const exampleMember = new aws.securityhub.Member("example", {
 *     accountId: "123456789012",
 *     email: "example@example.com",
 *     invite: true,
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * example_member = aws.securityhub.Member("example",
 *     account_id="123456789012",
 *     email="example@example.com",
 *     invite=True,
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var exampleMember = new Aws.SecurityHub.Member("example", new()
 *     {
 *         AccountId = "123456789012",
 *         Email = "example@example.com",
 *         Invite = true,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewMember(ctx, "example", &securityhub.MemberArgs{
 * 			AccountId: pulumi.String("123456789012"),
 * 			Email:     pulumi.String("example@example.com"),
 * 			Invite:    pulumi.Bool(true),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Member;
 * import com.pulumi.aws.securityhub.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("123456789012")
 *             .email("example@example.com")
 *             .invite(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleMember:
 *     type: aws:securityhub:Member
 *     name: example
 *     properties:
 *       accountId: '123456789012'
 *       email: example@example.com
 *       invite: true
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub members using their account ID. For example:
 * ```sh
 * $ pulumi import aws:securityhub/member:Member example 123456789012
 * ```
 * @property accountId The ID of the member AWS account.
 * @property email The email of the member AWS account.
 * @property invite Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
 */
public data class MemberArgs(
    public val accountId: Output<String>? = null,
    public val email: Output<String>? = null,
    public val invite: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.MemberArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.MemberArgs =
        com.pulumi.aws.securityhub.MemberArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .invite(invite?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberArgs].
 */
@PulumiTagMarker
public class MemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var email: Output<String>? = null

    private var invite: Output<Boolean>? = null

    /**
     * @param value The ID of the member AWS account.
     */
    @JvmName("tqmpwyastcqyeqvr")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The email of the member AWS account.
     */
    @JvmName("kqfrfwypxrtonafk")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
     */
    @JvmName("fmrxccdkdikswfto")
    public suspend fun invite(`value`: Output<Boolean>) {
        this.invite = value
    }

    /**
     * @param value The ID of the member AWS account.
     */
    @JvmName("wbghdqmwmmfvwbjk")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The email of the member AWS account.
     */
    @JvmName("myagbwkbnkpwlaya")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
     */
    @JvmName("wndqnnmkcvvwoesf")
    public suspend fun invite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invite = mapped
    }

    internal fun build(): MemberArgs = MemberArgs(
        accountId = accountId,
        email = email,
        invite = invite,
    )
}
