@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.kotlin.outputs.OrganizationConfigurationOrganizationConfiguration
import com.pulumi.aws.securityhub.kotlin.outputs.OrganizationConfigurationOrganizationConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationConfiguration].
 */
@PulumiTagMarker
public class OrganizationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConfigurationArgs = OrganizationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConfigurationArgsBuilder.() -> Unit) {
        val builder = OrganizationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationConfiguration {
        val builtJavaResource =
            com.pulumi.aws.securityhub.OrganizationConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationConfiguration(builtJavaResource)
    }
}

/**
 * Manages the Security Hub Organization Configuration.
 * > **NOTE:** This resource requires an `aws.securityhub.OrganizationAdminAccount` to be configured (not necessarily with Pulumi). More information about managing Security Hub in an organization can be found in the [Managing administrator and member accounts](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts.html) documentation.
 * > **NOTE:** In order to set the `configuration_type` to `CENTRAL`, the delegated admin must be a member account of the organization and not the management account. Central configuration also requires an `aws.securityhub.FindingAggregator` to be configured.
 * > **NOTE:** This is an advanced AWS resource. Pulumi will automatically assume management of the Security Hub Organization Configuration without import and perform no actions on removal from the Pulumi program.
 * > **NOTE:** Deleting this resource resets security hub to a local organization configuration with auto enable false.
 * ## Example Usage
 * ### Local Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["securityhub&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const exampleOrganizationAdminAccount = new aws.securityhub.OrganizationAdminAccount("example", {adminAccountId: "123456789012"}, {
 *     dependsOn: [example],
 * });
 * const exampleOrganizationConfiguration = new aws.securityhub.OrganizationConfiguration("example", {autoEnable: true});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.Organization("example",
 *     aws_service_access_principals=["securityhub&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example_organization_admin_account = aws.securityhub.OrganizationAdminAccount("example", admin_account_id="123456789012",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * example_organization_configuration = aws.securityhub.OrganizationConfiguration("example", auto_enable=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "securityhub.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var exampleOrganizationAdminAccount = new Aws.SecurityHub.OrganizationAdminAccount("example", new()
 *     {
 *         AdminAccountId = "123456789012",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 *     var exampleOrganizationConfiguration = new Aws.SecurityHub.OrganizationConfiguration("example", new()
 *     {
 *         AutoEnable = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("securityhub.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewOrganizationAdminAccount(ctx, "example", &securityhub.OrganizationAdminAccountArgs{
 * 			AdminAccountId: pulumi.String("123456789012"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewOrganizationConfiguration(ctx, "example", &securityhub.OrganizationConfigurationArgs{
 * 			AutoEnable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccount;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccountArgs;
 * import com.pulumi.aws.securityhub.OrganizationConfiguration;
 * import com.pulumi.aws.securityhub.OrganizationConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("securityhub.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnable(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:Organization
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - securityhub.amazonaws.com
 *       featureSet: ALL
 *   exampleOrganizationAdminAccount:
 *     type: aws:securityhub:OrganizationAdminAccount
 *     name: example
 *     properties:
 *       adminAccountId: '123456789012'
 *     options:
 *       dependson:
 *         - ${example}
 *   exampleOrganizationConfiguration:
 *     type: aws:securityhub:OrganizationConfiguration
 *     name: example
 *     properties:
 *       autoEnable: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Central Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.OrganizationAdminAccount("example", {adminAccountId: "123456789012"}, {
 *     dependsOn: [exampleAwsOrganizationsOrganization],
 * });
 * const exampleFindingAggregator = new aws.securityhub.FindingAggregator("example", {linkingMode: "ALL_REGIONS"}, {
 *     dependsOn: [example],
 * });
 * const exampleOrganizationConfiguration = new aws.securityhub.OrganizationConfiguration("example", {
 *     autoEnable: false,
 *     autoEnableStandards: "NONE",
 *     organizationConfiguration: {
 *         configurationType: "CENTRAL",
 *     },
 * }, {
 *     dependsOn: [exampleFindingAggregator],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.OrganizationAdminAccount("example", admin_account_id="123456789012",
 * opts = pulumi.ResourceOptions(depends_on=[example_aws_organizations_organization]))
 * example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="ALL_REGIONS",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * example_organization_configuration = aws.securityhub.OrganizationConfiguration("example",
 *     auto_enable=False,
 *     auto_enable_standards="NONE",
 *     organization_configuration={
 *         "configuration_type": "CENTRAL",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_finding_aggregator]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.OrganizationAdminAccount("example", new()
 *     {
 *         AdminAccountId = "123456789012",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsOrganizationsOrganization,
 *         },
 *     });
 *     var exampleFindingAggregator = new Aws.SecurityHub.FindingAggregator("example", new()
 *     {
 *         LinkingMode = "ALL_REGIONS",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 *     var exampleOrganizationConfiguration = new Aws.SecurityHub.OrganizationConfiguration("example", new()
 *     {
 *         AutoEnable = false,
 *         AutoEnableStandards = "NONE",
 *         OrganizationConfigurationDetails = new Aws.SecurityHub.Inputs.OrganizationConfigurationOrganizationConfigurationArgs
 *         {
 *             ConfigurationType = "CENTRAL",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleFindingAggregator,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewOrganizationAdminAccount(ctx, "example", &securityhub.OrganizationAdminAccountArgs{
 * 			AdminAccountId: pulumi.String("123456789012"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsOrganizationsOrganization,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleFindingAggregator, err := securityhub.NewFindingAggregator(ctx, "example", &securityhub.FindingAggregatorArgs{
 * 			LinkingMode: pulumi.String("ALL_REGIONS"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewOrganizationConfiguration(ctx, "example", &securityhub.OrganizationConfigurationArgs{
 * 			AutoEnable:          pulumi.Bool(false),
 * 			AutoEnableStandards: pulumi.String("NONE"),
 * 			OrganizationConfiguration: &securityhub.OrganizationConfigurationOrganizationConfigurationArgs{
 * 				ConfigurationType: pulumi.String("CENTRAL"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleFindingAggregator,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccount;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccountArgs;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.aws.securityhub.OrganizationConfiguration;
 * import com.pulumi.aws.securityhub.OrganizationConfigurationArgs;
 * import com.pulumi.aws.securityhub.inputs.OrganizationConfigurationOrganizationConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationAdminAccount("example", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsOrganizationsOrganization)
 *                 .build());
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnable(false)
 *             .autoEnableStandards("NONE")
 *             .organizationConfiguration(OrganizationConfigurationOrganizationConfigurationArgs.builder()
 *                 .configurationType("CENTRAL")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleFindingAggregator)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:OrganizationAdminAccount
 *     properties:
 *       adminAccountId: '123456789012'
 *     options:
 *       dependson:
 *         - ${exampleAwsOrganizationsOrganization}
 *   exampleFindingAggregator:
 *     type: aws:securityhub:FindingAggregator
 *     name: example
 *     properties:
 *       linkingMode: ALL_REGIONS
 *     options:
 *       dependson:
 *         - ${example}
 *   exampleOrganizationConfiguration:
 *     type: aws:securityhub:OrganizationConfiguration
 *     name: example
 *     properties:
 *       autoEnable: false
 *       autoEnableStandards: NONE
 *       organizationConfiguration:
 *         configurationType: CENTRAL
 *     options:
 *       dependson:
 *         - ${exampleFindingAggregator}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an existing Security Hub enabled account using the AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:securityhub/organizationConfiguration:OrganizationConfiguration example 123456789012
 * ```
 */
public class OrganizationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.OrganizationConfiguration,
) : KotlinCustomResource(javaResource, OrganizationConfigurationMapper) {
    /**
     * Whether to automatically enable Security Hub for new accounts in the organization.
     */
    public val autoEnable: Output<Boolean>
        get() = javaResource.autoEnable().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically enable Security Hub default standards for new member accounts in the organization. By default, this parameter is equal to `DEFAULT`, and new member accounts are automatically enabled with default Security Hub standards. To opt out of enabling default standards for new member accounts, set this parameter equal to `NONE`.
     */
    public val autoEnableStandards: Output<String>
        get() = javaResource.autoEnableStandards().applyValue({ args0 -> args0 })

    /**
     * Provides information about the way an organization is configured in Security Hub.
     */
    public val organizationConfiguration: Output<OrganizationConfigurationOrganizationConfiguration>
        get() = javaResource.organizationConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object OrganizationConfigurationMapper : ResourceMapper<OrganizationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.OrganizationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConfiguration =
        OrganizationConfiguration(
            javaResource as
                com.pulumi.aws.securityhub.OrganizationConfiguration,
        )
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConfiguration].
 */
public suspend fun organizationConfiguration(
    name: String,
    block: suspend OrganizationConfigurationResourceBuilder.() -> Unit,
): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConfiguration(name: String): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
