@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.ProductSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subscribes to a Security Hub product.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const current = aws.getRegion({});
 * const exampleProductSubscription = new aws.securityhub.ProductSubscription("example", {productArn: current.then(current => `arn:aws:securityhub:${current.name}:733251395267:product/alertlogic/althreatmanagement`)}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * current = aws.get_region()
 * example_product_subscription = aws.securityhub.ProductSubscription("example", product_arn=f"arn:aws:securityhub:{current.name}:733251395267:product/alertlogic/althreatmanagement",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var current = Aws.GetRegion.Invoke();
 *     var exampleProductSubscription = new Aws.SecurityHub.ProductSubscription("example", new()
 *     {
 *         ProductArn = $"arn:aws:securityhub:{current.Apply(getRegionResult => getRegionResult.Name)}:733251395267:product/alertlogic/althreatmanagement",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		current, err := aws.GetRegion(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewProductSubscription(ctx, "example", &securityhub.ProductSubscriptionArgs{
 * 			ProductArn: pulumi.Sprintf("arn:aws:securityhub:%v:733251395267:product/alertlogic/althreatmanagement", current.Name),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.securityhub.ProductSubscription;
 * import com.pulumi.aws.securityhub.ProductSubscriptionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         final var current = AwsFunctions.getRegion();
 *         var exampleProductSubscription = new ProductSubscription("exampleProductSubscription", ProductSubscriptionArgs.builder()
 *             .productArn(String.format("arn:aws:securityhub:%s:733251395267:product/alertlogic/althreatmanagement", current.applyValue(getRegionResult -> getRegionResult.name())))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   exampleProductSubscription:
 *     type: aws:securityhub:ProductSubscription
 *     name: example
 *     properties:
 *       productArn: arn:aws:securityhub:${current.name}:733251395267:product/alertlogic/althreatmanagement
 *     options:
 *       dependson:
 *         - ${example}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub product subscriptions using `product_arn,arn`. For example:
 * ```sh
 * $ pulumi import aws:securityhub/productSubscription:ProductSubscription example arn:aws:securityhub:eu-west-1:733251395267:product/alertlogic/althreatmanagement,arn:aws:securityhub:eu-west-1:123456789012:product-subscription/alertlogic/althreatmanagement
 * ```
 * @property productArn The ARN of the product that generates findings that you want to import into Security Hub - see below.
 * Amazon maintains a list of [Product integrations in AWS Security Hub](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-findings-providers&#46;html) that changes over time&#46; Any of the products on the linked [Available AWS service integrations](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-internal-providers&#46;html) or [Available third-party partner product integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-partner-providers.html) can be configured using `aws.securityhub.ProductSubscription`.
 * Available products can also be listed by running the AWS CLI command `aws securityhub describe-products`.
 * A subset of currently available products (remember to replace `${var.region}` as appropriate) includes:
 * * `arn:aws:securityhub:${var.region}::product/aws/guardduty`
 * * `arn:aws:securityhub:${var.region}::product/aws/inspector`
 * * `arn:aws:securityhub:${var.region}::product/aws/macie`
 * * `arn:aws:securityhub:${var.region}::product/alertlogic/althreatmanagement`
 * * `arn:aws:securityhub:${var.region}::product/armordefense/armoranywhere`
 * * `arn:aws:securityhub:${var.region}::product/barracuda/cloudsecurityguardian`
 * * `arn:aws:securityhub:${var.region}::product/checkpoint/cloudguard-iaas`
 * * `arn:aws:securityhub:${var.region}::product/checkpoint/dome9-arc`
 * * `arn:aws:securityhub:${var.region}::product/crowdstrike/crowdstrike-falcon`
 * * `arn:aws:securityhub:${var.region}::product/cyberark/cyberark-pta`
 * * `arn:aws:securityhub:${var.region}::product/f5networks/f5-advanced-waf`
 * * `arn:aws:securityhub:${var.region}::product/fortinet/fortigate`
 * * `arn:aws:securityhub:${var.region}::product/guardicore/aws-infection-monkey`
 * * `arn:aws:securityhub:${var.region}::product/guardicore/guardicore`
 * * `arn:aws:securityhub:${var.region}::product/ibm/qradar-siem`
 * * `arn:aws:securityhub:${var.region}::product/imperva/imperva-attack-analytics`
 * * `arn:aws:securityhub:${var.region}::product/mcafee-skyhigh/mcafee-mvision-cloud-aws`
 * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/redlock`
 * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/vm-series`
 * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-pc`
 * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-vm`
 * * `arn:aws:securityhub:${var.region}::product/rapid7/insightvm`
 * * `arn:aws:securityhub:${var.region}::product/sophos/sophos-server-protection`
 * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-enterprise`
 * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-phantom`
 * * `arn:aws:securityhub:${var.region}::product/sumologicinc/sumologic-mda`
 * * `arn:aws:securityhub:${var.region}::product/symantec-corp/symantec-cwp`
 * * `arn:aws:securityhub:${var.region}::product/tenable/tenable-io`
 * * `arn:aws:securityhub:${var.region}::product/trend-micro/deep-security`
 * * `arn:aws:securityhub:${var.region}::product/turbot/turbot`
 * * `arn:aws:securityhub:${var.region}::product/twistlock/twistlock-enterprise`
 */
public data class ProductSubscriptionArgs(
    public val productArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.ProductSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.ProductSubscriptionArgs =
        com.pulumi.aws.securityhub.ProductSubscriptionArgs.builder()
            .productArn(productArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductSubscriptionArgs].
 */
@PulumiTagMarker
public class ProductSubscriptionArgsBuilder internal constructor() {
    private var productArn: Output<String>? = null

    /**
     * @param value The ARN of the product that generates findings that you want to import into Security Hub - see below.
     * Amazon maintains a list of [Product integrations in AWS Security Hub](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-findings-providers&#46;html) that changes over time&#46; Any of the products on the linked [Available AWS service integrations](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-internal-providers&#46;html) or [Available third-party partner product integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-partner-providers.html) can be configured using `aws.securityhub.ProductSubscription`.
     * Available products can also be listed by running the AWS CLI command `aws securityhub describe-products`.
     * A subset of currently available products (remember to replace `${var.region}` as appropriate) includes:
     * * `arn:aws:securityhub:${var.region}::product/aws/guardduty`
     * * `arn:aws:securityhub:${var.region}::product/aws/inspector`
     * * `arn:aws:securityhub:${var.region}::product/aws/macie`
     * * `arn:aws:securityhub:${var.region}::product/alertlogic/althreatmanagement`
     * * `arn:aws:securityhub:${var.region}::product/armordefense/armoranywhere`
     * * `arn:aws:securityhub:${var.region}::product/barracuda/cloudsecurityguardian`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/cloudguard-iaas`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/dome9-arc`
     * * `arn:aws:securityhub:${var.region}::product/crowdstrike/crowdstrike-falcon`
     * * `arn:aws:securityhub:${var.region}::product/cyberark/cyberark-pta`
     * * `arn:aws:securityhub:${var.region}::product/f5networks/f5-advanced-waf`
     * * `arn:aws:securityhub:${var.region}::product/fortinet/fortigate`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/aws-infection-monkey`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/guardicore`
     * * `arn:aws:securityhub:${var.region}::product/ibm/qradar-siem`
     * * `arn:aws:securityhub:${var.region}::product/imperva/imperva-attack-analytics`
     * * `arn:aws:securityhub:${var.region}::product/mcafee-skyhigh/mcafee-mvision-cloud-aws`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/redlock`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/vm-series`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-pc`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-vm`
     * * `arn:aws:securityhub:${var.region}::product/rapid7/insightvm`
     * * `arn:aws:securityhub:${var.region}::product/sophos/sophos-server-protection`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-enterprise`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-phantom`
     * * `arn:aws:securityhub:${var.region}::product/sumologicinc/sumologic-mda`
     * * `arn:aws:securityhub:${var.region}::product/symantec-corp/symantec-cwp`
     * * `arn:aws:securityhub:${var.region}::product/tenable/tenable-io`
     * * `arn:aws:securityhub:${var.region}::product/trend-micro/deep-security`
     * * `arn:aws:securityhub:${var.region}::product/turbot/turbot`
     * * `arn:aws:securityhub:${var.region}::product/twistlock/twistlock-enterprise`
     */
    @JvmName("fqpkoghxaamvmelw")
    public suspend fun productArn(`value`: Output<String>) {
        this.productArn = value
    }

    /**
     * @param value The ARN of the product that generates findings that you want to import into Security Hub - see below.
     * Amazon maintains a list of [Product integrations in AWS Security Hub](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-findings-providers&#46;html) that changes over time&#46; Any of the products on the linked [Available AWS service integrations](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-internal-providers&#46;html) or [Available third-party partner product integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-partner-providers.html) can be configured using `aws.securityhub.ProductSubscription`.
     * Available products can also be listed by running the AWS CLI command `aws securityhub describe-products`.
     * A subset of currently available products (remember to replace `${var.region}` as appropriate) includes:
     * * `arn:aws:securityhub:${var.region}::product/aws/guardduty`
     * * `arn:aws:securityhub:${var.region}::product/aws/inspector`
     * * `arn:aws:securityhub:${var.region}::product/aws/macie`
     * * `arn:aws:securityhub:${var.region}::product/alertlogic/althreatmanagement`
     * * `arn:aws:securityhub:${var.region}::product/armordefense/armoranywhere`
     * * `arn:aws:securityhub:${var.region}::product/barracuda/cloudsecurityguardian`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/cloudguard-iaas`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/dome9-arc`
     * * `arn:aws:securityhub:${var.region}::product/crowdstrike/crowdstrike-falcon`
     * * `arn:aws:securityhub:${var.region}::product/cyberark/cyberark-pta`
     * * `arn:aws:securityhub:${var.region}::product/f5networks/f5-advanced-waf`
     * * `arn:aws:securityhub:${var.region}::product/fortinet/fortigate`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/aws-infection-monkey`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/guardicore`
     * * `arn:aws:securityhub:${var.region}::product/ibm/qradar-siem`
     * * `arn:aws:securityhub:${var.region}::product/imperva/imperva-attack-analytics`
     * * `arn:aws:securityhub:${var.region}::product/mcafee-skyhigh/mcafee-mvision-cloud-aws`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/redlock`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/vm-series`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-pc`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-vm`
     * * `arn:aws:securityhub:${var.region}::product/rapid7/insightvm`
     * * `arn:aws:securityhub:${var.region}::product/sophos/sophos-server-protection`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-enterprise`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-phantom`
     * * `arn:aws:securityhub:${var.region}::product/sumologicinc/sumologic-mda`
     * * `arn:aws:securityhub:${var.region}::product/symantec-corp/symantec-cwp`
     * * `arn:aws:securityhub:${var.region}::product/tenable/tenable-io`
     * * `arn:aws:securityhub:${var.region}::product/trend-micro/deep-security`
     * * `arn:aws:securityhub:${var.region}::product/turbot/turbot`
     * * `arn:aws:securityhub:${var.region}::product/twistlock/twistlock-enterprise`
     */
    @JvmName("unpnpykowqanfehx")
    public suspend fun productArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productArn = mapped
    }

    internal fun build(): ProductSubscriptionArgs = ProductSubscriptionArgs(
        productArn = productArn,
    )
}
