@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.StandardsControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Disable/enable Security Hub standards control in the current region.
 * The `aws.securityhub.StandardsControl` behaves differently from normal resources, in that
 * Pulumi does not _create_ this resource, but instead "adopts" it
 * into management. When you _delete_ this resource configuration, Pulumi "abandons" resource as is and just removes it from the state.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securityhub.Account("example", {});
 * const cisAwsFoundationsBenchmark = new aws.securityhub.StandardsSubscription("cis_aws_foundations_benchmark", {standardsArn: "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0"}, {
 *     dependsOn: [example],
 * });
 * const ensureIamPasswordPolicyPreventsPasswordReuse = new aws.securityhub.StandardsControl("ensure_iam_password_policy_prevents_password_reuse", {
 *     standardsControlArn: "arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10",
 *     controlStatus: "DISABLED",
 *     disabledReason: "We handle password policies within Okta",
 * }, {
 *     dependsOn: [cisAwsFoundationsBenchmark],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securityhub.Account("example")
 * cis_aws_foundations_benchmark = aws.securityhub.StandardsSubscription("cis_aws_foundations_benchmark", standards_arn="arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ensure_iam_password_policy_prevents_password_reuse = aws.securityhub.StandardsControl("ensure_iam_password_policy_prevents_password_reuse",
 *     standards_control_arn="arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10",
 *     control_status="DISABLED",
 *     disabled_reason="We handle password policies within Okta",
 *     opts = pulumi.ResourceOptions(depends_on=[cis_aws_foundations_benchmark]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityHub.Account("example");
 *     var cisAwsFoundationsBenchmark = new Aws.SecurityHub.StandardsSubscription("cis_aws_foundations_benchmark", new()
 *     {
 *         StandardsArn = "arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 *     var ensureIamPasswordPolicyPreventsPasswordReuse = new Aws.SecurityHub.StandardsControl("ensure_iam_password_policy_prevents_password_reuse", new()
 *     {
 *         StandardsControlArn = "arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10",
 *         ControlStatus = "DISABLED",
 *         DisabledReason = "We handle password policies within Okta",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             cisAwsFoundationsBenchmark,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securityhub"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := securityhub.NewAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cisAwsFoundationsBenchmark, err := securityhub.NewStandardsSubscription(ctx, "cis_aws_foundations_benchmark", &securityhub.StandardsSubscriptionArgs{
 * 			StandardsArn: pulumi.String("arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = securityhub.NewStandardsControl(ctx, "ensure_iam_password_policy_prevents_password_reuse", &securityhub.StandardsControlArgs{
 * 			StandardsControlArn: pulumi.String("arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10"),
 * 			ControlStatus:       pulumi.String("DISABLED"),
 * 			DisabledReason:      pulumi.String("We handle password policies within Okta"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			cisAwsFoundationsBenchmark,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.StandardsSubscription;
 * import com.pulumi.aws.securityhub.StandardsSubscriptionArgs;
 * import com.pulumi.aws.securityhub.StandardsControl;
 * import com.pulumi.aws.securityhub.StandardsControlArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var cisAwsFoundationsBenchmark = new StandardsSubscription("cisAwsFoundationsBenchmark", StandardsSubscriptionArgs.builder()
 *             .standardsArn("arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var ensureIamPasswordPolicyPreventsPasswordReuse = new StandardsControl("ensureIamPasswordPolicyPreventsPasswordReuse", StandardsControlArgs.builder()
 *             .standardsControlArn("arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10")
 *             .controlStatus("DISABLED")
 *             .disabledReason("We handle password policies within Okta")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(cisAwsFoundationsBenchmark)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securityhub:Account
 *   cisAwsFoundationsBenchmark:
 *     type: aws:securityhub:StandardsSubscription
 *     name: cis_aws_foundations_benchmark
 *     properties:
 *       standardsArn: arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0
 *     options:
 *       dependson:
 *         - ${example}
 *   ensureIamPasswordPolicyPreventsPasswordReuse:
 *     type: aws:securityhub:StandardsControl
 *     name: ensure_iam_password_policy_prevents_password_reuse
 *     properties:
 *       standardsControlArn: arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10
 *       controlStatus: DISABLED
 *       disabledReason: We handle password policies within Okta
 *     options:
 *       dependson:
 *         - ${cisAwsFoundationsBenchmark}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property controlStatus The control status could be `ENABLED` or `DISABLED`. You have to specify `disabled_reason` argument for `DISABLED` control status.
 * @property disabledReason A description of the reason why you are disabling a security standard control. If you specify this attribute, `control_status` will be set to `DISABLED` automatically.
 * @property standardsControlArn The standards control ARN. See the AWS documentation for how to list existing controls using [`get-enabled-standards`](https://awscli&#46;amazonaws&#46;com/v2/documentation/api/latest/reference/securityhub/get-enabled-standards&#46;html) and [`describe-standards-controls`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/securityhub/describe-standards-controls.html).
 */
public data class StandardsControlArgs(
    public val controlStatus: Output<String>? = null,
    public val disabledReason: Output<String>? = null,
    public val standardsControlArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.StandardsControlArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.StandardsControlArgs =
        com.pulumi.aws.securityhub.StandardsControlArgs.builder()
            .controlStatus(controlStatus?.applyValue({ args0 -> args0 }))
            .disabledReason(disabledReason?.applyValue({ args0 -> args0 }))
            .standardsControlArn(standardsControlArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StandardsControlArgs].
 */
@PulumiTagMarker
public class StandardsControlArgsBuilder internal constructor() {
    private var controlStatus: Output<String>? = null

    private var disabledReason: Output<String>? = null

    private var standardsControlArn: Output<String>? = null

    /**
     * @param value The control status could be `ENABLED` or `DISABLED`. You have to specify `disabled_reason` argument for `DISABLED` control status.
     */
    @JvmName("gsgoqnwlilshyvmq")
    public suspend fun controlStatus(`value`: Output<String>) {
        this.controlStatus = value
    }

    /**
     * @param value A description of the reason why you are disabling a security standard control. If you specify this attribute, `control_status` will be set to `DISABLED` automatically.
     */
    @JvmName("ssjakjcvixwthdmk")
    public suspend fun disabledReason(`value`: Output<String>) {
        this.disabledReason = value
    }

    /**
     * @param value The standards control ARN. See the AWS documentation for how to list existing controls using [`get-enabled-standards`](https://awscli&#46;amazonaws&#46;com/v2/documentation/api/latest/reference/securityhub/get-enabled-standards&#46;html) and [`describe-standards-controls`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/securityhub/describe-standards-controls.html).
     */
    @JvmName("yrutefsejqddsfeh")
    public suspend fun standardsControlArn(`value`: Output<String>) {
        this.standardsControlArn = value
    }

    /**
     * @param value The control status could be `ENABLED` or `DISABLED`. You have to specify `disabled_reason` argument for `DISABLED` control status.
     */
    @JvmName("quweqgmsdekiapmh")
    public suspend fun controlStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlStatus = mapped
    }

    /**
     * @param value A description of the reason why you are disabling a security standard control. If you specify this attribute, `control_status` will be set to `DISABLED` automatically.
     */
    @JvmName("cadiabbidpuyemre")
    public suspend fun disabledReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledReason = mapped
    }

    /**
     * @param value The standards control ARN. See the AWS documentation for how to list existing controls using [`get-enabled-standards`](https://awscli&#46;amazonaws&#46;com/v2/documentation/api/latest/reference/securityhub/get-enabled-standards&#46;html) and [`describe-standards-controls`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/securityhub/describe-standards-controls.html).
     */
    @JvmName("gafftqeduirsuhwx")
    public suspend fun standardsControlArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standardsControlArn = mapped
    }

    internal fun build(): StandardsControlArgs = StandardsControlArgs(
        controlStatus = controlStatus,
        disabledReason = disabledReason,
        standardsControlArn = standardsControlArn,
    )
}
