@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property findingFieldsUpdate A block that specifies that the automation rule action is an update to a finding field.  Documented below.
 * @property type Specifies that the rule action should update the `Types` finding field. The `Types` finding field classifies findings in the format of namespace/category/classifier.
 */
public data class AutomationRuleActionArgs(
    public val findingFieldsUpdate: Output<AutomationRuleActionFindingFieldsUpdateArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleActionArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleActionArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleActionArgs.builder()
            .findingFieldsUpdate(
                findingFieldsUpdate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleActionArgs].
 */
@PulumiTagMarker
public class AutomationRuleActionArgsBuilder internal constructor() {
    private var findingFieldsUpdate: Output<AutomationRuleActionFindingFieldsUpdateArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value A block that specifies that the automation rule action is an update to a finding field.  Documented below.
     */
    @JvmName("afyoinnadlmvrcat")
    public suspend fun findingFieldsUpdate(`value`: Output<AutomationRuleActionFindingFieldsUpdateArgs>) {
        this.findingFieldsUpdate = value
    }

    /**
     * @param value Specifies that the rule action should update the `Types` finding field. The `Types` finding field classifies findings in the format of namespace/category/classifier.
     */
    @JvmName("jdqtffxojnmqtpbi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A block that specifies that the automation rule action is an update to a finding field.  Documented below.
     */
    @JvmName("usaldjfggwjjtfvc")
    public suspend fun findingFieldsUpdate(`value`: AutomationRuleActionFindingFieldsUpdateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingFieldsUpdate = mapped
    }

    /**
     * @param argument A block that specifies that the automation rule action is an update to a finding field.  Documented below.
     */
    @JvmName("yyasevoexotrkpnr")
    public suspend fun findingFieldsUpdate(argument: suspend AutomationRuleActionFindingFieldsUpdateArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRuleActionFindingFieldsUpdateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.findingFieldsUpdate = mapped
    }

    /**
     * @param value Specifies that the rule action should update the `Types` finding field. The `Types` finding field classifies findings in the format of namespace/category/classifier.
     */
    @JvmName("gpgpuglgafkqbwhe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AutomationRuleActionArgs = AutomationRuleActionArgs(
        findingFieldsUpdate = findingFieldsUpdate,
        type = type,
    )
}
