@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property confidence The rule action updates the `Confidence` field of a finding.
 * @property criticality The rule action updates the `Criticality` field of a finding.
 * @property note A resource block that updates the note. Documented below.
 * @property relatedFindings A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
 * @property severity A resource block that updates to the severity information for a finding. Documented below.
 * @property types The rule action updates the `Types` field of a finding.
 * @property userDefinedFields The rule action updates the `UserDefinedFields` field of a finding.
 * @property verificationState The rule action updates the `VerificationState` field of a finding. The allowed values are the following `UNKNOWN`, `TRUE_POSITIVE`, `FALSE_POSITIVE` and `BENIGN_POSITIVE`.
 * @property workflow A resource block that is used to update information about the investigation into the finding. Documented below.
 */
public data class AutomationRuleActionFindingFieldsUpdateArgs(
    public val confidence: Output<Int>? = null,
    public val criticality: Output<Int>? = null,
    public val note: Output<AutomationRuleActionFindingFieldsUpdateNoteArgs>? = null,
    public val relatedFindings: Output<List<AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs>>? = null,
    public val severity: Output<AutomationRuleActionFindingFieldsUpdateSeverityArgs>? = null,
    public val types: Output<List<String>>? = null,
    public val userDefinedFields: Output<Map<String, String>>? = null,
    public val verificationState: Output<String>? = null,
    public val workflow: Output<AutomationRuleActionFindingFieldsUpdateWorkflowArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateArgs.builder()
            .confidence(confidence?.applyValue({ args0 -> args0 }))
            .criticality(criticality?.applyValue({ args0 -> args0 }))
            .note(note?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .relatedFindings(
                relatedFindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .severity(severity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .types(types?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .userDefinedFields(
                userDefinedFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .verificationState(verificationState?.applyValue({ args0 -> args0 }))
            .workflow(workflow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AutomationRuleActionFindingFieldsUpdateArgs].
 */
@PulumiTagMarker
public class AutomationRuleActionFindingFieldsUpdateArgsBuilder internal constructor() {
    private var confidence: Output<Int>? = null

    private var criticality: Output<Int>? = null

    private var note: Output<AutomationRuleActionFindingFieldsUpdateNoteArgs>? = null

    private var relatedFindings:
        Output<List<AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs>>? = null

    private var severity: Output<AutomationRuleActionFindingFieldsUpdateSeverityArgs>? = null

    private var types: Output<List<String>>? = null

    private var userDefinedFields: Output<Map<String, String>>? = null

    private var verificationState: Output<String>? = null

    private var workflow: Output<AutomationRuleActionFindingFieldsUpdateWorkflowArgs>? = null

    /**
     * @param value The rule action updates the `Confidence` field of a finding.
     */
    @JvmName("khpilkscgbtpqsak")
    public suspend fun confidence(`value`: Output<Int>) {
        this.confidence = value
    }

    /**
     * @param value The rule action updates the `Criticality` field of a finding.
     */
    @JvmName("hasurbmhpodtysiq")
    public suspend fun criticality(`value`: Output<Int>) {
        this.criticality = value
    }

    /**
     * @param value A resource block that updates the note. Documented below.
     */
    @JvmName("pkehlbehlrkqfwvv")
    public suspend fun note(`value`: Output<AutomationRuleActionFindingFieldsUpdateNoteArgs>) {
        this.note = value
    }

    /**
     * @param value A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("pyqowhotabxtpxad")
    public suspend fun relatedFindings(`value`: Output<List<AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs>>) {
        this.relatedFindings = value
    }

    @JvmName("uliggylhylemusqo")
    public suspend fun relatedFindings(vararg values: Output<AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs>) {
        this.relatedFindings = Output.all(values.asList())
    }

    /**
     * @param values A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("wdpygtjpljhhgkgb")
    public suspend fun relatedFindings(values: List<Output<AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs>>) {
        this.relatedFindings = Output.all(values)
    }

    /**
     * @param value A resource block that updates to the severity information for a finding. Documented below.
     */
    @JvmName("oslgoelcfajokxle")
    public suspend fun severity(`value`: Output<AutomationRuleActionFindingFieldsUpdateSeverityArgs>) {
        this.severity = value
    }

    /**
     * @param value The rule action updates the `Types` field of a finding.
     */
    @JvmName("pvrkhtuwasprnwwu")
    public suspend fun types(`value`: Output<List<String>>) {
        this.types = value
    }

    @JvmName("lydurddongfxpbwi")
    public suspend fun types(vararg values: Output<String>) {
        this.types = Output.all(values.asList())
    }

    /**
     * @param values The rule action updates the `Types` field of a finding.
     */
    @JvmName("eilddctksokvrvgn")
    public suspend fun types(values: List<Output<String>>) {
        this.types = Output.all(values)
    }

    /**
     * @param value The rule action updates the `UserDefinedFields` field of a finding.
     */
    @JvmName("bvsvrhkynfxpdybs")
    public suspend fun userDefinedFields(`value`: Output<Map<String, String>>) {
        this.userDefinedFields = value
    }

    /**
     * @param value The rule action updates the `VerificationState` field of a finding. The allowed values are the following `UNKNOWN`, `TRUE_POSITIVE`, `FALSE_POSITIVE` and `BENIGN_POSITIVE`.
     */
    @JvmName("kxbnyxagnqoemnpg")
    public suspend fun verificationState(`value`: Output<String>) {
        this.verificationState = value
    }

    /**
     * @param value A resource block that is used to update information about the investigation into the finding. Documented below.
     */
    @JvmName("evpdixjqimrtoaxa")
    public suspend fun workflow(`value`: Output<AutomationRuleActionFindingFieldsUpdateWorkflowArgs>) {
        this.workflow = value
    }

    /**
     * @param value The rule action updates the `Confidence` field of a finding.
     */
    @JvmName("hqdmcyclxorpygia")
    public suspend fun confidence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidence = mapped
    }

    /**
     * @param value The rule action updates the `Criticality` field of a finding.
     */
    @JvmName("xjfjhtpjgxaotice")
    public suspend fun criticality(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criticality = mapped
    }

    /**
     * @param value A resource block that updates the note. Documented below.
     */
    @JvmName("vvqxsidreyfekbax")
    public suspend fun note(`value`: AutomationRuleActionFindingFieldsUpdateNoteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.note = mapped
    }

    /**
     * @param argument A resource block that updates the note. Documented below.
     */
    @JvmName("ikttcnigpiqpunuw")
    public suspend fun note(argument: suspend AutomationRuleActionFindingFieldsUpdateNoteArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRuleActionFindingFieldsUpdateNoteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.note = mapped
    }

    /**
     * @param value A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("euamscjiwkotcspd")
    public suspend fun relatedFindings(`value`: List<AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedFindings = mapped
    }

    /**
     * @param argument A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("odeoupnfwcojgnqc")
    public suspend fun relatedFindings(argument: List<suspend AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindings = mapped
    }

    /**
     * @param argument A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("wyjwrqdfknpiqgwv")
    public suspend fun relatedFindings(vararg argument: suspend AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindings = mapped
    }

    /**
     * @param argument A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("udrqmtqntslhaesb")
    public suspend fun relatedFindings(argument: suspend AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.relatedFindings = mapped
    }

    /**
     * @param values A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
     */
    @JvmName("npnrkxfgjrstxnds")
    public suspend fun relatedFindings(vararg values: AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedFindings = mapped
    }

    /**
     * @param value A resource block that updates to the severity information for a finding. Documented below.
     */
    @JvmName("ejdjwqdaththrdft")
    public suspend fun severity(`value`: AutomationRuleActionFindingFieldsUpdateSeverityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param argument A resource block that updates to the severity information for a finding. Documented below.
     */
    @JvmName("luvnnmhjlylpvehl")
    public suspend fun severity(argument: suspend AutomationRuleActionFindingFieldsUpdateSeverityArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRuleActionFindingFieldsUpdateSeverityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.severity = mapped
    }

    /**
     * @param value The rule action updates the `Types` field of a finding.
     */
    @JvmName("dpjkubwvwawxjuig")
    public suspend fun types(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param values The rule action updates the `Types` field of a finding.
     */
    @JvmName("qtmrinedltwexwbf")
    public suspend fun types(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param value The rule action updates the `UserDefinedFields` field of a finding.
     */
    @JvmName("gntddftwxmnvnxnm")
    public suspend fun userDefinedFields(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefinedFields = mapped
    }

    /**
     * @param values The rule action updates the `UserDefinedFields` field of a finding.
     */
    @JvmName("yhjvwfaisdonbpcw")
    public fun userDefinedFields(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userDefinedFields = mapped
    }

    /**
     * @param value The rule action updates the `VerificationState` field of a finding. The allowed values are the following `UNKNOWN`, `TRUE_POSITIVE`, `FALSE_POSITIVE` and `BENIGN_POSITIVE`.
     */
    @JvmName("ftpkowglwnpanveb")
    public suspend fun verificationState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationState = mapped
    }

    /**
     * @param value A resource block that is used to update information about the investigation into the finding. Documented below.
     */
    @JvmName("vraqkmngcuuhhytv")
    public suspend fun workflow(`value`: AutomationRuleActionFindingFieldsUpdateWorkflowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflow = mapped
    }

    /**
     * @param argument A resource block that is used to update information about the investigation into the finding. Documented below.
     */
    @JvmName("fqwkxjpbcmkwjlic")
    public suspend fun workflow(argument: suspend AutomationRuleActionFindingFieldsUpdateWorkflowArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationRuleActionFindingFieldsUpdateWorkflowArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workflow = mapped
    }

    internal fun build(): AutomationRuleActionFindingFieldsUpdateArgs =
        AutomationRuleActionFindingFieldsUpdateArgs(
            confidence = confidence,
            criticality = criticality,
            note = note,
            relatedFindings = relatedFindings,
            severity = severity,
            types = types,
            userDefinedFields = userDefinedFields,
            verificationState = verificationState,
            workflow = workflow,
        )
}
