@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property text The updated note text.
 * @property updatedBy The principal that updated the note.
 */
public data class AutomationRuleActionFindingFieldsUpdateNoteArgs(
    public val text: Output<String>,
    public val updatedBy: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateNoteArgs.builder()
            .text(text.applyValue({ args0 -> args0 }))
            .updatedBy(updatedBy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleActionFindingFieldsUpdateNoteArgs].
 */
@PulumiTagMarker
public class AutomationRuleActionFindingFieldsUpdateNoteArgsBuilder internal constructor() {
    private var text: Output<String>? = null

    private var updatedBy: Output<String>? = null

    /**
     * @param value The updated note text.
     */
    @JvmName("btaswbclocoftaag")
    public suspend fun text(`value`: Output<String>) {
        this.text = value
    }

    /**
     * @param value The principal that updated the note.
     */
    @JvmName("eiklthctqckfhidi")
    public suspend fun updatedBy(`value`: Output<String>) {
        this.updatedBy = value
    }

    /**
     * @param value The updated note text.
     */
    @JvmName("emkbcgtlkviwvbiu")
    public suspend fun text(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.text = mapped
    }

    /**
     * @param value The principal that updated the note.
     */
    @JvmName("gbnwhcjlmbrebtie")
    public suspend fun updatedBy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updatedBy = mapped
    }

    internal fun build(): AutomationRuleActionFindingFieldsUpdateNoteArgs =
        AutomationRuleActionFindingFieldsUpdateNoteArgs(
            text = text ?: throw PulumiNullFieldException("text"),
            updatedBy = updatedBy ?: throw PulumiNullFieldException("updatedBy"),
        )
}
