@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The product-generated identifier for a related finding.
 * @property productArn The ARN of the product that generated a related finding.
 */
public data class AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs(
    public val id: Output<String>,
    public val productArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .productArn(productArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs].
 */
@PulumiTagMarker
public class AutomationRuleActionFindingFieldsUpdateRelatedFindingArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var productArn: Output<String>? = null

    /**
     * @param value The product-generated identifier for a related finding.
     */
    @JvmName("jquoadcranumufyq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ARN of the product that generated a related finding.
     */
    @JvmName("xoxikiobtqujhvii")
    public suspend fun productArn(`value`: Output<String>) {
        this.productArn = value
    }

    /**
     * @param value The product-generated identifier for a related finding.
     */
    @JvmName("ueeirhitnriaiyrc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ARN of the product that generated a related finding.
     */
    @JvmName("mwiktmqmqdkpjrlr")
    public suspend fun productArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productArn = mapped
    }

    internal fun build(): AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs =
        AutomationRuleActionFindingFieldsUpdateRelatedFindingArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            productArn = productArn ?: throw PulumiNullFieldException("productArn"),
        )
}
