@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property label The severity value of the finding. The allowed values are the following `INFORMATIONAL`, `LOW`, `MEDIUM`, `HIGH` and `CRITICAL`.
 * @property product The native severity as defined by the AWS service or integrated partner product that generated the finding.
 */
public data class AutomationRuleActionFindingFieldsUpdateSeverityArgs(
    public val label: Output<String>? = null,
    public val product: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateSeverityArgs.builder()
            .label(label?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleActionFindingFieldsUpdateSeverityArgs].
 */
@PulumiTagMarker
public class AutomationRuleActionFindingFieldsUpdateSeverityArgsBuilder internal constructor() {
    private var label: Output<String>? = null

    private var product: Output<Double>? = null

    /**
     * @param value The severity value of the finding. The allowed values are the following `INFORMATIONAL`, `LOW`, `MEDIUM`, `HIGH` and `CRITICAL`.
     */
    @JvmName("wjjvhnefginwllri")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The native severity as defined by the AWS service or integrated partner product that generated the finding.
     */
    @JvmName("dqkffaxrmxeyqbqx")
    public suspend fun product(`value`: Output<Double>) {
        this.product = value
    }

    /**
     * @param value The severity value of the finding. The allowed values are the following `INFORMATIONAL`, `LOW`, `MEDIUM`, `HIGH` and `CRITICAL`.
     */
    @JvmName("nwapvjbvnubkyqux")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The native severity as defined by the AWS service or integrated partner product that generated the finding.
     */
    @JvmName("eevmlhelkdguamby")
    public suspend fun product(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    internal fun build(): AutomationRuleActionFindingFieldsUpdateSeverityArgs =
        AutomationRuleActionFindingFieldsUpdateSeverityArgs(
            label = label,
            product = product,
        )
}
