@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateWorkflowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status The status of the investigation into the finding. The allowed values are the following `NEW`, `NOTIFIED`, `RESOLVED` and `SUPPRESSED`.
 */
public data class AutomationRuleActionFindingFieldsUpdateWorkflowArgs(
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateWorkflowArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateWorkflowArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleActionFindingFieldsUpdateWorkflowArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleActionFindingFieldsUpdateWorkflowArgs].
 */
@PulumiTagMarker
public class AutomationRuleActionFindingFieldsUpdateWorkflowArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value The status of the investigation into the finding. The allowed values are the following `NEW`, `NOTIFIED`, `RESOLVED` and `SUPPRESSED`.
     */
    @JvmName("exypdrgdioyddhsl")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The status of the investigation into the finding. The allowed values are the following `NEW`, `NOTIFIED`, `RESOLVED` and `SUPPRESSED`.
     */
    @JvmName("ytcvjvwkdbmpmapr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): AutomationRuleActionFindingFieldsUpdateWorkflowArgs =
        AutomationRuleActionFindingFieldsUpdateWorkflowArgs(
            status = status,
        )
}
