@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property awsAccountIds The AWS account ID in which a finding was generated. Documented below.
 * @property awsAccountNames The name of the AWS account in which a finding was generated. Documented below.
 * @property companyNames The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
 * @property complianceAssociatedStandardsIds The unique identifier of a standard in which a control is enabled. Documented below.
 * @property complianceSecurityControlIds The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
 * @property complianceStatuses The result of a security check. This field is only used for findings generated from controls. Documented below.
 * @property confidences The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
 * @property createdAts A timestamp that indicates when this finding record was created. Documented below.
 * @property criticalities The level of importance that is assigned to the resources that are associated with a finding. Documented below.
 * @property descriptions A finding's description. Documented below.
 * @property firstObservedAts A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
 * @property generatorIds The identifier for the solution-specific component that generated a finding. Documented below.
 * @property ids The product-specific identifier for a finding. Documented below.
 * @property lastObservedAts A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
 * @property noteTexts The text of a user-defined note that's added to a finding. Documented below.
 * @property noteUpdatedAts The timestamp of when the note was updated. Documented below.
 * @property noteUpdatedBies The principal that created a note. Documented below.
 * @property productArns The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
 * @property productNames Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
 * @property recordStates Provides the current state of a finding. Documented below.
 * @property relatedFindingsIds The product-generated identifier for a related finding.  Documented below.
 * @property relatedFindingsProductArns The ARN for the product that generated a related finding. Documented below.
 * @property resourceApplicationArns The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
 * @property resourceApplicationNames The name of the application that is related to a finding. Documented below.
 * @property resourceDetailsOthers Custom fields and values about the resource that a finding pertains to. Documented below.
 * @property resourceIds The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
 * @property resourcePartitions The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
 * @property resourceRegions The AWS Region where the resource that a finding pertains to is located. Documented below.
 * @property resourceTags A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
 * @property resourceTypes The type of resource that the finding pertains to. Documented below.
 * @property severityLabels The severity value of the finding. Documented below.
 * @property sourceUrls Provides a URL that links to a page about the current finding in the finding product. Documented below.
 * @property titles A finding's title. Documented below.
 * @property types One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
 * @property updatedAts A timestamp that indicates when the finding record was most recently updated. Documented below.
 * @property userDefinedFields A list of user-defined name and value string pairs added to a finding. Documented below.
 * @property verificationStates Provides the veracity of a finding. Documented below.
 * @property workflowStatuses Provides information about the status of the investigation into a finding. Documented below.
 */
public data class AutomationRuleCriteriaArgs(
    public val awsAccountIds: Output<List<AutomationRuleCriteriaAwsAccountIdArgs>>? = null,
    public val awsAccountNames: Output<List<AutomationRuleCriteriaAwsAccountNameArgs>>? = null,
    public val companyNames: Output<List<AutomationRuleCriteriaCompanyNameArgs>>? = null,
    public val complianceAssociatedStandardsIds: Output<List<AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs>>? = null,
    public val complianceSecurityControlIds: Output<List<AutomationRuleCriteriaComplianceSecurityControlIdArgs>>? = null,
    public val complianceStatuses: Output<List<AutomationRuleCriteriaComplianceStatusArgs>>? = null,
    public val confidences: Output<List<AutomationRuleCriteriaConfidenceArgs>>? = null,
    public val createdAts: Output<List<AutomationRuleCriteriaCreatedAtArgs>>? = null,
    public val criticalities: Output<List<AutomationRuleCriteriaCriticalityArgs>>? = null,
    public val descriptions: Output<List<AutomationRuleCriteriaDescriptionArgs>>? = null,
    public val firstObservedAts: Output<List<AutomationRuleCriteriaFirstObservedAtArgs>>? = null,
    public val generatorIds: Output<List<AutomationRuleCriteriaGeneratorIdArgs>>? = null,
    public val ids: Output<List<AutomationRuleCriteriaIdArgs>>? = null,
    public val lastObservedAts: Output<List<AutomationRuleCriteriaLastObservedAtArgs>>? = null,
    public val noteTexts: Output<List<AutomationRuleCriteriaNoteTextArgs>>? = null,
    public val noteUpdatedAts: Output<List<AutomationRuleCriteriaNoteUpdatedAtArgs>>? = null,
    public val noteUpdatedBies: Output<List<AutomationRuleCriteriaNoteUpdatedByArgs>>? = null,
    public val productArns: Output<List<AutomationRuleCriteriaProductArnArgs>>? = null,
    public val productNames: Output<List<AutomationRuleCriteriaProductNameArgs>>? = null,
    public val recordStates: Output<List<AutomationRuleCriteriaRecordStateArgs>>? = null,
    public val relatedFindingsIds: Output<List<AutomationRuleCriteriaRelatedFindingsIdArgs>>? = null,
    public val relatedFindingsProductArns: Output<List<AutomationRuleCriteriaRelatedFindingsProductArnArgs>>? = null,
    public val resourceApplicationArns: Output<List<AutomationRuleCriteriaResourceApplicationArnArgs>>? = null,
    public val resourceApplicationNames: Output<List<AutomationRuleCriteriaResourceApplicationNameArgs>>? = null,
    public val resourceDetailsOthers: Output<List<AutomationRuleCriteriaResourceDetailsOtherArgs>>? =
        null,
    public val resourceIds: Output<List<AutomationRuleCriteriaResourceIdArgs>>? = null,
    public val resourcePartitions: Output<List<AutomationRuleCriteriaResourcePartitionArgs>>? = null,
    public val resourceRegions: Output<List<AutomationRuleCriteriaResourceRegionArgs>>? = null,
    public val resourceTags: Output<List<AutomationRuleCriteriaResourceTagArgs>>? = null,
    public val resourceTypes: Output<List<AutomationRuleCriteriaResourceTypeArgs>>? = null,
    public val severityLabels: Output<List<AutomationRuleCriteriaSeverityLabelArgs>>? = null,
    public val sourceUrls: Output<List<AutomationRuleCriteriaSourceUrlArgs>>? = null,
    public val titles: Output<List<AutomationRuleCriteriaTitleArgs>>? = null,
    public val types: Output<List<AutomationRuleCriteriaTypeArgs>>? = null,
    public val updatedAts: Output<List<AutomationRuleCriteriaUpdatedAtArgs>>? = null,
    public val userDefinedFields: Output<List<AutomationRuleCriteriaUserDefinedFieldArgs>>? = null,
    public val verificationStates: Output<List<AutomationRuleCriteriaVerificationStateArgs>>? = null,
    public val workflowStatuses: Output<List<AutomationRuleCriteriaWorkflowStatusArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaArgs.builder()
            .awsAccountIds(
                awsAccountIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .awsAccountNames(
                awsAccountNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .companyNames(
                companyNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .complianceAssociatedStandardsIds(
                complianceAssociatedStandardsIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .complianceSecurityControlIds(
                complianceSecurityControlIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .complianceStatuses(
                complianceStatuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .confidences(
                confidences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .createdAts(
                createdAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .criticalities(
                criticalities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .descriptions(
                descriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .firstObservedAts(
                firstObservedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .generatorIds(
                generatorIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ids(ids?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .lastObservedAts(
                lastObservedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .noteTexts(
                noteTexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .noteUpdatedAts(
                noteUpdatedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .noteUpdatedBies(
                noteUpdatedBies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .productArns(
                productArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .productNames(
                productNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordStates(
                recordStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .relatedFindingsIds(
                relatedFindingsIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .relatedFindingsProductArns(
                relatedFindingsProductArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceApplicationArns(
                resourceApplicationArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceApplicationNames(
                resourceApplicationNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceDetailsOthers(
                resourceDetailsOthers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceIds(
                resourceIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourcePartitions(
                resourcePartitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceRegions(
                resourceRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceTags(
                resourceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceTypes(
                resourceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .severityLabels(
                severityLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceUrls(
                sourceUrls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .titles(titles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .types(types?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .updatedAts(
                updatedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userDefinedFields(
                userDefinedFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .verificationStates(
                verificationStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workflowStatuses(
                workflowStatuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationRuleCriteriaArgs].
 */
@PulumiTagMarker
public class AutomationRuleCriteriaArgsBuilder internal constructor() {
    private var awsAccountIds: Output<List<AutomationRuleCriteriaAwsAccountIdArgs>>? = null

    private var awsAccountNames: Output<List<AutomationRuleCriteriaAwsAccountNameArgs>>? = null

    private var companyNames: Output<List<AutomationRuleCriteriaCompanyNameArgs>>? = null

    private var complianceAssociatedStandardsIds:
        Output<List<AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs>>? = null

    private var complianceSecurityControlIds:
        Output<List<AutomationRuleCriteriaComplianceSecurityControlIdArgs>>? = null

    private var complianceStatuses: Output<List<AutomationRuleCriteriaComplianceStatusArgs>>? = null

    private var confidences: Output<List<AutomationRuleCriteriaConfidenceArgs>>? = null

    private var createdAts: Output<List<AutomationRuleCriteriaCreatedAtArgs>>? = null

    private var criticalities: Output<List<AutomationRuleCriteriaCriticalityArgs>>? = null

    private var descriptions: Output<List<AutomationRuleCriteriaDescriptionArgs>>? = null

    private var firstObservedAts: Output<List<AutomationRuleCriteriaFirstObservedAtArgs>>? = null

    private var generatorIds: Output<List<AutomationRuleCriteriaGeneratorIdArgs>>? = null

    private var ids: Output<List<AutomationRuleCriteriaIdArgs>>? = null

    private var lastObservedAts: Output<List<AutomationRuleCriteriaLastObservedAtArgs>>? = null

    private var noteTexts: Output<List<AutomationRuleCriteriaNoteTextArgs>>? = null

    private var noteUpdatedAts: Output<List<AutomationRuleCriteriaNoteUpdatedAtArgs>>? = null

    private var noteUpdatedBies: Output<List<AutomationRuleCriteriaNoteUpdatedByArgs>>? = null

    private var productArns: Output<List<AutomationRuleCriteriaProductArnArgs>>? = null

    private var productNames: Output<List<AutomationRuleCriteriaProductNameArgs>>? = null

    private var recordStates: Output<List<AutomationRuleCriteriaRecordStateArgs>>? = null

    private var relatedFindingsIds: Output<List<AutomationRuleCriteriaRelatedFindingsIdArgs>>? = null

    private var relatedFindingsProductArns:
        Output<List<AutomationRuleCriteriaRelatedFindingsProductArnArgs>>? = null

    private var resourceApplicationArns:
        Output<List<AutomationRuleCriteriaResourceApplicationArnArgs>>? = null

    private var resourceApplicationNames:
        Output<List<AutomationRuleCriteriaResourceApplicationNameArgs>>? = null

    private var resourceDetailsOthers: Output<List<AutomationRuleCriteriaResourceDetailsOtherArgs>>? =
        null

    private var resourceIds: Output<List<AutomationRuleCriteriaResourceIdArgs>>? = null

    private var resourcePartitions: Output<List<AutomationRuleCriteriaResourcePartitionArgs>>? = null

    private var resourceRegions: Output<List<AutomationRuleCriteriaResourceRegionArgs>>? = null

    private var resourceTags: Output<List<AutomationRuleCriteriaResourceTagArgs>>? = null

    private var resourceTypes: Output<List<AutomationRuleCriteriaResourceTypeArgs>>? = null

    private var severityLabels: Output<List<AutomationRuleCriteriaSeverityLabelArgs>>? = null

    private var sourceUrls: Output<List<AutomationRuleCriteriaSourceUrlArgs>>? = null

    private var titles: Output<List<AutomationRuleCriteriaTitleArgs>>? = null

    private var types: Output<List<AutomationRuleCriteriaTypeArgs>>? = null

    private var updatedAts: Output<List<AutomationRuleCriteriaUpdatedAtArgs>>? = null

    private var userDefinedFields: Output<List<AutomationRuleCriteriaUserDefinedFieldArgs>>? = null

    private var verificationStates: Output<List<AutomationRuleCriteriaVerificationStateArgs>>? = null

    private var workflowStatuses: Output<List<AutomationRuleCriteriaWorkflowStatusArgs>>? = null

    /**
     * @param value The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("ncjnpbvbqsdnfwgq")
    public suspend fun awsAccountIds(`value`: Output<List<AutomationRuleCriteriaAwsAccountIdArgs>>) {
        this.awsAccountIds = value
    }

    @JvmName("edqoxmarbrncrggx")
    public suspend fun awsAccountIds(vararg values: Output<AutomationRuleCriteriaAwsAccountIdArgs>) {
        this.awsAccountIds = Output.all(values.asList())
    }

    /**
     * @param values The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("jylmbperrahjovos")
    public suspend fun awsAccountIds(values: List<Output<AutomationRuleCriteriaAwsAccountIdArgs>>) {
        this.awsAccountIds = Output.all(values)
    }

    /**
     * @param value The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("jqjliaydkrlrhias")
    public suspend fun awsAccountNames(`value`: Output<List<AutomationRuleCriteriaAwsAccountNameArgs>>) {
        this.awsAccountNames = value
    }

    @JvmName("gsuntwrqopnsikmt")
    public suspend fun awsAccountNames(vararg values: Output<AutomationRuleCriteriaAwsAccountNameArgs>) {
        this.awsAccountNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("jqymiieshjryomvf")
    public suspend fun awsAccountNames(values: List<Output<AutomationRuleCriteriaAwsAccountNameArgs>>) {
        this.awsAccountNames = Output.all(values)
    }

    /**
     * @param value The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("qecraojueiymwcwt")
    public suspend fun companyNames(`value`: Output<List<AutomationRuleCriteriaCompanyNameArgs>>) {
        this.companyNames = value
    }

    @JvmName("llqqamspifmffges")
    public suspend fun companyNames(vararg values: Output<AutomationRuleCriteriaCompanyNameArgs>) {
        this.companyNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("lhnrsggihvhmdkxt")
    public suspend fun companyNames(values: List<Output<AutomationRuleCriteriaCompanyNameArgs>>) {
        this.companyNames = Output.all(values)
    }

    /**
     * @param value The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("jnmsuqddpkjdacwi")
    public suspend fun complianceAssociatedStandardsIds(`value`: Output<List<AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs>>) {
        this.complianceAssociatedStandardsIds = value
    }

    @JvmName("proejbiyqrnfgjhj")
    public suspend fun complianceAssociatedStandardsIds(vararg values: Output<AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs>) {
        this.complianceAssociatedStandardsIds = Output.all(values.asList())
    }

    /**
     * @param values The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("vedqjjtcimuypbjg")
    public suspend fun complianceAssociatedStandardsIds(values: List<Output<AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs>>) {
        this.complianceAssociatedStandardsIds = Output.all(values)
    }

    /**
     * @param value The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("fupjlaktfwseetby")
    public suspend fun complianceSecurityControlIds(`value`: Output<List<AutomationRuleCriteriaComplianceSecurityControlIdArgs>>) {
        this.complianceSecurityControlIds = value
    }

    @JvmName("cucxmkmvxtqmvuhr")
    public suspend fun complianceSecurityControlIds(vararg values: Output<AutomationRuleCriteriaComplianceSecurityControlIdArgs>) {
        this.complianceSecurityControlIds = Output.all(values.asList())
    }

    /**
     * @param values The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("metaqckfspekeggm")
    public suspend fun complianceSecurityControlIds(values: List<Output<AutomationRuleCriteriaComplianceSecurityControlIdArgs>>) {
        this.complianceSecurityControlIds = Output.all(values)
    }

    /**
     * @param value The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("lhgnqowmqnrudfwn")
    public suspend fun complianceStatuses(`value`: Output<List<AutomationRuleCriteriaComplianceStatusArgs>>) {
        this.complianceStatuses = value
    }

    @JvmName("yvikrskpuhiyrocy")
    public suspend fun complianceStatuses(vararg values: Output<AutomationRuleCriteriaComplianceStatusArgs>) {
        this.complianceStatuses = Output.all(values.asList())
    }

    /**
     * @param values The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("mxicvtiufevtofxe")
    public suspend fun complianceStatuses(values: List<Output<AutomationRuleCriteriaComplianceStatusArgs>>) {
        this.complianceStatuses = Output.all(values)
    }

    /**
     * @param value The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("nhiknujeiqrjwcqi")
    public suspend fun confidences(`value`: Output<List<AutomationRuleCriteriaConfidenceArgs>>) {
        this.confidences = value
    }

    @JvmName("guduclucnkrgcyub")
    public suspend fun confidences(vararg values: Output<AutomationRuleCriteriaConfidenceArgs>) {
        this.confidences = Output.all(values.asList())
    }

    /**
     * @param values The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("wxiteyhgrdscirtf")
    public suspend fun confidences(values: List<Output<AutomationRuleCriteriaConfidenceArgs>>) {
        this.confidences = Output.all(values)
    }

    /**
     * @param value A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("jwnxmavjfovmuxwe")
    public suspend fun createdAts(`value`: Output<List<AutomationRuleCriteriaCreatedAtArgs>>) {
        this.createdAts = value
    }

    @JvmName("dxiceheividyygyu")
    public suspend fun createdAts(vararg values: Output<AutomationRuleCriteriaCreatedAtArgs>) {
        this.createdAts = Output.all(values.asList())
    }

    /**
     * @param values A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("rymelneylncgkyui")
    public suspend fun createdAts(values: List<Output<AutomationRuleCriteriaCreatedAtArgs>>) {
        this.createdAts = Output.all(values)
    }

    /**
     * @param value The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("cpcwcajkikjmbjxc")
    public suspend fun criticalities(`value`: Output<List<AutomationRuleCriteriaCriticalityArgs>>) {
        this.criticalities = value
    }

    @JvmName("qgnebimonymxtmxd")
    public suspend fun criticalities(vararg values: Output<AutomationRuleCriteriaCriticalityArgs>) {
        this.criticalities = Output.all(values.asList())
    }

    /**
     * @param values The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("ifdivkhligwtovqo")
    public suspend fun criticalities(values: List<Output<AutomationRuleCriteriaCriticalityArgs>>) {
        this.criticalities = Output.all(values)
    }

    /**
     * @param value A finding's description. Documented below.
     */
    @JvmName("slghcyfaosigisbi")
    public suspend fun descriptions(`value`: Output<List<AutomationRuleCriteriaDescriptionArgs>>) {
        this.descriptions = value
    }

    @JvmName("nfinvpqqnweggyyw")
    public suspend fun descriptions(vararg values: Output<AutomationRuleCriteriaDescriptionArgs>) {
        this.descriptions = Output.all(values.asList())
    }

    /**
     * @param values A finding's description. Documented below.
     */
    @JvmName("xcbxufntnbnnboqk")
    public suspend fun descriptions(values: List<Output<AutomationRuleCriteriaDescriptionArgs>>) {
        this.descriptions = Output.all(values)
    }

    /**
     * @param value A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("sxayrrmnffptwocp")
    public suspend fun firstObservedAts(`value`: Output<List<AutomationRuleCriteriaFirstObservedAtArgs>>) {
        this.firstObservedAts = value
    }

    @JvmName("kqqmxqsaugywmqaa")
    public suspend fun firstObservedAts(vararg values: Output<AutomationRuleCriteriaFirstObservedAtArgs>) {
        this.firstObservedAts = Output.all(values.asList())
    }

    /**
     * @param values A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("ricrjxarlwmpbaua")
    public suspend fun firstObservedAts(values: List<Output<AutomationRuleCriteriaFirstObservedAtArgs>>) {
        this.firstObservedAts = Output.all(values)
    }

    /**
     * @param value The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("gwqnjmgwmjnlfgrw")
    public suspend fun generatorIds(`value`: Output<List<AutomationRuleCriteriaGeneratorIdArgs>>) {
        this.generatorIds = value
    }

    @JvmName("qkvhhflxquqoybcp")
    public suspend fun generatorIds(vararg values: Output<AutomationRuleCriteriaGeneratorIdArgs>) {
        this.generatorIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("mpiokivimwmavasj")
    public suspend fun generatorIds(values: List<Output<AutomationRuleCriteriaGeneratorIdArgs>>) {
        this.generatorIds = Output.all(values)
    }

    /**
     * @param value The product-specific identifier for a finding. Documented below.
     */
    @JvmName("tltgpeajorejbsdf")
    public suspend fun ids(`value`: Output<List<AutomationRuleCriteriaIdArgs>>) {
        this.ids = value
    }

    @JvmName("idqrngpklohnkpkh")
    public suspend fun ids(vararg values: Output<AutomationRuleCriteriaIdArgs>) {
        this.ids = Output.all(values.asList())
    }

    /**
     * @param values The product-specific identifier for a finding. Documented below.
     */
    @JvmName("wnejrcrcjrtjisgo")
    public suspend fun ids(values: List<Output<AutomationRuleCriteriaIdArgs>>) {
        this.ids = Output.all(values)
    }

    /**
     * @param value A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("naowfydvhmttrvop")
    public suspend fun lastObservedAts(`value`: Output<List<AutomationRuleCriteriaLastObservedAtArgs>>) {
        this.lastObservedAts = value
    }

    @JvmName("xjkqwdobkrcufvdx")
    public suspend fun lastObservedAts(vararg values: Output<AutomationRuleCriteriaLastObservedAtArgs>) {
        this.lastObservedAts = Output.all(values.asList())
    }

    /**
     * @param values A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("eqourvkmbxjokyga")
    public suspend fun lastObservedAts(values: List<Output<AutomationRuleCriteriaLastObservedAtArgs>>) {
        this.lastObservedAts = Output.all(values)
    }

    /**
     * @param value The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("ipjwqevuukfmplws")
    public suspend fun noteTexts(`value`: Output<List<AutomationRuleCriteriaNoteTextArgs>>) {
        this.noteTexts = value
    }

    @JvmName("eoswrwyliklolpwy")
    public suspend fun noteTexts(vararg values: Output<AutomationRuleCriteriaNoteTextArgs>) {
        this.noteTexts = Output.all(values.asList())
    }

    /**
     * @param values The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("vtkabyqydwbnhvnd")
    public suspend fun noteTexts(values: List<Output<AutomationRuleCriteriaNoteTextArgs>>) {
        this.noteTexts = Output.all(values)
    }

    /**
     * @param value The timestamp of when the note was updated. Documented below.
     */
    @JvmName("iowknvpyofvkpuke")
    public suspend fun noteUpdatedAts(`value`: Output<List<AutomationRuleCriteriaNoteUpdatedAtArgs>>) {
        this.noteUpdatedAts = value
    }

    @JvmName("mmsjaoxwmrrbyale")
    public suspend fun noteUpdatedAts(vararg values: Output<AutomationRuleCriteriaNoteUpdatedAtArgs>) {
        this.noteUpdatedAts = Output.all(values.asList())
    }

    /**
     * @param values The timestamp of when the note was updated. Documented below.
     */
    @JvmName("cxmcpbhgdteinapx")
    public suspend fun noteUpdatedAts(values: List<Output<AutomationRuleCriteriaNoteUpdatedAtArgs>>) {
        this.noteUpdatedAts = Output.all(values)
    }

    /**
     * @param value The principal that created a note. Documented below.
     */
    @JvmName("ulluirgpakinngmu")
    public suspend fun noteUpdatedBies(`value`: Output<List<AutomationRuleCriteriaNoteUpdatedByArgs>>) {
        this.noteUpdatedBies = value
    }

    @JvmName("lsgpprcymhwfxpji")
    public suspend fun noteUpdatedBies(vararg values: Output<AutomationRuleCriteriaNoteUpdatedByArgs>) {
        this.noteUpdatedBies = Output.all(values.asList())
    }

    /**
     * @param values The principal that created a note. Documented below.
     */
    @JvmName("ygmdlpadnywwcida")
    public suspend fun noteUpdatedBies(values: List<Output<AutomationRuleCriteriaNoteUpdatedByArgs>>) {
        this.noteUpdatedBies = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("kvvvwnotgguembji")
    public suspend fun productArns(`value`: Output<List<AutomationRuleCriteriaProductArnArgs>>) {
        this.productArns = value
    }

    @JvmName("peaikiwaxbxrqymm")
    public suspend fun productArns(vararg values: Output<AutomationRuleCriteriaProductArnArgs>) {
        this.productArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("rbbcjsdcjlxoixvo")
    public suspend fun productArns(values: List<Output<AutomationRuleCriteriaProductArnArgs>>) {
        this.productArns = Output.all(values)
    }

    /**
     * @param value Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("iqqmibuquxonwpsp")
    public suspend fun productNames(`value`: Output<List<AutomationRuleCriteriaProductNameArgs>>) {
        this.productNames = value
    }

    @JvmName("apeqqmtsujnklvlu")
    public suspend fun productNames(vararg values: Output<AutomationRuleCriteriaProductNameArgs>) {
        this.productNames = Output.all(values.asList())
    }

    /**
     * @param values Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("ffocdtpfdakjbkoq")
    public suspend fun productNames(values: List<Output<AutomationRuleCriteriaProductNameArgs>>) {
        this.productNames = Output.all(values)
    }

    /**
     * @param value Provides the current state of a finding. Documented below.
     */
    @JvmName("sxixcqayfcafhpxl")
    public suspend fun recordStates(`value`: Output<List<AutomationRuleCriteriaRecordStateArgs>>) {
        this.recordStates = value
    }

    @JvmName("qkstjvrcrfuoqrah")
    public suspend fun recordStates(vararg values: Output<AutomationRuleCriteriaRecordStateArgs>) {
        this.recordStates = Output.all(values.asList())
    }

    /**
     * @param values Provides the current state of a finding. Documented below.
     */
    @JvmName("eawbapdsfxbxjjxc")
    public suspend fun recordStates(values: List<Output<AutomationRuleCriteriaRecordStateArgs>>) {
        this.recordStates = Output.all(values)
    }

    /**
     * @param value The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("mrjiwlnfgjtcihld")
    public suspend fun relatedFindingsIds(`value`: Output<List<AutomationRuleCriteriaRelatedFindingsIdArgs>>) {
        this.relatedFindingsIds = value
    }

    @JvmName("nmgkuiktnkafkbpf")
    public suspend fun relatedFindingsIds(vararg values: Output<AutomationRuleCriteriaRelatedFindingsIdArgs>) {
        this.relatedFindingsIds = Output.all(values.asList())
    }

    /**
     * @param values The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("vydhcpbajwlxrgrk")
    public suspend fun relatedFindingsIds(values: List<Output<AutomationRuleCriteriaRelatedFindingsIdArgs>>) {
        this.relatedFindingsIds = Output.all(values)
    }

    /**
     * @param value The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("eelybxjfevtphtdv")
    public suspend fun relatedFindingsProductArns(`value`: Output<List<AutomationRuleCriteriaRelatedFindingsProductArnArgs>>) {
        this.relatedFindingsProductArns = value
    }

    @JvmName("uorcqugrnwdtumst")
    public suspend fun relatedFindingsProductArns(vararg values: Output<AutomationRuleCriteriaRelatedFindingsProductArnArgs>) {
        this.relatedFindingsProductArns = Output.all(values.asList())
    }

    /**
     * @param values The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("pfyqpprhoaucvoil")
    public suspend fun relatedFindingsProductArns(values: List<Output<AutomationRuleCriteriaRelatedFindingsProductArnArgs>>) {
        this.relatedFindingsProductArns = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("blfgrcbvaeyhshcx")
    public suspend fun resourceApplicationArns(`value`: Output<List<AutomationRuleCriteriaResourceApplicationArnArgs>>) {
        this.resourceApplicationArns = value
    }

    @JvmName("dbfysbdhksodbten")
    public suspend fun resourceApplicationArns(vararg values: Output<AutomationRuleCriteriaResourceApplicationArnArgs>) {
        this.resourceApplicationArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("dxjudeobrskxcepx")
    public suspend fun resourceApplicationArns(values: List<Output<AutomationRuleCriteriaResourceApplicationArnArgs>>) {
        this.resourceApplicationArns = Output.all(values)
    }

    /**
     * @param value The name of the application that is related to a finding. Documented below.
     */
    @JvmName("jbxecgenkgtdqiag")
    public suspend fun resourceApplicationNames(`value`: Output<List<AutomationRuleCriteriaResourceApplicationNameArgs>>) {
        this.resourceApplicationNames = value
    }

    @JvmName("wuldrkmfnotihflr")
    public suspend fun resourceApplicationNames(vararg values: Output<AutomationRuleCriteriaResourceApplicationNameArgs>) {
        this.resourceApplicationNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the application that is related to a finding. Documented below.
     */
    @JvmName("hghtiiyfueoegxur")
    public suspend fun resourceApplicationNames(values: List<Output<AutomationRuleCriteriaResourceApplicationNameArgs>>) {
        this.resourceApplicationNames = Output.all(values)
    }

    /**
     * @param value Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("gdntptlxxkrjikbi")
    public suspend fun resourceDetailsOthers(`value`: Output<List<AutomationRuleCriteriaResourceDetailsOtherArgs>>) {
        this.resourceDetailsOthers = value
    }

    @JvmName("wdvpoqyjvhctrtyy")
    public suspend fun resourceDetailsOthers(vararg values: Output<AutomationRuleCriteriaResourceDetailsOtherArgs>) {
        this.resourceDetailsOthers = Output.all(values.asList())
    }

    /**
     * @param values Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("nvoifmctbhekdpby")
    public suspend fun resourceDetailsOthers(values: List<Output<AutomationRuleCriteriaResourceDetailsOtherArgs>>) {
        this.resourceDetailsOthers = Output.all(values)
    }

    /**
     * @param value The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("fhulbsabggjnjnci")
    public suspend fun resourceIds(`value`: Output<List<AutomationRuleCriteriaResourceIdArgs>>) {
        this.resourceIds = value
    }

    @JvmName("bqbxpdhydhfjwtax")
    public suspend fun resourceIds(vararg values: Output<AutomationRuleCriteriaResourceIdArgs>) {
        this.resourceIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("pkbtfsujhnludwrk")
    public suspend fun resourceIds(values: List<Output<AutomationRuleCriteriaResourceIdArgs>>) {
        this.resourceIds = Output.all(values)
    }

    /**
     * @param value The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("fqgpncyckitdbjya")
    public suspend fun resourcePartitions(`value`: Output<List<AutomationRuleCriteriaResourcePartitionArgs>>) {
        this.resourcePartitions = value
    }

    @JvmName("emqtqifptfvsvere")
    public suspend fun resourcePartitions(vararg values: Output<AutomationRuleCriteriaResourcePartitionArgs>) {
        this.resourcePartitions = Output.all(values.asList())
    }

    /**
     * @param values The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("cncjwebviaqevybo")
    public suspend fun resourcePartitions(values: List<Output<AutomationRuleCriteriaResourcePartitionArgs>>) {
        this.resourcePartitions = Output.all(values)
    }

    /**
     * @param value The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("fckqucmwihcobiia")
    public suspend fun resourceRegions(`value`: Output<List<AutomationRuleCriteriaResourceRegionArgs>>) {
        this.resourceRegions = value
    }

    @JvmName("bonvttchshfgjjsg")
    public suspend fun resourceRegions(vararg values: Output<AutomationRuleCriteriaResourceRegionArgs>) {
        this.resourceRegions = Output.all(values.asList())
    }

    /**
     * @param values The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("uxdpbvwokogefhxi")
    public suspend fun resourceRegions(values: List<Output<AutomationRuleCriteriaResourceRegionArgs>>) {
        this.resourceRegions = Output.all(values)
    }

    /**
     * @param value A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("lbipidbabgcguyrr")
    public suspend fun resourceTags(`value`: Output<List<AutomationRuleCriteriaResourceTagArgs>>) {
        this.resourceTags = value
    }

    @JvmName("hyvodgvnbuqyvneu")
    public suspend fun resourceTags(vararg values: Output<AutomationRuleCriteriaResourceTagArgs>) {
        this.resourceTags = Output.all(values.asList())
    }

    /**
     * @param values A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("kwdllwsatuwxojql")
    public suspend fun resourceTags(values: List<Output<AutomationRuleCriteriaResourceTagArgs>>) {
        this.resourceTags = Output.all(values)
    }

    /**
     * @param value The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("jegajtxfmglbimdy")
    public suspend fun resourceTypes(`value`: Output<List<AutomationRuleCriteriaResourceTypeArgs>>) {
        this.resourceTypes = value
    }

    @JvmName("gmepjpoqfykfgmyf")
    public suspend fun resourceTypes(vararg values: Output<AutomationRuleCriteriaResourceTypeArgs>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("qyirsowjtnwovkcu")
    public suspend fun resourceTypes(values: List<Output<AutomationRuleCriteriaResourceTypeArgs>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value The severity value of the finding. Documented below.
     */
    @JvmName("ncmqhytuegjbbhoa")
    public suspend fun severityLabels(`value`: Output<List<AutomationRuleCriteriaSeverityLabelArgs>>) {
        this.severityLabels = value
    }

    @JvmName("bayyeslvqakhxquf")
    public suspend fun severityLabels(vararg values: Output<AutomationRuleCriteriaSeverityLabelArgs>) {
        this.severityLabels = Output.all(values.asList())
    }

    /**
     * @param values The severity value of the finding. Documented below.
     */
    @JvmName("oabemflhiqnudrbm")
    public suspend fun severityLabels(values: List<Output<AutomationRuleCriteriaSeverityLabelArgs>>) {
        this.severityLabels = Output.all(values)
    }

    /**
     * @param value Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("hukhurdsseanwsev")
    public suspend fun sourceUrls(`value`: Output<List<AutomationRuleCriteriaSourceUrlArgs>>) {
        this.sourceUrls = value
    }

    @JvmName("gdxauycodsfhiunx")
    public suspend fun sourceUrls(vararg values: Output<AutomationRuleCriteriaSourceUrlArgs>) {
        this.sourceUrls = Output.all(values.asList())
    }

    /**
     * @param values Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("eqljvjmkjeblhugc")
    public suspend fun sourceUrls(values: List<Output<AutomationRuleCriteriaSourceUrlArgs>>) {
        this.sourceUrls = Output.all(values)
    }

    /**
     * @param value A finding's title. Documented below.
     */
    @JvmName("mptgpvigsebbflna")
    public suspend fun titles(`value`: Output<List<AutomationRuleCriteriaTitleArgs>>) {
        this.titles = value
    }

    @JvmName("myxiypliijjkhnly")
    public suspend fun titles(vararg values: Output<AutomationRuleCriteriaTitleArgs>) {
        this.titles = Output.all(values.asList())
    }

    /**
     * @param values A finding's title. Documented below.
     */
    @JvmName("lborpllarouvtjxx")
    public suspend fun titles(values: List<Output<AutomationRuleCriteriaTitleArgs>>) {
        this.titles = Output.all(values)
    }

    /**
     * @param value One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("fowgqtwkfrlgwicm")
    public suspend fun types(`value`: Output<List<AutomationRuleCriteriaTypeArgs>>) {
        this.types = value
    }

    @JvmName("gxgckndjkvsptmfv")
    public suspend fun types(vararg values: Output<AutomationRuleCriteriaTypeArgs>) {
        this.types = Output.all(values.asList())
    }

    /**
     * @param values One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("uegfvpmjvbyqcngv")
    public suspend fun types(values: List<Output<AutomationRuleCriteriaTypeArgs>>) {
        this.types = Output.all(values)
    }

    /**
     * @param value A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("hucdkhbjtcawhxhs")
    public suspend fun updatedAts(`value`: Output<List<AutomationRuleCriteriaUpdatedAtArgs>>) {
        this.updatedAts = value
    }

    @JvmName("mnmjoqdvpqixhxrt")
    public suspend fun updatedAts(vararg values: Output<AutomationRuleCriteriaUpdatedAtArgs>) {
        this.updatedAts = Output.all(values.asList())
    }

    /**
     * @param values A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("sevmwubfrcicxxpu")
    public suspend fun updatedAts(values: List<Output<AutomationRuleCriteriaUpdatedAtArgs>>) {
        this.updatedAts = Output.all(values)
    }

    /**
     * @param value A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("qfypnfuethmoviov")
    public suspend fun userDefinedFields(`value`: Output<List<AutomationRuleCriteriaUserDefinedFieldArgs>>) {
        this.userDefinedFields = value
    }

    @JvmName("exlttibdptyuethl")
    public suspend fun userDefinedFields(vararg values: Output<AutomationRuleCriteriaUserDefinedFieldArgs>) {
        this.userDefinedFields = Output.all(values.asList())
    }

    /**
     * @param values A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("pxbcmewaiotprhvd")
    public suspend fun userDefinedFields(values: List<Output<AutomationRuleCriteriaUserDefinedFieldArgs>>) {
        this.userDefinedFields = Output.all(values)
    }

    /**
     * @param value Provides the veracity of a finding. Documented below.
     */
    @JvmName("cpkuymdubnwimlpk")
    public suspend fun verificationStates(`value`: Output<List<AutomationRuleCriteriaVerificationStateArgs>>) {
        this.verificationStates = value
    }

    @JvmName("inkvympgdhgdmplj")
    public suspend fun verificationStates(vararg values: Output<AutomationRuleCriteriaVerificationStateArgs>) {
        this.verificationStates = Output.all(values.asList())
    }

    /**
     * @param values Provides the veracity of a finding. Documented below.
     */
    @JvmName("ytyggnkqncssiwsp")
    public suspend fun verificationStates(values: List<Output<AutomationRuleCriteriaVerificationStateArgs>>) {
        this.verificationStates = Output.all(values)
    }

    /**
     * @param value Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("aarfkyxhiaullgcm")
    public suspend fun workflowStatuses(`value`: Output<List<AutomationRuleCriteriaWorkflowStatusArgs>>) {
        this.workflowStatuses = value
    }

    @JvmName("mjlbqperiwhexrfc")
    public suspend fun workflowStatuses(vararg values: Output<AutomationRuleCriteriaWorkflowStatusArgs>) {
        this.workflowStatuses = Output.all(values.asList())
    }

    /**
     * @param values Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("qcnowklfflgqxttk")
    public suspend fun workflowStatuses(values: List<Output<AutomationRuleCriteriaWorkflowStatusArgs>>) {
        this.workflowStatuses = Output.all(values)
    }

    /**
     * @param value The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("onrvtprtqfievhqg")
    public suspend fun awsAccountIds(`value`: List<AutomationRuleCriteriaAwsAccountIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountIds = mapped
    }

    /**
     * @param argument The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("sdhaxghejjxpkhtr")
    public suspend fun awsAccountIds(argument: List<suspend AutomationRuleCriteriaAwsAccountIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaAwsAccountIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccountIds = mapped
    }

    /**
     * @param argument The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("ogpkbclilrltagki")
    public suspend fun awsAccountIds(vararg argument: suspend AutomationRuleCriteriaAwsAccountIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaAwsAccountIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccountIds = mapped
    }

    /**
     * @param argument The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("vkujmbmubeqamemq")
    public suspend fun awsAccountIds(argument: suspend AutomationRuleCriteriaAwsAccountIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaAwsAccountIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.awsAccountIds = mapped
    }

    /**
     * @param values The AWS account ID in which a finding was generated. Documented below.
     */
    @JvmName("yaydfkrcqeejioiq")
    public suspend fun awsAccountIds(vararg values: AutomationRuleCriteriaAwsAccountIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsAccountIds = mapped
    }

    /**
     * @param value The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("gmwxlxortlbxmpkx")
    public suspend fun awsAccountNames(`value`: List<AutomationRuleCriteriaAwsAccountNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountNames = mapped
    }

    /**
     * @param argument The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("uxiofcaqacvgjepq")
    public suspend fun awsAccountNames(argument: List<suspend AutomationRuleCriteriaAwsAccountNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaAwsAccountNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccountNames = mapped
    }

    /**
     * @param argument The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("kxaslhfrcediypop")
    public suspend fun awsAccountNames(vararg argument: suspend AutomationRuleCriteriaAwsAccountNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaAwsAccountNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccountNames = mapped
    }

    /**
     * @param argument The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("rrmbucwgbfoequvt")
    public suspend fun awsAccountNames(argument: suspend AutomationRuleCriteriaAwsAccountNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaAwsAccountNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.awsAccountNames = mapped
    }

    /**
     * @param values The name of the AWS account in which a finding was generated. Documented below.
     */
    @JvmName("dvrmpsbyvcduiaqx")
    public suspend fun awsAccountNames(vararg values: AutomationRuleCriteriaAwsAccountNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsAccountNames = mapped
    }

    /**
     * @param value The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("vrjlleksbdmilfuy")
    public suspend fun companyNames(`value`: List<AutomationRuleCriteriaCompanyNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyNames = mapped
    }

    /**
     * @param argument The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("eqrccrtlsdrkcngf")
    public suspend fun companyNames(argument: List<suspend AutomationRuleCriteriaCompanyNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaCompanyNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.companyNames = mapped
    }

    /**
     * @param argument The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("aneuxnjshtbshjxl")
    public suspend fun companyNames(vararg argument: suspend AutomationRuleCriteriaCompanyNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaCompanyNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.companyNames = mapped
    }

    /**
     * @param argument The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("pbyebxxfqaruoxuu")
    public suspend fun companyNames(argument: suspend AutomationRuleCriteriaCompanyNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaCompanyNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.companyNames = mapped
    }

    /**
     * @param values The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
     */
    @JvmName("lvndqwkrkuxykmri")
    public suspend fun companyNames(vararg values: AutomationRuleCriteriaCompanyNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.companyNames = mapped
    }

    /**
     * @param value The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("pykxsrgeaqcjhyrt")
    public suspend fun complianceAssociatedStandardsIds(`value`: List<AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceAssociatedStandardsIds = mapped
    }

    /**
     * @param argument The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("wljfefkecklvvxbm")
    public suspend fun complianceAssociatedStandardsIds(argument: List<suspend AutomationRuleCriteriaComplianceAssociatedStandardsIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaComplianceAssociatedStandardsIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceAssociatedStandardsIds = mapped
    }

    /**
     * @param argument The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("ggbidexjsnflvyna")
    public suspend fun complianceAssociatedStandardsIds(vararg argument: suspend AutomationRuleCriteriaComplianceAssociatedStandardsIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaComplianceAssociatedStandardsIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceAssociatedStandardsIds = mapped
    }

    /**
     * @param argument The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("yyjbrvhxcqwdwhaq")
    public suspend fun complianceAssociatedStandardsIds(argument: suspend AutomationRuleCriteriaComplianceAssociatedStandardsIdArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AutomationRuleCriteriaComplianceAssociatedStandardsIdArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.complianceAssociatedStandardsIds = mapped
    }

    /**
     * @param values The unique identifier of a standard in which a control is enabled. Documented below.
     */
    @JvmName("hbhsytalbayvurpe")
    public suspend fun complianceAssociatedStandardsIds(vararg values: AutomationRuleCriteriaComplianceAssociatedStandardsIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceAssociatedStandardsIds = mapped
    }

    /**
     * @param value The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("teyirhwvcybiiote")
    public suspend fun complianceSecurityControlIds(`value`: List<AutomationRuleCriteriaComplianceSecurityControlIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceSecurityControlIds = mapped
    }

    /**
     * @param argument The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("arxgopsqtmnyyoxw")
    public suspend fun complianceSecurityControlIds(argument: List<suspend AutomationRuleCriteriaComplianceSecurityControlIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaComplianceSecurityControlIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceSecurityControlIds = mapped
    }

    /**
     * @param argument The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("agyqowtmvmbdquqw")
    public suspend fun complianceSecurityControlIds(vararg argument: suspend AutomationRuleCriteriaComplianceSecurityControlIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaComplianceSecurityControlIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceSecurityControlIds = mapped
    }

    /**
     * @param argument The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("khslopkenulmwvfm")
    public suspend fun complianceSecurityControlIds(argument: suspend AutomationRuleCriteriaComplianceSecurityControlIdArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AutomationRuleCriteriaComplianceSecurityControlIdArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.complianceSecurityControlIds = mapped
    }

    /**
     * @param values The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
     */
    @JvmName("tvvnghgbyjtaroca")
    public suspend fun complianceSecurityControlIds(vararg values: AutomationRuleCriteriaComplianceSecurityControlIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceSecurityControlIds = mapped
    }

    /**
     * @param value The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("cpttiberjvtvjfps")
    public suspend fun complianceStatuses(`value`: List<AutomationRuleCriteriaComplianceStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceStatuses = mapped
    }

    /**
     * @param argument The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("clfhfukjxqbarbej")
    public suspend fun complianceStatuses(argument: List<suspend AutomationRuleCriteriaComplianceStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaComplianceStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceStatuses = mapped
    }

    /**
     * @param argument The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("vdsqiphveftbxkvb")
    public suspend fun complianceStatuses(vararg argument: suspend AutomationRuleCriteriaComplianceStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaComplianceStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceStatuses = mapped
    }

    /**
     * @param argument The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("nsmewtquojabkvaw")
    public suspend fun complianceStatuses(argument: suspend AutomationRuleCriteriaComplianceStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaComplianceStatusArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.complianceStatuses = mapped
    }

    /**
     * @param values The result of a security check. This field is only used for findings generated from controls. Documented below.
     */
    @JvmName("fiocoqfrrlbeujxi")
    public suspend fun complianceStatuses(vararg values: AutomationRuleCriteriaComplianceStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceStatuses = mapped
    }

    /**
     * @param value The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("steqjcprputmojyu")
    public suspend fun confidences(`value`: List<AutomationRuleCriteriaConfidenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidences = mapped
    }

    /**
     * @param argument The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("ebvlpdssyjpqebca")
    public suspend fun confidences(argument: List<suspend AutomationRuleCriteriaConfidenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaConfidenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.confidences = mapped
    }

    /**
     * @param argument The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("fhruvvcsairsinwg")
    public suspend fun confidences(vararg argument: suspend AutomationRuleCriteriaConfidenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaConfidenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.confidences = mapped
    }

    /**
     * @param argument The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("pclceeqhsqhuspta")
    public suspend fun confidences(argument: suspend AutomationRuleCriteriaConfidenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaConfidenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.confidences = mapped
    }

    /**
     * @param values The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
     */
    @JvmName("mqdsaanjieylsfbq")
    public suspend fun confidences(vararg values: AutomationRuleCriteriaConfidenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.confidences = mapped
    }

    /**
     * @param value A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("iyjlgsgpmxnwovks")
    public suspend fun createdAts(`value`: List<AutomationRuleCriteriaCreatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("fdpmkyenlhfiakqg")
    public suspend fun createdAts(argument: List<suspend AutomationRuleCriteriaCreatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaCreatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createdAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("ranmrsejqqoosysi")
    public suspend fun createdAts(vararg argument: suspend AutomationRuleCriteriaCreatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaCreatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createdAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("faqyxpatkiyjvnop")
    public suspend fun createdAts(argument: suspend AutomationRuleCriteriaCreatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaCreatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.createdAts = mapped
    }

    /**
     * @param values A timestamp that indicates when this finding record was created. Documented below.
     */
    @JvmName("pmyknpatgtptgtwx")
    public suspend fun createdAts(vararg values: AutomationRuleCriteriaCreatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdAts = mapped
    }

    /**
     * @param value The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("vwvxxsxsfvglevhe")
    public suspend fun criticalities(`value`: List<AutomationRuleCriteriaCriticalityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criticalities = mapped
    }

    /**
     * @param argument The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("pfuklbujaaqqpkfk")
    public suspend fun criticalities(argument: List<suspend AutomationRuleCriteriaCriticalityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaCriticalityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.criticalities = mapped
    }

    /**
     * @param argument The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("fnpamgdermibdwat")
    public suspend fun criticalities(vararg argument: suspend AutomationRuleCriteriaCriticalityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaCriticalityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.criticalities = mapped
    }

    /**
     * @param argument The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("lhoqsxuswunlgrkh")
    public suspend fun criticalities(argument: suspend AutomationRuleCriteriaCriticalityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaCriticalityArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.criticalities = mapped
    }

    /**
     * @param values The level of importance that is assigned to the resources that are associated with a finding. Documented below.
     */
    @JvmName("lbhdcvdwwiofkajj")
    public suspend fun criticalities(vararg values: AutomationRuleCriteriaCriticalityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criticalities = mapped
    }

    /**
     * @param value A finding's description. Documented below.
     */
    @JvmName("mnwsnaqetwvxxyfa")
    public suspend fun descriptions(`value`: List<AutomationRuleCriteriaDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descriptions = mapped
    }

    /**
     * @param argument A finding's description. Documented below.
     */
    @JvmName("slifqkgmbcveaggx")
    public suspend fun descriptions(argument: List<suspend AutomationRuleCriteriaDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.descriptions = mapped
    }

    /**
     * @param argument A finding's description. Documented below.
     */
    @JvmName("bxquyjrndtaasyxu")
    public suspend fun descriptions(vararg argument: suspend AutomationRuleCriteriaDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.descriptions = mapped
    }

    /**
     * @param argument A finding's description. Documented below.
     */
    @JvmName("odyhdkogqdgjcpey")
    public suspend fun descriptions(argument: suspend AutomationRuleCriteriaDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.descriptions = mapped
    }

    /**
     * @param values A finding's description. Documented below.
     */
    @JvmName("vledaohuvbjlqltj")
    public suspend fun descriptions(vararg values: AutomationRuleCriteriaDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descriptions = mapped
    }

    /**
     * @param value A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("bxsmvxdgkfihgrbf")
    public suspend fun firstObservedAts(`value`: List<AutomationRuleCriteriaFirstObservedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstObservedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("rjfxovlcxhegygio")
    public suspend fun firstObservedAts(argument: List<suspend AutomationRuleCriteriaFirstObservedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaFirstObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firstObservedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("amjaymdfgekigbdj")
    public suspend fun firstObservedAts(vararg argument: suspend AutomationRuleCriteriaFirstObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaFirstObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firstObservedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("tkqdydpxcahisuvg")
    public suspend fun firstObservedAts(argument: suspend AutomationRuleCriteriaFirstObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaFirstObservedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.firstObservedAts = mapped
    }

    /**
     * @param values A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
     */
    @JvmName("myqymydgmxkxrcef")
    public suspend fun firstObservedAts(vararg values: AutomationRuleCriteriaFirstObservedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firstObservedAts = mapped
    }

    /**
     * @param value The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("lgwgvhokhyendjbf")
    public suspend fun generatorIds(`value`: List<AutomationRuleCriteriaGeneratorIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generatorIds = mapped
    }

    /**
     * @param argument The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("aerycmfxxrdohxyh")
    public suspend fun generatorIds(argument: List<suspend AutomationRuleCriteriaGeneratorIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaGeneratorIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.generatorIds = mapped
    }

    /**
     * @param argument The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("vfyhhtdtvmnxwcej")
    public suspend fun generatorIds(vararg argument: suspend AutomationRuleCriteriaGeneratorIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaGeneratorIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.generatorIds = mapped
    }

    /**
     * @param argument The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("fbcpqafwugmrdveq")
    public suspend fun generatorIds(argument: suspend AutomationRuleCriteriaGeneratorIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaGeneratorIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.generatorIds = mapped
    }

    /**
     * @param values The identifier for the solution-specific component that generated a finding. Documented below.
     */
    @JvmName("hgkeqrdpjxafemhn")
    public suspend fun generatorIds(vararg values: AutomationRuleCriteriaGeneratorIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generatorIds = mapped
    }

    /**
     * @param value The product-specific identifier for a finding. Documented below.
     */
    @JvmName("plsrgaynwfqwlxso")
    public suspend fun ids(`value`: List<AutomationRuleCriteriaIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ids = mapped
    }

    /**
     * @param argument The product-specific identifier for a finding. Documented below.
     */
    @JvmName("trthpkqonchsdflv")
    public suspend fun ids(argument: List<suspend AutomationRuleCriteriaIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param argument The product-specific identifier for a finding. Documented below.
     */
    @JvmName("kohlmugwqyrlusfg")
    public suspend fun ids(vararg argument: suspend AutomationRuleCriteriaIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param argument The product-specific identifier for a finding. Documented below.
     */
    @JvmName("quvnnkvqwbwnflew")
    public suspend fun ids(argument: suspend AutomationRuleCriteriaIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param values The product-specific identifier for a finding. Documented below.
     */
    @JvmName("ltmkxbhxwmqdrqoe")
    public suspend fun ids(vararg values: AutomationRuleCriteriaIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ids = mapped
    }

    /**
     * @param value A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("acyydfqqpajyxcps")
    public suspend fun lastObservedAts(`value`: List<AutomationRuleCriteriaLastObservedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastObservedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("ntdeiqnlgwgybryy")
    public suspend fun lastObservedAts(argument: List<suspend AutomationRuleCriteriaLastObservedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaLastObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.lastObservedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("caejxkgaoympfqsa")
    public suspend fun lastObservedAts(vararg argument: suspend AutomationRuleCriteriaLastObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaLastObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.lastObservedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("tbhrhhbvnugrsscg")
    public suspend fun lastObservedAts(argument: suspend AutomationRuleCriteriaLastObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaLastObservedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lastObservedAts = mapped
    }

    /**
     * @param values A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
     */
    @JvmName("sadbjsdbqedhcfbv")
    public suspend fun lastObservedAts(vararg values: AutomationRuleCriteriaLastObservedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastObservedAts = mapped
    }

    /**
     * @param value The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("wxvfumbluornlicb")
    public suspend fun noteTexts(`value`: List<AutomationRuleCriteriaNoteTextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteTexts = mapped
    }

    /**
     * @param argument The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("eaqepbvwxlfmmddu")
    public suspend fun noteTexts(argument: List<suspend AutomationRuleCriteriaNoteTextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaNoteTextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noteTexts = mapped
    }

    /**
     * @param argument The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("saouestewefmrydc")
    public suspend fun noteTexts(vararg argument: suspend AutomationRuleCriteriaNoteTextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaNoteTextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noteTexts = mapped
    }

    /**
     * @param argument The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("ooxomvcqogpgqype")
    public suspend fun noteTexts(argument: suspend AutomationRuleCriteriaNoteTextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaNoteTextArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.noteTexts = mapped
    }

    /**
     * @param values The text of a user-defined note that's added to a finding. Documented below.
     */
    @JvmName("yyacmgstihburyfj")
    public suspend fun noteTexts(vararg values: AutomationRuleCriteriaNoteTextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noteTexts = mapped
    }

    /**
     * @param value The timestamp of when the note was updated. Documented below.
     */
    @JvmName("xvaguufheevmpfgo")
    public suspend fun noteUpdatedAts(`value`: List<AutomationRuleCriteriaNoteUpdatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteUpdatedAts = mapped
    }

    /**
     * @param argument The timestamp of when the note was updated. Documented below.
     */
    @JvmName("jxkatehavsuutoaa")
    public suspend fun noteUpdatedAts(argument: List<suspend AutomationRuleCriteriaNoteUpdatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaNoteUpdatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedAts = mapped
    }

    /**
     * @param argument The timestamp of when the note was updated. Documented below.
     */
    @JvmName("hinudhrmbypiopbc")
    public suspend fun noteUpdatedAts(vararg argument: suspend AutomationRuleCriteriaNoteUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaNoteUpdatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedAts = mapped
    }

    /**
     * @param argument The timestamp of when the note was updated. Documented below.
     */
    @JvmName("jvegrnspgxqfcocv")
    public suspend fun noteUpdatedAts(argument: suspend AutomationRuleCriteriaNoteUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaNoteUpdatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.noteUpdatedAts = mapped
    }

    /**
     * @param values The timestamp of when the note was updated. Documented below.
     */
    @JvmName("akpjqalubddhtlie")
    public suspend fun noteUpdatedAts(vararg values: AutomationRuleCriteriaNoteUpdatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noteUpdatedAts = mapped
    }

    /**
     * @param value The principal that created a note. Documented below.
     */
    @JvmName("wrwommhcfgcnjfxc")
    public suspend fun noteUpdatedBies(`value`: List<AutomationRuleCriteriaNoteUpdatedByArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteUpdatedBies = mapped
    }

    /**
     * @param argument The principal that created a note. Documented below.
     */
    @JvmName("wurwgdybufkufxiu")
    public suspend fun noteUpdatedBies(argument: List<suspend AutomationRuleCriteriaNoteUpdatedByArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaNoteUpdatedByArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedBies = mapped
    }

    /**
     * @param argument The principal that created a note. Documented below.
     */
    @JvmName("mbuwejsgbqtjvgoj")
    public suspend fun noteUpdatedBies(vararg argument: suspend AutomationRuleCriteriaNoteUpdatedByArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaNoteUpdatedByArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedBies = mapped
    }

    /**
     * @param argument The principal that created a note. Documented below.
     */
    @JvmName("ecoqnqtgsofhmsax")
    public suspend fun noteUpdatedBies(argument: suspend AutomationRuleCriteriaNoteUpdatedByArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaNoteUpdatedByArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.noteUpdatedBies = mapped
    }

    /**
     * @param values The principal that created a note. Documented below.
     */
    @JvmName("otkxymokfuhnnbou")
    public suspend fun noteUpdatedBies(vararg values: AutomationRuleCriteriaNoteUpdatedByArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noteUpdatedBies = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("hgpxewxldoqbjqop")
    public suspend fun productArns(`value`: List<AutomationRuleCriteriaProductArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productArns = mapped
    }

    /**
     * @param argument The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("cyhcrlnftsfsvaia")
    public suspend fun productArns(argument: List<suspend AutomationRuleCriteriaProductArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaProductArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.productArns = mapped
    }

    /**
     * @param argument The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("waqodngurpgedsah")
    public suspend fun productArns(vararg argument: suspend AutomationRuleCriteriaProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaProductArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.productArns = mapped
    }

    /**
     * @param argument The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("kyqiugbptionskiq")
    public suspend fun productArns(argument: suspend AutomationRuleCriteriaProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaProductArnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.productArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
     */
    @JvmName("mpnbuwvkslrjdoyi")
    public suspend fun productArns(vararg values: AutomationRuleCriteriaProductArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productArns = mapped
    }

    /**
     * @param value Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("ouhotqqufdgdxhqg")
    public suspend fun productNames(`value`: List<AutomationRuleCriteriaProductNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productNames = mapped
    }

    /**
     * @param argument Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("yxuettqtuixgatfd")
    public suspend fun productNames(argument: List<suspend AutomationRuleCriteriaProductNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaProductNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.productNames = mapped
    }

    /**
     * @param argument Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("vbpkbbopcshlrbyh")
    public suspend fun productNames(vararg argument: suspend AutomationRuleCriteriaProductNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaProductNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.productNames = mapped
    }

    /**
     * @param argument Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("erfctqxcqhxseiob")
    public suspend fun productNames(argument: suspend AutomationRuleCriteriaProductNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaProductNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.productNames = mapped
    }

    /**
     * @param values Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
     */
    @JvmName("pugartljbygbqxrs")
    public suspend fun productNames(vararg values: AutomationRuleCriteriaProductNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productNames = mapped
    }

    /**
     * @param value Provides the current state of a finding. Documented below.
     */
    @JvmName("fuqbmmqqjehllgew")
    public suspend fun recordStates(`value`: List<AutomationRuleCriteriaRecordStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordStates = mapped
    }

    /**
     * @param argument Provides the current state of a finding. Documented below.
     */
    @JvmName("lxxycljljrllbkdw")
    public suspend fun recordStates(argument: List<suspend AutomationRuleCriteriaRecordStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaRecordStateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recordStates = mapped
    }

    /**
     * @param argument Provides the current state of a finding. Documented below.
     */
    @JvmName("naolilkamxnlqlxu")
    public suspend fun recordStates(vararg argument: suspend AutomationRuleCriteriaRecordStateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaRecordStateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recordStates = mapped
    }

    /**
     * @param argument Provides the current state of a finding. Documented below.
     */
    @JvmName("wocarymsbdnpwrcp")
    public suspend fun recordStates(argument: suspend AutomationRuleCriteriaRecordStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaRecordStateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.recordStates = mapped
    }

    /**
     * @param values Provides the current state of a finding. Documented below.
     */
    @JvmName("vudhnchmnyqkfdej")
    public suspend fun recordStates(vararg values: AutomationRuleCriteriaRecordStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordStates = mapped
    }

    /**
     * @param value The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("kodltbaaoxrhukqy")
    public suspend fun relatedFindingsIds(`value`: List<AutomationRuleCriteriaRelatedFindingsIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedFindingsIds = mapped
    }

    /**
     * @param argument The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("xnsxfpxaawpixqqn")
    public suspend fun relatedFindingsIds(argument: List<suspend AutomationRuleCriteriaRelatedFindingsIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaRelatedFindingsIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsIds = mapped
    }

    /**
     * @param argument The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("xgoxxwkpsmqkkhvi")
    public suspend fun relatedFindingsIds(vararg argument: suspend AutomationRuleCriteriaRelatedFindingsIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaRelatedFindingsIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsIds = mapped
    }

    /**
     * @param argument The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("eeeslkqvutcdurqr")
    public suspend fun relatedFindingsIds(argument: suspend AutomationRuleCriteriaRelatedFindingsIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaRelatedFindingsIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.relatedFindingsIds = mapped
    }

    /**
     * @param values The product-generated identifier for a related finding.  Documented below.
     */
    @JvmName("fbnrryljtkticrqk")
    public suspend fun relatedFindingsIds(vararg values: AutomationRuleCriteriaRelatedFindingsIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedFindingsIds = mapped
    }

    /**
     * @param value The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("dordpcjatyqhoxjx")
    public suspend fun relatedFindingsProductArns(`value`: List<AutomationRuleCriteriaRelatedFindingsProductArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("jphqiauvacvwwxxb")
    public suspend fun relatedFindingsProductArns(argument: List<suspend AutomationRuleCriteriaRelatedFindingsProductArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaRelatedFindingsProductArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("jmjdhgvjdmipxakd")
    public suspend fun relatedFindingsProductArns(vararg argument: suspend AutomationRuleCriteriaRelatedFindingsProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaRelatedFindingsProductArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("kcdwbrbmifqeeyox")
    public suspend fun relatedFindingsProductArns(argument: suspend AutomationRuleCriteriaRelatedFindingsProductArnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AutomationRuleCriteriaRelatedFindingsProductArnArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param values The ARN for the product that generated a related finding. Documented below.
     */
    @JvmName("sytkuswxvpjuvrwc")
    public suspend fun relatedFindingsProductArns(vararg values: AutomationRuleCriteriaRelatedFindingsProductArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("prqwwxvhltuqvrdo")
    public suspend fun resourceApplicationArns(`value`: List<AutomationRuleCriteriaResourceApplicationArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceApplicationArns = mapped
    }

    /**
     * @param argument The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("htpvbykvyhuvtfcl")
    public suspend fun resourceApplicationArns(argument: List<suspend AutomationRuleCriteriaResourceApplicationArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceApplicationArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceApplicationArns = mapped
    }

    /**
     * @param argument The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("qkfcgnwkjualayvr")
    public suspend fun resourceApplicationArns(vararg argument: suspend AutomationRuleCriteriaResourceApplicationArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceApplicationArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceApplicationArns = mapped
    }

    /**
     * @param argument The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("casbpxvtywplacdy")
    public suspend fun resourceApplicationArns(argument: suspend AutomationRuleCriteriaResourceApplicationArnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceApplicationArnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceApplicationArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
     */
    @JvmName("nxwfxdsqtprescxj")
    public suspend fun resourceApplicationArns(vararg values: AutomationRuleCriteriaResourceApplicationArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceApplicationArns = mapped
    }

    /**
     * @param value The name of the application that is related to a finding. Documented below.
     */
    @JvmName("vedgpfslxhpjwxoh")
    public suspend fun resourceApplicationNames(`value`: List<AutomationRuleCriteriaResourceApplicationNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceApplicationNames = mapped
    }

    /**
     * @param argument The name of the application that is related to a finding. Documented below.
     */
    @JvmName("kuednjqfvpijqtjn")
    public suspend fun resourceApplicationNames(argument: List<suspend AutomationRuleCriteriaResourceApplicationNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceApplicationNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceApplicationNames = mapped
    }

    /**
     * @param argument The name of the application that is related to a finding. Documented below.
     */
    @JvmName("ohpawtqdaovtnsys")
    public suspend fun resourceApplicationNames(vararg argument: suspend AutomationRuleCriteriaResourceApplicationNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceApplicationNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceApplicationNames = mapped
    }

    /**
     * @param argument The name of the application that is related to a finding. Documented below.
     */
    @JvmName("klpivbiclbkigfhg")
    public suspend fun resourceApplicationNames(argument: suspend AutomationRuleCriteriaResourceApplicationNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceApplicationNameArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceApplicationNames = mapped
    }

    /**
     * @param values The name of the application that is related to a finding. Documented below.
     */
    @JvmName("mpcflyhuugiuifij")
    public suspend fun resourceApplicationNames(vararg values: AutomationRuleCriteriaResourceApplicationNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceApplicationNames = mapped
    }

    /**
     * @param value Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("wxmqhojyjyrqpcwg")
    public suspend fun resourceDetailsOthers(`value`: List<AutomationRuleCriteriaResourceDetailsOtherArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param argument Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("iycnkgjbtdmslkpb")
    public suspend fun resourceDetailsOthers(argument: List<suspend AutomationRuleCriteriaResourceDetailsOtherArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceDetailsOtherArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param argument Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("mqjbauivpypuflmq")
    public suspend fun resourceDetailsOthers(vararg argument: suspend AutomationRuleCriteriaResourceDetailsOtherArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceDetailsOtherArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param argument Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("qdhvvxikphmvdcwb")
    public suspend fun resourceDetailsOthers(argument: suspend AutomationRuleCriteriaResourceDetailsOtherArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceDetailsOtherArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param values Custom fields and values about the resource that a finding pertains to. Documented below.
     */
    @JvmName("ipbhtmhbqesrudwo")
    public suspend fun resourceDetailsOthers(vararg values: AutomationRuleCriteriaResourceDetailsOtherArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param value The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("vigqopfigrovklux")
    public suspend fun resourceIds(`value`: List<AutomationRuleCriteriaResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIds = mapped
    }

    /**
     * @param argument The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("ujlivrxhymdsbxyh")
    public suspend fun resourceIds(argument: List<suspend AutomationRuleCriteriaResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceIds = mapped
    }

    /**
     * @param argument The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("upnoxdlptidwvtrw")
    public suspend fun resourceIds(vararg argument: suspend AutomationRuleCriteriaResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceIds = mapped
    }

    /**
     * @param argument The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("riyypkhdtlodaeul")
    public suspend fun resourceIds(argument: suspend AutomationRuleCriteriaResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceIds = mapped
    }

    /**
     * @param values The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
     */
    @JvmName("qgylkbvedmbjuehq")
    public suspend fun resourceIds(vararg values: AutomationRuleCriteriaResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceIds = mapped
    }

    /**
     * @param value The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("oyurckgiygkxotay")
    public suspend fun resourcePartitions(`value`: List<AutomationRuleCriteriaResourcePartitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePartitions = mapped
    }

    /**
     * @param argument The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("bqumdwbnqxuecigh")
    public suspend fun resourcePartitions(argument: List<suspend AutomationRuleCriteriaResourcePartitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourcePartitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourcePartitions = mapped
    }

    /**
     * @param argument The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("cnmvhkgrdmbejvyu")
    public suspend fun resourcePartitions(vararg argument: suspend AutomationRuleCriteriaResourcePartitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourcePartitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourcePartitions = mapped
    }

    /**
     * @param argument The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("niptyeqsueckotou")
    public suspend fun resourcePartitions(argument: suspend AutomationRuleCriteriaResourcePartitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourcePartitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourcePartitions = mapped
    }

    /**
     * @param values The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
     */
    @JvmName("glqvcieqgrkfkftt")
    public suspend fun resourcePartitions(vararg values: AutomationRuleCriteriaResourcePartitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourcePartitions = mapped
    }

    /**
     * @param value The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("iggrmitiuxhtovuy")
    public suspend fun resourceRegions(`value`: List<AutomationRuleCriteriaResourceRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRegions = mapped
    }

    /**
     * @param argument The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("icnhsmbkmpdmunxl")
    public suspend fun resourceRegions(argument: List<suspend AutomationRuleCriteriaResourceRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRegions = mapped
    }

    /**
     * @param argument The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("knmwspwqjgqsbaup")
    public suspend fun resourceRegions(vararg argument: suspend AutomationRuleCriteriaResourceRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRegions = mapped
    }

    /**
     * @param argument The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("epobdixrwhumrcya")
    public suspend fun resourceRegions(argument: suspend AutomationRuleCriteriaResourceRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceRegions = mapped
    }

    /**
     * @param values The AWS Region where the resource that a finding pertains to is located. Documented below.
     */
    @JvmName("sxuvdxhsinfmyesn")
    public suspend fun resourceRegions(vararg values: AutomationRuleCriteriaResourceRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceRegions = mapped
    }

    /**
     * @param value A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("flgpuaipsunvktfb")
    public suspend fun resourceTags(`value`: List<AutomationRuleCriteriaResourceTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param argument A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("riwkshknkyvvxiop")
    public suspend fun resourceTags(argument: List<suspend AutomationRuleCriteriaResourceTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("upurctgtawcpwyfh")
    public suspend fun resourceTags(vararg argument: suspend AutomationRuleCriteriaResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("lpbidhcmtbwhgjwb")
    public suspend fun resourceTags(argument: suspend AutomationRuleCriteriaResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceTagArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param values A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
     */
    @JvmName("yyeivbibeboyjupb")
    public suspend fun resourceTags(vararg values: AutomationRuleCriteriaResourceTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("auciffoejxvnwswu")
    public suspend fun resourceTypes(`value`: List<AutomationRuleCriteriaResourceTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param argument The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("eiamjmjjbctnctxt")
    public suspend fun resourceTypes(argument: List<suspend AutomationRuleCriteriaResourceTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param argument The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("qtupypremdjmscmb")
    public suspend fun resourceTypes(vararg argument: suspend AutomationRuleCriteriaResourceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaResourceTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param argument The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("iywmveaecmpnodyt")
    public suspend fun resourceTypes(argument: suspend AutomationRuleCriteriaResourceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaResourceTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param values The type of resource that the finding pertains to. Documented below.
     */
    @JvmName("jmhlytbduvrxdask")
    public suspend fun resourceTypes(vararg values: AutomationRuleCriteriaResourceTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value The severity value of the finding. Documented below.
     */
    @JvmName("ibdthynrnwhjejnp")
    public suspend fun severityLabels(`value`: List<AutomationRuleCriteriaSeverityLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severityLabels = mapped
    }

    /**
     * @param argument The severity value of the finding. Documented below.
     */
    @JvmName("fdgswwwtgnguoggf")
    public suspend fun severityLabels(argument: List<suspend AutomationRuleCriteriaSeverityLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaSeverityLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.severityLabels = mapped
    }

    /**
     * @param argument The severity value of the finding. Documented below.
     */
    @JvmName("ppeugpccbsoxtyay")
    public suspend fun severityLabels(vararg argument: suspend AutomationRuleCriteriaSeverityLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaSeverityLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.severityLabels = mapped
    }

    /**
     * @param argument The severity value of the finding. Documented below.
     */
    @JvmName("ysclnktgdmqasynm")
    public suspend fun severityLabels(argument: suspend AutomationRuleCriteriaSeverityLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaSeverityLabelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.severityLabels = mapped
    }

    /**
     * @param values The severity value of the finding. Documented below.
     */
    @JvmName("lecfncdivhxjtkco")
    public suspend fun severityLabels(vararg values: AutomationRuleCriteriaSeverityLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severityLabels = mapped
    }

    /**
     * @param value Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("hqnrvpmmxiqxlcux")
    public suspend fun sourceUrls(`value`: List<AutomationRuleCriteriaSourceUrlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUrls = mapped
    }

    /**
     * @param argument Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("uidqndgiovnkbhbh")
    public suspend fun sourceUrls(argument: List<suspend AutomationRuleCriteriaSourceUrlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaSourceUrlArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceUrls = mapped
    }

    /**
     * @param argument Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("rcbipfcukyckgkik")
    public suspend fun sourceUrls(vararg argument: suspend AutomationRuleCriteriaSourceUrlArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaSourceUrlArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceUrls = mapped
    }

    /**
     * @param argument Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("qgqogrrwmyacbodc")
    public suspend fun sourceUrls(argument: suspend AutomationRuleCriteriaSourceUrlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaSourceUrlArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceUrls = mapped
    }

    /**
     * @param values Provides a URL that links to a page about the current finding in the finding product. Documented below.
     */
    @JvmName("srohstrcgiyisrpl")
    public suspend fun sourceUrls(vararg values: AutomationRuleCriteriaSourceUrlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceUrls = mapped
    }

    /**
     * @param value A finding's title. Documented below.
     */
    @JvmName("ktpkegamqiscabun")
    public suspend fun titles(`value`: List<AutomationRuleCriteriaTitleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.titles = mapped
    }

    /**
     * @param argument A finding's title. Documented below.
     */
    @JvmName("aogbebttxewavtxf")
    public suspend fun titles(argument: List<suspend AutomationRuleCriteriaTitleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaTitleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.titles = mapped
    }

    /**
     * @param argument A finding's title. Documented below.
     */
    @JvmName("dqbuxehvcmyhaluo")
    public suspend fun titles(vararg argument: suspend AutomationRuleCriteriaTitleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaTitleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.titles = mapped
    }

    /**
     * @param argument A finding's title. Documented below.
     */
    @JvmName("bmjpunmumehgbjfh")
    public suspend fun titles(argument: suspend AutomationRuleCriteriaTitleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaTitleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.titles = mapped
    }

    /**
     * @param values A finding's title. Documented below.
     */
    @JvmName("basbvpwhxqlvwkae")
    public suspend fun titles(vararg values: AutomationRuleCriteriaTitleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.titles = mapped
    }

    /**
     * @param value One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("fpqdluaulfncvfrw")
    public suspend fun types(`value`: List<AutomationRuleCriteriaTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param argument One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("dhyecemydqgujmsf")
    public suspend fun types(argument: List<suspend AutomationRuleCriteriaTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.types = mapped
    }

    /**
     * @param argument One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("lyrwkchcwgwqouca")
    public suspend fun types(vararg argument: suspend AutomationRuleCriteriaTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.types = mapped
    }

    /**
     * @param argument One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("ejsvappdcaurnlbg")
    public suspend fun types(argument: suspend AutomationRuleCriteriaTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.types = mapped
    }

    /**
     * @param values One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
     */
    @JvmName("opjpeqqqatwntlai")
    public suspend fun types(vararg values: AutomationRuleCriteriaTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param value A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("xjwlectpwjkfclcs")
    public suspend fun updatedAts(`value`: List<AutomationRuleCriteriaUpdatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("pfwbbhjorpaeyikr")
    public suspend fun updatedAts(argument: List<suspend AutomationRuleCriteriaUpdatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaUpdatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.updatedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("rsgvulrrshwvapvy")
    public suspend fun updatedAts(vararg argument: suspend AutomationRuleCriteriaUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaUpdatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.updatedAts = mapped
    }

    /**
     * @param argument A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("blafxfsmkhwxfvjo")
    public suspend fun updatedAts(argument: suspend AutomationRuleCriteriaUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaUpdatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.updatedAts = mapped
    }

    /**
     * @param values A timestamp that indicates when the finding record was most recently updated. Documented below.
     */
    @JvmName("jknfgticbxbjyhcf")
    public suspend fun updatedAts(vararg values: AutomationRuleCriteriaUpdatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updatedAts = mapped
    }

    /**
     * @param value A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("ynimrblotkgwcsjv")
    public suspend fun userDefinedFields(`value`: List<AutomationRuleCriteriaUserDefinedFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefinedFields = mapped
    }

    /**
     * @param argument A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("vbxtooqcdtamsnrc")
    public suspend fun userDefinedFields(argument: List<suspend AutomationRuleCriteriaUserDefinedFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaUserDefinedFieldArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userDefinedFields = mapped
    }

    /**
     * @param argument A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("pcibqxumrpskcjel")
    public suspend fun userDefinedFields(vararg argument: suspend AutomationRuleCriteriaUserDefinedFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaUserDefinedFieldArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userDefinedFields = mapped
    }

    /**
     * @param argument A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("oldiotshciucefbb")
    public suspend fun userDefinedFields(argument: suspend AutomationRuleCriteriaUserDefinedFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaUserDefinedFieldArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.userDefinedFields = mapped
    }

    /**
     * @param values A list of user-defined name and value string pairs added to a finding. Documented below.
     */
    @JvmName("xlvfytyrtwuahlxl")
    public suspend fun userDefinedFields(vararg values: AutomationRuleCriteriaUserDefinedFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userDefinedFields = mapped
    }

    /**
     * @param value Provides the veracity of a finding. Documented below.
     */
    @JvmName("eskqisagsfmnbogx")
    public suspend fun verificationStates(`value`: List<AutomationRuleCriteriaVerificationStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationStates = mapped
    }

    /**
     * @param argument Provides the veracity of a finding. Documented below.
     */
    @JvmName("nalpeinkurutbqry")
    public suspend fun verificationStates(argument: List<suspend AutomationRuleCriteriaVerificationStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaVerificationStateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.verificationStates = mapped
    }

    /**
     * @param argument Provides the veracity of a finding. Documented below.
     */
    @JvmName("wirpbnntgsxvsceb")
    public suspend fun verificationStates(vararg argument: suspend AutomationRuleCriteriaVerificationStateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaVerificationStateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.verificationStates = mapped
    }

    /**
     * @param argument Provides the veracity of a finding. Documented below.
     */
    @JvmName("lkyhqdvgonyswwah")
    public suspend fun verificationStates(argument: suspend AutomationRuleCriteriaVerificationStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaVerificationStateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.verificationStates = mapped
    }

    /**
     * @param values Provides the veracity of a finding. Documented below.
     */
    @JvmName("qegfmjlrkwlqbuex")
    public suspend fun verificationStates(vararg values: AutomationRuleCriteriaVerificationStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verificationStates = mapped
    }

    /**
     * @param value Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("wlxqutoowmxwlees")
    public suspend fun workflowStatuses(`value`: List<AutomationRuleCriteriaWorkflowStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowStatuses = mapped
    }

    /**
     * @param argument Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("urvsvynerhkxkaxh")
    public suspend fun workflowStatuses(argument: List<suspend AutomationRuleCriteriaWorkflowStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaWorkflowStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workflowStatuses = mapped
    }

    /**
     * @param argument Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("wtqwpbxrchjausdh")
    public suspend fun workflowStatuses(vararg argument: suspend AutomationRuleCriteriaWorkflowStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRuleCriteriaWorkflowStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workflowStatuses = mapped
    }

    /**
     * @param argument Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("dkvuyjxepgaaysih")
    public suspend fun workflowStatuses(argument: suspend AutomationRuleCriteriaWorkflowStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRuleCriteriaWorkflowStatusArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workflowStatuses = mapped
    }

    /**
     * @param values Provides information about the status of the investigation into a finding. Documented below.
     */
    @JvmName("whyevrejfjygxtim")
    public suspend fun workflowStatuses(vararg values: AutomationRuleCriteriaWorkflowStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowStatuses = mapped
    }

    internal fun build(): AutomationRuleCriteriaArgs = AutomationRuleCriteriaArgs(
        awsAccountIds = awsAccountIds,
        awsAccountNames = awsAccountNames,
        companyNames = companyNames,
        complianceAssociatedStandardsIds = complianceAssociatedStandardsIds,
        complianceSecurityControlIds = complianceSecurityControlIds,
        complianceStatuses = complianceStatuses,
        confidences = confidences,
        createdAts = createdAts,
        criticalities = criticalities,
        descriptions = descriptions,
        firstObservedAts = firstObservedAts,
        generatorIds = generatorIds,
        ids = ids,
        lastObservedAts = lastObservedAts,
        noteTexts = noteTexts,
        noteUpdatedAts = noteUpdatedAts,
        noteUpdatedBies = noteUpdatedBies,
        productArns = productArns,
        productNames = productNames,
        recordStates = recordStates,
        relatedFindingsIds = relatedFindingsIds,
        relatedFindingsProductArns = relatedFindingsProductArns,
        resourceApplicationArns = resourceApplicationArns,
        resourceApplicationNames = resourceApplicationNames,
        resourceDetailsOthers = resourceDetailsOthers,
        resourceIds = resourceIds,
        resourcePartitions = resourcePartitions,
        resourceRegions = resourceRegions,
        resourceTags = resourceTags,
        resourceTypes = resourceTypes,
        severityLabels = severityLabels,
        sourceUrls = sourceUrls,
        titles = titles,
        types = types,
        updatedAts = updatedAts,
        userDefinedFields = userDefinedFields,
        verificationStates = verificationStates,
        workflowStatuses = workflowStatuses,
    )
}
