@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaCriticalityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eq The equal-to condition to be applied to a single field when querying for findings, provided as a String.
 * @property gt
 * @property gte The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 * @property lt
 * @property lte The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 */
public data class AutomationRuleCriteriaCriticalityArgs(
    public val eq: Output<Double>? = null,
    public val gt: Output<Double>? = null,
    public val gte: Output<Double>? = null,
    public val lt: Output<Double>? = null,
    public val lte: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaCriticalityArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaCriticalityArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaCriticalityArgs.builder()
            .eq(eq?.applyValue({ args0 -> args0 }))
            .gt(gt?.applyValue({ args0 -> args0 }))
            .gte(gte?.applyValue({ args0 -> args0 }))
            .lt(lt?.applyValue({ args0 -> args0 }))
            .lte(lte?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleCriteriaCriticalityArgs].
 */
@PulumiTagMarker
public class AutomationRuleCriteriaCriticalityArgsBuilder internal constructor() {
    private var eq: Output<Double>? = null

    private var gt: Output<Double>? = null

    private var gte: Output<Double>? = null

    private var lt: Output<Double>? = null

    private var lte: Output<Double>? = null

    /**
     * @param value The equal-to condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("vjqyfxmorfmanncr")
    public suspend fun eq(`value`: Output<Double>) {
        this.eq = value
    }

    /**
     * @param value
     */
    @JvmName("gpvdkitfupaxmmwn")
    public suspend fun gt(`value`: Output<Double>) {
        this.gt = value
    }

    /**
     * @param value The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("nmlcupaywsyvvkgp")
    public suspend fun gte(`value`: Output<Double>) {
        this.gte = value
    }

    /**
     * @param value
     */
    @JvmName("tcrdwhklpnlnojqk")
    public suspend fun lt(`value`: Output<Double>) {
        this.lt = value
    }

    /**
     * @param value The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("wgnbxrjnajrcmikm")
    public suspend fun lte(`value`: Output<Double>) {
        this.lte = value
    }

    /**
     * @param value The equal-to condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("jycicasogydypfna")
    public suspend fun eq(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eq = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqtfkjsiqfqurpaa")
    public suspend fun gt(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gt = mapped
    }

    /**
     * @param value The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("olbdnpoqnavcqybu")
    public suspend fun gte(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gte = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewvtkkfkvsqqaglf")
    public suspend fun lt(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lt = mapped
    }

    /**
     * @param value The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("vhvpjpgywdkkrdsc")
    public suspend fun lte(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lte = mapped
    }

    internal fun build(): AutomationRuleCriteriaCriticalityArgs =
        AutomationRuleCriteriaCriticalityArgs(
            eq = eq,
            gt = gt,
            gte = gte,
            lt = lt,
            lte = lte,
        )
}
