@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison
 * @property value
 */
public data class AutomationRuleCriteriaIdArgs(
    public val comparison: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaIdArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaIdArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaIdArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleCriteriaIdArgs].
 */
@PulumiTagMarker
public class AutomationRuleCriteriaIdArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ywwlqyipmagarutl")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value
     */
    @JvmName("ihtcmytteugiyhwo")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("ptevoccpsnagerje")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value
     */
    @JvmName("iblupcxybkdjlrgn")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AutomationRuleCriteriaIdArgs = AutomationRuleCriteriaIdArgs(
        comparison = comparison ?: throw PulumiNullFieldException("comparison"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
