@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaResourceTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison
 * @property key The key of the map filter.
 * @property value
 */
public data class AutomationRuleCriteriaResourceTagArgs(
    public val comparison: Output<String>,
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaResourceTagArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaResourceTagArgs =
        com.pulumi.aws.securityhub.inputs.AutomationRuleCriteriaResourceTagArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationRuleCriteriaResourceTagArgs].
 */
@PulumiTagMarker
public class AutomationRuleCriteriaResourceTagArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("scipjcgitahyosmn")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value The key of the map filter.
     */
    @JvmName("uynjokbftkfriyvq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("nifmohkmxpcascmm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("cgqvycmiekoittbl")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value The key of the map filter.
     */
    @JvmName("dyrmegxwtebpiyma")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("gutmpmnyykhvhktb")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AutomationRuleCriteriaResourceTagArgs =
        AutomationRuleCriteriaResourceTagArgs(
            comparison = comparison ?: throw PulumiNullFieldException("comparison"),
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
