@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabledStandardArns A list that defines which security standards are enabled in the configuration policy. It must be defined if `service_enabled` is set to true.
 * @property securityControlsConfiguration Defines which security controls are enabled in the configuration policy and any customizations to parameters affecting them. See below.
 * @property serviceEnabled Indicates whether Security Hub is enabled in the policy.
 */
public data class ConfigurationPolicyConfigurationPolicyArgs(
    public val enabledStandardArns: Output<List<String>>? = null,
    public val securityControlsConfiguration: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs>? = null,
    public val serviceEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs =
        com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicyArgs.builder()
            .enabledStandardArns(enabledStandardArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityControlsConfiguration(
                securityControlsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .serviceEnabled(serviceEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationPolicyConfigurationPolicyArgs].
 */
@PulumiTagMarker
public class ConfigurationPolicyConfigurationPolicyArgsBuilder internal constructor() {
    private var enabledStandardArns: Output<List<String>>? = null

    private var securityControlsConfiguration:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs>? = null

    private var serviceEnabled: Output<Boolean>? = null

    /**
     * @param value A list that defines which security standards are enabled in the configuration policy. It must be defined if `service_enabled` is set to true.
     */
    @JvmName("fjjnfiqjhkdrboyb")
    public suspend fun enabledStandardArns(`value`: Output<List<String>>) {
        this.enabledStandardArns = value
    }

    @JvmName("swhngwlqjjtyilsh")
    public suspend fun enabledStandardArns(vararg values: Output<String>) {
        this.enabledStandardArns = Output.all(values.asList())
    }

    /**
     * @param values A list that defines which security standards are enabled in the configuration policy. It must be defined if `service_enabled` is set to true.
     */
    @JvmName("aawrwyqfjhoxefha")
    public suspend fun enabledStandardArns(values: List<Output<String>>) {
        this.enabledStandardArns = Output.all(values)
    }

    /**
     * @param value Defines which security controls are enabled in the configuration policy and any customizations to parameters affecting them. See below.
     */
    @JvmName("nibrhhoitrvqpmmf")
    public suspend fun securityControlsConfiguration(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs>) {
        this.securityControlsConfiguration = value
    }

    /**
     * @param value Indicates whether Security Hub is enabled in the policy.
     */
    @JvmName("wmdsfhyepndmchhg")
    public suspend fun serviceEnabled(`value`: Output<Boolean>) {
        this.serviceEnabled = value
    }

    /**
     * @param value A list that defines which security standards are enabled in the configuration policy. It must be defined if `service_enabled` is set to true.
     */
    @JvmName("abfxvtqrruokwqxt")
    public suspend fun enabledStandardArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledStandardArns = mapped
    }

    /**
     * @param values A list that defines which security standards are enabled in the configuration policy. It must be defined if `service_enabled` is set to true.
     */
    @JvmName("thkpnmrqpqynshyw")
    public suspend fun enabledStandardArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledStandardArns = mapped
    }

    /**
     * @param value Defines which security controls are enabled in the configuration policy and any customizations to parameters affecting them. See below.
     */
    @JvmName("jsgwmcejjvpxxpnx")
    public suspend fun securityControlsConfiguration(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityControlsConfiguration = mapped
    }

    /**
     * @param argument Defines which security controls are enabled in the configuration policy and any customizations to parameters affecting them. See below.
     */
    @JvmName("ifitffhscmqbrgyl")
    public suspend fun securityControlsConfiguration(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.securityControlsConfiguration = mapped
    }

    /**
     * @param value Indicates whether Security Hub is enabled in the policy.
     */
    @JvmName("vduhwethhetsgejh")
    public suspend fun serviceEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEnabled = mapped
    }

    internal fun build(): ConfigurationPolicyConfigurationPolicyArgs =
        ConfigurationPolicyConfigurationPolicyArgs(
            enabledStandardArns = enabledStandardArns,
            securityControlsConfiguration = securityControlsConfiguration,
            serviceEnabled = serviceEnabled ?: throw PulumiNullFieldException("serviceEnabled"),
        )
}
