@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property disabledControlIdentifiers A list of security controls that are disabled in the configuration policy Security Hub enables all other controls (including newly released controls) other than the listed controls. Conflicts with `enabled_control_identifiers`.
 * @property enabledControlIdentifiers A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. Conflicts with `disabled_control_identifiers`.
 * @property securityControlCustomParameters A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
 */
public data class ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs(
    public val disabledControlIdentifiers: Output<List<String>>? = null,
    public val enabledControlIdentifiers: Output<List<String>>? = null,
    public val securityControlCustomParameters: Output<List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs =
        com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs.builder()
            .disabledControlIdentifiers(
                disabledControlIdentifiers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .enabledControlIdentifiers(
                enabledControlIdentifiers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .securityControlCustomParameters(
                securityControlCustomParameters?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgsBuilder internal constructor() {
    private var disabledControlIdentifiers: Output<List<String>>? = null

    private var enabledControlIdentifiers: Output<List<String>>? = null

    private var securityControlCustomParameters:
        Output<List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs>>? =
        null

    /**
     * @param value A list of security controls that are disabled in the configuration policy Security Hub enables all other controls (including newly released controls) other than the listed controls. Conflicts with `enabled_control_identifiers`.
     */
    @JvmName("vhoqvprmusemnmqg")
    public suspend fun disabledControlIdentifiers(`value`: Output<List<String>>) {
        this.disabledControlIdentifiers = value
    }

    @JvmName("yvlptpxygtnmpjit")
    public suspend fun disabledControlIdentifiers(vararg values: Output<String>) {
        this.disabledControlIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values A list of security controls that are disabled in the configuration policy Security Hub enables all other controls (including newly released controls) other than the listed controls. Conflicts with `enabled_control_identifiers`.
     */
    @JvmName("kbbrpyteuptovwsj")
    public suspend fun disabledControlIdentifiers(values: List<Output<String>>) {
        this.disabledControlIdentifiers = Output.all(values)
    }

    /**
     * @param value A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. Conflicts with `disabled_control_identifiers`.
     */
    @JvmName("ktavbxokoixntqsk")
    public suspend fun enabledControlIdentifiers(`value`: Output<List<String>>) {
        this.enabledControlIdentifiers = value
    }

    @JvmName("ejpeyrbrsgbbwlip")
    public suspend fun enabledControlIdentifiers(vararg values: Output<String>) {
        this.enabledControlIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. Conflicts with `disabled_control_identifiers`.
     */
    @JvmName("nxmalljdqcyyhumr")
    public suspend fun enabledControlIdentifiers(values: List<Output<String>>) {
        this.enabledControlIdentifiers = Output.all(values)
    }

    /**
     * @param value A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("kjkdmnmkgaafogfl")
    public suspend fun securityControlCustomParameters(`value`: Output<List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs>>) {
        this.securityControlCustomParameters = value
    }

    @JvmName("dqmbquxwpkqqhxqu")
    public suspend fun securityControlCustomParameters(vararg values: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs>) {
        this.securityControlCustomParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("dbgaavplwbixljod")
    public suspend fun securityControlCustomParameters(values: List<Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs>>) {
        this.securityControlCustomParameters = Output.all(values)
    }

    /**
     * @param value A list of security controls that are disabled in the configuration policy Security Hub enables all other controls (including newly released controls) other than the listed controls. Conflicts with `enabled_control_identifiers`.
     */
    @JvmName("htdrqlstaojfkfhh")
    public suspend fun disabledControlIdentifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledControlIdentifiers = mapped
    }

    /**
     * @param values A list of security controls that are disabled in the configuration policy Security Hub enables all other controls (including newly released controls) other than the listed controls. Conflicts with `enabled_control_identifiers`.
     */
    @JvmName("khxslyrpwgrquwxw")
    public suspend fun disabledControlIdentifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledControlIdentifiers = mapped
    }

    /**
     * @param value A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. Conflicts with `disabled_control_identifiers`.
     */
    @JvmName("moosipdevjuteefp")
    public suspend fun enabledControlIdentifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledControlIdentifiers = mapped
    }

    /**
     * @param values A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. Conflicts with `disabled_control_identifiers`.
     */
    @JvmName("njjrrytkkkvonjhq")
    public suspend fun enabledControlIdentifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledControlIdentifiers = mapped
    }

    /**
     * @param value A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("pgjykpstbimwhaiq")
    public suspend fun securityControlCustomParameters(`value`: List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityControlCustomParameters = mapped
    }

    /**
     * @param argument A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("igsnikpypnncqsmq")
    public suspend fun securityControlCustomParameters(argument: List<suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.securityControlCustomParameters = mapped
    }

    /**
     * @param argument A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("lfeddpafkmxftdky")
    public suspend fun securityControlCustomParameters(vararg argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.securityControlCustomParameters = mapped
    }

    /**
     * @param argument A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("npefbdbjqneniuib")
    public suspend fun securityControlCustomParameters(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.securityControlCustomParameters = mapped
    }

    /**
     * @param values A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
     */
    @JvmName("ubdlqmadhdriaasc")
    public suspend fun securityControlCustomParameters(vararg values: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityControlCustomParameters = mapped
    }

    internal fun build(): ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs =
        ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationArgs(
            disabledControlIdentifiers = disabledControlIdentifiers,
            enabledControlIdentifiers = enabledControlIdentifiers,
            securityControlCustomParameters = securityControlCustomParameters,
        )
}
