@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property parameters An object that specifies parameter values for a control in a configuration policy. See below.
 * @property securityControlId The ID of the security control. For more information see the [Security Hub controls reference] documentation.
 */
public data class
ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs(
    public val parameters: Output<List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs>>,
    public val securityControlId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs =
        com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs.builder()
            .parameters(
                parameters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .securityControlId(securityControlId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs].
 */
@PulumiTagMarker
public class
ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgsBuilder
internal constructor() {
    private var parameters:
        Output<List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs>>? =
        null

    private var securityControlId: Output<String>? = null

    /**
     * @param value An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("gmhxnbugafpsxekk")
    public suspend fun parameters(`value`: Output<List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("seqwgnliglutrbwp")
    public suspend fun parameters(vararg values: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("hdvhuobkhtmgqkil")
    public suspend fun parameters(values: List<Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The ID of the security control. For more information see the [Security Hub controls reference] documentation.
     */
    @JvmName("eedygqjeqpdtuwvx")
    public suspend fun securityControlId(`value`: Output<String>) {
        this.securityControlId = value
    }

    /**
     * @param value An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("dqirwbwxlgvkcmmn")
    public suspend fun parameters(`value`: List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("jbedxkxmijocsjoq")
    public suspend fun parameters(argument: List<suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("stoescyfbupgjsbp")
    public suspend fun parameters(vararg argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("fddewviprnfyrxny")
    public suspend fun parameters(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values An object that specifies parameter values for a control in a configuration policy. See below.
     */
    @JvmName("xyxkmwmfwhcoeild")
    public suspend fun parameters(vararg values: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The ID of the security control. For more information see the [Security Hub controls reference] documentation.
     */
    @JvmName("jkonqygawdasklit")
    public suspend fun securityControlId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityControlId = mapped
    }

    internal fun build(): ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs =
        ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterArgs(
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
            securityControlId = securityControlId ?: throw PulumiNullFieldException("securityControlId"),
        )
}
