@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bool The bool `value` for a Boolean-typed Security Hub Control Parameter.
 * @property double The float `value` for a Double-typed Security Hub Control Parameter.
 * @property enum The string `value` for a Enum-typed Security Hub Control Parameter.
 * @property enumList The string list `value` for a EnumList-typed Security Hub Control Parameter.
 * @property int The int `value` for a Int-typed Security Hub Control Parameter.
 * @property intList The int list `value` for a IntList-typed Security Hub Control Parameter.
 * @property name The name of the control parameter. For more information see the [Security Hub controls reference] documentation.
 * @property string The string `value` for a String-typed Security Hub Control Parameter.
 * @property stringList The string list `value` for a StringList-typed Security Hub Control Parameter.
 * @property valueType Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub behavior. Valid values: `DEFAULT`, `CUSTOM`.
 */
public data class
ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs(
    public val bool: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs>? =
        null,
    public val double: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDoubleArgs>? =
        null,
    public val `enum`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs>? =
        null,
    public val enumList: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumListArgs>? =
        null,
    public val int: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs>? =
        null,
    public val intList: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntListArgs>? =
        null,
    public val name: Output<String>,
    public val string: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringArgs>? =
        null,
    public val stringList: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringListArgs>? =
        null,
    public val valueType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs =
        com.pulumi.aws.securityhub.inputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs.builder()
            .bool(bool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .double_(double?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enum_(`enum`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enumList(enumList?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .int_(int?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intList(intList?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .string(string?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stringList(stringList?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .valueType(valueType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs].
 */
@PulumiTagMarker
public class
ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgsBuilder
internal constructor() {
    private var bool:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs>? =
        null

    private var double:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDoubleArgs>? =
        null

    private var `enum`:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs>? =
        null

    private var enumList:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumListArgs>? =
        null

    private var int:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs>? =
        null

    private var intList:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntListArgs>? =
        null

    private var name: Output<String>? = null

    private var string:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringArgs>? =
        null

    private var stringList:
        Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringListArgs>? =
        null

    private var valueType: Output<String>? = null

    /**
     * @param value The bool `value` for a Boolean-typed Security Hub Control Parameter.
     */
    @JvmName("iphtjffwpwiybdum")
    public suspend fun bool(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs>) {
        this.bool = value
    }

    /**
     * @param value The float `value` for a Double-typed Security Hub Control Parameter.
     */
    @JvmName("poyasgtpyclqaseo")
    public suspend fun double(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDoubleArgs>) {
        this.double = value
    }

    /**
     * @param value The string `value` for a Enum-typed Security Hub Control Parameter.
     */
    @JvmName("xcegjpfegubvfoef")
    public suspend fun `enum`(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs>) {
        this.`enum` = value
    }

    /**
     * @param value The string list `value` for a EnumList-typed Security Hub Control Parameter.
     */
    @JvmName("cxfamtcwbeougwsn")
    public suspend fun enumList(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumListArgs>) {
        this.enumList = value
    }

    /**
     * @param value The int `value` for a Int-typed Security Hub Control Parameter.
     */
    @JvmName("jevrolxobwaksukv")
    public suspend fun int(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs>) {
        this.int = value
    }

    /**
     * @param value The int list `value` for a IntList-typed Security Hub Control Parameter.
     */
    @JvmName("onhirfqecohcwkho")
    public suspend fun intList(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntListArgs>) {
        this.intList = value
    }

    /**
     * @param value The name of the control parameter. For more information see the [Security Hub controls reference] documentation.
     */
    @JvmName("goxqgredtlayrxkc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The string `value` for a String-typed Security Hub Control Parameter.
     */
    @JvmName("vhfqhtaimqquanhi")
    public suspend fun string(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringArgs>) {
        this.string = value
    }

    /**
     * @param value The string list `value` for a StringList-typed Security Hub Control Parameter.
     */
    @JvmName("njaykiofdtlxhxjg")
    public suspend fun stringList(`value`: Output<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringListArgs>) {
        this.stringList = value
    }

    /**
     * @param value Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub behavior. Valid values: `DEFAULT`, `CUSTOM`.
     */
    @JvmName("qildbpwmlfilmfmc")
    public suspend fun valueType(`value`: Output<String>) {
        this.valueType = value
    }

    /**
     * @param value The bool `value` for a Boolean-typed Security Hub Control Parameter.
     */
    @JvmName("juneyxsndskxrpob")
    public suspend fun bool(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bool = mapped
    }

    /**
     * @param argument The bool `value` for a Boolean-typed Security Hub Control Parameter.
     */
    @JvmName("ejeguhbmvjwcehbs")
    public suspend fun bool(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBoolArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.bool = mapped
    }

    /**
     * @param value The float `value` for a Double-typed Security Hub Control Parameter.
     */
    @JvmName("dqlmnlghmruwwlws")
    public suspend fun double(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDoubleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.double = mapped
    }

    /**
     * @param argument The float `value` for a Double-typed Security Hub Control Parameter.
     */
    @JvmName("vjgpxnraxkitkohe")
    public suspend fun double(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDoubleArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDoubleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.double = mapped
    }

    /**
     * @param value The string `value` for a Enum-typed Security Hub Control Parameter.
     */
    @JvmName("xyiaibgpvxxkxlqf")
    public suspend fun `enum`(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`enum` = mapped
    }

    /**
     * @param argument The string `value` for a Enum-typed Security Hub Control Parameter.
     */
    @JvmName("tbknssnpagadidlr")
    public suspend fun `enum`(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.`enum` = mapped
    }

    /**
     * @param value The string list `value` for a EnumList-typed Security Hub Control Parameter.
     */
    @JvmName("rukvokqstqkpoolu")
    public suspend fun enumList(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enumList = mapped
    }

    /**
     * @param argument The string list `value` for a EnumList-typed Security Hub Control Parameter.
     */
    @JvmName("diwksxugcelpqrnt")
    public suspend fun enumList(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumListArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumListArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.enumList = mapped
    }

    /**
     * @param value The int `value` for a Int-typed Security Hub Control Parameter.
     */
    @JvmName("qbvfxsxhgpsmdymr")
    public suspend fun int(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.int = mapped
    }

    /**
     * @param argument The int `value` for a Int-typed Security Hub Control Parameter.
     */
    @JvmName("idwpuaqacdogqlaj")
    public suspend fun int(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.int = mapped
    }

    /**
     * @param value The int list `value` for a IntList-typed Security Hub Control Parameter.
     */
    @JvmName("mrasiplrhibdrxbq")
    public suspend fun intList(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intList = mapped
    }

    /**
     * @param argument The int list `value` for a IntList-typed Security Hub Control Parameter.
     */
    @JvmName("dybugrmrqbalewdt")
    public suspend fun intList(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntListArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntListArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.intList = mapped
    }

    /**
     * @param value The name of the control parameter. For more information see the [Security Hub controls reference] documentation.
     */
    @JvmName("eklfkjgfirqkqgjb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The string `value` for a String-typed Security Hub Control Parameter.
     */
    @JvmName("kclxelotsabiggaf")
    public suspend fun string(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.string = mapped
    }

    /**
     * @param argument The string `value` for a String-typed Security Hub Control Parameter.
     */
    @JvmName("eervwcqqsopeprcp")
    public suspend fun string(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.string = mapped
    }

    /**
     * @param value The string list `value` for a StringList-typed Security Hub Control Parameter.
     */
    @JvmName("appkmrnubltpbdhc")
    public suspend fun stringList(`value`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringList = mapped
    }

    /**
     * @param argument The string list `value` for a StringList-typed Security Hub Control Parameter.
     */
    @JvmName("qwptengfainchwbp")
    public suspend fun stringList(argument: suspend ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringListArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringListArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.stringList = mapped
    }

    /**
     * @param value Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub behavior. Valid values: `DEFAULT`, `CUSTOM`.
     */
    @JvmName("xvklpqbsaavvxlwx")
    public suspend fun valueType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueType = mapped
    }

    internal fun build(): ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs =
        ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterArgs(
            bool = bool,
            double = double,
            `enum` = `enum`,
            enumList = enumList,
            int = int,
            intList = intList,
            name = name ?: throw PulumiNullFieldException("name"),
            string = string,
            stringList = stringList,
            valueType = valueType ?: throw PulumiNullFieldException("valueType"),
        )
}
