@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property awsAccountIds AWS account ID that a finding is generated in. See String_Filter below for more details.
 * @property companyNames The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
 * @property complianceStatuses Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
 * @property confidences A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
 * @property createdAts An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
 * @property criticalities The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
 * @property descriptions A finding's description. See String Filter below for more details.
 * @property findingProviderFieldsConfidences The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
 * @property findingProviderFieldsCriticalities The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
 * @property findingProviderFieldsRelatedFindingsIds The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
 * @property findingProviderFieldsRelatedFindingsProductArns The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
 * @property findingProviderFieldsSeverityLabels The finding provider value for the severity label. See String Filter below for more details.
 * @property findingProviderFieldsSeverityOriginals The finding provider's original value for the severity. See String Filter below for more details.
 * @property findingProviderFieldsTypes One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
 * @property firstObservedAts An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
 * @property generatorIds The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
 * @property ids The security findings provider-specific identifier for a finding. See String Filter below for more details.
 * @property keywords A keyword for a finding. See Keyword Filter below for more details.
 * @property lastObservedAts An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
 * @property malwareNames The name of the malware that was observed. See String Filter below for more details.
 * @property malwarePaths The filesystem path of the malware that was observed. See String Filter below for more details.
 * @property malwareStates The state of the malware that was observed. See String Filter below for more details.
 * @property malwareTypes The type of the malware that was observed. See String Filter below for more details.
 * @property networkDestinationDomains The destination domain of network-related information about a finding. See String Filter below for more details.
 * @property networkDestinationIpv4s The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkDestinationIpv6s The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkDestinationPorts The destination port of network-related information about a finding. See Number Filter below for more details.
 * @property networkDirections Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
 * @property networkProtocols The protocol of network-related information about a finding. See String Filter below for more details.
 * @property networkSourceDomains The source domain of network-related information about a finding. See String Filter below for more details.
 * @property networkSourceIpv4s The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkSourceIpv6s The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkSourceMacs The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
 * @property networkSourcePorts The source port of network-related information about a finding. See Number Filter below for more details.
 * @property noteTexts The text of a note. See String Filter below for more details.
 * @property noteUpdatedAts The timestamp of when the note was updated. See Date Filter below for more details.
 * @property noteUpdatedBies The principal that created a note. See String Filter below for more details.
 * @property processLaunchedAts The date/time that the process was launched. See Date Filter below for more details.
 * @property processNames The name of the process. See String Filter below for more details.
 * @property processParentPids The parent process ID. See Number Filter below for more details.
 * @property processPaths The path to the process executable. See String Filter below for more details.
 * @property processPids The process ID. See Number Filter below for more details.
 * @property processTerminatedAts The date/time that the process was terminated. See Date Filter below for more details.
 * @property productArns The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
 * @property productFields A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
 * @property productNames The name of the solution (product) that generates findings. See String Filter below for more details.
 * @property recommendationTexts The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
 * @property recordStates The updated record state for the finding. See String Filter below for more details.
 * @property relatedFindingsIds The solution-generated identifier for a related finding. See String Filter below for more details.
 * @property relatedFindingsProductArns The ARN of the solution that generated a related finding. See String Filter below for more details.
 * @property resourceAwsEc2InstanceIamInstanceProfileArns The IAM profile ARN of the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceImageIds The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceIpv4Addresses The IPv4 addresses associated with the instance. See Ip Filter below for more details.
 * @property resourceAwsEc2InstanceIpv6Addresses The IPv6 addresses associated with the instance. See Ip Filter below for more details.
 * @property resourceAwsEc2InstanceKeyNames The key name associated with the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceLaunchedAts The date and time the instance was launched. See Date Filter below for more details.
 * @property resourceAwsEc2InstanceSubnetIds The identifier of the subnet that the instance was launched in. See String Filter below for more details.
 * @property resourceAwsEc2InstanceTypes The instance type of the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceVpcIds The identifier of the VPC that the instance was launched in. See String Filter below for more details.
 * @property resourceAwsIamAccessKeyCreatedAts The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
 * @property resourceAwsIamAccessKeyStatuses The status of the IAM access key related to a finding. See String Filter below for more details.
 * @property resourceAwsIamAccessKeyUserNames The user associated with the IAM access key related to a finding. See String Filter below for more details.
 * @property resourceAwsS3BucketOwnerIds The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
 * @property resourceAwsS3BucketOwnerNames The display name of the owner of the S3 bucket. See String Filter below for more details.
 * @property resourceContainerImageIds The identifier of the image related to a finding. See String Filter below for more details.
 * @property resourceContainerImageNames The name of the image related to a finding. See String Filter below for more details.
 * @property resourceContainerLaunchedAts The date/time that the container was started. See Date Filter below for more details.
 * @property resourceContainerNames The name of the container related to a finding. See String Filter below for more details.
 * @property resourceDetailsOthers The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
 * @property resourceIds The canonical identifier for the given resource type. See String Filter below for more details.
 * @property resourcePartitions The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
 * @property resourceRegions The canonical AWS external Region name where this resource is located. See String Filter below for more details.
 * @property resourceTags A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
 * @property resourceTypes Specifies the type of the resource that details are provided for. See String Filter below for more details.
 * @property severityLabels The label of a finding's severity. See String Filter below for more details.
 * @property sourceUrls A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
 * @property threatIntelIndicatorCategories The category of a threat intelligence indicator. See String Filter below for more details.
 * @property threatIntelIndicatorLastObservedAts The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
 * @property threatIntelIndicatorSourceUrls The URL for more details from the source of the threat intelligence. See String Filter below for more details.
 * @property threatIntelIndicatorSources The source of the threat intelligence. See String Filter below for more details.
 * @property threatIntelIndicatorTypes The type of a threat intelligence indicator. See String Filter below for more details.
 * @property threatIntelIndicatorValues The value of a threat intelligence indicator. See String Filter below for more details.
 * @property titles A finding's title. See String Filter below for more details.
 * @property types A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
 * @property updatedAts An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
 * @property userDefinedValues A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
 * @property verificationStates The veracity of a finding. See String Filter below for more details.
 * @property workflowStatuses The status of the investigation into a finding. See Workflow Status Filter below for more details.
 */
public data class InsightFiltersArgs(
    public val awsAccountIds: Output<List<InsightFiltersAwsAccountIdArgs>>? = null,
    public val companyNames: Output<List<InsightFiltersCompanyNameArgs>>? = null,
    public val complianceStatuses: Output<List<InsightFiltersComplianceStatusArgs>>? = null,
    public val confidences: Output<List<InsightFiltersConfidenceArgs>>? = null,
    public val createdAts: Output<List<InsightFiltersCreatedAtArgs>>? = null,
    public val criticalities: Output<List<InsightFiltersCriticalityArgs>>? = null,
    public val descriptions: Output<List<InsightFiltersDescriptionArgs>>? = null,
    public val findingProviderFieldsConfidences: Output<List<InsightFiltersFindingProviderFieldsConfidenceArgs>>? = null,
    public val findingProviderFieldsCriticalities: Output<List<InsightFiltersFindingProviderFieldsCriticalityArgs>>? = null,
    public val findingProviderFieldsRelatedFindingsIds: Output<List<InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs>>? = null,
    public val findingProviderFieldsRelatedFindingsProductArns: Output<List<InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs>>? = null,
    public val findingProviderFieldsSeverityLabels: Output<List<InsightFiltersFindingProviderFieldsSeverityLabelArgs>>? = null,
    public val findingProviderFieldsSeverityOriginals: Output<List<InsightFiltersFindingProviderFieldsSeverityOriginalArgs>>? = null,
    public val findingProviderFieldsTypes: Output<List<InsightFiltersFindingProviderFieldsTypeArgs>>? =
        null,
    public val firstObservedAts: Output<List<InsightFiltersFirstObservedAtArgs>>? = null,
    public val generatorIds: Output<List<InsightFiltersGeneratorIdArgs>>? = null,
    public val ids: Output<List<InsightFiltersIdArgs>>? = null,
    public val keywords: Output<List<InsightFiltersKeywordArgs>>? = null,
    public val lastObservedAts: Output<List<InsightFiltersLastObservedAtArgs>>? = null,
    public val malwareNames: Output<List<InsightFiltersMalwareNameArgs>>? = null,
    public val malwarePaths: Output<List<InsightFiltersMalwarePathArgs>>? = null,
    public val malwareStates: Output<List<InsightFiltersMalwareStateArgs>>? = null,
    public val malwareTypes: Output<List<InsightFiltersMalwareTypeArgs>>? = null,
    public val networkDestinationDomains: Output<List<InsightFiltersNetworkDestinationDomainArgs>>? =
        null,
    public val networkDestinationIpv4s: Output<List<InsightFiltersNetworkDestinationIpv4Args>>? =
        null,
    public val networkDestinationIpv6s: Output<List<InsightFiltersNetworkDestinationIpv6Args>>? =
        null,
    public val networkDestinationPorts: Output<List<InsightFiltersNetworkDestinationPortArgs>>? =
        null,
    public val networkDirections: Output<List<InsightFiltersNetworkDirectionArgs>>? = null,
    public val networkProtocols: Output<List<InsightFiltersNetworkProtocolArgs>>? = null,
    public val networkSourceDomains: Output<List<InsightFiltersNetworkSourceDomainArgs>>? = null,
    public val networkSourceIpv4s: Output<List<InsightFiltersNetworkSourceIpv4Args>>? = null,
    public val networkSourceIpv6s: Output<List<InsightFiltersNetworkSourceIpv6Args>>? = null,
    public val networkSourceMacs: Output<List<InsightFiltersNetworkSourceMacArgs>>? = null,
    public val networkSourcePorts: Output<List<InsightFiltersNetworkSourcePortArgs>>? = null,
    public val noteTexts: Output<List<InsightFiltersNoteTextArgs>>? = null,
    public val noteUpdatedAts: Output<List<InsightFiltersNoteUpdatedAtArgs>>? = null,
    public val noteUpdatedBies: Output<List<InsightFiltersNoteUpdatedByArgs>>? = null,
    public val processLaunchedAts: Output<List<InsightFiltersProcessLaunchedAtArgs>>? = null,
    public val processNames: Output<List<InsightFiltersProcessNameArgs>>? = null,
    public val processParentPids: Output<List<InsightFiltersProcessParentPidArgs>>? = null,
    public val processPaths: Output<List<InsightFiltersProcessPathArgs>>? = null,
    public val processPids: Output<List<InsightFiltersProcessPidArgs>>? = null,
    public val processTerminatedAts: Output<List<InsightFiltersProcessTerminatedAtArgs>>? = null,
    public val productArns: Output<List<InsightFiltersProductArnArgs>>? = null,
    public val productFields: Output<List<InsightFiltersProductFieldArgs>>? = null,
    public val productNames: Output<List<InsightFiltersProductNameArgs>>? = null,
    public val recommendationTexts: Output<List<InsightFiltersRecommendationTextArgs>>? = null,
    public val recordStates: Output<List<InsightFiltersRecordStateArgs>>? = null,
    public val relatedFindingsIds: Output<List<InsightFiltersRelatedFindingsIdArgs>>? = null,
    public val relatedFindingsProductArns: Output<List<InsightFiltersRelatedFindingsProductArnArgs>>? =
        null,
    public val resourceAwsEc2InstanceIamInstanceProfileArns: Output<List<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs>>? = null,
    public val resourceAwsEc2InstanceImageIds: Output<List<InsightFiltersResourceAwsEc2InstanceImageIdArgs>>? = null,
    public val resourceAwsEc2InstanceIpv4Addresses: Output<List<InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs>>? = null,
    public val resourceAwsEc2InstanceIpv6Addresses: Output<List<InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs>>? = null,
    public val resourceAwsEc2InstanceKeyNames: Output<List<InsightFiltersResourceAwsEc2InstanceKeyNameArgs>>? = null,
    public val resourceAwsEc2InstanceLaunchedAts: Output<List<InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs>>? = null,
    public val resourceAwsEc2InstanceSubnetIds: Output<List<InsightFiltersResourceAwsEc2InstanceSubnetIdArgs>>? = null,
    public val resourceAwsEc2InstanceTypes: Output<List<InsightFiltersResourceAwsEc2InstanceTypeArgs>>? = null,
    public val resourceAwsEc2InstanceVpcIds: Output<List<InsightFiltersResourceAwsEc2InstanceVpcIdArgs>>? = null,
    public val resourceAwsIamAccessKeyCreatedAts: Output<List<InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs>>? = null,
    public val resourceAwsIamAccessKeyStatuses: Output<List<InsightFiltersResourceAwsIamAccessKeyStatusArgs>>? = null,
    public val resourceAwsIamAccessKeyUserNames: Output<List<InsightFiltersResourceAwsIamAccessKeyUserNameArgs>>? = null,
    public val resourceAwsS3BucketOwnerIds: Output<List<InsightFiltersResourceAwsS3BucketOwnerIdArgs>>? = null,
    public val resourceAwsS3BucketOwnerNames: Output<List<InsightFiltersResourceAwsS3BucketOwnerNameArgs>>? = null,
    public val resourceContainerImageIds: Output<List<InsightFiltersResourceContainerImageIdArgs>>? =
        null,
    public val resourceContainerImageNames: Output<List<InsightFiltersResourceContainerImageNameArgs>>? = null,
    public val resourceContainerLaunchedAts: Output<List<InsightFiltersResourceContainerLaunchedAtArgs>>? = null,
    public val resourceContainerNames: Output<List<InsightFiltersResourceContainerNameArgs>>? = null,
    public val resourceDetailsOthers: Output<List<InsightFiltersResourceDetailsOtherArgs>>? = null,
    public val resourceIds: Output<List<InsightFiltersResourceIdArgs>>? = null,
    public val resourcePartitions: Output<List<InsightFiltersResourcePartitionArgs>>? = null,
    public val resourceRegions: Output<List<InsightFiltersResourceRegionArgs>>? = null,
    public val resourceTags: Output<List<InsightFiltersResourceTagArgs>>? = null,
    public val resourceTypes: Output<List<InsightFiltersResourceTypeArgs>>? = null,
    public val severityLabels: Output<List<InsightFiltersSeverityLabelArgs>>? = null,
    public val sourceUrls: Output<List<InsightFiltersSourceUrlArgs>>? = null,
    public val threatIntelIndicatorCategories: Output<List<InsightFiltersThreatIntelIndicatorCategoryArgs>>? = null,
    public val threatIntelIndicatorLastObservedAts: Output<List<InsightFiltersThreatIntelIndicatorLastObservedAtArgs>>? = null,
    public val threatIntelIndicatorSourceUrls: Output<List<InsightFiltersThreatIntelIndicatorSourceUrlArgs>>? = null,
    public val threatIntelIndicatorSources: Output<List<InsightFiltersThreatIntelIndicatorSourceArgs>>? = null,
    public val threatIntelIndicatorTypes: Output<List<InsightFiltersThreatIntelIndicatorTypeArgs>>? =
        null,
    public val threatIntelIndicatorValues: Output<List<InsightFiltersThreatIntelIndicatorValueArgs>>? =
        null,
    public val titles: Output<List<InsightFiltersTitleArgs>>? = null,
    public val types: Output<List<InsightFiltersTypeArgs>>? = null,
    public val updatedAts: Output<List<InsightFiltersUpdatedAtArgs>>? = null,
    public val userDefinedValues: Output<List<InsightFiltersUserDefinedValueArgs>>? = null,
    public val verificationStates: Output<List<InsightFiltersVerificationStateArgs>>? = null,
    public val workflowStatuses: Output<List<InsightFiltersWorkflowStatusArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersArgs.builder()
            .awsAccountIds(
                awsAccountIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .companyNames(
                companyNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .complianceStatuses(
                complianceStatuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .confidences(
                confidences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .createdAts(
                createdAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .criticalities(
                criticalities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .descriptions(
                descriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .findingProviderFieldsConfidences(
                findingProviderFieldsConfidences?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .findingProviderFieldsCriticalities(
                findingProviderFieldsCriticalities?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .findingProviderFieldsRelatedFindingsIds(
                findingProviderFieldsRelatedFindingsIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .findingProviderFieldsRelatedFindingsProductArns(
                findingProviderFieldsRelatedFindingsProductArns?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .findingProviderFieldsSeverityLabels(
                findingProviderFieldsSeverityLabels?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .findingProviderFieldsSeverityOriginals(
                findingProviderFieldsSeverityOriginals?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .findingProviderFieldsTypes(
                findingProviderFieldsTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .firstObservedAts(
                firstObservedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .generatorIds(
                generatorIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ids(ids?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .keywords(
                keywords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lastObservedAts(
                lastObservedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .malwareNames(
                malwareNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .malwarePaths(
                malwarePaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .malwareStates(
                malwareStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .malwareTypes(
                malwareTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .networkDestinationDomains(
                networkDestinationDomains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkDestinationIpv4s(
                networkDestinationIpv4s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkDestinationIpv6s(
                networkDestinationIpv6s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkDestinationPorts(
                networkDestinationPorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkDirections(
                networkDirections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .networkProtocols(
                networkProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .networkSourceDomains(
                networkSourceDomains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkSourceIpv4s(
                networkSourceIpv4s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkSourceIpv6s(
                networkSourceIpv6s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkSourceMacs(
                networkSourceMacs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .networkSourcePorts(
                networkSourcePorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .noteTexts(
                noteTexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .noteUpdatedAts(
                noteUpdatedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .noteUpdatedBies(
                noteUpdatedBies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processLaunchedAts(
                processLaunchedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .processNames(
                processNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processParentPids(
                processParentPids?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processPaths(
                processPaths?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processPids(
                processPids?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processTerminatedAts(
                processTerminatedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .productArns(
                productArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .productFields(
                productFields?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .productNames(
                productNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recommendationTexts(
                recommendationTexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .recordStates(
                recordStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .relatedFindingsIds(
                relatedFindingsIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .relatedFindingsProductArns(
                relatedFindingsProductArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceAwsEc2InstanceIamInstanceProfileArns(
                resourceAwsEc2InstanceIamInstanceProfileArns?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceImageIds(
                resourceAwsEc2InstanceImageIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceIpv4Addresses(
                resourceAwsEc2InstanceIpv4Addresses?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceIpv6Addresses(
                resourceAwsEc2InstanceIpv6Addresses?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceKeyNames(
                resourceAwsEc2InstanceKeyNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceLaunchedAts(
                resourceAwsEc2InstanceLaunchedAts?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceSubnetIds(
                resourceAwsEc2InstanceSubnetIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsEc2InstanceTypes(
                resourceAwsEc2InstanceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceAwsEc2InstanceVpcIds(
                resourceAwsEc2InstanceVpcIds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsIamAccessKeyCreatedAts(
                resourceAwsIamAccessKeyCreatedAts?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsIamAccessKeyStatuses(
                resourceAwsIamAccessKeyStatuses?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsIamAccessKeyUserNames(
                resourceAwsIamAccessKeyUserNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceAwsS3BucketOwnerIds(
                resourceAwsS3BucketOwnerIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceAwsS3BucketOwnerNames(
                resourceAwsS3BucketOwnerNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceContainerImageIds(
                resourceContainerImageIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceContainerImageNames(
                resourceContainerImageNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceContainerLaunchedAts(
                resourceContainerLaunchedAts?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceContainerNames(
                resourceContainerNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceDetailsOthers(
                resourceDetailsOthers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceIds(
                resourceIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourcePartitions(
                resourcePartitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceRegions(
                resourceRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceTags(
                resourceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceTypes(
                resourceTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .severityLabels(
                severityLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceUrls(
                sourceUrls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .threatIntelIndicatorCategories(
                threatIntelIndicatorCategories?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .threatIntelIndicatorLastObservedAts(
                threatIntelIndicatorLastObservedAts?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .threatIntelIndicatorSourceUrls(
                threatIntelIndicatorSourceUrls?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .threatIntelIndicatorSources(
                threatIntelIndicatorSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threatIntelIndicatorTypes(
                threatIntelIndicatorTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threatIntelIndicatorValues(
                threatIntelIndicatorValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .titles(titles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .types(types?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .updatedAts(
                updatedAts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userDefinedValues(
                userDefinedValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .verificationStates(
                verificationStates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .workflowStatuses(
                workflowStatuses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InsightFiltersArgs].
 */
@PulumiTagMarker
public class InsightFiltersArgsBuilder internal constructor() {
    private var awsAccountIds: Output<List<InsightFiltersAwsAccountIdArgs>>? = null

    private var companyNames: Output<List<InsightFiltersCompanyNameArgs>>? = null

    private var complianceStatuses: Output<List<InsightFiltersComplianceStatusArgs>>? = null

    private var confidences: Output<List<InsightFiltersConfidenceArgs>>? = null

    private var createdAts: Output<List<InsightFiltersCreatedAtArgs>>? = null

    private var criticalities: Output<List<InsightFiltersCriticalityArgs>>? = null

    private var descriptions: Output<List<InsightFiltersDescriptionArgs>>? = null

    private var findingProviderFieldsConfidences:
        Output<List<InsightFiltersFindingProviderFieldsConfidenceArgs>>? = null

    private var findingProviderFieldsCriticalities:
        Output<List<InsightFiltersFindingProviderFieldsCriticalityArgs>>? = null

    private var findingProviderFieldsRelatedFindingsIds:
        Output<List<InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs>>? = null

    private var findingProviderFieldsRelatedFindingsProductArns:
        Output<List<InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs>>? = null

    private var findingProviderFieldsSeverityLabels:
        Output<List<InsightFiltersFindingProviderFieldsSeverityLabelArgs>>? = null

    private var findingProviderFieldsSeverityOriginals:
        Output<List<InsightFiltersFindingProviderFieldsSeverityOriginalArgs>>? = null

    private var findingProviderFieldsTypes: Output<List<InsightFiltersFindingProviderFieldsTypeArgs>>? =
        null

    private var firstObservedAts: Output<List<InsightFiltersFirstObservedAtArgs>>? = null

    private var generatorIds: Output<List<InsightFiltersGeneratorIdArgs>>? = null

    private var ids: Output<List<InsightFiltersIdArgs>>? = null

    private var keywords: Output<List<InsightFiltersKeywordArgs>>? = null

    private var lastObservedAts: Output<List<InsightFiltersLastObservedAtArgs>>? = null

    private var malwareNames: Output<List<InsightFiltersMalwareNameArgs>>? = null

    private var malwarePaths: Output<List<InsightFiltersMalwarePathArgs>>? = null

    private var malwareStates: Output<List<InsightFiltersMalwareStateArgs>>? = null

    private var malwareTypes: Output<List<InsightFiltersMalwareTypeArgs>>? = null

    private var networkDestinationDomains: Output<List<InsightFiltersNetworkDestinationDomainArgs>>? =
        null

    private var networkDestinationIpv4s: Output<List<InsightFiltersNetworkDestinationIpv4Args>>? =
        null

    private var networkDestinationIpv6s: Output<List<InsightFiltersNetworkDestinationIpv6Args>>? =
        null

    private var networkDestinationPorts: Output<List<InsightFiltersNetworkDestinationPortArgs>>? =
        null

    private var networkDirections: Output<List<InsightFiltersNetworkDirectionArgs>>? = null

    private var networkProtocols: Output<List<InsightFiltersNetworkProtocolArgs>>? = null

    private var networkSourceDomains: Output<List<InsightFiltersNetworkSourceDomainArgs>>? = null

    private var networkSourceIpv4s: Output<List<InsightFiltersNetworkSourceIpv4Args>>? = null

    private var networkSourceIpv6s: Output<List<InsightFiltersNetworkSourceIpv6Args>>? = null

    private var networkSourceMacs: Output<List<InsightFiltersNetworkSourceMacArgs>>? = null

    private var networkSourcePorts: Output<List<InsightFiltersNetworkSourcePortArgs>>? = null

    private var noteTexts: Output<List<InsightFiltersNoteTextArgs>>? = null

    private var noteUpdatedAts: Output<List<InsightFiltersNoteUpdatedAtArgs>>? = null

    private var noteUpdatedBies: Output<List<InsightFiltersNoteUpdatedByArgs>>? = null

    private var processLaunchedAts: Output<List<InsightFiltersProcessLaunchedAtArgs>>? = null

    private var processNames: Output<List<InsightFiltersProcessNameArgs>>? = null

    private var processParentPids: Output<List<InsightFiltersProcessParentPidArgs>>? = null

    private var processPaths: Output<List<InsightFiltersProcessPathArgs>>? = null

    private var processPids: Output<List<InsightFiltersProcessPidArgs>>? = null

    private var processTerminatedAts: Output<List<InsightFiltersProcessTerminatedAtArgs>>? = null

    private var productArns: Output<List<InsightFiltersProductArnArgs>>? = null

    private var productFields: Output<List<InsightFiltersProductFieldArgs>>? = null

    private var productNames: Output<List<InsightFiltersProductNameArgs>>? = null

    private var recommendationTexts: Output<List<InsightFiltersRecommendationTextArgs>>? = null

    private var recordStates: Output<List<InsightFiltersRecordStateArgs>>? = null

    private var relatedFindingsIds: Output<List<InsightFiltersRelatedFindingsIdArgs>>? = null

    private var relatedFindingsProductArns: Output<List<InsightFiltersRelatedFindingsProductArnArgs>>? =
        null

    private var resourceAwsEc2InstanceIamInstanceProfileArns:
        Output<List<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs>>? = null

    private var resourceAwsEc2InstanceImageIds:
        Output<List<InsightFiltersResourceAwsEc2InstanceImageIdArgs>>? = null

    private var resourceAwsEc2InstanceIpv4Addresses:
        Output<List<InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs>>? = null

    private var resourceAwsEc2InstanceIpv6Addresses:
        Output<List<InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs>>? = null

    private var resourceAwsEc2InstanceKeyNames:
        Output<List<InsightFiltersResourceAwsEc2InstanceKeyNameArgs>>? = null

    private var resourceAwsEc2InstanceLaunchedAts:
        Output<List<InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs>>? = null

    private var resourceAwsEc2InstanceSubnetIds:
        Output<List<InsightFiltersResourceAwsEc2InstanceSubnetIdArgs>>? = null

    private var resourceAwsEc2InstanceTypes:
        Output<List<InsightFiltersResourceAwsEc2InstanceTypeArgs>>? = null

    private var resourceAwsEc2InstanceVpcIds:
        Output<List<InsightFiltersResourceAwsEc2InstanceVpcIdArgs>>? = null

    private var resourceAwsIamAccessKeyCreatedAts:
        Output<List<InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs>>? = null

    private var resourceAwsIamAccessKeyStatuses:
        Output<List<InsightFiltersResourceAwsIamAccessKeyStatusArgs>>? = null

    private var resourceAwsIamAccessKeyUserNames:
        Output<List<InsightFiltersResourceAwsIamAccessKeyUserNameArgs>>? = null

    private var resourceAwsS3BucketOwnerIds:
        Output<List<InsightFiltersResourceAwsS3BucketOwnerIdArgs>>? = null

    private var resourceAwsS3BucketOwnerNames:
        Output<List<InsightFiltersResourceAwsS3BucketOwnerNameArgs>>? = null

    private var resourceContainerImageIds: Output<List<InsightFiltersResourceContainerImageIdArgs>>? =
        null

    private var resourceContainerImageNames:
        Output<List<InsightFiltersResourceContainerImageNameArgs>>? = null

    private var resourceContainerLaunchedAts:
        Output<List<InsightFiltersResourceContainerLaunchedAtArgs>>? = null

    private var resourceContainerNames: Output<List<InsightFiltersResourceContainerNameArgs>>? = null

    private var resourceDetailsOthers: Output<List<InsightFiltersResourceDetailsOtherArgs>>? = null

    private var resourceIds: Output<List<InsightFiltersResourceIdArgs>>? = null

    private var resourcePartitions: Output<List<InsightFiltersResourcePartitionArgs>>? = null

    private var resourceRegions: Output<List<InsightFiltersResourceRegionArgs>>? = null

    private var resourceTags: Output<List<InsightFiltersResourceTagArgs>>? = null

    private var resourceTypes: Output<List<InsightFiltersResourceTypeArgs>>? = null

    private var severityLabels: Output<List<InsightFiltersSeverityLabelArgs>>? = null

    private var sourceUrls: Output<List<InsightFiltersSourceUrlArgs>>? = null

    private var threatIntelIndicatorCategories:
        Output<List<InsightFiltersThreatIntelIndicatorCategoryArgs>>? = null

    private var threatIntelIndicatorLastObservedAts:
        Output<List<InsightFiltersThreatIntelIndicatorLastObservedAtArgs>>? = null

    private var threatIntelIndicatorSourceUrls:
        Output<List<InsightFiltersThreatIntelIndicatorSourceUrlArgs>>? = null

    private var threatIntelIndicatorSources:
        Output<List<InsightFiltersThreatIntelIndicatorSourceArgs>>? = null

    private var threatIntelIndicatorTypes: Output<List<InsightFiltersThreatIntelIndicatorTypeArgs>>? =
        null

    private var threatIntelIndicatorValues: Output<List<InsightFiltersThreatIntelIndicatorValueArgs>>? =
        null

    private var titles: Output<List<InsightFiltersTitleArgs>>? = null

    private var types: Output<List<InsightFiltersTypeArgs>>? = null

    private var updatedAts: Output<List<InsightFiltersUpdatedAtArgs>>? = null

    private var userDefinedValues: Output<List<InsightFiltersUserDefinedValueArgs>>? = null

    private var verificationStates: Output<List<InsightFiltersVerificationStateArgs>>? = null

    private var workflowStatuses: Output<List<InsightFiltersWorkflowStatusArgs>>? = null

    /**
     * @param value AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("gwyrfgabeeooujbh")
    public suspend fun awsAccountIds(`value`: Output<List<InsightFiltersAwsAccountIdArgs>>) {
        this.awsAccountIds = value
    }

    @JvmName("kgoyrnoxkkkqpgvh")
    public suspend fun awsAccountIds(vararg values: Output<InsightFiltersAwsAccountIdArgs>) {
        this.awsAccountIds = Output.all(values.asList())
    }

    /**
     * @param values AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("wmmsoenyvwgpscfe")
    public suspend fun awsAccountIds(values: List<Output<InsightFiltersAwsAccountIdArgs>>) {
        this.awsAccountIds = Output.all(values)
    }

    /**
     * @param value The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("rdwxcvtcenpwyeka")
    public suspend fun companyNames(`value`: Output<List<InsightFiltersCompanyNameArgs>>) {
        this.companyNames = value
    }

    @JvmName("bkbkixbmcpyulerw")
    public suspend fun companyNames(vararg values: Output<InsightFiltersCompanyNameArgs>) {
        this.companyNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("cdwjscglpwbjdpbe")
    public suspend fun companyNames(values: List<Output<InsightFiltersCompanyNameArgs>>) {
        this.companyNames = Output.all(values)
    }

    /**
     * @param value Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("cfwuyolrhplsvedk")
    public suspend fun complianceStatuses(`value`: Output<List<InsightFiltersComplianceStatusArgs>>) {
        this.complianceStatuses = value
    }

    @JvmName("ndxanwpwfptmivsn")
    public suspend fun complianceStatuses(vararg values: Output<InsightFiltersComplianceStatusArgs>) {
        this.complianceStatuses = Output.all(values.asList())
    }

    /**
     * @param values Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("prigsgnyyolgfdas")
    public suspend fun complianceStatuses(values: List<Output<InsightFiltersComplianceStatusArgs>>) {
        this.complianceStatuses = Output.all(values)
    }

    /**
     * @param value A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("vvsultrgekatkkoe")
    public suspend fun confidences(`value`: Output<List<InsightFiltersConfidenceArgs>>) {
        this.confidences = value
    }

    @JvmName("spmtjhpumycxqnrp")
    public suspend fun confidences(vararg values: Output<InsightFiltersConfidenceArgs>) {
        this.confidences = Output.all(values.asList())
    }

    /**
     * @param values A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("yfkhtafdfiliitlh")
    public suspend fun confidences(values: List<Output<InsightFiltersConfidenceArgs>>) {
        this.confidences = Output.all(values)
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("eafgtbkfifhdsybw")
    public suspend fun createdAts(`value`: Output<List<InsightFiltersCreatedAtArgs>>) {
        this.createdAts = value
    }

    @JvmName("pecnretkotjxvpdc")
    public suspend fun createdAts(vararg values: Output<InsightFiltersCreatedAtArgs>) {
        this.createdAts = Output.all(values.asList())
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("gxlwxmonclsblasu")
    public suspend fun createdAts(values: List<Output<InsightFiltersCreatedAtArgs>>) {
        this.createdAts = Output.all(values)
    }

    /**
     * @param value The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("covhfdxehylxawod")
    public suspend fun criticalities(`value`: Output<List<InsightFiltersCriticalityArgs>>) {
        this.criticalities = value
    }

    @JvmName("uogqcqrynsjbwowh")
    public suspend fun criticalities(vararg values: Output<InsightFiltersCriticalityArgs>) {
        this.criticalities = Output.all(values.asList())
    }

    /**
     * @param values The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("wdyjohawbrtgjpcc")
    public suspend fun criticalities(values: List<Output<InsightFiltersCriticalityArgs>>) {
        this.criticalities = Output.all(values)
    }

    /**
     * @param value A finding's description. See String Filter below for more details.
     */
    @JvmName("dqmalhuhrrfwjfbk")
    public suspend fun descriptions(`value`: Output<List<InsightFiltersDescriptionArgs>>) {
        this.descriptions = value
    }

    @JvmName("evdptbqxpuwlesis")
    public suspend fun descriptions(vararg values: Output<InsightFiltersDescriptionArgs>) {
        this.descriptions = Output.all(values.asList())
    }

    /**
     * @param values A finding's description. See String Filter below for more details.
     */
    @JvmName("nljkiemkwvwcycqg")
    public suspend fun descriptions(values: List<Output<InsightFiltersDescriptionArgs>>) {
        this.descriptions = Output.all(values)
    }

    /**
     * @param value The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("bvkgdftuwbrhtobo")
    public suspend fun findingProviderFieldsConfidences(`value`: Output<List<InsightFiltersFindingProviderFieldsConfidenceArgs>>) {
        this.findingProviderFieldsConfidences = value
    }

    @JvmName("cfcqbrvjmjcshsjv")
    public suspend fun findingProviderFieldsConfidences(vararg values: Output<InsightFiltersFindingProviderFieldsConfidenceArgs>) {
        this.findingProviderFieldsConfidences = Output.all(values.asList())
    }

    /**
     * @param values The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("sseirfcavfxhpbkt")
    public suspend fun findingProviderFieldsConfidences(values: List<Output<InsightFiltersFindingProviderFieldsConfidenceArgs>>) {
        this.findingProviderFieldsConfidences = Output.all(values)
    }

    /**
     * @param value The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("lcnlitvkswtjqgdb")
    public suspend fun findingProviderFieldsCriticalities(`value`: Output<List<InsightFiltersFindingProviderFieldsCriticalityArgs>>) {
        this.findingProviderFieldsCriticalities = value
    }

    @JvmName("htvjucorlrefubhw")
    public suspend fun findingProviderFieldsCriticalities(vararg values: Output<InsightFiltersFindingProviderFieldsCriticalityArgs>) {
        this.findingProviderFieldsCriticalities = Output.all(values.asList())
    }

    /**
     * @param values The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("prbrlvdwgqpspbjd")
    public suspend fun findingProviderFieldsCriticalities(values: List<Output<InsightFiltersFindingProviderFieldsCriticalityArgs>>) {
        this.findingProviderFieldsCriticalities = Output.all(values)
    }

    /**
     * @param value The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("jlewgejwqruuevca")
    public suspend fun findingProviderFieldsRelatedFindingsIds(`value`: Output<List<InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs>>) {
        this.findingProviderFieldsRelatedFindingsIds = value
    }

    @JvmName("eapoaryiddodjrhp")
    public suspend fun findingProviderFieldsRelatedFindingsIds(vararg values: Output<InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs>) {
        this.findingProviderFieldsRelatedFindingsIds = Output.all(values.asList())
    }

    /**
     * @param values The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("qxlaiopqmvsoyyue")
    public suspend fun findingProviderFieldsRelatedFindingsIds(values: List<Output<InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs>>) {
        this.findingProviderFieldsRelatedFindingsIds = Output.all(values)
    }

    /**
     * @param value The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("migwvhmyeenkprke")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(`value`: Output<List<InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs>>) {
        this.findingProviderFieldsRelatedFindingsProductArns = value
    }

    @JvmName("jvhvjpejogxkisqb")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(vararg values: Output<InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs>) {
        this.findingProviderFieldsRelatedFindingsProductArns = Output.all(values.asList())
    }

    /**
     * @param values The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("grxmxqldvupwsugh")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(values: List<Output<InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs>>) {
        this.findingProviderFieldsRelatedFindingsProductArns = Output.all(values)
    }

    /**
     * @param value The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("nrcnspoyporywsof")
    public suspend fun findingProviderFieldsSeverityLabels(`value`: Output<List<InsightFiltersFindingProviderFieldsSeverityLabelArgs>>) {
        this.findingProviderFieldsSeverityLabels = value
    }

    @JvmName("pxcpatwlaygikcfi")
    public suspend fun findingProviderFieldsSeverityLabels(vararg values: Output<InsightFiltersFindingProviderFieldsSeverityLabelArgs>) {
        this.findingProviderFieldsSeverityLabels = Output.all(values.asList())
    }

    /**
     * @param values The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("mjognifdomqqhupp")
    public suspend fun findingProviderFieldsSeverityLabels(values: List<Output<InsightFiltersFindingProviderFieldsSeverityLabelArgs>>) {
        this.findingProviderFieldsSeverityLabels = Output.all(values)
    }

    /**
     * @param value The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("pfdtwfxtaubkjsrf")
    public suspend fun findingProviderFieldsSeverityOriginals(`value`: Output<List<InsightFiltersFindingProviderFieldsSeverityOriginalArgs>>) {
        this.findingProviderFieldsSeverityOriginals = value
    }

    @JvmName("fbwinuetxvysoqvw")
    public suspend fun findingProviderFieldsSeverityOriginals(vararg values: Output<InsightFiltersFindingProviderFieldsSeverityOriginalArgs>) {
        this.findingProviderFieldsSeverityOriginals = Output.all(values.asList())
    }

    /**
     * @param values The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("rsflcuysdvytjjwa")
    public suspend fun findingProviderFieldsSeverityOriginals(values: List<Output<InsightFiltersFindingProviderFieldsSeverityOriginalArgs>>) {
        this.findingProviderFieldsSeverityOriginals = Output.all(values)
    }

    /**
     * @param value One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("bjuqnvhmlkjylaoo")
    public suspend fun findingProviderFieldsTypes(`value`: Output<List<InsightFiltersFindingProviderFieldsTypeArgs>>) {
        this.findingProviderFieldsTypes = value
    }

    @JvmName("lrecqugcjvvcnykj")
    public suspend fun findingProviderFieldsTypes(vararg values: Output<InsightFiltersFindingProviderFieldsTypeArgs>) {
        this.findingProviderFieldsTypes = Output.all(values.asList())
    }

    /**
     * @param values One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("nkgxgcckhkecerln")
    public suspend fun findingProviderFieldsTypes(values: List<Output<InsightFiltersFindingProviderFieldsTypeArgs>>) {
        this.findingProviderFieldsTypes = Output.all(values)
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("rdmrkbukjphilybt")
    public suspend fun firstObservedAts(`value`: Output<List<InsightFiltersFirstObservedAtArgs>>) {
        this.firstObservedAts = value
    }

    @JvmName("mkcmplogpgrqnijn")
    public suspend fun firstObservedAts(vararg values: Output<InsightFiltersFirstObservedAtArgs>) {
        this.firstObservedAts = Output.all(values.asList())
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("jfqwiqxncmqpmtia")
    public suspend fun firstObservedAts(values: List<Output<InsightFiltersFirstObservedAtArgs>>) {
        this.firstObservedAts = Output.all(values)
    }

    /**
     * @param value The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("guuvebxyaeeccyug")
    public suspend fun generatorIds(`value`: Output<List<InsightFiltersGeneratorIdArgs>>) {
        this.generatorIds = value
    }

    @JvmName("bjfwibbajtlrxiie")
    public suspend fun generatorIds(vararg values: Output<InsightFiltersGeneratorIdArgs>) {
        this.generatorIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("inrekgqqmvjpkfxa")
    public suspend fun generatorIds(values: List<Output<InsightFiltersGeneratorIdArgs>>) {
        this.generatorIds = Output.all(values)
    }

    /**
     * @param value The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("fppndppuewnngrir")
    public suspend fun ids(`value`: Output<List<InsightFiltersIdArgs>>) {
        this.ids = value
    }

    @JvmName("cdenodowwnuclcrv")
    public suspend fun ids(vararg values: Output<InsightFiltersIdArgs>) {
        this.ids = Output.all(values.asList())
    }

    /**
     * @param values The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("wvlknlojvfownefu")
    public suspend fun ids(values: List<Output<InsightFiltersIdArgs>>) {
        this.ids = Output.all(values)
    }

    /**
     * @param value A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("gsskyeudamkylhce")
    public suspend fun keywords(`value`: Output<List<InsightFiltersKeywordArgs>>) {
        this.keywords = value
    }

    @JvmName("fpgywcdtiqmrrrfo")
    public suspend fun keywords(vararg values: Output<InsightFiltersKeywordArgs>) {
        this.keywords = Output.all(values.asList())
    }

    /**
     * @param values A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("puwemikklnhnmwpe")
    public suspend fun keywords(values: List<Output<InsightFiltersKeywordArgs>>) {
        this.keywords = Output.all(values)
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("exfmdycbkmtykaci")
    public suspend fun lastObservedAts(`value`: Output<List<InsightFiltersLastObservedAtArgs>>) {
        this.lastObservedAts = value
    }

    @JvmName("abbarboparogpsep")
    public suspend fun lastObservedAts(vararg values: Output<InsightFiltersLastObservedAtArgs>) {
        this.lastObservedAts = Output.all(values.asList())
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("trbgrurwxxhxpvny")
    public suspend fun lastObservedAts(values: List<Output<InsightFiltersLastObservedAtArgs>>) {
        this.lastObservedAts = Output.all(values)
    }

    /**
     * @param value The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("gbhdahffrurdicia")
    public suspend fun malwareNames(`value`: Output<List<InsightFiltersMalwareNameArgs>>) {
        this.malwareNames = value
    }

    @JvmName("ugncbwihpgfkkrch")
    public suspend fun malwareNames(vararg values: Output<InsightFiltersMalwareNameArgs>) {
        this.malwareNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("pgiykkekmtllhkvh")
    public suspend fun malwareNames(values: List<Output<InsightFiltersMalwareNameArgs>>) {
        this.malwareNames = Output.all(values)
    }

    /**
     * @param value The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("pnefkjmfgxvcsfya")
    public suspend fun malwarePaths(`value`: Output<List<InsightFiltersMalwarePathArgs>>) {
        this.malwarePaths = value
    }

    @JvmName("lpmyktxgnugssdln")
    public suspend fun malwarePaths(vararg values: Output<InsightFiltersMalwarePathArgs>) {
        this.malwarePaths = Output.all(values.asList())
    }

    /**
     * @param values The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("wxhksfhknegylpyg")
    public suspend fun malwarePaths(values: List<Output<InsightFiltersMalwarePathArgs>>) {
        this.malwarePaths = Output.all(values)
    }

    /**
     * @param value The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("bbolqfblctbmgtpe")
    public suspend fun malwareStates(`value`: Output<List<InsightFiltersMalwareStateArgs>>) {
        this.malwareStates = value
    }

    @JvmName("mhuapxebeviwhxdh")
    public suspend fun malwareStates(vararg values: Output<InsightFiltersMalwareStateArgs>) {
        this.malwareStates = Output.all(values.asList())
    }

    /**
     * @param values The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("dxfoikvsvgwktorb")
    public suspend fun malwareStates(values: List<Output<InsightFiltersMalwareStateArgs>>) {
        this.malwareStates = Output.all(values)
    }

    /**
     * @param value The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("kugudcbwsuilcghg")
    public suspend fun malwareTypes(`value`: Output<List<InsightFiltersMalwareTypeArgs>>) {
        this.malwareTypes = value
    }

    @JvmName("quqgpjkkcyjybrmg")
    public suspend fun malwareTypes(vararg values: Output<InsightFiltersMalwareTypeArgs>) {
        this.malwareTypes = Output.all(values.asList())
    }

    /**
     * @param values The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("taowawosxdblbckq")
    public suspend fun malwareTypes(values: List<Output<InsightFiltersMalwareTypeArgs>>) {
        this.malwareTypes = Output.all(values)
    }

    /**
     * @param value The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("pxselvkigloeyrey")
    public suspend fun networkDestinationDomains(`value`: Output<List<InsightFiltersNetworkDestinationDomainArgs>>) {
        this.networkDestinationDomains = value
    }

    @JvmName("sckhpkyjyrgjobkx")
    public suspend fun networkDestinationDomains(vararg values: Output<InsightFiltersNetworkDestinationDomainArgs>) {
        this.networkDestinationDomains = Output.all(values.asList())
    }

    /**
     * @param values The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("siqhopelfmlyhvtf")
    public suspend fun networkDestinationDomains(values: List<Output<InsightFiltersNetworkDestinationDomainArgs>>) {
        this.networkDestinationDomains = Output.all(values)
    }

    /**
     * @param value The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("ltwdrlcitkpmqove")
    public suspend fun networkDestinationIpv4s(`value`: Output<List<InsightFiltersNetworkDestinationIpv4Args>>) {
        this.networkDestinationIpv4s = value
    }

    @JvmName("napdastucotopwin")
    public suspend fun networkDestinationIpv4s(vararg values: Output<InsightFiltersNetworkDestinationIpv4Args>) {
        this.networkDestinationIpv4s = Output.all(values.asList())
    }

    /**
     * @param values The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("bdajudlojrsdclai")
    public suspend fun networkDestinationIpv4s(values: List<Output<InsightFiltersNetworkDestinationIpv4Args>>) {
        this.networkDestinationIpv4s = Output.all(values)
    }

    /**
     * @param value The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("hkxsopymhrxxaiod")
    public suspend fun networkDestinationIpv6s(`value`: Output<List<InsightFiltersNetworkDestinationIpv6Args>>) {
        this.networkDestinationIpv6s = value
    }

    @JvmName("wvsihnflwgmqrcnq")
    public suspend fun networkDestinationIpv6s(vararg values: Output<InsightFiltersNetworkDestinationIpv6Args>) {
        this.networkDestinationIpv6s = Output.all(values.asList())
    }

    /**
     * @param values The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("tocqmacaqnqeilta")
    public suspend fun networkDestinationIpv6s(values: List<Output<InsightFiltersNetworkDestinationIpv6Args>>) {
        this.networkDestinationIpv6s = Output.all(values)
    }

    /**
     * @param value The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("uogykjnyvtstovgh")
    public suspend fun networkDestinationPorts(`value`: Output<List<InsightFiltersNetworkDestinationPortArgs>>) {
        this.networkDestinationPorts = value
    }

    @JvmName("owyrubhlmwifkdhj")
    public suspend fun networkDestinationPorts(vararg values: Output<InsightFiltersNetworkDestinationPortArgs>) {
        this.networkDestinationPorts = Output.all(values.asList())
    }

    /**
     * @param values The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("reseqmhvepbnrkpu")
    public suspend fun networkDestinationPorts(values: List<Output<InsightFiltersNetworkDestinationPortArgs>>) {
        this.networkDestinationPorts = Output.all(values)
    }

    /**
     * @param value Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("yeohrtodggiqfmuo")
    public suspend fun networkDirections(`value`: Output<List<InsightFiltersNetworkDirectionArgs>>) {
        this.networkDirections = value
    }

    @JvmName("ovfqhffjjlkyxndb")
    public suspend fun networkDirections(vararg values: Output<InsightFiltersNetworkDirectionArgs>) {
        this.networkDirections = Output.all(values.asList())
    }

    /**
     * @param values Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("qwcawkqxiqguscgk")
    public suspend fun networkDirections(values: List<Output<InsightFiltersNetworkDirectionArgs>>) {
        this.networkDirections = Output.all(values)
    }

    /**
     * @param value The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("ylqsksfsoambktqx")
    public suspend fun networkProtocols(`value`: Output<List<InsightFiltersNetworkProtocolArgs>>) {
        this.networkProtocols = value
    }

    @JvmName("rlrwpdwvcwebwiuy")
    public suspend fun networkProtocols(vararg values: Output<InsightFiltersNetworkProtocolArgs>) {
        this.networkProtocols = Output.all(values.asList())
    }

    /**
     * @param values The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("qfwnlbaxplrdhqui")
    public suspend fun networkProtocols(values: List<Output<InsightFiltersNetworkProtocolArgs>>) {
        this.networkProtocols = Output.all(values)
    }

    /**
     * @param value The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("otngdgqdegbrtddl")
    public suspend fun networkSourceDomains(`value`: Output<List<InsightFiltersNetworkSourceDomainArgs>>) {
        this.networkSourceDomains = value
    }

    @JvmName("thjsnafmjbtiygmg")
    public suspend fun networkSourceDomains(vararg values: Output<InsightFiltersNetworkSourceDomainArgs>) {
        this.networkSourceDomains = Output.all(values.asList())
    }

    /**
     * @param values The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("duxrpqvpxwdjwsyo")
    public suspend fun networkSourceDomains(values: List<Output<InsightFiltersNetworkSourceDomainArgs>>) {
        this.networkSourceDomains = Output.all(values)
    }

    /**
     * @param value The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("vrifuxegpxpupqmn")
    public suspend fun networkSourceIpv4s(`value`: Output<List<InsightFiltersNetworkSourceIpv4Args>>) {
        this.networkSourceIpv4s = value
    }

    @JvmName("qjyqlmigooycgilk")
    public suspend fun networkSourceIpv4s(vararg values: Output<InsightFiltersNetworkSourceIpv4Args>) {
        this.networkSourceIpv4s = Output.all(values.asList())
    }

    /**
     * @param values The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("xfnsxhnwmrcaaqfd")
    public suspend fun networkSourceIpv4s(values: List<Output<InsightFiltersNetworkSourceIpv4Args>>) {
        this.networkSourceIpv4s = Output.all(values)
    }

    /**
     * @param value The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("yhvhnxmrdpxrfcde")
    public suspend fun networkSourceIpv6s(`value`: Output<List<InsightFiltersNetworkSourceIpv6Args>>) {
        this.networkSourceIpv6s = value
    }

    @JvmName("vpbxjmbtlloleppj")
    public suspend fun networkSourceIpv6s(vararg values: Output<InsightFiltersNetworkSourceIpv6Args>) {
        this.networkSourceIpv6s = Output.all(values.asList())
    }

    /**
     * @param values The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("jpgojawmfbontoig")
    public suspend fun networkSourceIpv6s(values: List<Output<InsightFiltersNetworkSourceIpv6Args>>) {
        this.networkSourceIpv6s = Output.all(values)
    }

    /**
     * @param value The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("juvaenfrosulmfum")
    public suspend fun networkSourceMacs(`value`: Output<List<InsightFiltersNetworkSourceMacArgs>>) {
        this.networkSourceMacs = value
    }

    @JvmName("myjovbtucyqovmhx")
    public suspend fun networkSourceMacs(vararg values: Output<InsightFiltersNetworkSourceMacArgs>) {
        this.networkSourceMacs = Output.all(values.asList())
    }

    /**
     * @param values The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("uehqiwvjybejcvwk")
    public suspend fun networkSourceMacs(values: List<Output<InsightFiltersNetworkSourceMacArgs>>) {
        this.networkSourceMacs = Output.all(values)
    }

    /**
     * @param value The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("plbnctacglldjdpt")
    public suspend fun networkSourcePorts(`value`: Output<List<InsightFiltersNetworkSourcePortArgs>>) {
        this.networkSourcePorts = value
    }

    @JvmName("pwinypsgukfvhtgs")
    public suspend fun networkSourcePorts(vararg values: Output<InsightFiltersNetworkSourcePortArgs>) {
        this.networkSourcePorts = Output.all(values.asList())
    }

    /**
     * @param values The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("wqykugbdvwsqduqu")
    public suspend fun networkSourcePorts(values: List<Output<InsightFiltersNetworkSourcePortArgs>>) {
        this.networkSourcePorts = Output.all(values)
    }

    /**
     * @param value The text of a note. See String Filter below for more details.
     */
    @JvmName("taxwrbuaabvlwauy")
    public suspend fun noteTexts(`value`: Output<List<InsightFiltersNoteTextArgs>>) {
        this.noteTexts = value
    }

    @JvmName("itmqstkffuxneapc")
    public suspend fun noteTexts(vararg values: Output<InsightFiltersNoteTextArgs>) {
        this.noteTexts = Output.all(values.asList())
    }

    /**
     * @param values The text of a note. See String Filter below for more details.
     */
    @JvmName("uahxfkahvqsicdbc")
    public suspend fun noteTexts(values: List<Output<InsightFiltersNoteTextArgs>>) {
        this.noteTexts = Output.all(values)
    }

    /**
     * @param value The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("clwpyeqnlwfkhxic")
    public suspend fun noteUpdatedAts(`value`: Output<List<InsightFiltersNoteUpdatedAtArgs>>) {
        this.noteUpdatedAts = value
    }

    @JvmName("ldksephprkkhydhb")
    public suspend fun noteUpdatedAts(vararg values: Output<InsightFiltersNoteUpdatedAtArgs>) {
        this.noteUpdatedAts = Output.all(values.asList())
    }

    /**
     * @param values The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("jsecuvpmbtceumah")
    public suspend fun noteUpdatedAts(values: List<Output<InsightFiltersNoteUpdatedAtArgs>>) {
        this.noteUpdatedAts = Output.all(values)
    }

    /**
     * @param value The principal that created a note. See String Filter below for more details.
     */
    @JvmName("qpatimnbvauidbos")
    public suspend fun noteUpdatedBies(`value`: Output<List<InsightFiltersNoteUpdatedByArgs>>) {
        this.noteUpdatedBies = value
    }

    @JvmName("ofpsgypipdedqljl")
    public suspend fun noteUpdatedBies(vararg values: Output<InsightFiltersNoteUpdatedByArgs>) {
        this.noteUpdatedBies = Output.all(values.asList())
    }

    /**
     * @param values The principal that created a note. See String Filter below for more details.
     */
    @JvmName("yfqpcdaxbcfuuvmt")
    public suspend fun noteUpdatedBies(values: List<Output<InsightFiltersNoteUpdatedByArgs>>) {
        this.noteUpdatedBies = Output.all(values)
    }

    /**
     * @param value The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("ujqrxxpsgfwrlsju")
    public suspend fun processLaunchedAts(`value`: Output<List<InsightFiltersProcessLaunchedAtArgs>>) {
        this.processLaunchedAts = value
    }

    @JvmName("bmatxjbipceomspi")
    public suspend fun processLaunchedAts(vararg values: Output<InsightFiltersProcessLaunchedAtArgs>) {
        this.processLaunchedAts = Output.all(values.asList())
    }

    /**
     * @param values The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("newynrhaghsfobhq")
    public suspend fun processLaunchedAts(values: List<Output<InsightFiltersProcessLaunchedAtArgs>>) {
        this.processLaunchedAts = Output.all(values)
    }

    /**
     * @param value The name of the process. See String Filter below for more details.
     */
    @JvmName("thglhqdcvjthilxi")
    public suspend fun processNames(`value`: Output<List<InsightFiltersProcessNameArgs>>) {
        this.processNames = value
    }

    @JvmName("rjlpsvqvondgbdom")
    public suspend fun processNames(vararg values: Output<InsightFiltersProcessNameArgs>) {
        this.processNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the process. See String Filter below for more details.
     */
    @JvmName("stycdpelmsrvqcje")
    public suspend fun processNames(values: List<Output<InsightFiltersProcessNameArgs>>) {
        this.processNames = Output.all(values)
    }

    /**
     * @param value The parent process ID. See Number Filter below for more details.
     */
    @JvmName("oqrswpeeolyrjjmf")
    public suspend fun processParentPids(`value`: Output<List<InsightFiltersProcessParentPidArgs>>) {
        this.processParentPids = value
    }

    @JvmName("ygxfxpvhkofubycd")
    public suspend fun processParentPids(vararg values: Output<InsightFiltersProcessParentPidArgs>) {
        this.processParentPids = Output.all(values.asList())
    }

    /**
     * @param values The parent process ID. See Number Filter below for more details.
     */
    @JvmName("tlhkjaecltcdvkdu")
    public suspend fun processParentPids(values: List<Output<InsightFiltersProcessParentPidArgs>>) {
        this.processParentPids = Output.all(values)
    }

    /**
     * @param value The path to the process executable. See String Filter below for more details.
     */
    @JvmName("ypycevrlsttqmlxk")
    public suspend fun processPaths(`value`: Output<List<InsightFiltersProcessPathArgs>>) {
        this.processPaths = value
    }

    @JvmName("cumcraemxkskkvit")
    public suspend fun processPaths(vararg values: Output<InsightFiltersProcessPathArgs>) {
        this.processPaths = Output.all(values.asList())
    }

    /**
     * @param values The path to the process executable. See String Filter below for more details.
     */
    @JvmName("wxdlnsfxhcnukboj")
    public suspend fun processPaths(values: List<Output<InsightFiltersProcessPathArgs>>) {
        this.processPaths = Output.all(values)
    }

    /**
     * @param value The process ID. See Number Filter below for more details.
     */
    @JvmName("nqbfdyiwtbuynpnl")
    public suspend fun processPids(`value`: Output<List<InsightFiltersProcessPidArgs>>) {
        this.processPids = value
    }

    @JvmName("puffseayusknpdyv")
    public suspend fun processPids(vararg values: Output<InsightFiltersProcessPidArgs>) {
        this.processPids = Output.all(values.asList())
    }

    /**
     * @param values The process ID. See Number Filter below for more details.
     */
    @JvmName("rrelciocbijoeiho")
    public suspend fun processPids(values: List<Output<InsightFiltersProcessPidArgs>>) {
        this.processPids = Output.all(values)
    }

    /**
     * @param value The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("yndqoiqarxgxjeio")
    public suspend fun processTerminatedAts(`value`: Output<List<InsightFiltersProcessTerminatedAtArgs>>) {
        this.processTerminatedAts = value
    }

    @JvmName("jqrignybgddmljcw")
    public suspend fun processTerminatedAts(vararg values: Output<InsightFiltersProcessTerminatedAtArgs>) {
        this.processTerminatedAts = Output.all(values.asList())
    }

    /**
     * @param values The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("npsqmwjvnqfofkhy")
    public suspend fun processTerminatedAts(values: List<Output<InsightFiltersProcessTerminatedAtArgs>>) {
        this.processTerminatedAts = Output.all(values)
    }

    /**
     * @param value The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("xquhedfwheimlbwh")
    public suspend fun productArns(`value`: Output<List<InsightFiltersProductArnArgs>>) {
        this.productArns = value
    }

    @JvmName("tavqtpcmmadnxdnl")
    public suspend fun productArns(vararg values: Output<InsightFiltersProductArnArgs>) {
        this.productArns = Output.all(values.asList())
    }

    /**
     * @param values The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("putvkhtpoqjanmmw")
    public suspend fun productArns(values: List<Output<InsightFiltersProductArnArgs>>) {
        this.productArns = Output.all(values)
    }

    /**
     * @param value A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("whuqnggqbeengifj")
    public suspend fun productFields(`value`: Output<List<InsightFiltersProductFieldArgs>>) {
        this.productFields = value
    }

    @JvmName("bnodwftqcpufwjua")
    public suspend fun productFields(vararg values: Output<InsightFiltersProductFieldArgs>) {
        this.productFields = Output.all(values.asList())
    }

    /**
     * @param values A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("qvkafeniaowquelq")
    public suspend fun productFields(values: List<Output<InsightFiltersProductFieldArgs>>) {
        this.productFields = Output.all(values)
    }

    /**
     * @param value The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("ejxmgshvswevtdxp")
    public suspend fun productNames(`value`: Output<List<InsightFiltersProductNameArgs>>) {
        this.productNames = value
    }

    @JvmName("uenychokwwnaggmm")
    public suspend fun productNames(vararg values: Output<InsightFiltersProductNameArgs>) {
        this.productNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("gbfnpyqtwybuaklc")
    public suspend fun productNames(values: List<Output<InsightFiltersProductNameArgs>>) {
        this.productNames = Output.all(values)
    }

    /**
     * @param value The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("jclsyydtpfkualvu")
    public suspend fun recommendationTexts(`value`: Output<List<InsightFiltersRecommendationTextArgs>>) {
        this.recommendationTexts = value
    }

    @JvmName("abvoqjiyupwlcwmp")
    public suspend fun recommendationTexts(vararg values: Output<InsightFiltersRecommendationTextArgs>) {
        this.recommendationTexts = Output.all(values.asList())
    }

    /**
     * @param values The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("cwbgtiqmaikcygub")
    public suspend fun recommendationTexts(values: List<Output<InsightFiltersRecommendationTextArgs>>) {
        this.recommendationTexts = Output.all(values)
    }

    /**
     * @param value The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("llspeenbwqimtcau")
    public suspend fun recordStates(`value`: Output<List<InsightFiltersRecordStateArgs>>) {
        this.recordStates = value
    }

    @JvmName("xbhtajnqnmjcsuyf")
    public suspend fun recordStates(vararg values: Output<InsightFiltersRecordStateArgs>) {
        this.recordStates = Output.all(values.asList())
    }

    /**
     * @param values The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("bqoihnsbnpxgwioh")
    public suspend fun recordStates(values: List<Output<InsightFiltersRecordStateArgs>>) {
        this.recordStates = Output.all(values)
    }

    /**
     * @param value The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("kfpctbdbsnxnayqy")
    public suspend fun relatedFindingsIds(`value`: Output<List<InsightFiltersRelatedFindingsIdArgs>>) {
        this.relatedFindingsIds = value
    }

    @JvmName("wiafjchnawodelwu")
    public suspend fun relatedFindingsIds(vararg values: Output<InsightFiltersRelatedFindingsIdArgs>) {
        this.relatedFindingsIds = Output.all(values.asList())
    }

    /**
     * @param values The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("xsvxgcxhgqawjdjy")
    public suspend fun relatedFindingsIds(values: List<Output<InsightFiltersRelatedFindingsIdArgs>>) {
        this.relatedFindingsIds = Output.all(values)
    }

    /**
     * @param value The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("jsnytgqhjqoywwwj")
    public suspend fun relatedFindingsProductArns(`value`: Output<List<InsightFiltersRelatedFindingsProductArnArgs>>) {
        this.relatedFindingsProductArns = value
    }

    @JvmName("cqxhpsvncpuoqfhq")
    public suspend fun relatedFindingsProductArns(vararg values: Output<InsightFiltersRelatedFindingsProductArnArgs>) {
        this.relatedFindingsProductArns = Output.all(values.asList())
    }

    /**
     * @param values The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("awunaytqafdahlmb")
    public suspend fun relatedFindingsProductArns(values: List<Output<InsightFiltersRelatedFindingsProductArnArgs>>) {
        this.relatedFindingsProductArns = Output.all(values)
    }

    /**
     * @param value The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("tdyotnsdtfottmry")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs>>) {
        this.resourceAwsEc2InstanceIamInstanceProfileArns = value
    }

    @JvmName("lgljwmdmbufksaft")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(vararg values: Output<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs>) {
        this.resourceAwsEc2InstanceIamInstanceProfileArns = Output.all(values.asList())
    }

    /**
     * @param values The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("udwjeilukfpqaecw")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(values: List<Output<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs>>) {
        this.resourceAwsEc2InstanceIamInstanceProfileArns = Output.all(values)
    }

    /**
     * @param value The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("wrscbjbwsbpuscck")
    public suspend fun resourceAwsEc2InstanceImageIds(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceImageIdArgs>>) {
        this.resourceAwsEc2InstanceImageIds = value
    }

    @JvmName("oefcavjkhxfgkogi")
    public suspend fun resourceAwsEc2InstanceImageIds(vararg values: Output<InsightFiltersResourceAwsEc2InstanceImageIdArgs>) {
        this.resourceAwsEc2InstanceImageIds = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("icryldiehprbnwtg")
    public suspend fun resourceAwsEc2InstanceImageIds(values: List<Output<InsightFiltersResourceAwsEc2InstanceImageIdArgs>>) {
        this.resourceAwsEc2InstanceImageIds = Output.all(values)
    }

    /**
     * @param value The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("tlrbrellxcumgxnm")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs>>) {
        this.resourceAwsEc2InstanceIpv4Addresses = value
    }

    @JvmName("cjkiihxjkmicrakc")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(vararg values: Output<InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs>) {
        this.resourceAwsEc2InstanceIpv4Addresses = Output.all(values.asList())
    }

    /**
     * @param values The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("tossxhkfarvuoaik")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(values: List<Output<InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs>>) {
        this.resourceAwsEc2InstanceIpv4Addresses = Output.all(values)
    }

    /**
     * @param value The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("akhbmdqnctmdbjqt")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs>>) {
        this.resourceAwsEc2InstanceIpv6Addresses = value
    }

    @JvmName("fpxuyasqegpabqft")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(vararg values: Output<InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs>) {
        this.resourceAwsEc2InstanceIpv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("dpjsfeygkvuyaynt")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(values: List<Output<InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs>>) {
        this.resourceAwsEc2InstanceIpv6Addresses = Output.all(values)
    }

    /**
     * @param value The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("ekpbfxaxixwfktqk")
    public suspend fun resourceAwsEc2InstanceKeyNames(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceKeyNameArgs>>) {
        this.resourceAwsEc2InstanceKeyNames = value
    }

    @JvmName("eghntobcdxouycsy")
    public suspend fun resourceAwsEc2InstanceKeyNames(vararg values: Output<InsightFiltersResourceAwsEc2InstanceKeyNameArgs>) {
        this.resourceAwsEc2InstanceKeyNames = Output.all(values.asList())
    }

    /**
     * @param values The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("kufcxbccqtqidled")
    public suspend fun resourceAwsEc2InstanceKeyNames(values: List<Output<InsightFiltersResourceAwsEc2InstanceKeyNameArgs>>) {
        this.resourceAwsEc2InstanceKeyNames = Output.all(values)
    }

    /**
     * @param value The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("trcjyggoyhhvslaa")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs>>) {
        this.resourceAwsEc2InstanceLaunchedAts = value
    }

    @JvmName("vdgqiiymeeawmsse")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(vararg values: Output<InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs>) {
        this.resourceAwsEc2InstanceLaunchedAts = Output.all(values.asList())
    }

    /**
     * @param values The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("cyurijbqcigemnix")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(values: List<Output<InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs>>) {
        this.resourceAwsEc2InstanceLaunchedAts = Output.all(values)
    }

    /**
     * @param value The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("bpjrflplpalmlbmj")
    public suspend fun resourceAwsEc2InstanceSubnetIds(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceSubnetIdArgs>>) {
        this.resourceAwsEc2InstanceSubnetIds = value
    }

    @JvmName("ggimoxevcerjfhva")
    public suspend fun resourceAwsEc2InstanceSubnetIds(vararg values: Output<InsightFiltersResourceAwsEc2InstanceSubnetIdArgs>) {
        this.resourceAwsEc2InstanceSubnetIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("qaiqfemgoabrphvu")
    public suspend fun resourceAwsEc2InstanceSubnetIds(values: List<Output<InsightFiltersResourceAwsEc2InstanceSubnetIdArgs>>) {
        this.resourceAwsEc2InstanceSubnetIds = Output.all(values)
    }

    /**
     * @param value The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("wlxukaaifmchefig")
    public suspend fun resourceAwsEc2InstanceTypes(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceTypeArgs>>) {
        this.resourceAwsEc2InstanceTypes = value
    }

    @JvmName("wyqicrmufmgivbxj")
    public suspend fun resourceAwsEc2InstanceTypes(vararg values: Output<InsightFiltersResourceAwsEc2InstanceTypeArgs>) {
        this.resourceAwsEc2InstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("xyesmtgfnrjlwgqo")
    public suspend fun resourceAwsEc2InstanceTypes(values: List<Output<InsightFiltersResourceAwsEc2InstanceTypeArgs>>) {
        this.resourceAwsEc2InstanceTypes = Output.all(values)
    }

    /**
     * @param value The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("endkptfedtphbnyn")
    public suspend fun resourceAwsEc2InstanceVpcIds(`value`: Output<List<InsightFiltersResourceAwsEc2InstanceVpcIdArgs>>) {
        this.resourceAwsEc2InstanceVpcIds = value
    }

    @JvmName("ytmmxuecntoglxto")
    public suspend fun resourceAwsEc2InstanceVpcIds(vararg values: Output<InsightFiltersResourceAwsEc2InstanceVpcIdArgs>) {
        this.resourceAwsEc2InstanceVpcIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("rosyjmakhrsqrqwc")
    public suspend fun resourceAwsEc2InstanceVpcIds(values: List<Output<InsightFiltersResourceAwsEc2InstanceVpcIdArgs>>) {
        this.resourceAwsEc2InstanceVpcIds = Output.all(values)
    }

    /**
     * @param value The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("mcdghpqjvubcrrnj")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(`value`: Output<List<InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs>>) {
        this.resourceAwsIamAccessKeyCreatedAts = value
    }

    @JvmName("pgqgtcpgbxmxpusr")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(vararg values: Output<InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs>) {
        this.resourceAwsIamAccessKeyCreatedAts = Output.all(values.asList())
    }

    /**
     * @param values The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("itndoagwfhwxfbks")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(values: List<Output<InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs>>) {
        this.resourceAwsIamAccessKeyCreatedAts = Output.all(values)
    }

    /**
     * @param value The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("pqlwmfqbowyglqtp")
    public suspend fun resourceAwsIamAccessKeyStatuses(`value`: Output<List<InsightFiltersResourceAwsIamAccessKeyStatusArgs>>) {
        this.resourceAwsIamAccessKeyStatuses = value
    }

    @JvmName("dbmhhsvewoyjeqbx")
    public suspend fun resourceAwsIamAccessKeyStatuses(vararg values: Output<InsightFiltersResourceAwsIamAccessKeyStatusArgs>) {
        this.resourceAwsIamAccessKeyStatuses = Output.all(values.asList())
    }

    /**
     * @param values The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("acxiftpulexoycwj")
    public suspend fun resourceAwsIamAccessKeyStatuses(values: List<Output<InsightFiltersResourceAwsIamAccessKeyStatusArgs>>) {
        this.resourceAwsIamAccessKeyStatuses = Output.all(values)
    }

    /**
     * @param value The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("etslkaqqjqeputef")
    public suspend fun resourceAwsIamAccessKeyUserNames(`value`: Output<List<InsightFiltersResourceAwsIamAccessKeyUserNameArgs>>) {
        this.resourceAwsIamAccessKeyUserNames = value
    }

    @JvmName("rqewgbiexcfoebwv")
    public suspend fun resourceAwsIamAccessKeyUserNames(vararg values: Output<InsightFiltersResourceAwsIamAccessKeyUserNameArgs>) {
        this.resourceAwsIamAccessKeyUserNames = Output.all(values.asList())
    }

    /**
     * @param values The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("cgudeqbltyttdbnv")
    public suspend fun resourceAwsIamAccessKeyUserNames(values: List<Output<InsightFiltersResourceAwsIamAccessKeyUserNameArgs>>) {
        this.resourceAwsIamAccessKeyUserNames = Output.all(values)
    }

    /**
     * @param value The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("aleatbsvocavvqea")
    public suspend fun resourceAwsS3BucketOwnerIds(`value`: Output<List<InsightFiltersResourceAwsS3BucketOwnerIdArgs>>) {
        this.resourceAwsS3BucketOwnerIds = value
    }

    @JvmName("lhvkjqowinsypjyf")
    public suspend fun resourceAwsS3BucketOwnerIds(vararg values: Output<InsightFiltersResourceAwsS3BucketOwnerIdArgs>) {
        this.resourceAwsS3BucketOwnerIds = Output.all(values.asList())
    }

    /**
     * @param values The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("hafaqhhchojirndb")
    public suspend fun resourceAwsS3BucketOwnerIds(values: List<Output<InsightFiltersResourceAwsS3BucketOwnerIdArgs>>) {
        this.resourceAwsS3BucketOwnerIds = Output.all(values)
    }

    /**
     * @param value The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("antiewfcpqghmggf")
    public suspend fun resourceAwsS3BucketOwnerNames(`value`: Output<List<InsightFiltersResourceAwsS3BucketOwnerNameArgs>>) {
        this.resourceAwsS3BucketOwnerNames = value
    }

    @JvmName("crmvxyawfhcoyvae")
    public suspend fun resourceAwsS3BucketOwnerNames(vararg values: Output<InsightFiltersResourceAwsS3BucketOwnerNameArgs>) {
        this.resourceAwsS3BucketOwnerNames = Output.all(values.asList())
    }

    /**
     * @param values The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("qskrnjcswbmnblgv")
    public suspend fun resourceAwsS3BucketOwnerNames(values: List<Output<InsightFiltersResourceAwsS3BucketOwnerNameArgs>>) {
        this.resourceAwsS3BucketOwnerNames = Output.all(values)
    }

    /**
     * @param value The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("ogclagapqwjupxyf")
    public suspend fun resourceContainerImageIds(`value`: Output<List<InsightFiltersResourceContainerImageIdArgs>>) {
        this.resourceContainerImageIds = value
    }

    @JvmName("mfnjmcgehhkfrojy")
    public suspend fun resourceContainerImageIds(vararg values: Output<InsightFiltersResourceContainerImageIdArgs>) {
        this.resourceContainerImageIds = Output.all(values.asList())
    }

    /**
     * @param values The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("gdmxgrqygjwlgmbe")
    public suspend fun resourceContainerImageIds(values: List<Output<InsightFiltersResourceContainerImageIdArgs>>) {
        this.resourceContainerImageIds = Output.all(values)
    }

    /**
     * @param value The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("bjkdfbvthodoqcqx")
    public suspend fun resourceContainerImageNames(`value`: Output<List<InsightFiltersResourceContainerImageNameArgs>>) {
        this.resourceContainerImageNames = value
    }

    @JvmName("pxcaflgshkfdivuy")
    public suspend fun resourceContainerImageNames(vararg values: Output<InsightFiltersResourceContainerImageNameArgs>) {
        this.resourceContainerImageNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("trjuycdwwwupqrhl")
    public suspend fun resourceContainerImageNames(values: List<Output<InsightFiltersResourceContainerImageNameArgs>>) {
        this.resourceContainerImageNames = Output.all(values)
    }

    /**
     * @param value The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("tjecpqutioxnqirn")
    public suspend fun resourceContainerLaunchedAts(`value`: Output<List<InsightFiltersResourceContainerLaunchedAtArgs>>) {
        this.resourceContainerLaunchedAts = value
    }

    @JvmName("kujhkdypgdkslvvm")
    public suspend fun resourceContainerLaunchedAts(vararg values: Output<InsightFiltersResourceContainerLaunchedAtArgs>) {
        this.resourceContainerLaunchedAts = Output.all(values.asList())
    }

    /**
     * @param values The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("clbgowqtvgmmqqaf")
    public suspend fun resourceContainerLaunchedAts(values: List<Output<InsightFiltersResourceContainerLaunchedAtArgs>>) {
        this.resourceContainerLaunchedAts = Output.all(values)
    }

    /**
     * @param value The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("ohihnwlpnjynroth")
    public suspend fun resourceContainerNames(`value`: Output<List<InsightFiltersResourceContainerNameArgs>>) {
        this.resourceContainerNames = value
    }

    @JvmName("iumwudqggrfrasns")
    public suspend fun resourceContainerNames(vararg values: Output<InsightFiltersResourceContainerNameArgs>) {
        this.resourceContainerNames = Output.all(values.asList())
    }

    /**
     * @param values The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("nemovvogemfaswqe")
    public suspend fun resourceContainerNames(values: List<Output<InsightFiltersResourceContainerNameArgs>>) {
        this.resourceContainerNames = Output.all(values)
    }

    /**
     * @param value The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("mhnrdqbkkndougbm")
    public suspend fun resourceDetailsOthers(`value`: Output<List<InsightFiltersResourceDetailsOtherArgs>>) {
        this.resourceDetailsOthers = value
    }

    @JvmName("tlryulubuayhknea")
    public suspend fun resourceDetailsOthers(vararg values: Output<InsightFiltersResourceDetailsOtherArgs>) {
        this.resourceDetailsOthers = Output.all(values.asList())
    }

    /**
     * @param values The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("xkssdmwbrptmwbqu")
    public suspend fun resourceDetailsOthers(values: List<Output<InsightFiltersResourceDetailsOtherArgs>>) {
        this.resourceDetailsOthers = Output.all(values)
    }

    /**
     * @param value The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("evdeqynvpwtdsbka")
    public suspend fun resourceIds(`value`: Output<List<InsightFiltersResourceIdArgs>>) {
        this.resourceIds = value
    }

    @JvmName("ocrslplmjuonsoyh")
    public suspend fun resourceIds(vararg values: Output<InsightFiltersResourceIdArgs>) {
        this.resourceIds = Output.all(values.asList())
    }

    /**
     * @param values The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("dxqaxgfknjmvmvdr")
    public suspend fun resourceIds(values: List<Output<InsightFiltersResourceIdArgs>>) {
        this.resourceIds = Output.all(values)
    }

    /**
     * @param value The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("xogyeilbfggsnijl")
    public suspend fun resourcePartitions(`value`: Output<List<InsightFiltersResourcePartitionArgs>>) {
        this.resourcePartitions = value
    }

    @JvmName("rxaccuurivyiwqyg")
    public suspend fun resourcePartitions(vararg values: Output<InsightFiltersResourcePartitionArgs>) {
        this.resourcePartitions = Output.all(values.asList())
    }

    /**
     * @param values The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("fvnyjpmvrsvklxvr")
    public suspend fun resourcePartitions(values: List<Output<InsightFiltersResourcePartitionArgs>>) {
        this.resourcePartitions = Output.all(values)
    }

    /**
     * @param value The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("kkmnxgoddbkwekut")
    public suspend fun resourceRegions(`value`: Output<List<InsightFiltersResourceRegionArgs>>) {
        this.resourceRegions = value
    }

    @JvmName("wftmqpotfpsfmenl")
    public suspend fun resourceRegions(vararg values: Output<InsightFiltersResourceRegionArgs>) {
        this.resourceRegions = Output.all(values.asList())
    }

    /**
     * @param values The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("eqecivxnwqyhsesu")
    public suspend fun resourceRegions(values: List<Output<InsightFiltersResourceRegionArgs>>) {
        this.resourceRegions = Output.all(values)
    }

    /**
     * @param value A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("ueqtnwfaecgqctgn")
    public suspend fun resourceTags(`value`: Output<List<InsightFiltersResourceTagArgs>>) {
        this.resourceTags = value
    }

    @JvmName("rskvsrorbbhfxpye")
    public suspend fun resourceTags(vararg values: Output<InsightFiltersResourceTagArgs>) {
        this.resourceTags = Output.all(values.asList())
    }

    /**
     * @param values A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("shwbwhiratwtyywa")
    public suspend fun resourceTags(values: List<Output<InsightFiltersResourceTagArgs>>) {
        this.resourceTags = Output.all(values)
    }

    /**
     * @param value Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("jrfmedqxhehtctji")
    public suspend fun resourceTypes(`value`: Output<List<InsightFiltersResourceTypeArgs>>) {
        this.resourceTypes = value
    }

    @JvmName("xddqhmqqbitbfueh")
    public suspend fun resourceTypes(vararg values: Output<InsightFiltersResourceTypeArgs>) {
        this.resourceTypes = Output.all(values.asList())
    }

    /**
     * @param values Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("hboqbounipxundjg")
    public suspend fun resourceTypes(values: List<Output<InsightFiltersResourceTypeArgs>>) {
        this.resourceTypes = Output.all(values)
    }

    /**
     * @param value The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("nlgyccitftflewmk")
    public suspend fun severityLabels(`value`: Output<List<InsightFiltersSeverityLabelArgs>>) {
        this.severityLabels = value
    }

    @JvmName("cvtqmyjvrxiffkjh")
    public suspend fun severityLabels(vararg values: Output<InsightFiltersSeverityLabelArgs>) {
        this.severityLabels = Output.all(values.asList())
    }

    /**
     * @param values The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("tivgcrbvqjxxtvix")
    public suspend fun severityLabels(values: List<Output<InsightFiltersSeverityLabelArgs>>) {
        this.severityLabels = Output.all(values)
    }

    /**
     * @param value A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("jmqcwvydfbyekuet")
    public suspend fun sourceUrls(`value`: Output<List<InsightFiltersSourceUrlArgs>>) {
        this.sourceUrls = value
    }

    @JvmName("isrgakvnyxdxnnmi")
    public suspend fun sourceUrls(vararg values: Output<InsightFiltersSourceUrlArgs>) {
        this.sourceUrls = Output.all(values.asList())
    }

    /**
     * @param values A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("rqcwallmtogupjfx")
    public suspend fun sourceUrls(values: List<Output<InsightFiltersSourceUrlArgs>>) {
        this.sourceUrls = Output.all(values)
    }

    /**
     * @param value The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("letfqbjmrpetlvso")
    public suspend fun threatIntelIndicatorCategories(`value`: Output<List<InsightFiltersThreatIntelIndicatorCategoryArgs>>) {
        this.threatIntelIndicatorCategories = value
    }

    @JvmName("kqilncjhonqyrxav")
    public suspend fun threatIntelIndicatorCategories(vararg values: Output<InsightFiltersThreatIntelIndicatorCategoryArgs>) {
        this.threatIntelIndicatorCategories = Output.all(values.asList())
    }

    /**
     * @param values The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("ogthcnsyfjnxtcfo")
    public suspend fun threatIntelIndicatorCategories(values: List<Output<InsightFiltersThreatIntelIndicatorCategoryArgs>>) {
        this.threatIntelIndicatorCategories = Output.all(values)
    }

    /**
     * @param value The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("ecodplysqyxgkhrc")
    public suspend fun threatIntelIndicatorLastObservedAts(`value`: Output<List<InsightFiltersThreatIntelIndicatorLastObservedAtArgs>>) {
        this.threatIntelIndicatorLastObservedAts = value
    }

    @JvmName("pfmucsdbolnhxenh")
    public suspend fun threatIntelIndicatorLastObservedAts(vararg values: Output<InsightFiltersThreatIntelIndicatorLastObservedAtArgs>) {
        this.threatIntelIndicatorLastObservedAts = Output.all(values.asList())
    }

    /**
     * @param values The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("kkacbxwprcjeiunx")
    public suspend fun threatIntelIndicatorLastObservedAts(values: List<Output<InsightFiltersThreatIntelIndicatorLastObservedAtArgs>>) {
        this.threatIntelIndicatorLastObservedAts = Output.all(values)
    }

    /**
     * @param value The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("raepkuikhneygmgj")
    public suspend fun threatIntelIndicatorSourceUrls(`value`: Output<List<InsightFiltersThreatIntelIndicatorSourceUrlArgs>>) {
        this.threatIntelIndicatorSourceUrls = value
    }

    @JvmName("jodctawygxwfluua")
    public suspend fun threatIntelIndicatorSourceUrls(vararg values: Output<InsightFiltersThreatIntelIndicatorSourceUrlArgs>) {
        this.threatIntelIndicatorSourceUrls = Output.all(values.asList())
    }

    /**
     * @param values The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("ijdbogipuftgewba")
    public suspend fun threatIntelIndicatorSourceUrls(values: List<Output<InsightFiltersThreatIntelIndicatorSourceUrlArgs>>) {
        this.threatIntelIndicatorSourceUrls = Output.all(values)
    }

    /**
     * @param value The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("efisqucjcaubusgt")
    public suspend fun threatIntelIndicatorSources(`value`: Output<List<InsightFiltersThreatIntelIndicatorSourceArgs>>) {
        this.threatIntelIndicatorSources = value
    }

    @JvmName("jjveuicflhhjtjpk")
    public suspend fun threatIntelIndicatorSources(vararg values: Output<InsightFiltersThreatIntelIndicatorSourceArgs>) {
        this.threatIntelIndicatorSources = Output.all(values.asList())
    }

    /**
     * @param values The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("lappvpanfrnskhai")
    public suspend fun threatIntelIndicatorSources(values: List<Output<InsightFiltersThreatIntelIndicatorSourceArgs>>) {
        this.threatIntelIndicatorSources = Output.all(values)
    }

    /**
     * @param value The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("niynpsfisoljntgk")
    public suspend fun threatIntelIndicatorTypes(`value`: Output<List<InsightFiltersThreatIntelIndicatorTypeArgs>>) {
        this.threatIntelIndicatorTypes = value
    }

    @JvmName("agxtlwwnidwohrmk")
    public suspend fun threatIntelIndicatorTypes(vararg values: Output<InsightFiltersThreatIntelIndicatorTypeArgs>) {
        this.threatIntelIndicatorTypes = Output.all(values.asList())
    }

    /**
     * @param values The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("qmyykxrrmueifvbr")
    public suspend fun threatIntelIndicatorTypes(values: List<Output<InsightFiltersThreatIntelIndicatorTypeArgs>>) {
        this.threatIntelIndicatorTypes = Output.all(values)
    }

    /**
     * @param value The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("tvthkrbtmypeirxw")
    public suspend fun threatIntelIndicatorValues(`value`: Output<List<InsightFiltersThreatIntelIndicatorValueArgs>>) {
        this.threatIntelIndicatorValues = value
    }

    @JvmName("ojymkpfnbukspeha")
    public suspend fun threatIntelIndicatorValues(vararg values: Output<InsightFiltersThreatIntelIndicatorValueArgs>) {
        this.threatIntelIndicatorValues = Output.all(values.asList())
    }

    /**
     * @param values The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("txrebnkajxjnqflr")
    public suspend fun threatIntelIndicatorValues(values: List<Output<InsightFiltersThreatIntelIndicatorValueArgs>>) {
        this.threatIntelIndicatorValues = Output.all(values)
    }

    /**
     * @param value A finding's title. See String Filter below for more details.
     */
    @JvmName("jfhkoidjfbpskxun")
    public suspend fun titles(`value`: Output<List<InsightFiltersTitleArgs>>) {
        this.titles = value
    }

    @JvmName("mnkefqhfimajivyk")
    public suspend fun titles(vararg values: Output<InsightFiltersTitleArgs>) {
        this.titles = Output.all(values.asList())
    }

    /**
     * @param values A finding's title. See String Filter below for more details.
     */
    @JvmName("bjlxthjkodapfcpf")
    public suspend fun titles(values: List<Output<InsightFiltersTitleArgs>>) {
        this.titles = Output.all(values)
    }

    /**
     * @param value A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("ccujcpainvejvdtf")
    public suspend fun types(`value`: Output<List<InsightFiltersTypeArgs>>) {
        this.types = value
    }

    @JvmName("kkjwankeljdcuflc")
    public suspend fun types(vararg values: Output<InsightFiltersTypeArgs>) {
        this.types = Output.all(values.asList())
    }

    /**
     * @param values A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("bhyssuuvyficexgi")
    public suspend fun types(values: List<Output<InsightFiltersTypeArgs>>) {
        this.types = Output.all(values)
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("oflqglwtwiuqlgxg")
    public suspend fun updatedAts(`value`: Output<List<InsightFiltersUpdatedAtArgs>>) {
        this.updatedAts = value
    }

    @JvmName("tlwdyjybjcpxwnqx")
    public suspend fun updatedAts(vararg values: Output<InsightFiltersUpdatedAtArgs>) {
        this.updatedAts = Output.all(values.asList())
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("glcifvvwbicwofcd")
    public suspend fun updatedAts(values: List<Output<InsightFiltersUpdatedAtArgs>>) {
        this.updatedAts = Output.all(values)
    }

    /**
     * @param value A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("gobqqqfjxuqyyiph")
    public suspend fun userDefinedValues(`value`: Output<List<InsightFiltersUserDefinedValueArgs>>) {
        this.userDefinedValues = value
    }

    @JvmName("rfpjmwgljytottrk")
    public suspend fun userDefinedValues(vararg values: Output<InsightFiltersUserDefinedValueArgs>) {
        this.userDefinedValues = Output.all(values.asList())
    }

    /**
     * @param values A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("qnitkpovokaqqrmq")
    public suspend fun userDefinedValues(values: List<Output<InsightFiltersUserDefinedValueArgs>>) {
        this.userDefinedValues = Output.all(values)
    }

    /**
     * @param value The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("hmvsxwwtqlcdltbh")
    public suspend fun verificationStates(`value`: Output<List<InsightFiltersVerificationStateArgs>>) {
        this.verificationStates = value
    }

    @JvmName("vrngxtsorhsbxhqn")
    public suspend fun verificationStates(vararg values: Output<InsightFiltersVerificationStateArgs>) {
        this.verificationStates = Output.all(values.asList())
    }

    /**
     * @param values The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("mhrqwdbayhcnxags")
    public suspend fun verificationStates(values: List<Output<InsightFiltersVerificationStateArgs>>) {
        this.verificationStates = Output.all(values)
    }

    /**
     * @param value The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("nsxxxhhitqeedywk")
    public suspend fun workflowStatuses(`value`: Output<List<InsightFiltersWorkflowStatusArgs>>) {
        this.workflowStatuses = value
    }

    @JvmName("fxtlfaqktvblapfc")
    public suspend fun workflowStatuses(vararg values: Output<InsightFiltersWorkflowStatusArgs>) {
        this.workflowStatuses = Output.all(values.asList())
    }

    /**
     * @param values The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("ataywlkpfdpxamdy")
    public suspend fun workflowStatuses(values: List<Output<InsightFiltersWorkflowStatusArgs>>) {
        this.workflowStatuses = Output.all(values)
    }

    /**
     * @param value AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("oothalsghhwlwbfb")
    public suspend fun awsAccountIds(`value`: List<InsightFiltersAwsAccountIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountIds = mapped
    }

    /**
     * @param argument AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("ivcveeyorsawnwus")
    public suspend fun awsAccountIds(argument: List<suspend InsightFiltersAwsAccountIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersAwsAccountIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccountIds = mapped
    }

    /**
     * @param argument AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("aogykemvyjypqlae")
    public suspend fun awsAccountIds(vararg argument: suspend InsightFiltersAwsAccountIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersAwsAccountIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccountIds = mapped
    }

    /**
     * @param argument AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("nmmauljkatcutnbu")
    public suspend fun awsAccountIds(argument: suspend InsightFiltersAwsAccountIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersAwsAccountIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.awsAccountIds = mapped
    }

    /**
     * @param values AWS account ID that a finding is generated in. See String_Filter below for more details.
     */
    @JvmName("jxbvtunoccojpfnu")
    public suspend fun awsAccountIds(vararg values: InsightFiltersAwsAccountIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsAccountIds = mapped
    }

    /**
     * @param value The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("dmkaifssbihvydjg")
    public suspend fun companyNames(`value`: List<InsightFiltersCompanyNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyNames = mapped
    }

    /**
     * @param argument The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("isifxyvchhkdyvbg")
    public suspend fun companyNames(argument: List<suspend InsightFiltersCompanyNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersCompanyNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.companyNames = mapped
    }

    /**
     * @param argument The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("csjvrwtjhstswqke")
    public suspend fun companyNames(vararg argument: suspend InsightFiltersCompanyNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersCompanyNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.companyNames = mapped
    }

    /**
     * @param argument The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("rtytlvcjddvmwkno")
    public suspend fun companyNames(argument: suspend InsightFiltersCompanyNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersCompanyNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.companyNames = mapped
    }

    /**
     * @param values The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
     */
    @JvmName("mkjmxbmxutxvfooa")
    public suspend fun companyNames(vararg values: InsightFiltersCompanyNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.companyNames = mapped
    }

    /**
     * @param value Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("ajyycqoygxpdpiis")
    public suspend fun complianceStatuses(`value`: List<InsightFiltersComplianceStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceStatuses = mapped
    }

    /**
     * @param argument Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("uvqscnuppwtlofri")
    public suspend fun complianceStatuses(argument: List<suspend InsightFiltersComplianceStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersComplianceStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceStatuses = mapped
    }

    /**
     * @param argument Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("qphvhvgohilaxnhc")
    public suspend fun complianceStatuses(vararg argument: suspend InsightFiltersComplianceStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersComplianceStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.complianceStatuses = mapped
    }

    /**
     * @param argument Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("yejddawvvuvbpyoe")
    public suspend fun complianceStatuses(argument: suspend InsightFiltersComplianceStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersComplianceStatusArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.complianceStatuses = mapped
    }

    /**
     * @param values Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
     */
    @JvmName("exeeglvwympsxjko")
    public suspend fun complianceStatuses(vararg values: InsightFiltersComplianceStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complianceStatuses = mapped
    }

    /**
     * @param value A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("oaqfnnxmetueleik")
    public suspend fun confidences(`value`: List<InsightFiltersConfidenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidences = mapped
    }

    /**
     * @param argument A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("bjyuepilfcmagdbv")
    public suspend fun confidences(argument: List<suspend InsightFiltersConfidenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersConfidenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.confidences = mapped
    }

    /**
     * @param argument A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("adldnetximiuvmdx")
    public suspend fun confidences(vararg argument: suspend InsightFiltersConfidenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersConfidenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.confidences = mapped
    }

    /**
     * @param argument A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("ejryhuvlsktkuhik")
    public suspend fun confidences(argument: suspend InsightFiltersConfidenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersConfidenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.confidences = mapped
    }

    /**
     * @param values A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("voghkoucyhcfamup")
    public suspend fun confidences(vararg values: InsightFiltersConfidenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.confidences = mapped
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("eeimgbrfbdphrmtw")
    public suspend fun createdAts(`value`: List<InsightFiltersCreatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("pepsqejxrufhvvfh")
    public suspend fun createdAts(argument: List<suspend InsightFiltersCreatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersCreatedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.createdAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("jkpynmggruyduhwu")
    public suspend fun createdAts(vararg argument: suspend InsightFiltersCreatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersCreatedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.createdAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("htbehmnyenexqfii")
    public suspend fun createdAts(argument: suspend InsightFiltersCreatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersCreatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.createdAts = mapped
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("iradxwdtptffnyno")
    public suspend fun createdAts(vararg values: InsightFiltersCreatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createdAts = mapped
    }

    /**
     * @param value The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("dagpmhfjkyixhrho")
    public suspend fun criticalities(`value`: List<InsightFiltersCriticalityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criticalities = mapped
    }

    /**
     * @param argument The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("jusvyniogemuirhb")
    public suspend fun criticalities(argument: List<suspend InsightFiltersCriticalityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersCriticalityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criticalities = mapped
    }

    /**
     * @param argument The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("hgfttimfvbvxefya")
    public suspend fun criticalities(vararg argument: suspend InsightFiltersCriticalityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersCriticalityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.criticalities = mapped
    }

    /**
     * @param argument The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("dwnggkifaklegrhm")
    public suspend fun criticalities(argument: suspend InsightFiltersCriticalityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersCriticalityArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.criticalities = mapped
    }

    /**
     * @param values The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("irylibhrhepqxjpf")
    public suspend fun criticalities(vararg values: InsightFiltersCriticalityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criticalities = mapped
    }

    /**
     * @param value A finding's description. See String Filter below for more details.
     */
    @JvmName("lnxvpdulwdxgfhwj")
    public suspend fun descriptions(`value`: List<InsightFiltersDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descriptions = mapped
    }

    /**
     * @param argument A finding's description. See String Filter below for more details.
     */
    @JvmName("kpogyfuwdmgxpxuu")
    public suspend fun descriptions(argument: List<suspend InsightFiltersDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.descriptions = mapped
    }

    /**
     * @param argument A finding's description. See String Filter below for more details.
     */
    @JvmName("ahvuebnbiunotjhl")
    public suspend fun descriptions(vararg argument: suspend InsightFiltersDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersDescriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.descriptions = mapped
    }

    /**
     * @param argument A finding's description. See String Filter below for more details.
     */
    @JvmName("fflrqawfvgjlxtma")
    public suspend fun descriptions(argument: suspend InsightFiltersDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.descriptions = mapped
    }

    /**
     * @param values A finding's description. See String Filter below for more details.
     */
    @JvmName("erodnayytyemjhhy")
    public suspend fun descriptions(vararg values: InsightFiltersDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descriptions = mapped
    }

    /**
     * @param value The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("smipvvtosrsxuobd")
    public suspend fun findingProviderFieldsConfidences(`value`: List<InsightFiltersFindingProviderFieldsConfidenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsConfidences = mapped
    }

    /**
     * @param argument The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("cdvxljqtggcxptpu")
    public suspend fun findingProviderFieldsConfidences(argument: List<suspend InsightFiltersFindingProviderFieldsConfidenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsConfidenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsConfidences = mapped
    }

    /**
     * @param argument The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("ablectyksittpeab")
    public suspend fun findingProviderFieldsConfidences(vararg argument: suspend InsightFiltersFindingProviderFieldsConfidenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsConfidenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsConfidences = mapped
    }

    /**
     * @param argument The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("nlsblcguwrrfyceb")
    public suspend fun findingProviderFieldsConfidences(argument: suspend InsightFiltersFindingProviderFieldsConfidenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersFindingProviderFieldsConfidenceArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsConfidences = mapped
    }

    /**
     * @param values The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
     */
    @JvmName("hddtflialmgmsnvp")
    public suspend fun findingProviderFieldsConfidences(vararg values: InsightFiltersFindingProviderFieldsConfidenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsConfidences = mapped
    }

    /**
     * @param value The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("ulgjbssfaotdsqli")
    public suspend fun findingProviderFieldsCriticalities(`value`: List<InsightFiltersFindingProviderFieldsCriticalityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsCriticalities = mapped
    }

    /**
     * @param argument The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("rgcpyhurtoomeyas")
    public suspend fun findingProviderFieldsCriticalities(argument: List<suspend InsightFiltersFindingProviderFieldsCriticalityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsCriticalityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsCriticalities = mapped
    }

    /**
     * @param argument The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("glrnsmytknqagptx")
    public suspend fun findingProviderFieldsCriticalities(vararg argument: suspend InsightFiltersFindingProviderFieldsCriticalityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsCriticalityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsCriticalities = mapped
    }

    /**
     * @param argument The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("faqdprcugbgfoqvr")
    public suspend fun findingProviderFieldsCriticalities(argument: suspend InsightFiltersFindingProviderFieldsCriticalityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersFindingProviderFieldsCriticalityArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsCriticalities = mapped
    }

    /**
     * @param values The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
     */
    @JvmName("wuhuaaftntpflhwj")
    public suspend fun findingProviderFieldsCriticalities(vararg values: InsightFiltersFindingProviderFieldsCriticalityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsCriticalities = mapped
    }

    /**
     * @param value The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("qwrttfxwgmxlvgex")
    public suspend fun findingProviderFieldsRelatedFindingsIds(`value`: List<InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsRelatedFindingsIds = mapped
    }

    /**
     * @param argument The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("eggsnwrjlpnnemkt")
    public suspend fun findingProviderFieldsRelatedFindingsIds(argument: List<suspend InsightFiltersFindingProviderFieldsRelatedFindingsIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsRelatedFindingsIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsRelatedFindingsIds = mapped
    }

    /**
     * @param argument The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("jvosegqjebavclqc")
    public suspend fun findingProviderFieldsRelatedFindingsIds(vararg argument: suspend InsightFiltersFindingProviderFieldsRelatedFindingsIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsRelatedFindingsIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsRelatedFindingsIds = mapped
    }

    /**
     * @param argument The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("rkaofcbemjsvomxv")
    public suspend fun findingProviderFieldsRelatedFindingsIds(argument: suspend InsightFiltersFindingProviderFieldsRelatedFindingsIdArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersFindingProviderFieldsRelatedFindingsIdArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsRelatedFindingsIds = mapped
    }

    /**
     * @param values The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("oglyhmhkcoegrmee")
    public suspend fun findingProviderFieldsRelatedFindingsIds(vararg values: InsightFiltersFindingProviderFieldsRelatedFindingsIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsRelatedFindingsIds = mapped
    }

    /**
     * @param value The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("kqbpftolwuhkljmy")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(`value`: List<InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsRelatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("wmyvfeebqhknpbvu")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(argument: List<suspend InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsRelatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("qmfmgxnajuutiwso")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(vararg argument: suspend InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsRelatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("aofaibsmdqvonhys")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(argument: suspend InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsRelatedFindingsProductArns = mapped
    }

    /**
     * @param values The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
     */
    @JvmName("bdxcgcvldgnxvwmh")
    public suspend fun findingProviderFieldsRelatedFindingsProductArns(vararg values: InsightFiltersFindingProviderFieldsRelatedFindingsProductArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsRelatedFindingsProductArns = mapped
    }

    /**
     * @param value The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("kvpvcpixrlwttogq")
    public suspend fun findingProviderFieldsSeverityLabels(`value`: List<InsightFiltersFindingProviderFieldsSeverityLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsSeverityLabels = mapped
    }

    /**
     * @param argument The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("pdyxmsmyrdvhfocr")
    public suspend fun findingProviderFieldsSeverityLabels(argument: List<suspend InsightFiltersFindingProviderFieldsSeverityLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsSeverityLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsSeverityLabels = mapped
    }

    /**
     * @param argument The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("hayggjhuhcibqekk")
    public suspend fun findingProviderFieldsSeverityLabels(vararg argument: suspend InsightFiltersFindingProviderFieldsSeverityLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsSeverityLabelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsSeverityLabels = mapped
    }

    /**
     * @param argument The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("qwohfnqjwyceshws")
    public suspend fun findingProviderFieldsSeverityLabels(argument: suspend InsightFiltersFindingProviderFieldsSeverityLabelArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersFindingProviderFieldsSeverityLabelArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsSeverityLabels = mapped
    }

    /**
     * @param values The finding provider value for the severity label. See String Filter below for more details.
     */
    @JvmName("dfhdwtnpqdovspux")
    public suspend fun findingProviderFieldsSeverityLabels(vararg values: InsightFiltersFindingProviderFieldsSeverityLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsSeverityLabels = mapped
    }

    /**
     * @param value The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("qqijxuhwughnbkhu")
    public suspend fun findingProviderFieldsSeverityOriginals(`value`: List<InsightFiltersFindingProviderFieldsSeverityOriginalArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsSeverityOriginals = mapped
    }

    /**
     * @param argument The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("bknvhomuwsafycoh")
    public suspend fun findingProviderFieldsSeverityOriginals(argument: List<suspend InsightFiltersFindingProviderFieldsSeverityOriginalArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsSeverityOriginalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsSeverityOriginals = mapped
    }

    /**
     * @param argument The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("tbtluynqjpkqwjyq")
    public suspend fun findingProviderFieldsSeverityOriginals(vararg argument: suspend InsightFiltersFindingProviderFieldsSeverityOriginalArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsSeverityOriginalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsSeverityOriginals = mapped
    }

    /**
     * @param argument The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("dbxespvnfnwqcbgj")
    public suspend fun findingProviderFieldsSeverityOriginals(argument: suspend InsightFiltersFindingProviderFieldsSeverityOriginalArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersFindingProviderFieldsSeverityOriginalArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsSeverityOriginals = mapped
    }

    /**
     * @param values The finding provider's original value for the severity. See String Filter below for more details.
     */
    @JvmName("vqakiuvipkwybktr")
    public suspend fun findingProviderFieldsSeverityOriginals(vararg values: InsightFiltersFindingProviderFieldsSeverityOriginalArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsSeverityOriginals = mapped
    }

    /**
     * @param value One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("clslpcycsysnxdep")
    public suspend fun findingProviderFieldsTypes(`value`: List<InsightFiltersFindingProviderFieldsTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingProviderFieldsTypes = mapped
    }

    /**
     * @param argument One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("xlnuvfllhsjtfafy")
    public suspend fun findingProviderFieldsTypes(argument: List<suspend InsightFiltersFindingProviderFieldsTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsTypes = mapped
    }

    /**
     * @param argument One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("thhvxxvvmlwnyfeb")
    public suspend fun findingProviderFieldsTypes(vararg argument: suspend InsightFiltersFindingProviderFieldsTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFindingProviderFieldsTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.findingProviderFieldsTypes = mapped
    }

    /**
     * @param argument One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("uytlmkwuhibmikbg")
    public suspend fun findingProviderFieldsTypes(argument: suspend InsightFiltersFindingProviderFieldsTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersFindingProviderFieldsTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.findingProviderFieldsTypes = mapped
    }

    /**
     * @param values One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
     */
    @JvmName("owmkrctthfhpfuot")
    public suspend fun findingProviderFieldsTypes(vararg values: InsightFiltersFindingProviderFieldsTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.findingProviderFieldsTypes = mapped
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("uyogygfjdsckujmt")
    public suspend fun firstObservedAts(`value`: List<InsightFiltersFirstObservedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstObservedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("qurnauftbqhldevx")
    public suspend fun firstObservedAts(argument: List<suspend InsightFiltersFirstObservedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFirstObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firstObservedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("nipxhomthbjtelss")
    public suspend fun firstObservedAts(vararg argument: suspend InsightFiltersFirstObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersFirstObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firstObservedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("qrhgfuftlqkgprqk")
    public suspend fun firstObservedAts(argument: suspend InsightFiltersFirstObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersFirstObservedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.firstObservedAts = mapped
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("okmioisorqfdbgba")
    public suspend fun firstObservedAts(vararg values: InsightFiltersFirstObservedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firstObservedAts = mapped
    }

    /**
     * @param value The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("oulofyxoobcibnmg")
    public suspend fun generatorIds(`value`: List<InsightFiltersGeneratorIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generatorIds = mapped
    }

    /**
     * @param argument The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("fredvbppqhvvghwj")
    public suspend fun generatorIds(argument: List<suspend InsightFiltersGeneratorIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersGeneratorIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.generatorIds = mapped
    }

    /**
     * @param argument The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("lyhidcpraudwpeul")
    public suspend fun generatorIds(vararg argument: suspend InsightFiltersGeneratorIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersGeneratorIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.generatorIds = mapped
    }

    /**
     * @param argument The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("wymfackoorijijtm")
    public suspend fun generatorIds(argument: suspend InsightFiltersGeneratorIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersGeneratorIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.generatorIds = mapped
    }

    /**
     * @param values The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
     */
    @JvmName("mfsdfywpcpjvykdp")
    public suspend fun generatorIds(vararg values: InsightFiltersGeneratorIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.generatorIds = mapped
    }

    /**
     * @param value The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("djxevyldpdrouksj")
    public suspend fun ids(`value`: List<InsightFiltersIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ids = mapped
    }

    /**
     * @param argument The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("exlotetikfutqyds")
    public suspend fun ids(argument: List<suspend InsightFiltersIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param argument The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("vcohiqyhsdpjggje")
    public suspend fun ids(vararg argument: suspend InsightFiltersIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param argument The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("bmlaxmuuyuglbryq")
    public suspend fun ids(argument: suspend InsightFiltersIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InsightFiltersIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ids = mapped
    }

    /**
     * @param values The security findings provider-specific identifier for a finding. See String Filter below for more details.
     */
    @JvmName("fwejmeageesmeeco")
    public suspend fun ids(vararg values: InsightFiltersIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ids = mapped
    }

    /**
     * @param value A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("rclldygurruhkval")
    public suspend fun keywords(`value`: List<InsightFiltersKeywordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param argument A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("bbatssffeycctmub")
    public suspend fun keywords(argument: List<suspend InsightFiltersKeywordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersKeywordArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keywords = mapped
    }

    /**
     * @param argument A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("dswemlowhndhaecm")
    public suspend fun keywords(vararg argument: suspend InsightFiltersKeywordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersKeywordArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keywords = mapped
    }

    /**
     * @param argument A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("cjembibuilfipopw")
    public suspend fun keywords(argument: suspend InsightFiltersKeywordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InsightFiltersKeywordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.keywords = mapped
    }

    /**
     * @param values A keyword for a finding. See Keyword Filter below for more details.
     */
    @JvmName("txwovcgcdlpnjxtb")
    public suspend fun keywords(vararg values: InsightFiltersKeywordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("tetrjojjwviubnat")
    public suspend fun lastObservedAts(`value`: List<InsightFiltersLastObservedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastObservedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("ceskpxpkhflknwbl")
    public suspend fun lastObservedAts(argument: List<suspend InsightFiltersLastObservedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersLastObservedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lastObservedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("qibijvsrnovbbnqe")
    public suspend fun lastObservedAts(vararg argument: suspend InsightFiltersLastObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersLastObservedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lastObservedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("fbjyrnnsokauwsdh")
    public suspend fun lastObservedAts(argument: suspend InsightFiltersLastObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersLastObservedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lastObservedAts = mapped
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
     */
    @JvmName("hkvddmtgbbdlnunl")
    public suspend fun lastObservedAts(vararg values: InsightFiltersLastObservedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lastObservedAts = mapped
    }

    /**
     * @param value The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("oetrvlhadsrutdpl")
    public suspend fun malwareNames(`value`: List<InsightFiltersMalwareNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwareNames = mapped
    }

    /**
     * @param argument The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("qmjgondqmjepvfll")
    public suspend fun malwareNames(argument: List<suspend InsightFiltersMalwareNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwareNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwareNames = mapped
    }

    /**
     * @param argument The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("ikvlkhomfvdtpopt")
    public suspend fun malwareNames(vararg argument: suspend InsightFiltersMalwareNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwareNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwareNames = mapped
    }

    /**
     * @param argument The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("cfgcvfbipvriocuy")
    public suspend fun malwareNames(argument: suspend InsightFiltersMalwareNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersMalwareNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.malwareNames = mapped
    }

    /**
     * @param values The name of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("evnhkagndxlhuwrj")
    public suspend fun malwareNames(vararg values: InsightFiltersMalwareNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.malwareNames = mapped
    }

    /**
     * @param value The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("qkvvypjnlldxexxp")
    public suspend fun malwarePaths(`value`: List<InsightFiltersMalwarePathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwarePaths = mapped
    }

    /**
     * @param argument The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("vsnbswufptyodrjy")
    public suspend fun malwarePaths(argument: List<suspend InsightFiltersMalwarePathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwarePathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwarePaths = mapped
    }

    /**
     * @param argument The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("ddwkwpogvucgdyxr")
    public suspend fun malwarePaths(vararg argument: suspend InsightFiltersMalwarePathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwarePathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwarePaths = mapped
    }

    /**
     * @param argument The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("wdxbtpsyolabmjab")
    public suspend fun malwarePaths(argument: suspend InsightFiltersMalwarePathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersMalwarePathArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.malwarePaths = mapped
    }

    /**
     * @param values The filesystem path of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("yplraegjqfufmfpa")
    public suspend fun malwarePaths(vararg values: InsightFiltersMalwarePathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.malwarePaths = mapped
    }

    /**
     * @param value The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("olmkbbsytyokfdch")
    public suspend fun malwareStates(`value`: List<InsightFiltersMalwareStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwareStates = mapped
    }

    /**
     * @param argument The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("kxmymvghgcqushjs")
    public suspend fun malwareStates(argument: List<suspend InsightFiltersMalwareStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwareStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwareStates = mapped
    }

    /**
     * @param argument The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("jhnnqjrefqxxmmyv")
    public suspend fun malwareStates(vararg argument: suspend InsightFiltersMalwareStateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwareStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwareStates = mapped
    }

    /**
     * @param argument The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("llxwxsialomyvybe")
    public suspend fun malwareStates(argument: suspend InsightFiltersMalwareStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersMalwareStateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.malwareStates = mapped
    }

    /**
     * @param values The state of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("vdiycuhqcnafxnat")
    public suspend fun malwareStates(vararg values: InsightFiltersMalwareStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.malwareStates = mapped
    }

    /**
     * @param value The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("fxwettjxhfhbyyeu")
    public suspend fun malwareTypes(`value`: List<InsightFiltersMalwareTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwareTypes = mapped
    }

    /**
     * @param argument The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("ocgldjpkycglanyc")
    public suspend fun malwareTypes(argument: List<suspend InsightFiltersMalwareTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwareTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwareTypes = mapped
    }

    /**
     * @param argument The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("bfthrxtehrluqnff")
    public suspend fun malwareTypes(vararg argument: suspend InsightFiltersMalwareTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersMalwareTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.malwareTypes = mapped
    }

    /**
     * @param argument The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("btgtcnrxvnkmekjm")
    public suspend fun malwareTypes(argument: suspend InsightFiltersMalwareTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersMalwareTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.malwareTypes = mapped
    }

    /**
     * @param values The type of the malware that was observed. See String Filter below for more details.
     */
    @JvmName("ekuojtrlystcfvrf")
    public suspend fun malwareTypes(vararg values: InsightFiltersMalwareTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.malwareTypes = mapped
    }

    /**
     * @param value The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("xdtnmfnxterulrcf")
    public suspend fun networkDestinationDomains(`value`: List<InsightFiltersNetworkDestinationDomainArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDestinationDomains = mapped
    }

    /**
     * @param argument The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("qvenclpijouorhmk")
    public suspend fun networkDestinationDomains(argument: List<suspend InsightFiltersNetworkDestinationDomainArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationDomainArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationDomains = mapped
    }

    /**
     * @param argument The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("xnxbibarudjtbqlf")
    public suspend fun networkDestinationDomains(vararg argument: suspend InsightFiltersNetworkDestinationDomainArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationDomainArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationDomains = mapped
    }

    /**
     * @param argument The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("fpktngnnndrnskoa")
    public suspend fun networkDestinationDomains(argument: suspend InsightFiltersNetworkDestinationDomainArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkDestinationDomainArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkDestinationDomains = mapped
    }

    /**
     * @param values The destination domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("elxycslxofpklpom")
    public suspend fun networkDestinationDomains(vararg values: InsightFiltersNetworkDestinationDomainArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDestinationDomains = mapped
    }

    /**
     * @param value The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("cvgbyhkjkoognpbj")
    public suspend fun networkDestinationIpv4s(`value`: List<InsightFiltersNetworkDestinationIpv4Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDestinationIpv4s = mapped
    }

    /**
     * @param argument The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("bngiwyshpepbxgrn")
    public suspend fun networkDestinationIpv4s(argument: List<suspend InsightFiltersNetworkDestinationIpv4ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationIpv4ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationIpv4s = mapped
    }

    /**
     * @param argument The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("xafqmgxekmnqmavi")
    public suspend fun networkDestinationIpv4s(vararg argument: suspend InsightFiltersNetworkDestinationIpv4ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationIpv4ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationIpv4s = mapped
    }

    /**
     * @param argument The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("ijcfonodsvicsgno")
    public suspend fun networkDestinationIpv4s(argument: suspend InsightFiltersNetworkDestinationIpv4ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkDestinationIpv4ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkDestinationIpv4s = mapped
    }

    /**
     * @param values The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("wigaajkefftramln")
    public suspend fun networkDestinationIpv4s(vararg values: InsightFiltersNetworkDestinationIpv4Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDestinationIpv4s = mapped
    }

    /**
     * @param value The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("dlfaivwbxagyided")
    public suspend fun networkDestinationIpv6s(`value`: List<InsightFiltersNetworkDestinationIpv6Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDestinationIpv6s = mapped
    }

    /**
     * @param argument The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("tibouybsvipxssbu")
    public suspend fun networkDestinationIpv6s(argument: List<suspend InsightFiltersNetworkDestinationIpv6ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationIpv6ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationIpv6s = mapped
    }

    /**
     * @param argument The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("srrbowagpcdcwrip")
    public suspend fun networkDestinationIpv6s(vararg argument: suspend InsightFiltersNetworkDestinationIpv6ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationIpv6ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationIpv6s = mapped
    }

    /**
     * @param argument The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("klcrvbqygftosrxv")
    public suspend fun networkDestinationIpv6s(argument: suspend InsightFiltersNetworkDestinationIpv6ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkDestinationIpv6ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkDestinationIpv6s = mapped
    }

    /**
     * @param values The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("ramorgpdgoxagskc")
    public suspend fun networkDestinationIpv6s(vararg values: InsightFiltersNetworkDestinationIpv6Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDestinationIpv6s = mapped
    }

    /**
     * @param value The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("cjrqrjnslqbhgfum")
    public suspend fun networkDestinationPorts(`value`: List<InsightFiltersNetworkDestinationPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDestinationPorts = mapped
    }

    /**
     * @param argument The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("lafjtjdmjknjwduq")
    public suspend fun networkDestinationPorts(argument: List<suspend InsightFiltersNetworkDestinationPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationPorts = mapped
    }

    /**
     * @param argument The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("eoodqajrblymuiug")
    public suspend fun networkDestinationPorts(vararg argument: suspend InsightFiltersNetworkDestinationPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDestinationPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDestinationPorts = mapped
    }

    /**
     * @param argument The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("nmhhfyikixtfilph")
    public suspend fun networkDestinationPorts(argument: suspend InsightFiltersNetworkDestinationPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkDestinationPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkDestinationPorts = mapped
    }

    /**
     * @param values The destination port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("pfnoeehjfaeidkcr")
    public suspend fun networkDestinationPorts(vararg values: InsightFiltersNetworkDestinationPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDestinationPorts = mapped
    }

    /**
     * @param value Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("ishnnrrlbsvybnbq")
    public suspend fun networkDirections(`value`: List<InsightFiltersNetworkDirectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDirections = mapped
    }

    /**
     * @param argument Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("btpvphnoqldhbkys")
    public suspend fun networkDirections(argument: List<suspend InsightFiltersNetworkDirectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDirectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDirections = mapped
    }

    /**
     * @param argument Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("hxlidaffpuvudvse")
    public suspend fun networkDirections(vararg argument: suspend InsightFiltersNetworkDirectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkDirectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkDirections = mapped
    }

    /**
     * @param argument Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("movxeccorerhllql")
    public suspend fun networkDirections(argument: suspend InsightFiltersNetworkDirectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkDirectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkDirections = mapped
    }

    /**
     * @param values Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
     */
    @JvmName("tccgrhvqujfeaflp")
    public suspend fun networkDirections(vararg values: InsightFiltersNetworkDirectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDirections = mapped
    }

    /**
     * @param value The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("atfwmcswvymejugt")
    public suspend fun networkProtocols(`value`: List<InsightFiltersNetworkProtocolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProtocols = mapped
    }

    /**
     * @param argument The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("sqgurtgvgtpwijjq")
    public suspend fun networkProtocols(argument: List<suspend InsightFiltersNetworkProtocolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkProtocols = mapped
    }

    /**
     * @param argument The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("fldwpmahmxvsywtf")
    public suspend fun networkProtocols(vararg argument: suspend InsightFiltersNetworkProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkProtocols = mapped
    }

    /**
     * @param argument The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("ynbvcbokgventbnv")
    public suspend fun networkProtocols(argument: suspend InsightFiltersNetworkProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkProtocolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkProtocols = mapped
    }

    /**
     * @param values The protocol of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("bcdxvxjukmmsquvr")
    public suspend fun networkProtocols(vararg values: InsightFiltersNetworkProtocolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkProtocols = mapped
    }

    /**
     * @param value The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("fokukwtpnrjaqnoi")
    public suspend fun networkSourceDomains(`value`: List<InsightFiltersNetworkSourceDomainArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSourceDomains = mapped
    }

    /**
     * @param argument The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("meigpjkfoguoxemb")
    public suspend fun networkSourceDomains(argument: List<suspend InsightFiltersNetworkSourceDomainArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceDomainArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceDomains = mapped
    }

    /**
     * @param argument The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("kbrsywvdyagpmvwf")
    public suspend fun networkSourceDomains(vararg argument: suspend InsightFiltersNetworkSourceDomainArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceDomainArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceDomains = mapped
    }

    /**
     * @param argument The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("cwbuwygxnemcvdtq")
    public suspend fun networkSourceDomains(argument: suspend InsightFiltersNetworkSourceDomainArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkSourceDomainArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkSourceDomains = mapped
    }

    /**
     * @param values The source domain of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("glqlchetcpmeslsr")
    public suspend fun networkSourceDomains(vararg values: InsightFiltersNetworkSourceDomainArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSourceDomains = mapped
    }

    /**
     * @param value The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("uhvartmrfqhftpab")
    public suspend fun networkSourceIpv4s(`value`: List<InsightFiltersNetworkSourceIpv4Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSourceIpv4s = mapped
    }

    /**
     * @param argument The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("gouvnuwknwnspein")
    public suspend fun networkSourceIpv4s(argument: List<suspend InsightFiltersNetworkSourceIpv4ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceIpv4ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceIpv4s = mapped
    }

    /**
     * @param argument The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("gkfnccflevdsccok")
    public suspend fun networkSourceIpv4s(vararg argument: suspend InsightFiltersNetworkSourceIpv4ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceIpv4ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceIpv4s = mapped
    }

    /**
     * @param argument The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("csybjvfaqfmjnpkc")
    public suspend fun networkSourceIpv4s(argument: suspend InsightFiltersNetworkSourceIpv4ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkSourceIpv4ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkSourceIpv4s = mapped
    }

    /**
     * @param values The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("snetnegyntfdejfn")
    public suspend fun networkSourceIpv4s(vararg values: InsightFiltersNetworkSourceIpv4Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSourceIpv4s = mapped
    }

    /**
     * @param value The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("ipiinkgdpxhokemu")
    public suspend fun networkSourceIpv6s(`value`: List<InsightFiltersNetworkSourceIpv6Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSourceIpv6s = mapped
    }

    /**
     * @param argument The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("dhdxrkooytdcsgfu")
    public suspend fun networkSourceIpv6s(argument: List<suspend InsightFiltersNetworkSourceIpv6ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceIpv6ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceIpv6s = mapped
    }

    /**
     * @param argument The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("xtxocyihpegmxhtb")
    public suspend fun networkSourceIpv6s(vararg argument: suspend InsightFiltersNetworkSourceIpv6ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceIpv6ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceIpv6s = mapped
    }

    /**
     * @param argument The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("jmlpqqoeciodwbiu")
    public suspend fun networkSourceIpv6s(argument: suspend InsightFiltersNetworkSourceIpv6ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkSourceIpv6ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkSourceIpv6s = mapped
    }

    /**
     * @param values The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
     */
    @JvmName("adkcuajxngfybhko")
    public suspend fun networkSourceIpv6s(vararg values: InsightFiltersNetworkSourceIpv6Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSourceIpv6s = mapped
    }

    /**
     * @param value The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("avlouclduheebnsk")
    public suspend fun networkSourceMacs(`value`: List<InsightFiltersNetworkSourceMacArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSourceMacs = mapped
    }

    /**
     * @param argument The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("asnrsggcpefbjqrp")
    public suspend fun networkSourceMacs(argument: List<suspend InsightFiltersNetworkSourceMacArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceMacArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceMacs = mapped
    }

    /**
     * @param argument The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("gwpkuiuekcqihhop")
    public suspend fun networkSourceMacs(vararg argument: suspend InsightFiltersNetworkSourceMacArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourceMacArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourceMacs = mapped
    }

    /**
     * @param argument The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("tiwihyldaifnqypy")
    public suspend fun networkSourceMacs(argument: suspend InsightFiltersNetworkSourceMacArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkSourceMacArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkSourceMacs = mapped
    }

    /**
     * @param values The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
     */
    @JvmName("krdtgtmfqnebttwj")
    public suspend fun networkSourceMacs(vararg values: InsightFiltersNetworkSourceMacArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSourceMacs = mapped
    }

    /**
     * @param value The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("kailajglelugrgcd")
    public suspend fun networkSourcePorts(`value`: List<InsightFiltersNetworkSourcePortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSourcePorts = mapped
    }

    /**
     * @param argument The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("luwgwwgxwhklomjf")
    public suspend fun networkSourcePorts(argument: List<suspend InsightFiltersNetworkSourcePortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourcePortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourcePorts = mapped
    }

    /**
     * @param argument The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("drgvfsggopxcngok")
    public suspend fun networkSourcePorts(vararg argument: suspend InsightFiltersNetworkSourcePortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNetworkSourcePortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSourcePorts = mapped
    }

    /**
     * @param argument The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("igdgaeivtwalfkww")
    public suspend fun networkSourcePorts(argument: suspend InsightFiltersNetworkSourcePortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNetworkSourcePortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkSourcePorts = mapped
    }

    /**
     * @param values The source port of network-related information about a finding. See Number Filter below for more details.
     */
    @JvmName("wphnxgpjjgdmdlmo")
    public suspend fun networkSourcePorts(vararg values: InsightFiltersNetworkSourcePortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSourcePorts = mapped
    }

    /**
     * @param value The text of a note. See String Filter below for more details.
     */
    @JvmName("jxdhxyukqpxeivro")
    public suspend fun noteTexts(`value`: List<InsightFiltersNoteTextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteTexts = mapped
    }

    /**
     * @param argument The text of a note. See String Filter below for more details.
     */
    @JvmName("seecndrcaawvdclj")
    public suspend fun noteTexts(argument: List<suspend InsightFiltersNoteTextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNoteTextArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noteTexts = mapped
    }

    /**
     * @param argument The text of a note. See String Filter below for more details.
     */
    @JvmName("hvhlqlxarfdjifjn")
    public suspend fun noteTexts(vararg argument: suspend InsightFiltersNoteTextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNoteTextArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noteTexts = mapped
    }

    /**
     * @param argument The text of a note. See String Filter below for more details.
     */
    @JvmName("fkajoxfhrocmmtnw")
    public suspend fun noteTexts(argument: suspend InsightFiltersNoteTextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InsightFiltersNoteTextArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.noteTexts = mapped
    }

    /**
     * @param values The text of a note. See String Filter below for more details.
     */
    @JvmName("tvgikcfyvwumdgdj")
    public suspend fun noteTexts(vararg values: InsightFiltersNoteTextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noteTexts = mapped
    }

    /**
     * @param value The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("gclmvbpyroukxpqe")
    public suspend fun noteUpdatedAts(`value`: List<InsightFiltersNoteUpdatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteUpdatedAts = mapped
    }

    /**
     * @param argument The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("hryyyaaaaogsaomx")
    public suspend fun noteUpdatedAts(argument: List<suspend InsightFiltersNoteUpdatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNoteUpdatedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedAts = mapped
    }

    /**
     * @param argument The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("xomylktcqghthcch")
    public suspend fun noteUpdatedAts(vararg argument: suspend InsightFiltersNoteUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNoteUpdatedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedAts = mapped
    }

    /**
     * @param argument The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("ogqrhwybrwbjybwt")
    public suspend fun noteUpdatedAts(argument: suspend InsightFiltersNoteUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNoteUpdatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.noteUpdatedAts = mapped
    }

    /**
     * @param values The timestamp of when the note was updated. See Date Filter below for more details.
     */
    @JvmName("duykspgwoxauvudk")
    public suspend fun noteUpdatedAts(vararg values: InsightFiltersNoteUpdatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noteUpdatedAts = mapped
    }

    /**
     * @param value The principal that created a note. See String Filter below for more details.
     */
    @JvmName("tuanuayrltajspoo")
    public suspend fun noteUpdatedBies(`value`: List<InsightFiltersNoteUpdatedByArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteUpdatedBies = mapped
    }

    /**
     * @param argument The principal that created a note. See String Filter below for more details.
     */
    @JvmName("hrhjeyqqsbnpogsm")
    public suspend fun noteUpdatedBies(argument: List<suspend InsightFiltersNoteUpdatedByArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNoteUpdatedByArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedBies = mapped
    }

    /**
     * @param argument The principal that created a note. See String Filter below for more details.
     */
    @JvmName("fihnlabykulckndy")
    public suspend fun noteUpdatedBies(vararg argument: suspend InsightFiltersNoteUpdatedByArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersNoteUpdatedByArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.noteUpdatedBies = mapped
    }

    /**
     * @param argument The principal that created a note. See String Filter below for more details.
     */
    @JvmName("routqfvjjadctwlv")
    public suspend fun noteUpdatedBies(argument: suspend InsightFiltersNoteUpdatedByArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersNoteUpdatedByArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.noteUpdatedBies = mapped
    }

    /**
     * @param values The principal that created a note. See String Filter below for more details.
     */
    @JvmName("ysqmlbhawdxukbtp")
    public suspend fun noteUpdatedBies(vararg values: InsightFiltersNoteUpdatedByArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noteUpdatedBies = mapped
    }

    /**
     * @param value The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("gblsiilftdmvwfux")
    public suspend fun processLaunchedAts(`value`: List<InsightFiltersProcessLaunchedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processLaunchedAts = mapped
    }

    /**
     * @param argument The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("acovpfxufyqiegor")
    public suspend fun processLaunchedAts(argument: List<suspend InsightFiltersProcessLaunchedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessLaunchedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.processLaunchedAts = mapped
    }

    /**
     * @param argument The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("mxfsngeikixlfurx")
    public suspend fun processLaunchedAts(vararg argument: suspend InsightFiltersProcessLaunchedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessLaunchedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.processLaunchedAts = mapped
    }

    /**
     * @param argument The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("vcshvlnsvnuqeoxs")
    public suspend fun processLaunchedAts(argument: suspend InsightFiltersProcessLaunchedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProcessLaunchedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.processLaunchedAts = mapped
    }

    /**
     * @param values The date/time that the process was launched. See Date Filter below for more details.
     */
    @JvmName("qnolatleovehomwf")
    public suspend fun processLaunchedAts(vararg values: InsightFiltersProcessLaunchedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processLaunchedAts = mapped
    }

    /**
     * @param value The name of the process. See String Filter below for more details.
     */
    @JvmName("aveshcfmfxvhdvqg")
    public suspend fun processNames(`value`: List<InsightFiltersProcessNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processNames = mapped
    }

    /**
     * @param argument The name of the process. See String Filter below for more details.
     */
    @JvmName("vaejnvquqjjfvfan")
    public suspend fun processNames(argument: List<suspend InsightFiltersProcessNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processNames = mapped
    }

    /**
     * @param argument The name of the process. See String Filter below for more details.
     */
    @JvmName("objtvxosfnfcyagb")
    public suspend fun processNames(vararg argument: suspend InsightFiltersProcessNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processNames = mapped
    }

    /**
     * @param argument The name of the process. See String Filter below for more details.
     */
    @JvmName("lvcskesbydfcrgjm")
    public suspend fun processNames(argument: suspend InsightFiltersProcessNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProcessNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.processNames = mapped
    }

    /**
     * @param values The name of the process. See String Filter below for more details.
     */
    @JvmName("gdqisqitfyqmcxno")
    public suspend fun processNames(vararg values: InsightFiltersProcessNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processNames = mapped
    }

    /**
     * @param value The parent process ID. See Number Filter below for more details.
     */
    @JvmName("uuidjdnjjschddaj")
    public suspend fun processParentPids(`value`: List<InsightFiltersProcessParentPidArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processParentPids = mapped
    }

    /**
     * @param argument The parent process ID. See Number Filter below for more details.
     */
    @JvmName("jtfuiitnbybnkwlg")
    public suspend fun processParentPids(argument: List<suspend InsightFiltersProcessParentPidArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessParentPidArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.processParentPids = mapped
    }

    /**
     * @param argument The parent process ID. See Number Filter below for more details.
     */
    @JvmName("xslhdwjnyrheurkb")
    public suspend fun processParentPids(vararg argument: suspend InsightFiltersProcessParentPidArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessParentPidArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.processParentPids = mapped
    }

    /**
     * @param argument The parent process ID. See Number Filter below for more details.
     */
    @JvmName("nwvasbognmijspqk")
    public suspend fun processParentPids(argument: suspend InsightFiltersProcessParentPidArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProcessParentPidArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.processParentPids = mapped
    }

    /**
     * @param values The parent process ID. See Number Filter below for more details.
     */
    @JvmName("vrnwvtruvubrjoip")
    public suspend fun processParentPids(vararg values: InsightFiltersProcessParentPidArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processParentPids = mapped
    }

    /**
     * @param value The path to the process executable. See String Filter below for more details.
     */
    @JvmName("fohaclbhjlxhpxrp")
    public suspend fun processPaths(`value`: List<InsightFiltersProcessPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processPaths = mapped
    }

    /**
     * @param argument The path to the process executable. See String Filter below for more details.
     */
    @JvmName("hfxyejcknamcmuoq")
    public suspend fun processPaths(argument: List<suspend InsightFiltersProcessPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processPaths = mapped
    }

    /**
     * @param argument The path to the process executable. See String Filter below for more details.
     */
    @JvmName("oguwcbtaakmgwckp")
    public suspend fun processPaths(vararg argument: suspend InsightFiltersProcessPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processPaths = mapped
    }

    /**
     * @param argument The path to the process executable. See String Filter below for more details.
     */
    @JvmName("nbrehikbswxleouv")
    public suspend fun processPaths(argument: suspend InsightFiltersProcessPathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProcessPathArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.processPaths = mapped
    }

    /**
     * @param values The path to the process executable. See String Filter below for more details.
     */
    @JvmName("auvxbtvbbueeojkh")
    public suspend fun processPaths(vararg values: InsightFiltersProcessPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processPaths = mapped
    }

    /**
     * @param value The process ID. See Number Filter below for more details.
     */
    @JvmName("qnpfvjxkhsrjjaav")
    public suspend fun processPids(`value`: List<InsightFiltersProcessPidArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processPids = mapped
    }

    /**
     * @param argument The process ID. See Number Filter below for more details.
     */
    @JvmName("uyrfrsteevdqlgov")
    public suspend fun processPids(argument: List<suspend InsightFiltersProcessPidArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessPidArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processPids = mapped
    }

    /**
     * @param argument The process ID. See Number Filter below for more details.
     */
    @JvmName("vcjrcvforiltlgeo")
    public suspend fun processPids(vararg argument: suspend InsightFiltersProcessPidArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessPidArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processPids = mapped
    }

    /**
     * @param argument The process ID. See Number Filter below for more details.
     */
    @JvmName("ovayyujsjtpnvdkd")
    public suspend fun processPids(argument: suspend InsightFiltersProcessPidArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProcessPidArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.processPids = mapped
    }

    /**
     * @param values The process ID. See Number Filter below for more details.
     */
    @JvmName("wlenyxglxiuhjpat")
    public suspend fun processPids(vararg values: InsightFiltersProcessPidArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processPids = mapped
    }

    /**
     * @param value The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("jarobojxxtnnkdlh")
    public suspend fun processTerminatedAts(`value`: List<InsightFiltersProcessTerminatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processTerminatedAts = mapped
    }

    /**
     * @param argument The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("ovilkufceifmgvcl")
    public suspend fun processTerminatedAts(argument: List<suspend InsightFiltersProcessTerminatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessTerminatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.processTerminatedAts = mapped
    }

    /**
     * @param argument The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("pbqdwamkilqhnydl")
    public suspend fun processTerminatedAts(vararg argument: suspend InsightFiltersProcessTerminatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProcessTerminatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.processTerminatedAts = mapped
    }

    /**
     * @param argument The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("cinageewuktmynxg")
    public suspend fun processTerminatedAts(argument: suspend InsightFiltersProcessTerminatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProcessTerminatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.processTerminatedAts = mapped
    }

    /**
     * @param values The date/time that the process was terminated. See Date Filter below for more details.
     */
    @JvmName("opeibwnvykybggwy")
    public suspend fun processTerminatedAts(vararg values: InsightFiltersProcessTerminatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processTerminatedAts = mapped
    }

    /**
     * @param value The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("inoiertojbdakmst")
    public suspend fun productArns(`value`: List<InsightFiltersProductArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productArns = mapped
    }

    /**
     * @param argument The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("frluipeemfboxnxt")
    public suspend fun productArns(argument: List<suspend InsightFiltersProductArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProductArnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.productArns = mapped
    }

    /**
     * @param argument The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("lpnybdxrltfuruvk")
    public suspend fun productArns(vararg argument: suspend InsightFiltersProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProductArnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.productArns = mapped
    }

    /**
     * @param argument The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("tcoafrnnfegxwsji")
    public suspend fun productArns(argument: suspend InsightFiltersProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProductArnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.productArns = mapped
    }

    /**
     * @param values The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
     */
    @JvmName("tlepkpiypoechotr")
    public suspend fun productArns(vararg values: InsightFiltersProductArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productArns = mapped
    }

    /**
     * @param value A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("mngpvoodknllrekg")
    public suspend fun productFields(`value`: List<InsightFiltersProductFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productFields = mapped
    }

    /**
     * @param argument A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("htrerlbvlqsjmgba")
    public suspend fun productFields(argument: List<suspend InsightFiltersProductFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProductFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.productFields = mapped
    }

    /**
     * @param argument A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("vdhmahxanbqicxun")
    public suspend fun productFields(vararg argument: suspend InsightFiltersProductFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProductFieldArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.productFields = mapped
    }

    /**
     * @param argument A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("xggmnitpamnebfue")
    public suspend fun productFields(argument: suspend InsightFiltersProductFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProductFieldArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.productFields = mapped
    }

    /**
     * @param values A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
     */
    @JvmName("cmndfexdqyhhiukl")
    public suspend fun productFields(vararg values: InsightFiltersProductFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productFields = mapped
    }

    /**
     * @param value The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("wkkikxxmegnrnlbm")
    public suspend fun productNames(`value`: List<InsightFiltersProductNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productNames = mapped
    }

    /**
     * @param argument The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("lxivvrojpstrybjl")
    public suspend fun productNames(argument: List<suspend InsightFiltersProductNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProductNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.productNames = mapped
    }

    /**
     * @param argument The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("vympabcdbfmmigom")
    public suspend fun productNames(vararg argument: suspend InsightFiltersProductNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersProductNameArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.productNames = mapped
    }

    /**
     * @param argument The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("bwtfehpfxtkxuxyg")
    public suspend fun productNames(argument: suspend InsightFiltersProductNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersProductNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.productNames = mapped
    }

    /**
     * @param values The name of the solution (product) that generates findings. See String Filter below for more details.
     */
    @JvmName("vrvlrbvpeukeanwd")
    public suspend fun productNames(vararg values: InsightFiltersProductNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productNames = mapped
    }

    /**
     * @param value The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("owdjuvovyrlqeqiy")
    public suspend fun recommendationTexts(`value`: List<InsightFiltersRecommendationTextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationTexts = mapped
    }

    /**
     * @param argument The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("jdercxoysvjxdtax")
    public suspend fun recommendationTexts(argument: List<suspend InsightFiltersRecommendationTextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRecommendationTextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recommendationTexts = mapped
    }

    /**
     * @param argument The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("fjjtnltvsnxqstdk")
    public suspend fun recommendationTexts(vararg argument: suspend InsightFiltersRecommendationTextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRecommendationTextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recommendationTexts = mapped
    }

    /**
     * @param argument The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("bghjimmerohhflva")
    public suspend fun recommendationTexts(argument: suspend InsightFiltersRecommendationTextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersRecommendationTextArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.recommendationTexts = mapped
    }

    /**
     * @param values The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
     */
    @JvmName("hxjrayuqcvmuvqmo")
    public suspend fun recommendationTexts(vararg values: InsightFiltersRecommendationTextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recommendationTexts = mapped
    }

    /**
     * @param value The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("jlmnbamfunbhkahm")
    public suspend fun recordStates(`value`: List<InsightFiltersRecordStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordStates = mapped
    }

    /**
     * @param argument The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("ekdydajguhkffuds")
    public suspend fun recordStates(argument: List<suspend InsightFiltersRecordStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRecordStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordStates = mapped
    }

    /**
     * @param argument The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("qnicjxucyushgxwb")
    public suspend fun recordStates(vararg argument: suspend InsightFiltersRecordStateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRecordStateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordStates = mapped
    }

    /**
     * @param argument The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("vlyyowmygwtnilvt")
    public suspend fun recordStates(argument: suspend InsightFiltersRecordStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersRecordStateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.recordStates = mapped
    }

    /**
     * @param values The updated record state for the finding. See String Filter below for more details.
     */
    @JvmName("vcoycsgwujtoqnvb")
    public suspend fun recordStates(vararg values: InsightFiltersRecordStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordStates = mapped
    }

    /**
     * @param value The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("iddmkkosafrtfhdb")
    public suspend fun relatedFindingsIds(`value`: List<InsightFiltersRelatedFindingsIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedFindingsIds = mapped
    }

    /**
     * @param argument The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("ocnjwtrqhaewpjdt")
    public suspend fun relatedFindingsIds(argument: List<suspend InsightFiltersRelatedFindingsIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRelatedFindingsIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsIds = mapped
    }

    /**
     * @param argument The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("xdjppjoolouqxgyd")
    public suspend fun relatedFindingsIds(vararg argument: suspend InsightFiltersRelatedFindingsIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRelatedFindingsIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsIds = mapped
    }

    /**
     * @param argument The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("ivnykemyrtsodhnt")
    public suspend fun relatedFindingsIds(argument: suspend InsightFiltersRelatedFindingsIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersRelatedFindingsIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.relatedFindingsIds = mapped
    }

    /**
     * @param values The solution-generated identifier for a related finding. See String Filter below for more details.
     */
    @JvmName("pirtfyljyfygcdyp")
    public suspend fun relatedFindingsIds(vararg values: InsightFiltersRelatedFindingsIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedFindingsIds = mapped
    }

    /**
     * @param value The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("ngoblrilaewhlfpe")
    public suspend fun relatedFindingsProductArns(`value`: List<InsightFiltersRelatedFindingsProductArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("lnmiilcpdfucrdju")
    public suspend fun relatedFindingsProductArns(argument: List<suspend InsightFiltersRelatedFindingsProductArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRelatedFindingsProductArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("nbdmrsfpmwmwsouw")
    public suspend fun relatedFindingsProductArns(vararg argument: suspend InsightFiltersRelatedFindingsProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersRelatedFindingsProductArnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param argument The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("uwkpwqoacarwxjqe")
    public suspend fun relatedFindingsProductArns(argument: suspend InsightFiltersRelatedFindingsProductArnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersRelatedFindingsProductArnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param values The ARN of the solution that generated a related finding. See String Filter below for more details.
     */
    @JvmName("bgbiaxgvdelbdlyx")
    public suspend fun relatedFindingsProductArns(vararg values: InsightFiltersRelatedFindingsProductArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relatedFindingsProductArns = mapped
    }

    /**
     * @param value The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("ijcloxhiyomjjaeo")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(`value`: List<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceIamInstanceProfileArns = mapped
    }

    /**
     * @param argument The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("oepofsvmduoxxafs")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(argument: List<suspend InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIamInstanceProfileArns = mapped
    }

    /**
     * @param argument The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("pvvcefpgqfomklli")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIamInstanceProfileArns = mapped
    }

    /**
     * @param argument The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("xedqxypebtnciqvk")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(argument: suspend InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIamInstanceProfileArns = mapped
    }

    /**
     * @param values The IAM profile ARN of the instance. See String Filter below for more details.
     */
    @JvmName("ahiynwenxkhmdocn")
    public suspend fun resourceAwsEc2InstanceIamInstanceProfileArns(vararg values: InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceIamInstanceProfileArns = mapped
    }

    /**
     * @param value The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("ngircmekmdmlhjco")
    public suspend fun resourceAwsEc2InstanceImageIds(`value`: List<InsightFiltersResourceAwsEc2InstanceImageIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceImageIds = mapped
    }

    /**
     * @param argument The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("rmhvpqlqpysmujds")
    public suspend fun resourceAwsEc2InstanceImageIds(argument: List<suspend InsightFiltersResourceAwsEc2InstanceImageIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceImageIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceImageIds = mapped
    }

    /**
     * @param argument The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("dfhgbrayphrsyqbu")
    public suspend fun resourceAwsEc2InstanceImageIds(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceImageIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceImageIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceImageIds = mapped
    }

    /**
     * @param argument The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("gshwiiitlrlibfqg")
    public suspend fun resourceAwsEc2InstanceImageIds(argument: suspend InsightFiltersResourceAwsEc2InstanceImageIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsEc2InstanceImageIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceImageIds = mapped
    }

    /**
     * @param values The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
     */
    @JvmName("atyldsnhcwysnjcf")
    public suspend fun resourceAwsEc2InstanceImageIds(vararg values: InsightFiltersResourceAwsEc2InstanceImageIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceImageIds = mapped
    }

    /**
     * @param value The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("fnplwewoabpwcxvt")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(`value`: List<InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceIpv4Addresses = mapped
    }

    /**
     * @param argument The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("quimgyhsifdaidqj")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(argument: List<suspend InsightFiltersResourceAwsEc2InstanceIpv4AddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceIpv4AddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIpv4Addresses = mapped
    }

    /**
     * @param argument The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("yshxkuomfachlimy")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceIpv4AddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceIpv4AddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIpv4Addresses = mapped
    }

    /**
     * @param argument The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("raquokrwhkdbphqu")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(argument: suspend InsightFiltersResourceAwsEc2InstanceIpv4AddressArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersResourceAwsEc2InstanceIpv4AddressArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIpv4Addresses = mapped
    }

    /**
     * @param values The IPv4 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("fqyictxtepmcposa")
    public suspend fun resourceAwsEc2InstanceIpv4Addresses(vararg values: InsightFiltersResourceAwsEc2InstanceIpv4AddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceIpv4Addresses = mapped
    }

    /**
     * @param value The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("hduisdynonvtkqev")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(`value`: List<InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceIpv6Addresses = mapped
    }

    /**
     * @param argument The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("jivawywusjdbsxod")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(argument: List<suspend InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIpv6Addresses = mapped
    }

    /**
     * @param argument The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("mkaodsrvdaywfnom")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIpv6Addresses = mapped
    }

    /**
     * @param argument The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("caqfiigiojdafbta")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(argument: suspend InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceIpv6Addresses = mapped
    }

    /**
     * @param values The IPv6 addresses associated with the instance. See Ip Filter below for more details.
     */
    @JvmName("jvvtrjxsqydgmxqs")
    public suspend fun resourceAwsEc2InstanceIpv6Addresses(vararg values: InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceIpv6Addresses = mapped
    }

    /**
     * @param value The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("jgfsigeqotoweaxr")
    public suspend fun resourceAwsEc2InstanceKeyNames(`value`: List<InsightFiltersResourceAwsEc2InstanceKeyNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceKeyNames = mapped
    }

    /**
     * @param argument The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("axywdpgxeqnrtopp")
    public suspend fun resourceAwsEc2InstanceKeyNames(argument: List<suspend InsightFiltersResourceAwsEc2InstanceKeyNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceKeyNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceKeyNames = mapped
    }

    /**
     * @param argument The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("wmrhpweypknhyjpl")
    public suspend fun resourceAwsEc2InstanceKeyNames(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceKeyNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceKeyNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceKeyNames = mapped
    }

    /**
     * @param argument The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("axexguboitaggbys")
    public suspend fun resourceAwsEc2InstanceKeyNames(argument: suspend InsightFiltersResourceAwsEc2InstanceKeyNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsEc2InstanceKeyNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceKeyNames = mapped
    }

    /**
     * @param values The key name associated with the instance. See String Filter below for more details.
     */
    @JvmName("dwaaihltshkifjbe")
    public suspend fun resourceAwsEc2InstanceKeyNames(vararg values: InsightFiltersResourceAwsEc2InstanceKeyNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceKeyNames = mapped
    }

    /**
     * @param value The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("xjuknkxyqlvpwhue")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(`value`: List<InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceLaunchedAts = mapped
    }

    /**
     * @param argument The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("ndgbqxmqpwoyxafc")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(argument: List<suspend InsightFiltersResourceAwsEc2InstanceLaunchedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceLaunchedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceLaunchedAts = mapped
    }

    /**
     * @param argument The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("ffbewaecwutgjpau")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceLaunchedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceLaunchedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceLaunchedAts = mapped
    }

    /**
     * @param argument The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("tveodsuealbwbckn")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(argument: suspend InsightFiltersResourceAwsEc2InstanceLaunchedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsEc2InstanceLaunchedAtArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceLaunchedAts = mapped
    }

    /**
     * @param values The date and time the instance was launched. See Date Filter below for more details.
     */
    @JvmName("hweaclpsviuldgrv")
    public suspend fun resourceAwsEc2InstanceLaunchedAts(vararg values: InsightFiltersResourceAwsEc2InstanceLaunchedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceLaunchedAts = mapped
    }

    /**
     * @param value The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("gqbowckucwwgkuch")
    public suspend fun resourceAwsEc2InstanceSubnetIds(`value`: List<InsightFiltersResourceAwsEc2InstanceSubnetIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceSubnetIds = mapped
    }

    /**
     * @param argument The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("olpnmlfqtiwwalxs")
    public suspend fun resourceAwsEc2InstanceSubnetIds(argument: List<suspend InsightFiltersResourceAwsEc2InstanceSubnetIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceSubnetIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceSubnetIds = mapped
    }

    /**
     * @param argument The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("wuvkrfbxqqtiofcv")
    public suspend fun resourceAwsEc2InstanceSubnetIds(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceSubnetIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceSubnetIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceSubnetIds = mapped
    }

    /**
     * @param argument The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("jcpmhhlyrjdibina")
    public suspend fun resourceAwsEc2InstanceSubnetIds(argument: suspend InsightFiltersResourceAwsEc2InstanceSubnetIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsEc2InstanceSubnetIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceSubnetIds = mapped
    }

    /**
     * @param values The identifier of the subnet that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("pkkosuqaevqdnacl")
    public suspend fun resourceAwsEc2InstanceSubnetIds(vararg values: InsightFiltersResourceAwsEc2InstanceSubnetIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceSubnetIds = mapped
    }

    /**
     * @param value The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("qpewbuscmutyqcrr")
    public suspend fun resourceAwsEc2InstanceTypes(`value`: List<InsightFiltersResourceAwsEc2InstanceTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceTypes = mapped
    }

    /**
     * @param argument The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("mgmgkeuoyngrtfik")
    public suspend fun resourceAwsEc2InstanceTypes(argument: List<suspend InsightFiltersResourceAwsEc2InstanceTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceTypes = mapped
    }

    /**
     * @param argument The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("qnwswaefsrvcbixh")
    public suspend fun resourceAwsEc2InstanceTypes(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceTypes = mapped
    }

    /**
     * @param argument The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("watitrnbbyhxauky")
    public suspend fun resourceAwsEc2InstanceTypes(argument: suspend InsightFiltersResourceAwsEc2InstanceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsEc2InstanceTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceTypes = mapped
    }

    /**
     * @param values The instance type of the instance. See String Filter below for more details.
     */
    @JvmName("opvtgmujjhklxqlh")
    public suspend fun resourceAwsEc2InstanceTypes(vararg values: InsightFiltersResourceAwsEc2InstanceTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceTypes = mapped
    }

    /**
     * @param value The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("xwwmngwslqdubnih")
    public suspend fun resourceAwsEc2InstanceVpcIds(`value`: List<InsightFiltersResourceAwsEc2InstanceVpcIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceVpcIds = mapped
    }

    /**
     * @param argument The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("dneoxdrshmsgqdvi")
    public suspend fun resourceAwsEc2InstanceVpcIds(argument: List<suspend InsightFiltersResourceAwsEc2InstanceVpcIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceVpcIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceVpcIds = mapped
    }

    /**
     * @param argument The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("ebvyeeajhyciqlpu")
    public suspend fun resourceAwsEc2InstanceVpcIds(vararg argument: suspend InsightFiltersResourceAwsEc2InstanceVpcIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsEc2InstanceVpcIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceVpcIds = mapped
    }

    /**
     * @param argument The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("qkwyuccsafodcobw")
    public suspend fun resourceAwsEc2InstanceVpcIds(argument: suspend InsightFiltersResourceAwsEc2InstanceVpcIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsEc2InstanceVpcIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsEc2InstanceVpcIds = mapped
    }

    /**
     * @param values The identifier of the VPC that the instance was launched in. See String Filter below for more details.
     */
    @JvmName("kghtciqrxwpjrwsy")
    public suspend fun resourceAwsEc2InstanceVpcIds(vararg values: InsightFiltersResourceAwsEc2InstanceVpcIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsEc2InstanceVpcIds = mapped
    }

    /**
     * @param value The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("bbhvtgubcrvvvjgl")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(`value`: List<InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsIamAccessKeyCreatedAts = mapped
    }

    /**
     * @param argument The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("xemmfgmdxrxolatw")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(argument: List<suspend InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyCreatedAts = mapped
    }

    /**
     * @param argument The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("jtsdvsrddpptwgfp")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(vararg argument: suspend InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyCreatedAts = mapped
    }

    /**
     * @param argument The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("kjfdciathgxgvcox")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(argument: suspend InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyCreatedAts = mapped
    }

    /**
     * @param values The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
     */
    @JvmName("gtunwdkcmvycirip")
    public suspend fun resourceAwsIamAccessKeyCreatedAts(vararg values: InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsIamAccessKeyCreatedAts = mapped
    }

    /**
     * @param value The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("fwjmivjnkumkfumn")
    public suspend fun resourceAwsIamAccessKeyStatuses(`value`: List<InsightFiltersResourceAwsIamAccessKeyStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsIamAccessKeyStatuses = mapped
    }

    /**
     * @param argument The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("ixlpmmmcoethybxx")
    public suspend fun resourceAwsIamAccessKeyStatuses(argument: List<suspend InsightFiltersResourceAwsIamAccessKeyStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsIamAccessKeyStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyStatuses = mapped
    }

    /**
     * @param argument The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("gwbjfvsxgxtwwbgg")
    public suspend fun resourceAwsIamAccessKeyStatuses(vararg argument: suspend InsightFiltersResourceAwsIamAccessKeyStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsIamAccessKeyStatusArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyStatuses = mapped
    }

    /**
     * @param argument The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("dcmlwuorvcjhnolp")
    public suspend fun resourceAwsIamAccessKeyStatuses(argument: suspend InsightFiltersResourceAwsIamAccessKeyStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsIamAccessKeyStatusArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyStatuses = mapped
    }

    /**
     * @param values The status of the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("kkfevblxrieswpbu")
    public suspend fun resourceAwsIamAccessKeyStatuses(vararg values: InsightFiltersResourceAwsIamAccessKeyStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsIamAccessKeyStatuses = mapped
    }

    /**
     * @param value The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("dschudooakamyicj")
    public suspend fun resourceAwsIamAccessKeyUserNames(`value`: List<InsightFiltersResourceAwsIamAccessKeyUserNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsIamAccessKeyUserNames = mapped
    }

    /**
     * @param argument The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("jdqmrhuxmojjcdwc")
    public suspend fun resourceAwsIamAccessKeyUserNames(argument: List<suspend InsightFiltersResourceAwsIamAccessKeyUserNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsIamAccessKeyUserNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyUserNames = mapped
    }

    /**
     * @param argument The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("ulnndbnuolxyjstb")
    public suspend fun resourceAwsIamAccessKeyUserNames(vararg argument: suspend InsightFiltersResourceAwsIamAccessKeyUserNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsIamAccessKeyUserNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyUserNames = mapped
    }

    /**
     * @param argument The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("mxrkuongjwqugwgk")
    public suspend fun resourceAwsIamAccessKeyUserNames(argument: suspend InsightFiltersResourceAwsIamAccessKeyUserNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsIamAccessKeyUserNameArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsIamAccessKeyUserNames = mapped
    }

    /**
     * @param values The user associated with the IAM access key related to a finding. See String Filter below for more details.
     */
    @JvmName("okrpjwtbfhaqahem")
    public suspend fun resourceAwsIamAccessKeyUserNames(vararg values: InsightFiltersResourceAwsIamAccessKeyUserNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsIamAccessKeyUserNames = mapped
    }

    /**
     * @param value The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("iposlpwlfjpmlwvc")
    public suspend fun resourceAwsS3BucketOwnerIds(`value`: List<InsightFiltersResourceAwsS3BucketOwnerIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsS3BucketOwnerIds = mapped
    }

    /**
     * @param argument The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("whvopmhpjtifuujh")
    public suspend fun resourceAwsS3BucketOwnerIds(argument: List<suspend InsightFiltersResourceAwsS3BucketOwnerIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsS3BucketOwnerIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsS3BucketOwnerIds = mapped
    }

    /**
     * @param argument The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("vpxuymwvfnnatlyv")
    public suspend fun resourceAwsS3BucketOwnerIds(vararg argument: suspend InsightFiltersResourceAwsS3BucketOwnerIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsS3BucketOwnerIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsS3BucketOwnerIds = mapped
    }

    /**
     * @param argument The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("dlwruaniadnakgis")
    public suspend fun resourceAwsS3BucketOwnerIds(argument: suspend InsightFiltersResourceAwsS3BucketOwnerIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsS3BucketOwnerIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsS3BucketOwnerIds = mapped
    }

    /**
     * @param values The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("foilwtdstytdmgwk")
    public suspend fun resourceAwsS3BucketOwnerIds(vararg values: InsightFiltersResourceAwsS3BucketOwnerIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsS3BucketOwnerIds = mapped
    }

    /**
     * @param value The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("uusxntevvyiquhsr")
    public suspend fun resourceAwsS3BucketOwnerNames(`value`: List<InsightFiltersResourceAwsS3BucketOwnerNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAwsS3BucketOwnerNames = mapped
    }

    /**
     * @param argument The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("ovaolnjfjmvebtmm")
    public suspend fun resourceAwsS3BucketOwnerNames(argument: List<suspend InsightFiltersResourceAwsS3BucketOwnerNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsS3BucketOwnerNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsS3BucketOwnerNames = mapped
    }

    /**
     * @param argument The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("ftvpeelmllrjjgme")
    public suspend fun resourceAwsS3BucketOwnerNames(vararg argument: suspend InsightFiltersResourceAwsS3BucketOwnerNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceAwsS3BucketOwnerNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceAwsS3BucketOwnerNames = mapped
    }

    /**
     * @param argument The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("bjayuvblsihqbkvi")
    public suspend fun resourceAwsS3BucketOwnerNames(argument: suspend InsightFiltersResourceAwsS3BucketOwnerNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceAwsS3BucketOwnerNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceAwsS3BucketOwnerNames = mapped
    }

    /**
     * @param values The display name of the owner of the S3 bucket. See String Filter below for more details.
     */
    @JvmName("ubsmrbmyivfvfoav")
    public suspend fun resourceAwsS3BucketOwnerNames(vararg values: InsightFiltersResourceAwsS3BucketOwnerNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAwsS3BucketOwnerNames = mapped
    }

    /**
     * @param value The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("dvurtnwadgfckray")
    public suspend fun resourceContainerImageIds(`value`: List<InsightFiltersResourceContainerImageIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceContainerImageIds = mapped
    }

    /**
     * @param argument The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("eowiormywmekpydn")
    public suspend fun resourceContainerImageIds(argument: List<suspend InsightFiltersResourceContainerImageIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerImageIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerImageIds = mapped
    }

    /**
     * @param argument The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("gndrrxxbmtgytilo")
    public suspend fun resourceContainerImageIds(vararg argument: suspend InsightFiltersResourceContainerImageIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerImageIdArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerImageIds = mapped
    }

    /**
     * @param argument The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("vwctpvufdpauwmok")
    public suspend fun resourceContainerImageIds(argument: suspend InsightFiltersResourceContainerImageIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceContainerImageIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceContainerImageIds = mapped
    }

    /**
     * @param values The identifier of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("ijgobnbwfulnsmwo")
    public suspend fun resourceContainerImageIds(vararg values: InsightFiltersResourceContainerImageIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceContainerImageIds = mapped
    }

    /**
     * @param value The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("jkputfsfuohccfop")
    public suspend fun resourceContainerImageNames(`value`: List<InsightFiltersResourceContainerImageNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceContainerImageNames = mapped
    }

    /**
     * @param argument The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("tajmtcpfohpwhvub")
    public suspend fun resourceContainerImageNames(argument: List<suspend InsightFiltersResourceContainerImageNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerImageNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerImageNames = mapped
    }

    /**
     * @param argument The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("gndjnkqueicqarnu")
    public suspend fun resourceContainerImageNames(vararg argument: suspend InsightFiltersResourceContainerImageNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerImageNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerImageNames = mapped
    }

    /**
     * @param argument The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("mjiaibmfjrrmpbtb")
    public suspend fun resourceContainerImageNames(argument: suspend InsightFiltersResourceContainerImageNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceContainerImageNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceContainerImageNames = mapped
    }

    /**
     * @param values The name of the image related to a finding. See String Filter below for more details.
     */
    @JvmName("avwgsnmibayyvqoo")
    public suspend fun resourceContainerImageNames(vararg values: InsightFiltersResourceContainerImageNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceContainerImageNames = mapped
    }

    /**
     * @param value The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("ujhguglcpwnpunog")
    public suspend fun resourceContainerLaunchedAts(`value`: List<InsightFiltersResourceContainerLaunchedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceContainerLaunchedAts = mapped
    }

    /**
     * @param argument The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("pgwtjjtdxxadkxbv")
    public suspend fun resourceContainerLaunchedAts(argument: List<suspend InsightFiltersResourceContainerLaunchedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerLaunchedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerLaunchedAts = mapped
    }

    /**
     * @param argument The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("bpihgcgbolisqehb")
    public suspend fun resourceContainerLaunchedAts(vararg argument: suspend InsightFiltersResourceContainerLaunchedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerLaunchedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerLaunchedAts = mapped
    }

    /**
     * @param argument The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("jxiqrdwlvsgtavkd")
    public suspend fun resourceContainerLaunchedAts(argument: suspend InsightFiltersResourceContainerLaunchedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceContainerLaunchedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceContainerLaunchedAts = mapped
    }

    /**
     * @param values The date/time that the container was started. See Date Filter below for more details.
     */
    @JvmName("rlyklusobewovdkt")
    public suspend fun resourceContainerLaunchedAts(vararg values: InsightFiltersResourceContainerLaunchedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceContainerLaunchedAts = mapped
    }

    /**
     * @param value The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("bnfmvwucwgppdiwr")
    public suspend fun resourceContainerNames(`value`: List<InsightFiltersResourceContainerNameArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceContainerNames = mapped
    }

    /**
     * @param argument The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("ixpriapamhaiigua")
    public suspend fun resourceContainerNames(argument: List<suspend InsightFiltersResourceContainerNameArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerNames = mapped
    }

    /**
     * @param argument The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("lnpynyoipgscldjy")
    public suspend fun resourceContainerNames(vararg argument: suspend InsightFiltersResourceContainerNameArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceContainerNameArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceContainerNames = mapped
    }

    /**
     * @param argument The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("iisdofqqnjcpjxqk")
    public suspend fun resourceContainerNames(argument: suspend InsightFiltersResourceContainerNameArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceContainerNameArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceContainerNames = mapped
    }

    /**
     * @param values The name of the container related to a finding. See String Filter below for more details.
     */
    @JvmName("tfqsjjvblilhuctv")
    public suspend fun resourceContainerNames(vararg values: InsightFiltersResourceContainerNameArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceContainerNames = mapped
    }

    /**
     * @param value The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("xebopvxvydjqoaei")
    public suspend fun resourceDetailsOthers(`value`: List<InsightFiltersResourceDetailsOtherArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param argument The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("jswkpxuvcvvwaomg")
    public suspend fun resourceDetailsOthers(argument: List<suspend InsightFiltersResourceDetailsOtherArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceDetailsOtherArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param argument The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("raypltwtqciihlum")
    public suspend fun resourceDetailsOthers(vararg argument: suspend InsightFiltersResourceDetailsOtherArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceDetailsOtherArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param argument The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("phhkuiobscnvtkrd")
    public suspend fun resourceDetailsOthers(argument: suspend InsightFiltersResourceDetailsOtherArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceDetailsOtherArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param values The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
     */
    @JvmName("ytbklorbjekxjxvk")
    public suspend fun resourceDetailsOthers(vararg values: InsightFiltersResourceDetailsOtherArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceDetailsOthers = mapped
    }

    /**
     * @param value The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("fwtvnpfjlgrlwgwl")
    public suspend fun resourceIds(`value`: List<InsightFiltersResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIds = mapped
    }

    /**
     * @param argument The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("uosdcxxilrhbonth")
    public suspend fun resourceIds(argument: List<suspend InsightFiltersResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceIds = mapped
    }

    /**
     * @param argument The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("loyemcngoorisfdg")
    public suspend fun resourceIds(vararg argument: suspend InsightFiltersResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceIds = mapped
    }

    /**
     * @param argument The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("piserlhpbhtkjtie")
    public suspend fun resourceIds(argument: suspend InsightFiltersResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceIdArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceIds = mapped
    }

    /**
     * @param values The canonical identifier for the given resource type. See String Filter below for more details.
     */
    @JvmName("jqwiyodyadikyecw")
    public suspend fun resourceIds(vararg values: InsightFiltersResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceIds = mapped
    }

    /**
     * @param value The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("nvjqkvsrhskgdins")
    public suspend fun resourcePartitions(`value`: List<InsightFiltersResourcePartitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePartitions = mapped
    }

    /**
     * @param argument The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("pyxakhgtenyvlwhn")
    public suspend fun resourcePartitions(argument: List<suspend InsightFiltersResourcePartitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourcePartitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourcePartitions = mapped
    }

    /**
     * @param argument The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("tseahifqmetpmelx")
    public suspend fun resourcePartitions(vararg argument: suspend InsightFiltersResourcePartitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourcePartitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourcePartitions = mapped
    }

    /**
     * @param argument The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("cnumefjolhkuhkjl")
    public suspend fun resourcePartitions(argument: suspend InsightFiltersResourcePartitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourcePartitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourcePartitions = mapped
    }

    /**
     * @param values The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
     */
    @JvmName("fhxlcsppfbawabmv")
    public suspend fun resourcePartitions(vararg values: InsightFiltersResourcePartitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourcePartitions = mapped
    }

    /**
     * @param value The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("reinhvayxljebehw")
    public suspend fun resourceRegions(`value`: List<InsightFiltersResourceRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRegions = mapped
    }

    /**
     * @param argument The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("ohhrdmcxvxalgaco")
    public suspend fun resourceRegions(argument: List<suspend InsightFiltersResourceRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRegions = mapped
    }

    /**
     * @param argument The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("mkojpynnfqwlofpa")
    public suspend fun resourceRegions(vararg argument: suspend InsightFiltersResourceRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRegions = mapped
    }

    /**
     * @param argument The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("gpucjowmjfayltvy")
    public suspend fun resourceRegions(argument: suspend InsightFiltersResourceRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceRegions = mapped
    }

    /**
     * @param values The canonical AWS external Region name where this resource is located. See String Filter below for more details.
     */
    @JvmName("tteapciupfoynfsx")
    public suspend fun resourceRegions(vararg values: InsightFiltersResourceRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceRegions = mapped
    }

    /**
     * @param value A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("faiupdkcpyvghplk")
    public suspend fun resourceTags(`value`: List<InsightFiltersResourceTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param argument A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("asolandatkjnrgip")
    public suspend fun resourceTags(argument: List<suspend InsightFiltersResourceTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("xgjxflbarfcnopjn")
    public suspend fun resourceTags(vararg argument: suspend InsightFiltersResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("jgabinbotnciqhhv")
    public suspend fun resourceTags(argument: suspend InsightFiltersResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceTagArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param values A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
     */
    @JvmName("lvxaodeqityiienw")
    public suspend fun resourceTags(vararg values: InsightFiltersResourceTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("iwokablyimdavfdg")
    public suspend fun resourceTypes(`value`: List<InsightFiltersResourceTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param argument Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("mdevvcoccinxlsue")
    public suspend fun resourceTypes(argument: List<suspend InsightFiltersResourceTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param argument Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("tkkinedhmqgtpfdh")
    public suspend fun resourceTypes(vararg argument: suspend InsightFiltersResourceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersResourceTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param argument Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("wffdbflmsnqutxxl")
    public suspend fun resourceTypes(argument: suspend InsightFiltersResourceTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersResourceTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTypes = mapped
    }

    /**
     * @param values Specifies the type of the resource that details are provided for. See String Filter below for more details.
     */
    @JvmName("jvwydmavrhedwhtx")
    public suspend fun resourceTypes(vararg values: InsightFiltersResourceTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypes = mapped
    }

    /**
     * @param value The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("mnctlgkcjtlbdfni")
    public suspend fun severityLabels(`value`: List<InsightFiltersSeverityLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severityLabels = mapped
    }

    /**
     * @param argument The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("vaxtlqxusqnfeejb")
    public suspend fun severityLabels(argument: List<suspend InsightFiltersSeverityLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersSeverityLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.severityLabels = mapped
    }

    /**
     * @param argument The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("fosxicmjcmeexngl")
    public suspend fun severityLabels(vararg argument: suspend InsightFiltersSeverityLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersSeverityLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.severityLabels = mapped
    }

    /**
     * @param argument The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("bsoexosxacjtiugt")
    public suspend fun severityLabels(argument: suspend InsightFiltersSeverityLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersSeverityLabelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.severityLabels = mapped
    }

    /**
     * @param values The label of a finding's severity. See String Filter below for more details.
     */
    @JvmName("nafjsaqjrpuapcfd")
    public suspend fun severityLabels(vararg values: InsightFiltersSeverityLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severityLabels = mapped
    }

    /**
     * @param value A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("wwinugwliwecolti")
    public suspend fun sourceUrls(`value`: List<InsightFiltersSourceUrlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUrls = mapped
    }

    /**
     * @param argument A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("iurlcbxgnxtrmukf")
    public suspend fun sourceUrls(argument: List<suspend InsightFiltersSourceUrlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersSourceUrlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceUrls = mapped
    }

    /**
     * @param argument A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("aobdanrfaechwjxk")
    public suspend fun sourceUrls(vararg argument: suspend InsightFiltersSourceUrlArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersSourceUrlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceUrls = mapped
    }

    /**
     * @param argument A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("qababeddpmfundvd")
    public suspend fun sourceUrls(argument: suspend InsightFiltersSourceUrlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersSourceUrlArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceUrls = mapped
    }

    /**
     * @param values A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
     */
    @JvmName("ohqkteiqackmtqys")
    public suspend fun sourceUrls(vararg values: InsightFiltersSourceUrlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceUrls = mapped
    }

    /**
     * @param value The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("uvwinrdvfgcvkffy")
    public suspend fun threatIntelIndicatorCategories(`value`: List<InsightFiltersThreatIntelIndicatorCategoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelIndicatorCategories = mapped
    }

    /**
     * @param argument The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("hbcdceavcecwlgjr")
    public suspend fun threatIntelIndicatorCategories(argument: List<suspend InsightFiltersThreatIntelIndicatorCategoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorCategoryArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorCategories = mapped
    }

    /**
     * @param argument The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("pvqugspjlkdkkvwx")
    public suspend fun threatIntelIndicatorCategories(vararg argument: suspend InsightFiltersThreatIntelIndicatorCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorCategoryArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorCategories = mapped
    }

    /**
     * @param argument The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("vwmfctaoexaypqlr")
    public suspend fun threatIntelIndicatorCategories(argument: suspend InsightFiltersThreatIntelIndicatorCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersThreatIntelIndicatorCategoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorCategories = mapped
    }

    /**
     * @param values The category of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("aydxijdimmfugwia")
    public suspend fun threatIntelIndicatorCategories(vararg values: InsightFiltersThreatIntelIndicatorCategoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelIndicatorCategories = mapped
    }

    /**
     * @param value The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("xlptxoyvixgnlppa")
    public suspend fun threatIntelIndicatorLastObservedAts(`value`: List<InsightFiltersThreatIntelIndicatorLastObservedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelIndicatorLastObservedAts = mapped
    }

    /**
     * @param argument The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("rwneoomutfapomhf")
    public suspend fun threatIntelIndicatorLastObservedAts(argument: List<suspend InsightFiltersThreatIntelIndicatorLastObservedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorLastObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorLastObservedAts = mapped
    }

    /**
     * @param argument The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("tpurgifjavkjyaie")
    public suspend fun threatIntelIndicatorLastObservedAts(vararg argument: suspend InsightFiltersThreatIntelIndicatorLastObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorLastObservedAtArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorLastObservedAts = mapped
    }

    /**
     * @param argument The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("pdnvswheewmtblom")
    public suspend fun threatIntelIndicatorLastObservedAts(argument: suspend InsightFiltersThreatIntelIndicatorLastObservedAtArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                InsightFiltersThreatIntelIndicatorLastObservedAtArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorLastObservedAts = mapped
    }

    /**
     * @param values The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
     */
    @JvmName("sabewnvxigpwnclw")
    public suspend fun threatIntelIndicatorLastObservedAts(vararg values: InsightFiltersThreatIntelIndicatorLastObservedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelIndicatorLastObservedAts = mapped
    }

    /**
     * @param value The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("oyoldneyhtfloxfw")
    public suspend fun threatIntelIndicatorSourceUrls(`value`: List<InsightFiltersThreatIntelIndicatorSourceUrlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelIndicatorSourceUrls = mapped
    }

    /**
     * @param argument The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("mnnrxurxxaenbbvj")
    public suspend fun threatIntelIndicatorSourceUrls(argument: List<suspend InsightFiltersThreatIntelIndicatorSourceUrlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorSourceUrlArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorSourceUrls = mapped
    }

    /**
     * @param argument The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("icdgugmknxjplxrt")
    public suspend fun threatIntelIndicatorSourceUrls(vararg argument: suspend InsightFiltersThreatIntelIndicatorSourceUrlArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorSourceUrlArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorSourceUrls = mapped
    }

    /**
     * @param argument The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("pymaowveiflmseje")
    public suspend fun threatIntelIndicatorSourceUrls(argument: suspend InsightFiltersThreatIntelIndicatorSourceUrlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersThreatIntelIndicatorSourceUrlArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorSourceUrls = mapped
    }

    /**
     * @param values The URL for more details from the source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("htvsjorfsajeluhj")
    public suspend fun threatIntelIndicatorSourceUrls(vararg values: InsightFiltersThreatIntelIndicatorSourceUrlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelIndicatorSourceUrls = mapped
    }

    /**
     * @param value The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("ixesbvnlonjydprg")
    public suspend fun threatIntelIndicatorSources(`value`: List<InsightFiltersThreatIntelIndicatorSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelIndicatorSources = mapped
    }

    /**
     * @param argument The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("xejjqgphjlcvwkkx")
    public suspend fun threatIntelIndicatorSources(argument: List<suspend InsightFiltersThreatIntelIndicatorSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorSources = mapped
    }

    /**
     * @param argument The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("ohplhqukrvkkdbsh")
    public suspend fun threatIntelIndicatorSources(vararg argument: suspend InsightFiltersThreatIntelIndicatorSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorSources = mapped
    }

    /**
     * @param argument The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("atdpfmdwtllcllpe")
    public suspend fun threatIntelIndicatorSources(argument: suspend InsightFiltersThreatIntelIndicatorSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersThreatIntelIndicatorSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorSources = mapped
    }

    /**
     * @param values The source of the threat intelligence. See String Filter below for more details.
     */
    @JvmName("nayitfideomrfojp")
    public suspend fun threatIntelIndicatorSources(vararg values: InsightFiltersThreatIntelIndicatorSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelIndicatorSources = mapped
    }

    /**
     * @param value The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("whvjbigkawvdpdpd")
    public suspend fun threatIntelIndicatorTypes(`value`: List<InsightFiltersThreatIntelIndicatorTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelIndicatorTypes = mapped
    }

    /**
     * @param argument The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("gunuvhtuhglmmwyh")
    public suspend fun threatIntelIndicatorTypes(argument: List<suspend InsightFiltersThreatIntelIndicatorTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorTypes = mapped
    }

    /**
     * @param argument The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("bdkfoeopfumksrla")
    public suspend fun threatIntelIndicatorTypes(vararg argument: suspend InsightFiltersThreatIntelIndicatorTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorTypes = mapped
    }

    /**
     * @param argument The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("nvyedbesfapctwln")
    public suspend fun threatIntelIndicatorTypes(argument: suspend InsightFiltersThreatIntelIndicatorTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersThreatIntelIndicatorTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorTypes = mapped
    }

    /**
     * @param values The type of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("bfsydumivjrpguos")
    public suspend fun threatIntelIndicatorTypes(vararg values: InsightFiltersThreatIntelIndicatorTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelIndicatorTypes = mapped
    }

    /**
     * @param value The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("yyttgiselsutpoit")
    public suspend fun threatIntelIndicatorValues(`value`: List<InsightFiltersThreatIntelIndicatorValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelIndicatorValues = mapped
    }

    /**
     * @param argument The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("aywcxhrhaaffornc")
    public suspend fun threatIntelIndicatorValues(argument: List<suspend InsightFiltersThreatIntelIndicatorValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorValues = mapped
    }

    /**
     * @param argument The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("cttcnonjpeufohks")
    public suspend fun threatIntelIndicatorValues(vararg argument: suspend InsightFiltersThreatIntelIndicatorValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersThreatIntelIndicatorValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorValues = mapped
    }

    /**
     * @param argument The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("yrqhyosejirylwls")
    public suspend fun threatIntelIndicatorValues(argument: suspend InsightFiltersThreatIntelIndicatorValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersThreatIntelIndicatorValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.threatIntelIndicatorValues = mapped
    }

    /**
     * @param values The value of a threat intelligence indicator. See String Filter below for more details.
     */
    @JvmName("iuctdtqqyitwslun")
    public suspend fun threatIntelIndicatorValues(vararg values: InsightFiltersThreatIntelIndicatorValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelIndicatorValues = mapped
    }

    /**
     * @param value A finding's title. See String Filter below for more details.
     */
    @JvmName("mkjnmefnhjnvusom")
    public suspend fun titles(`value`: List<InsightFiltersTitleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.titles = mapped
    }

    /**
     * @param argument A finding's title. See String Filter below for more details.
     */
    @JvmName("vsvmlxyeorsorhos")
    public suspend fun titles(argument: List<suspend InsightFiltersTitleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersTitleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.titles = mapped
    }

    /**
     * @param argument A finding's title. See String Filter below for more details.
     */
    @JvmName("bvsrhtkcaiikwdhd")
    public suspend fun titles(vararg argument: suspend InsightFiltersTitleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersTitleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.titles = mapped
    }

    /**
     * @param argument A finding's title. See String Filter below for more details.
     */
    @JvmName("scmhybshjhwkxept")
    public suspend fun titles(argument: suspend InsightFiltersTitleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InsightFiltersTitleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.titles = mapped
    }

    /**
     * @param values A finding's title. See String Filter below for more details.
     */
    @JvmName("qepesmdqggekgekr")
    public suspend fun titles(vararg values: InsightFiltersTitleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.titles = mapped
    }

    /**
     * @param value A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("hchjslfoiixdefxg")
    public suspend fun types(`value`: List<InsightFiltersTypeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param argument A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("iinemfbctaoopdpg")
    public suspend fun types(argument: List<suspend InsightFiltersTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.types = mapped
    }

    /**
     * @param argument A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("niubfvrknrbomsxw")
    public suspend fun types(vararg argument: suspend InsightFiltersTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersTypeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.types = mapped
    }

    /**
     * @param argument A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("jrrygwdliixmuwje")
    public suspend fun types(argument: suspend InsightFiltersTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InsightFiltersTypeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.types = mapped
    }

    /**
     * @param values A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
     */
    @JvmName("qavrxkuiawuksgjo")
    public suspend fun types(vararg values: InsightFiltersTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param value An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("bwgebcugukuujhvs")
    public suspend fun updatedAts(`value`: List<InsightFiltersUpdatedAtArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("jxaglibeemhvxaov")
    public suspend fun updatedAts(argument: List<suspend InsightFiltersUpdatedAtArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersUpdatedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.updatedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("xauyfndwcvtnfnas")
    public suspend fun updatedAts(vararg argument: suspend InsightFiltersUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersUpdatedAtArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.updatedAts = mapped
    }

    /**
     * @param argument An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("ksrboykhnbscoutf")
    public suspend fun updatedAts(argument: suspend InsightFiltersUpdatedAtArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersUpdatedAtArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.updatedAts = mapped
    }

    /**
     * @param values An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
     */
    @JvmName("pwuiabuaydbsylyj")
    public suspend fun updatedAts(vararg values: InsightFiltersUpdatedAtArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updatedAts = mapped
    }

    /**
     * @param value A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("fombjddyglhhronp")
    public suspend fun userDefinedValues(`value`: List<InsightFiltersUserDefinedValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefinedValues = mapped
    }

    /**
     * @param argument A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("hfcdtuwggnkpmqdk")
    public suspend fun userDefinedValues(argument: List<suspend InsightFiltersUserDefinedValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersUserDefinedValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userDefinedValues = mapped
    }

    /**
     * @param argument A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("qmnjmwstetrlraxy")
    public suspend fun userDefinedValues(vararg argument: suspend InsightFiltersUserDefinedValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersUserDefinedValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userDefinedValues = mapped
    }

    /**
     * @param argument A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("akhccttxpualfhor")
    public suspend fun userDefinedValues(argument: suspend InsightFiltersUserDefinedValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersUserDefinedValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.userDefinedValues = mapped
    }

    /**
     * @param values A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
     */
    @JvmName("nocvujtokiflytxs")
    public suspend fun userDefinedValues(vararg values: InsightFiltersUserDefinedValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userDefinedValues = mapped
    }

    /**
     * @param value The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("wdayybvywtesdqds")
    public suspend fun verificationStates(`value`: List<InsightFiltersVerificationStateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationStates = mapped
    }

    /**
     * @param argument The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("kuxcrmhrbuwptocp")
    public suspend fun verificationStates(argument: List<suspend InsightFiltersVerificationStateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersVerificationStateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.verificationStates = mapped
    }

    /**
     * @param argument The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("oqrbdjkgdtlkpnkt")
    public suspend fun verificationStates(vararg argument: suspend InsightFiltersVerificationStateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersVerificationStateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.verificationStates = mapped
    }

    /**
     * @param argument The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("slwknulovqddlheo")
    public suspend fun verificationStates(argument: suspend InsightFiltersVerificationStateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersVerificationStateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.verificationStates = mapped
    }

    /**
     * @param values The veracity of a finding. See String Filter below for more details.
     */
    @JvmName("ixbwxexvfwgxjfup")
    public suspend fun verificationStates(vararg values: InsightFiltersVerificationStateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verificationStates = mapped
    }

    /**
     * @param value The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("ofyrbmjribejdppl")
    public suspend fun workflowStatuses(`value`: List<InsightFiltersWorkflowStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowStatuses = mapped
    }

    /**
     * @param argument The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("ifvpkivseswgbefp")
    public suspend fun workflowStatuses(argument: List<suspend InsightFiltersWorkflowStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InsightFiltersWorkflowStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workflowStatuses = mapped
    }

    /**
     * @param argument The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("kunavkjidugvorcf")
    public suspend fun workflowStatuses(vararg argument: suspend InsightFiltersWorkflowStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InsightFiltersWorkflowStatusArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workflowStatuses = mapped
    }

    /**
     * @param argument The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("avwpjtcntbkwbash")
    public suspend fun workflowStatuses(argument: suspend InsightFiltersWorkflowStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InsightFiltersWorkflowStatusArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workflowStatuses = mapped
    }

    /**
     * @param values The status of the investigation into a finding. See Workflow Status Filter below for more details.
     */
    @JvmName("wnndnyenrmyfvxbv")
    public suspend fun workflowStatuses(vararg values: InsightFiltersWorkflowStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowStatuses = mapped
    }

    internal fun build(): InsightFiltersArgs = InsightFiltersArgs(
        awsAccountIds = awsAccountIds,
        companyNames = companyNames,
        complianceStatuses = complianceStatuses,
        confidences = confidences,
        createdAts = createdAts,
        criticalities = criticalities,
        descriptions = descriptions,
        findingProviderFieldsConfidences = findingProviderFieldsConfidences,
        findingProviderFieldsCriticalities = findingProviderFieldsCriticalities,
        findingProviderFieldsRelatedFindingsIds = findingProviderFieldsRelatedFindingsIds,
        findingProviderFieldsRelatedFindingsProductArns = findingProviderFieldsRelatedFindingsProductArns,
        findingProviderFieldsSeverityLabels = findingProviderFieldsSeverityLabels,
        findingProviderFieldsSeverityOriginals = findingProviderFieldsSeverityOriginals,
        findingProviderFieldsTypes = findingProviderFieldsTypes,
        firstObservedAts = firstObservedAts,
        generatorIds = generatorIds,
        ids = ids,
        keywords = keywords,
        lastObservedAts = lastObservedAts,
        malwareNames = malwareNames,
        malwarePaths = malwarePaths,
        malwareStates = malwareStates,
        malwareTypes = malwareTypes,
        networkDestinationDomains = networkDestinationDomains,
        networkDestinationIpv4s = networkDestinationIpv4s,
        networkDestinationIpv6s = networkDestinationIpv6s,
        networkDestinationPorts = networkDestinationPorts,
        networkDirections = networkDirections,
        networkProtocols = networkProtocols,
        networkSourceDomains = networkSourceDomains,
        networkSourceIpv4s = networkSourceIpv4s,
        networkSourceIpv6s = networkSourceIpv6s,
        networkSourceMacs = networkSourceMacs,
        networkSourcePorts = networkSourcePorts,
        noteTexts = noteTexts,
        noteUpdatedAts = noteUpdatedAts,
        noteUpdatedBies = noteUpdatedBies,
        processLaunchedAts = processLaunchedAts,
        processNames = processNames,
        processParentPids = processParentPids,
        processPaths = processPaths,
        processPids = processPids,
        processTerminatedAts = processTerminatedAts,
        productArns = productArns,
        productFields = productFields,
        productNames = productNames,
        recommendationTexts = recommendationTexts,
        recordStates = recordStates,
        relatedFindingsIds = relatedFindingsIds,
        relatedFindingsProductArns = relatedFindingsProductArns,
        resourceAwsEc2InstanceIamInstanceProfileArns = resourceAwsEc2InstanceIamInstanceProfileArns,
        resourceAwsEc2InstanceImageIds = resourceAwsEc2InstanceImageIds,
        resourceAwsEc2InstanceIpv4Addresses = resourceAwsEc2InstanceIpv4Addresses,
        resourceAwsEc2InstanceIpv6Addresses = resourceAwsEc2InstanceIpv6Addresses,
        resourceAwsEc2InstanceKeyNames = resourceAwsEc2InstanceKeyNames,
        resourceAwsEc2InstanceLaunchedAts = resourceAwsEc2InstanceLaunchedAts,
        resourceAwsEc2InstanceSubnetIds = resourceAwsEc2InstanceSubnetIds,
        resourceAwsEc2InstanceTypes = resourceAwsEc2InstanceTypes,
        resourceAwsEc2InstanceVpcIds = resourceAwsEc2InstanceVpcIds,
        resourceAwsIamAccessKeyCreatedAts = resourceAwsIamAccessKeyCreatedAts,
        resourceAwsIamAccessKeyStatuses = resourceAwsIamAccessKeyStatuses,
        resourceAwsIamAccessKeyUserNames = resourceAwsIamAccessKeyUserNames,
        resourceAwsS3BucketOwnerIds = resourceAwsS3BucketOwnerIds,
        resourceAwsS3BucketOwnerNames = resourceAwsS3BucketOwnerNames,
        resourceContainerImageIds = resourceContainerImageIds,
        resourceContainerImageNames = resourceContainerImageNames,
        resourceContainerLaunchedAts = resourceContainerLaunchedAts,
        resourceContainerNames = resourceContainerNames,
        resourceDetailsOthers = resourceDetailsOthers,
        resourceIds = resourceIds,
        resourcePartitions = resourcePartitions,
        resourceRegions = resourceRegions,
        resourceTags = resourceTags,
        resourceTypes = resourceTypes,
        severityLabels = severityLabels,
        sourceUrls = sourceUrls,
        threatIntelIndicatorCategories = threatIntelIndicatorCategories,
        threatIntelIndicatorLastObservedAts = threatIntelIndicatorLastObservedAts,
        threatIntelIndicatorSourceUrls = threatIntelIndicatorSourceUrls,
        threatIntelIndicatorSources = threatIntelIndicatorSources,
        threatIntelIndicatorTypes = threatIntelIndicatorTypes,
        threatIntelIndicatorValues = threatIntelIndicatorValues,
        titles = titles,
        types = types,
        updatedAts = updatedAts,
        userDefinedValues = userDefinedValues,
        verificationStates = verificationStates,
        workflowStatuses = workflowStatuses,
    )
}
