@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersCriticalityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eq The equal-to condition to be applied to a single field when querying for findings, provided as a String.
 * @property gte The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 * @property lte The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 */
public data class InsightFiltersCriticalityArgs(
    public val eq: Output<String>? = null,
    public val gte: Output<String>? = null,
    public val lte: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersCriticalityArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersCriticalityArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersCriticalityArgs.builder()
            .eq(eq?.applyValue({ args0 -> args0 }))
            .gte(gte?.applyValue({ args0 -> args0 }))
            .lte(lte?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersCriticalityArgs].
 */
@PulumiTagMarker
public class InsightFiltersCriticalityArgsBuilder internal constructor() {
    private var eq: Output<String>? = null

    private var gte: Output<String>? = null

    private var lte: Output<String>? = null

    /**
     * @param value The equal-to condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("qalymlgxbbisdurq")
    public suspend fun eq(`value`: Output<String>) {
        this.eq = value
    }

    /**
     * @param value The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("rytpfrthhixwirdm")
    public suspend fun gte(`value`: Output<String>) {
        this.gte = value
    }

    /**
     * @param value The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("jmbbxommjcxxskiy")
    public suspend fun lte(`value`: Output<String>) {
        this.lte = value
    }

    /**
     * @param value The equal-to condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("yakelvfefxenxlma")
    public suspend fun eq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eq = mapped
    }

    /**
     * @param value The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("wdwkaekathamynyu")
    public suspend fun gte(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gte = mapped
    }

    /**
     * @param value The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("ypfixmmhpgtavdta")
    public suspend fun lte(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lte = mapped
    }

    internal fun build(): InsightFiltersCriticalityArgs = InsightFiltersCriticalityArgs(
        eq = eq,
        gte = gte,
        lte = lte,
    )
}
