@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersMalwareStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison
 * @property value
 */
public data class InsightFiltersMalwareStateArgs(
    public val comparison: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersMalwareStateArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersMalwareStateArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersMalwareStateArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersMalwareStateArgs].
 */
@PulumiTagMarker
public class InsightFiltersMalwareStateArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("hpnefxytlqoyjmcq")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value
     */
    @JvmName("oiueufjhgricmaif")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("nvvpiwuhoeoaaoeb")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value
     */
    @JvmName("eugwbqsycrsmjugs")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): InsightFiltersMalwareStateArgs = InsightFiltersMalwareStateArgs(
        comparison = comparison ?: throw PulumiNullFieldException("comparison"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
