@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourceIpv4Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidr A finding's CIDR value.
 */
public data class InsightFiltersNetworkSourceIpv4Args(
    public val cidr: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourceIpv4Args> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourceIpv4Args =
        com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourceIpv4Args.builder()
            .cidr(cidr.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersNetworkSourceIpv4Args].
 */
@PulumiTagMarker
public class InsightFiltersNetworkSourceIpv4ArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    /**
     * @param value A finding's CIDR value.
     */
    @JvmName("xdqkmcnlpalcsgrt")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value A finding's CIDR value.
     */
    @JvmName("baojbqtcxelbssgj")
    public suspend fun cidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    internal fun build(): InsightFiltersNetworkSourceIpv4Args = InsightFiltersNetworkSourceIpv4Args(
        cidr = cidr ?: throw PulumiNullFieldException("cidr"),
    )
}
