@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourcePortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eq The equal-to condition to be applied to a single field when querying for findings, provided as a String.
 * @property gte The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 * @property lte The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 */
public data class InsightFiltersNetworkSourcePortArgs(
    public val eq: Output<String>? = null,
    public val gte: Output<String>? = null,
    public val lte: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourcePortArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourcePortArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersNetworkSourcePortArgs.builder()
            .eq(eq?.applyValue({ args0 -> args0 }))
            .gte(gte?.applyValue({ args0 -> args0 }))
            .lte(lte?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersNetworkSourcePortArgs].
 */
@PulumiTagMarker
public class InsightFiltersNetworkSourcePortArgsBuilder internal constructor() {
    private var eq: Output<String>? = null

    private var gte: Output<String>? = null

    private var lte: Output<String>? = null

    /**
     * @param value The equal-to condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("vjmwayardcyseuyx")
    public suspend fun eq(`value`: Output<String>) {
        this.eq = value
    }

    /**
     * @param value The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("sfuunbqfvvasluia")
    public suspend fun gte(`value`: Output<String>) {
        this.gte = value
    }

    /**
     * @param value The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("cfvtmyodblovkdtt")
    public suspend fun lte(`value`: Output<String>) {
        this.lte = value
    }

    /**
     * @param value The equal-to condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("anxjpokvriwwaimm")
    public suspend fun eq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eq = mapped
    }

    /**
     * @param value The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("edqlqsuaukrounkn")
    public suspend fun gte(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gte = mapped
    }

    /**
     * @param value The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
     */
    @JvmName("juixvjafcfgirxfh")
    public suspend fun lte(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lte = mapped
    }

    internal fun build(): InsightFiltersNetworkSourcePortArgs = InsightFiltersNetworkSourcePortArgs(
        eq = eq,
        gte = gte,
        lte = lte,
    )
}
