@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersProductFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison
 * @property key The key of the map filter. For example, for `ResourceTags`, `Key` identifies the name of the tag. For `UserDefinedFields`, `Key` is the name of the field.
 * @property value
 */
public data class InsightFiltersProductFieldArgs(
    public val comparison: Output<String>,
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersProductFieldArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersProductFieldArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersProductFieldArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersProductFieldArgs].
 */
@PulumiTagMarker
public class InsightFiltersProductFieldArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qwdixjjtimnmkvyk")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value The key of the map filter. For example, for `ResourceTags`, `Key` identifies the name of the tag. For `UserDefinedFields`, `Key` is the name of the field.
     */
    @JvmName("rquwxdfmcvkjpqmt")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("nkcxljefyfjquurv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("vanylmehgnsbgexo")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value The key of the map filter. For example, for `ResourceTags`, `Key` identifies the name of the tag. For `UserDefinedFields`, `Key` is the name of the field.
     */
    @JvmName("ktkfwpgqqkgidtee")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("fqwcftuiwyjubjdn")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): InsightFiltersProductFieldArgs = InsightFiltersProductFieldArgs(
        comparison = comparison ?: throw PulumiNullFieldException("comparison"),
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
