@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidr A finding's CIDR value.
 */
public data class InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs(
    public val cidr: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs.builder()
            .cidr(cidr.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs].
 */
@PulumiTagMarker
public class InsightFiltersResourceAwsEc2InstanceIpv6AddressArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    /**
     * @param value A finding's CIDR value.
     */
    @JvmName("cdrkoxfyksleevnp")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value A finding's CIDR value.
     */
    @JvmName("ysuvnoqomojyhslc")
    public suspend fun cidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    internal fun build(): InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs =
        InsightFiltersResourceAwsEc2InstanceIpv6AddressArgs(
            cidr = cidr ?: throw PulumiNullFieldException("cidr"),
        )
}
