@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersThreatIntelIndicatorValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison
 * @property value
 */
public data class InsightFiltersThreatIntelIndicatorValueArgs(
    public val comparison: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersThreatIntelIndicatorValueArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersThreatIntelIndicatorValueArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersThreatIntelIndicatorValueArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersThreatIntelIndicatorValueArgs].
 */
@PulumiTagMarker
public class InsightFiltersThreatIntelIndicatorValueArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xfqyadjokgbbgrjw")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value
     */
    @JvmName("qeloxtyxhfqqdhcb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("qnngsmcdujeofquk")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value
     */
    @JvmName("runwkklnqitvelty")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): InsightFiltersThreatIntelIndicatorValueArgs =
        InsightFiltersThreatIntelIndicatorValueArgs(
            comparison = comparison ?: throw PulumiNullFieldException("comparison"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
