@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.OrganizationConfigurationOrganizationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationType Indicates whether the organization uses local or central configuration. If using central configuration, `auto_enable` must be set to `false` and `auto_enable_standards` set to `NONE`. More information can be found in the [documentation for central configuration](https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html). Valid values: `LOCAL`, `CENTRAL`.
 */
public data class OrganizationConfigurationOrganizationConfigurationArgs(
    public val configurationType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.OrganizationConfigurationOrganizationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.OrganizationConfigurationOrganizationConfigurationArgs =
        com.pulumi.aws.securityhub.inputs.OrganizationConfigurationOrganizationConfigurationArgs.builder()
            .configurationType(configurationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationOrganizationConfigurationArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationOrganizationConfigurationArgsBuilder internal constructor() {
    private var configurationType: Output<String>? = null

    /**
     * @param value Indicates whether the organization uses local or central configuration. If using central configuration, `auto_enable` must be set to `false` and `auto_enable_standards` set to `NONE`. More information can be found in the [documentation for central configuration](https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html). Valid values: `LOCAL`, `CENTRAL`.
     */
    @JvmName("xitjdaqsamnueabm")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value Indicates whether the organization uses local or central configuration. If using central configuration, `auto_enable` must be set to `false` and `auto_enable_standards` set to `NONE`. More information can be found in the [documentation for central configuration](https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html). Valid values: `LOCAL`, `CENTRAL`.
     */
    @JvmName("obdbrdwspqsbsvpg")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    internal fun build(): OrganizationConfigurationOrganizationConfigurationArgs =
        OrganizationConfigurationOrganizationConfigurationArgs(
            configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        )
}
