@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property findingFieldsUpdate A block that specifies that the automation rule action is an update to a finding field.  Documented below.
 * @property type Specifies that the rule action should update the `Types` finding field. The `Types` finding field classifies findings in the format of namespace/category/classifier.
 */
public data class AutomationRuleAction(
    public val findingFieldsUpdate: AutomationRuleActionFindingFieldsUpdate? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.AutomationRuleAction): AutomationRuleAction = AutomationRuleAction(
            findingFieldsUpdate = javaType.findingFieldsUpdate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleActionFindingFieldsUpdate.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
