@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property confidence The rule action updates the `Confidence` field of a finding.
 * @property criticality The rule action updates the `Criticality` field of a finding.
 * @property note A resource block that updates the note. Documented below.
 * @property relatedFindings A resource block that the rule action updates the `RelatedFindings` field of a finding. Documented below.
 * @property severity A resource block that updates to the severity information for a finding. Documented below.
 * @property types The rule action updates the `Types` field of a finding.
 * @property userDefinedFields The rule action updates the `UserDefinedFields` field of a finding.
 * @property verificationState The rule action updates the `VerificationState` field of a finding. The allowed values are the following `UNKNOWN`, `TRUE_POSITIVE`, `FALSE_POSITIVE` and `BENIGN_POSITIVE`.
 * @property workflow A resource block that is used to update information about the investigation into the finding. Documented below.
 */
public data class AutomationRuleActionFindingFieldsUpdate(
    public val confidence: Int? = null,
    public val criticality: Int? = null,
    public val note: AutomationRuleActionFindingFieldsUpdateNote? = null,
    public val relatedFindings: List<AutomationRuleActionFindingFieldsUpdateRelatedFinding>? = null,
    public val severity: AutomationRuleActionFindingFieldsUpdateSeverity? = null,
    public val types: List<String>? = null,
    public val userDefinedFields: Map<String, String>? = null,
    public val verificationState: String? = null,
    public val workflow: AutomationRuleActionFindingFieldsUpdateWorkflow? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.AutomationRuleActionFindingFieldsUpdate): AutomationRuleActionFindingFieldsUpdate = AutomationRuleActionFindingFieldsUpdate(
            confidence = javaType.confidence().map({ args0 -> args0 }).orElse(null),
            criticality = javaType.criticality().map({ args0 -> args0 }).orElse(null),
            note = javaType.note().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleActionFindingFieldsUpdateNote.Companion.toKotlin(args0)
                })
            }).orElse(null),
            relatedFindings = javaType.relatedFindings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleActionFindingFieldsUpdateRelatedFinding.Companion.toKotlin(args0)
                })
            }),
            severity = javaType.severity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleActionFindingFieldsUpdateSeverity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            types = javaType.types().map({ args0 -> args0 }),
            userDefinedFields = javaType.userDefinedFields().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            verificationState = javaType.verificationState().map({ args0 -> args0 }).orElse(null),
            workflow = javaType.workflow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleActionFindingFieldsUpdateWorkflow.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
