@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property label The severity value of the finding. The allowed values are the following `INFORMATIONAL`, `LOW`, `MEDIUM`, `HIGH` and `CRITICAL`.
 * @property product The native severity as defined by the AWS service or integrated partner product that generated the finding.
 */
public data class AutomationRuleActionFindingFieldsUpdateSeverity(
    public val label: String? = null,
    public val product: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.AutomationRuleActionFindingFieldsUpdateSeverity): AutomationRuleActionFindingFieldsUpdateSeverity =
            AutomationRuleActionFindingFieldsUpdateSeverity(
                label = javaType.label().map({ args0 -> args0 }).orElse(null),
                product = javaType.product().map({ args0 -> args0 }).orElse(null),
            )
    }
}
