@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property awsAccountIds The AWS account ID in which a finding was generated. Documented below.
 * @property awsAccountNames The name of the AWS account in which a finding was generated. Documented below.
 * @property companyNames The name of the company for the product that generated the finding. For control-based findings, the company is AWS. Documented below.
 * @property complianceAssociatedStandardsIds The unique identifier of a standard in which a control is enabled. Documented below.
 * @property complianceSecurityControlIds The security control ID for which a finding was generated. Security control IDs are the same across standards. Documented below.
 * @property complianceStatuses The result of a security check. This field is only used for findings generated from controls. Documented below.
 * @property confidences The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. Documented below.
 * @property createdAts A timestamp that indicates when this finding record was created. Documented below.
 * @property criticalities The level of importance that is assigned to the resources that are associated with a finding. Documented below.
 * @property descriptions A finding's description. Documented below.
 * @property firstObservedAts A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product. Documented below.
 * @property generatorIds The identifier for the solution-specific component that generated a finding. Documented below.
 * @property ids The product-specific identifier for a finding. Documented below.
 * @property lastObservedAts A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product. Documented below.
 * @property noteTexts The text of a user-defined note that's added to a finding. Documented below.
 * @property noteUpdatedAts The timestamp of when the note was updated. Documented below.
 * @property noteUpdatedBies The principal that created a note. Documented below.
 * @property productArns The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub. Documented below.
 * @property productNames Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub. Documented below.
 * @property recordStates Provides the current state of a finding. Documented below.
 * @property relatedFindingsIds The product-generated identifier for a related finding.  Documented below.
 * @property relatedFindingsProductArns The ARN for the product that generated a related finding. Documented below.
 * @property resourceApplicationArns The Amazon Resource Name (ARN) of the application that is related to a finding. Documented below.
 * @property resourceApplicationNames The name of the application that is related to a finding. Documented below.
 * @property resourceDetailsOthers Custom fields and values about the resource that a finding pertains to. Documented below.
 * @property resourceIds The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non-AWS resources, this is a unique identifier that is associated with the resource. Documented below.
 * @property resourcePartitions The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions. Each AWS account is scoped to one partition. Documented below.
 * @property resourceRegions The AWS Region where the resource that a finding pertains to is located. Documented below.
 * @property resourceTags A list of AWS tags associated with a resource at the time the finding was processed. Documented below.
 * @property resourceTypes The type of resource that the finding pertains to. Documented below.
 * @property severityLabels The severity value of the finding. Documented below.
 * @property sourceUrls Provides a URL that links to a page about the current finding in the finding product. Documented below.
 * @property titles A finding's title. Documented below.
 * @property types One or more finding types in the format of namespace/category/classifier that classify a finding. Documented below.
 * @property updatedAts A timestamp that indicates when the finding record was most recently updated. Documented below.
 * @property userDefinedFields A list of user-defined name and value string pairs added to a finding. Documented below.
 * @property verificationStates Provides the veracity of a finding. Documented below.
 * @property workflowStatuses Provides information about the status of the investigation into a finding. Documented below.
 */
public data class AutomationRuleCriteria(
    public val awsAccountIds: List<AutomationRuleCriteriaAwsAccountId>? = null,
    public val awsAccountNames: List<AutomationRuleCriteriaAwsAccountName>? = null,
    public val companyNames: List<AutomationRuleCriteriaCompanyName>? = null,
    public val complianceAssociatedStandardsIds: List<AutomationRuleCriteriaComplianceAssociatedStandardsId>? = null,
    public val complianceSecurityControlIds: List<AutomationRuleCriteriaComplianceSecurityControlId>? =
        null,
    public val complianceStatuses: List<AutomationRuleCriteriaComplianceStatus>? = null,
    public val confidences: List<AutomationRuleCriteriaConfidence>? = null,
    public val createdAts: List<AutomationRuleCriteriaCreatedAt>? = null,
    public val criticalities: List<AutomationRuleCriteriaCriticality>? = null,
    public val descriptions: List<AutomationRuleCriteriaDescription>? = null,
    public val firstObservedAts: List<AutomationRuleCriteriaFirstObservedAt>? = null,
    public val generatorIds: List<AutomationRuleCriteriaGeneratorId>? = null,
    public val ids: List<AutomationRuleCriteriaId>? = null,
    public val lastObservedAts: List<AutomationRuleCriteriaLastObservedAt>? = null,
    public val noteTexts: List<AutomationRuleCriteriaNoteText>? = null,
    public val noteUpdatedAts: List<AutomationRuleCriteriaNoteUpdatedAt>? = null,
    public val noteUpdatedBies: List<AutomationRuleCriteriaNoteUpdatedBy>? = null,
    public val productArns: List<AutomationRuleCriteriaProductArn>? = null,
    public val productNames: List<AutomationRuleCriteriaProductName>? = null,
    public val recordStates: List<AutomationRuleCriteriaRecordState>? = null,
    public val relatedFindingsIds: List<AutomationRuleCriteriaRelatedFindingsId>? = null,
    public val relatedFindingsProductArns: List<AutomationRuleCriteriaRelatedFindingsProductArn>? =
        null,
    public val resourceApplicationArns: List<AutomationRuleCriteriaResourceApplicationArn>? = null,
    public val resourceApplicationNames: List<AutomationRuleCriteriaResourceApplicationName>? = null,
    public val resourceDetailsOthers: List<AutomationRuleCriteriaResourceDetailsOther>? = null,
    public val resourceIds: List<AutomationRuleCriteriaResourceId>? = null,
    public val resourcePartitions: List<AutomationRuleCriteriaResourcePartition>? = null,
    public val resourceRegions: List<AutomationRuleCriteriaResourceRegion>? = null,
    public val resourceTags: List<AutomationRuleCriteriaResourceTag>? = null,
    public val resourceTypes: List<AutomationRuleCriteriaResourceType>? = null,
    public val severityLabels: List<AutomationRuleCriteriaSeverityLabel>? = null,
    public val sourceUrls: List<AutomationRuleCriteriaSourceUrl>? = null,
    public val titles: List<AutomationRuleCriteriaTitle>? = null,
    public val types: List<AutomationRuleCriteriaType>? = null,
    public val updatedAts: List<AutomationRuleCriteriaUpdatedAt>? = null,
    public val userDefinedFields: List<AutomationRuleCriteriaUserDefinedField>? = null,
    public val verificationStates: List<AutomationRuleCriteriaVerificationState>? = null,
    public val workflowStatuses: List<AutomationRuleCriteriaWorkflowStatus>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.AutomationRuleCriteria): AutomationRuleCriteria = AutomationRuleCriteria(
            awsAccountIds = javaType.awsAccountIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaAwsAccountId.Companion.toKotlin(args0)
                })
            }),
            awsAccountNames = javaType.awsAccountNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaAwsAccountName.Companion.toKotlin(args0)
                })
            }),
            companyNames = javaType.companyNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaCompanyName.Companion.toKotlin(args0)
                })
            }),
            complianceAssociatedStandardsIds = javaType.complianceAssociatedStandardsIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaComplianceAssociatedStandardsId.Companion.toKotlin(args0)
                })
            }),
            complianceSecurityControlIds = javaType.complianceSecurityControlIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaComplianceSecurityControlId.Companion.toKotlin(args0)
                })
            }),
            complianceStatuses = javaType.complianceStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaComplianceStatus.Companion.toKotlin(args0)
                })
            }),
            confidences = javaType.confidences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaConfidence.Companion.toKotlin(args0)
                })
            }),
            createdAts = javaType.createdAts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaCreatedAt.Companion.toKotlin(args0)
                })
            }),
            criticalities = javaType.criticalities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaCriticality.Companion.toKotlin(args0)
                })
            }),
            descriptions = javaType.descriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaDescription.Companion.toKotlin(args0)
                })
            }),
            firstObservedAts = javaType.firstObservedAts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaFirstObservedAt.Companion.toKotlin(args0)
                })
            }),
            generatorIds = javaType.generatorIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaGeneratorId.Companion.toKotlin(args0)
                })
            }),
            ids = javaType.ids().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaId.Companion.toKotlin(args0)
                })
            }),
            lastObservedAts = javaType.lastObservedAts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaLastObservedAt.Companion.toKotlin(args0)
                })
            }),
            noteTexts = javaType.noteTexts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaNoteText.Companion.toKotlin(args0)
                })
            }),
            noteUpdatedAts = javaType.noteUpdatedAts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaNoteUpdatedAt.Companion.toKotlin(args0)
                })
            }),
            noteUpdatedBies = javaType.noteUpdatedBies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaNoteUpdatedBy.Companion.toKotlin(args0)
                })
            }),
            productArns = javaType.productArns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaProductArn.Companion.toKotlin(args0)
                })
            }),
            productNames = javaType.productNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaProductName.Companion.toKotlin(args0)
                })
            }),
            recordStates = javaType.recordStates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaRecordState.Companion.toKotlin(args0)
                })
            }),
            relatedFindingsIds = javaType.relatedFindingsIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaRelatedFindingsId.Companion.toKotlin(args0)
                })
            }),
            relatedFindingsProductArns = javaType.relatedFindingsProductArns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaRelatedFindingsProductArn.Companion.toKotlin(args0)
                })
            }),
            resourceApplicationArns = javaType.resourceApplicationArns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceApplicationArn.Companion.toKotlin(args0)
                })
            }),
            resourceApplicationNames = javaType.resourceApplicationNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceApplicationName.Companion.toKotlin(args0)
                })
            }),
            resourceDetailsOthers = javaType.resourceDetailsOthers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceDetailsOther.Companion.toKotlin(args0)
                })
            }),
            resourceIds = javaType.resourceIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceId.Companion.toKotlin(args0)
                })
            }),
            resourcePartitions = javaType.resourcePartitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourcePartition.Companion.toKotlin(args0)
                })
            }),
            resourceRegions = javaType.resourceRegions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceRegion.Companion.toKotlin(args0)
                })
            }),
            resourceTags = javaType.resourceTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceTag.Companion.toKotlin(args0)
                })
            }),
            resourceTypes = javaType.resourceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaResourceType.Companion.toKotlin(args0)
                })
            }),
            severityLabels = javaType.severityLabels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaSeverityLabel.Companion.toKotlin(args0)
                })
            }),
            sourceUrls = javaType.sourceUrls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaSourceUrl.Companion.toKotlin(args0)
                })
            }),
            titles = javaType.titles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaTitle.Companion.toKotlin(args0)
                })
            }),
            types = javaType.types().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaType.Companion.toKotlin(args0)
                })
            }),
            updatedAts = javaType.updatedAts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaUpdatedAt.Companion.toKotlin(args0)
                })
            }),
            userDefinedFields = javaType.userDefinedFields().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaUserDefinedField.Companion.toKotlin(args0)
                })
            }),
            verificationStates = javaType.verificationStates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaVerificationState.Companion.toKotlin(args0)
                })
            }),
            workflowStatuses = javaType.workflowStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.AutomationRuleCriteriaWorkflowStatus.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
