@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property eq The equal-to condition to be applied to a single field when querying for findings, provided as a String.
 * @property gt
 * @property gte The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 * @property lt
 * @property lte The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 */
public data class AutomationRuleCriteriaCriticality(
    public val eq: Double? = null,
    public val gt: Double? = null,
    public val gte: Double? = null,
    public val lt: Double? = null,
    public val lte: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.AutomationRuleCriteriaCriticality): AutomationRuleCriteriaCriticality = AutomationRuleCriteriaCriticality(
            eq = javaType.eq().map({ args0 -> args0 }).orElse(null),
            gt = javaType.gt().map({ args0 -> args0 }).orElse(null),
            gte = javaType.gte().map({ args0 -> args0 }).orElse(null),
            lt = javaType.lt().map({ args0 -> args0 }).orElse(null),
            lte = javaType.lte().map({ args0 -> args0 }).orElse(null),
        )
    }
}
