@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabledStandardArns A list that defines which security standards are enabled in the configuration policy. It must be defined if `service_enabled` is set to true.
 * @property securityControlsConfiguration Defines which security controls are enabled in the configuration policy and any customizations to parameters affecting them. See below.
 * @property serviceEnabled Indicates whether Security Hub is enabled in the policy.
 */
public data class ConfigurationPolicyConfigurationPolicy(
    public val enabledStandardArns: List<String>? = null,
    public val securityControlsConfiguration: ConfigurationPolicyConfigurationPolicySecurityControlsConfiguration? = null,
    public val serviceEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.ConfigurationPolicyConfigurationPolicy): ConfigurationPolicyConfigurationPolicy = ConfigurationPolicyConfigurationPolicy(
            enabledStandardArns = javaType.enabledStandardArns().map({ args0 -> args0 }),
            securityControlsConfiguration = javaType.securityControlsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceEnabled = javaType.serviceEnabled(),
        )
    }
}
