@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property disabledControlIdentifiers A list of security controls that are disabled in the configuration policy Security Hub enables all other controls (including newly released controls) other than the listed controls. Conflicts with `enabled_control_identifiers`.
 * @property enabledControlIdentifiers A list of security controls that are enabled in the configuration policy. Security Hub disables all other controls (including newly released controls) other than the listed controls. Conflicts with `disabled_control_identifiers`.
 * @property securityControlCustomParameters A list of control parameter customizations that are included in a configuration policy. Include multiple blocks to define multiple control custom parameters. See below.
 */
public data class ConfigurationPolicyConfigurationPolicySecurityControlsConfiguration(
    public val disabledControlIdentifiers: List<String>? = null,
    public val enabledControlIdentifiers: List<String>? = null,
    public val securityControlCustomParameters: List<ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameter>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfiguration): ConfigurationPolicyConfigurationPolicySecurityControlsConfiguration =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfiguration(
                disabledControlIdentifiers = javaType.disabledControlIdentifiers().map({ args0 -> args0 }),
                enabledControlIdentifiers = javaType.enabledControlIdentifiers().map({ args0 -> args0 }),
                securityControlCustomParameters = javaType.securityControlCustomParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameter.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
