@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bool The bool `value` for a Boolean-typed Security Hub Control Parameter.
 * @property double The float `value` for a Double-typed Security Hub Control Parameter.
 * @property enum The string `value` for a Enum-typed Security Hub Control Parameter.
 * @property enumList The string list `value` for a EnumList-typed Security Hub Control Parameter.
 * @property int The int `value` for a Int-typed Security Hub Control Parameter.
 * @property intList The int list `value` for a IntList-typed Security Hub Control Parameter.
 * @property name The name of the control parameter. For more information see the [Security Hub controls reference] documentation.
 * @property string The string `value` for a String-typed Security Hub Control Parameter.
 * @property stringList The string list `value` for a StringList-typed Security Hub Control Parameter.
 * @property valueType Identifies whether a control parameter uses a custom user-defined value or subscribes to the default Security Hub behavior. Valid values: `DEFAULT`, `CUSTOM`.
 */
public data class
ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameter(
    public val bool: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBool? =
        null,
    public val double: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDouble? =
        null,
    public val `enum`: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnum? =
        null,
    public val enumList: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumList? =
        null,
    public val int: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterInt? =
        null,
    public val intList: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntList? =
        null,
    public val name: String,
    public val string: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterString? =
        null,
    public val stringList: ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringList? =
        null,
    public val valueType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameter): ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameter =
            ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameter(
                bool = javaType.bool().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterBool.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                double = javaType.double_().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterDouble.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                `enum` = javaType.enum_().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnum.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enumList = javaType.enumList().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterEnumList.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                int = javaType.int_().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterInt.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                intList = javaType.intList().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterIntList.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name(),
                string = javaType.string().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                stringList = javaType.stringList().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.ConfigurationPolicyConfigurationPolicySecurityControlsConfigurationSecurityControlCustomParameterParameterStringList.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                valueType = javaType.valueType(),
            )
    }
}
