@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dateRange A configuration block of the date range for the date filter. See date_range below for more details.
 * @property end An end date for the date filter. Required with `start` if `date_range` is not specified.
 * @property start A start date for the date filter. Required with `end` if `date_range` is not specified.
 */
public data class InsightFiltersLastObservedAt(
    public val dateRange: InsightFiltersLastObservedAtDateRange? = null,
    public val end: String? = null,
    public val start: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.InsightFiltersLastObservedAt): InsightFiltersLastObservedAt = InsightFiltersLastObservedAt(
            dateRange = javaType.dateRange().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersLastObservedAtDateRange.Companion.toKotlin(args0)
                })
            }).orElse(null),
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            start = javaType.start().map({ args0 -> args0 }).orElse(null),
        )
    }
}
