@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eq The equal-to condition to be applied to a single field when querying for findings, provided as a String.
 * @property gte The greater-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 * @property lte The less-than-equal condition to be applied to a single field when querying for findings, provided as a String.
 */
public data class InsightFiltersProcessPid(
    public val eq: String? = null,
    public val gte: String? = null,
    public val lte: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.InsightFiltersProcessPid): InsightFiltersProcessPid = InsightFiltersProcessPid(
            eq = javaType.eq().map({ args0 -> args0 }).orElse(null),
            gte = javaType.gte().map({ args0 -> args0 }).orElse(null),
            lte = javaType.lte().map({ args0 -> args0 }).orElse(null),
        )
    }
}
