@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configurationType Indicates whether the organization uses local or central configuration. If using central configuration, `auto_enable` must be set to `false` and `auto_enable_standards` set to `NONE`. More information can be found in the [documentation for central configuration](https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html). Valid values: `LOCAL`, `CENTRAL`.
 */
public data class OrganizationConfigurationOrganizationConfiguration(
    public val configurationType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.OrganizationConfigurationOrganizationConfiguration): OrganizationConfigurationOrganizationConfiguration =
            OrganizationConfigurationOrganizationConfiguration(
                configurationType = javaType.configurationType(),
            )
    }
}
