@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.kotlin.outputs.AwsLogSourceSource
import com.pulumi.aws.securitylake.kotlin.outputs.AwsLogSourceSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AwsLogSource].
 */
@PulumiTagMarker
public class AwsLogSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AwsLogSourceArgs = AwsLogSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AwsLogSourceArgsBuilder.() -> Unit) {
        val builder = AwsLogSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AwsLogSource {
        val builtJavaResource = com.pulumi.aws.securitylake.AwsLogSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AwsLogSource(builtJavaResource)
    }
}

/**
 * Resource for managing an Amazon Security Lake AWS Log Source.
 * > **NOTE:** A single `aws.securitylake.AwsLogSource` should be used to configure a log source across all regions and accounts.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating the `aws.securitylake.AwsLogSource`. Use a `depends_on` statement.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.AwsLogSource("example", {source: {
 *     accounts: ["123456789012"],
 *     regions: ["eu-west-1"],
 *     sourceName: "ROUTE53",
 * }}, {
 *     dependsOn: [exampleAwsSecuritylakeDataLake],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.AwsLogSource("example", source={
 *     "accounts": ["123456789012"],
 *     "regions": ["eu-west-1"],
 *     "source_name": "ROUTE53",
 * },
 * opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.AwsLogSource("example", new()
 *     {
 *         Source = new Aws.SecurityLake.Inputs.AwsLogSourceSourceArgs
 *         {
 *             Accounts = new[]
 *             {
 *                 "123456789012",
 *             },
 *             Regions = new[]
 *             {
 *                 "eu-west-1",
 *             },
 *             SourceName = "ROUTE53",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSecuritylakeDataLake,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewAwsLogSource(ctx, "example", &securitylake.AwsLogSourceArgs{
 * 			Source: &securitylake.AwsLogSourceSourceArgs{
 * 				Accounts: pulumi.StringArray{
 * 					pulumi.String("123456789012"),
 * 				},
 * 				Regions: pulumi.StringArray{
 * 					pulumi.String("eu-west-1"),
 * 				},
 * 				SourceName: pulumi.String("ROUTE53"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSecuritylakeDataLake,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.AwsLogSource;
 * import com.pulumi.aws.securitylake.AwsLogSourceArgs;
 * import com.pulumi.aws.securitylake.inputs.AwsLogSourceSourceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AwsLogSource("example", AwsLogSourceArgs.builder()
 *             .source(AwsLogSourceSourceArgs.builder()
 *                 .accounts("123456789012")
 *                 .regions("eu-west-1")
 *                 .sourceName("ROUTE53")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSecuritylakeDataLake)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:AwsLogSource
 *     properties:
 *       source:
 *         accounts:
 *           - '123456789012'
 *         regions:
 *           - eu-west-1
 *         sourceName: ROUTE53
 *     options:
 *       dependson:
 *         - ${exampleAwsSecuritylakeDataLake}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS log sources using the source name. For example:
 * ```sh
 * $ pulumi import aws:securitylake/awsLogSource:AwsLogSource example ROUTE53
 * ```
 */
public class AwsLogSource internal constructor(
    override val javaResource: com.pulumi.aws.securitylake.AwsLogSource,
) : KotlinCustomResource(javaResource, AwsLogSourceMapper) {
    /**
     * Specify the natively-supported AWS service to add as a source in Security Lake.
     */
    public val source: Output<AwsLogSourceSource>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AwsLogSourceMapper : ResourceMapper<AwsLogSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securitylake.AwsLogSource::class == javaResource::class

    override fun map(javaResource: Resource): AwsLogSource = AwsLogSource(
        javaResource as
            com.pulumi.aws.securitylake.AwsLogSource,
    )
}

/**
 * @see [AwsLogSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AwsLogSource].
 */
public suspend fun awsLogSource(
    name: String,
    block: suspend AwsLogSourceResourceBuilder.() -> Unit,
): AwsLogSource {
    val builder = AwsLogSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AwsLogSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun awsLogSource(name: String): AwsLogSource {
    val builder = AwsLogSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
