@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.AwsLogSourceArgs.builder
import com.pulumi.aws.securitylake.kotlin.inputs.AwsLogSourceSourceArgs
import com.pulumi.aws.securitylake.kotlin.inputs.AwsLogSourceSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon Security Lake AWS Log Source.
 * > **NOTE:** A single `aws.securitylake.AwsLogSource` should be used to configure a log source across all regions and accounts.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating the `aws.securitylake.AwsLogSource`. Use a `depends_on` statement.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.AwsLogSource("example", {source: {
 *     accounts: ["123456789012"],
 *     regions: ["eu-west-1"],
 *     sourceName: "ROUTE53",
 * }}, {
 *     dependsOn: [exampleAwsSecuritylakeDataLake],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.AwsLogSource("example", source={
 *     "accounts": ["123456789012"],
 *     "regions": ["eu-west-1"],
 *     "source_name": "ROUTE53",
 * },
 * opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.AwsLogSource("example", new()
 *     {
 *         Source = new Aws.SecurityLake.Inputs.AwsLogSourceSourceArgs
 *         {
 *             Accounts = new[]
 *             {
 *                 "123456789012",
 *             },
 *             Regions = new[]
 *             {
 *                 "eu-west-1",
 *             },
 *             SourceName = "ROUTE53",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSecuritylakeDataLake,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewAwsLogSource(ctx, "example", &securitylake.AwsLogSourceArgs{
 * 			Source: &securitylake.AwsLogSourceSourceArgs{
 * 				Accounts: pulumi.StringArray{
 * 					pulumi.String("123456789012"),
 * 				},
 * 				Regions: pulumi.StringArray{
 * 					pulumi.String("eu-west-1"),
 * 				},
 * 				SourceName: pulumi.String("ROUTE53"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSecuritylakeDataLake,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.AwsLogSource;
 * import com.pulumi.aws.securitylake.AwsLogSourceArgs;
 * import com.pulumi.aws.securitylake.inputs.AwsLogSourceSourceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AwsLogSource("example", AwsLogSourceArgs.builder()
 *             .source(AwsLogSourceSourceArgs.builder()
 *                 .accounts("123456789012")
 *                 .regions("eu-west-1")
 *                 .sourceName("ROUTE53")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSecuritylakeDataLake)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:AwsLogSource
 *     properties:
 *       source:
 *         accounts:
 *           - '123456789012'
 *         regions:
 *           - eu-west-1
 *         sourceName: ROUTE53
 *     options:
 *       dependson:
 *         - ${exampleAwsSecuritylakeDataLake}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS log sources using the source name. For example:
 * ```sh
 * $ pulumi import aws:securitylake/awsLogSource:AwsLogSource example ROUTE53
 * ```
 * @property source Specify the natively-supported AWS service to add as a source in Security Lake.
 */
public data class AwsLogSourceArgs(
    public val source: Output<AwsLogSourceSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.AwsLogSourceArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.AwsLogSourceArgs =
        com.pulumi.aws.securitylake.AwsLogSourceArgs.builder()
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AwsLogSourceArgs].
 */
@PulumiTagMarker
public class AwsLogSourceArgsBuilder internal constructor() {
    private var source: Output<AwsLogSourceSourceArgs>? = null

    /**
     * @param value Specify the natively-supported AWS service to add as a source in Security Lake.
     */
    @JvmName("qlddutunsaphlerr")
    public suspend fun source(`value`: Output<AwsLogSourceSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Specify the natively-supported AWS service to add as a source in Security Lake.
     */
    @JvmName("seaypxgbihfrqjpp")
    public suspend fun source(`value`: AwsLogSourceSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Specify the natively-supported AWS service to add as a source in Security Lake.
     */
    @JvmName("rnhobxbnpesskxwd")
    public suspend fun source(argument: suspend AwsLogSourceSourceArgsBuilder.() -> Unit) {
        val toBeMapped = AwsLogSourceSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): AwsLogSourceArgs = AwsLogSourceArgs(
        source = source,
    )
}
