@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceAttribute
import com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceConfiguration
import com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceProviderDetail
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceAttribute.Companion.toKotlin as customLogSourceAttributeToKotlin
import com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceConfiguration.Companion.toKotlin as customLogSourceConfigurationToKotlin
import com.pulumi.aws.securitylake.kotlin.outputs.CustomLogSourceProviderDetail.Companion.toKotlin as customLogSourceProviderDetailToKotlin

/**
 * Builder for [CustomLogSource].
 */
@PulumiTagMarker
public class CustomLogSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomLogSourceArgs = CustomLogSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomLogSourceArgsBuilder.() -> Unit) {
        val builder = CustomLogSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomLogSource {
        val builtJavaResource = com.pulumi.aws.securitylake.CustomLogSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomLogSource(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Security Lake Custom Log Source.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating the `aws.securitylake.CustomLogSource`. Use a `depends_on` statement.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.CustomLogSource("example", {
 *     sourceName: "example-name",
 *     sourceVersion: "1.0",
 *     eventClasses: ["FILE_ACTIVITY"],
 *     configuration: {
 *         crawlerConfiguration: {
 *             roleArn: customLog.arn,
 *         },
 *         providerIdentity: {
 *             externalId: "example-id",
 *             principal: "123456789012",
 *         },
 *     },
 * }, {
 *     dependsOn: [exampleAwsSecuritylakeDataLake],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.CustomLogSource("example",
 *     source_name="example-name",
 *     source_version="1.0",
 *     event_classes=["FILE_ACTIVITY"],
 *     configuration={
 *         "crawler_configuration": {
 *             "role_arn": custom_log["arn"],
 *         },
 *         "provider_identity": {
 *             "external_id": "example-id",
 *             "principal": "123456789012",
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.CustomLogSource("example", new()
 *     {
 *         SourceName = "example-name",
 *         SourceVersion = "1.0",
 *         EventClasses = new[]
 *         {
 *             "FILE_ACTIVITY",
 *         },
 *         Configuration = new Aws.SecurityLake.Inputs.CustomLogSourceConfigurationArgs
 *         {
 *             CrawlerConfiguration = new Aws.SecurityLake.Inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs
 *             {
 *                 RoleArn = customLog.Arn,
 *             },
 *             ProviderIdentity = new Aws.SecurityLake.Inputs.CustomLogSourceConfigurationProviderIdentityArgs
 *             {
 *                 ExternalId = "example-id",
 *                 Principal = "123456789012",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSecuritylakeDataLake,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewCustomLogSource(ctx, "example", &securitylake.CustomLogSourceArgs{
 * 			SourceName:    pulumi.String("example-name"),
 * 			SourceVersion: pulumi.String("1.0"),
 * 			EventClasses: pulumi.StringArray{
 * 				pulumi.String("FILE_ACTIVITY"),
 * 			},
 * 			Configuration: &securitylake.CustomLogSourceConfigurationArgs{
 * 				CrawlerConfiguration: &securitylake.CustomLogSourceConfigurationCrawlerConfigurationArgs{
 * 					RoleArn: pulumi.Any(customLog.Arn),
 * 				},
 * 				ProviderIdentity: &securitylake.CustomLogSourceConfigurationProviderIdentityArgs{
 * 					ExternalId: pulumi.String("example-id"),
 * 					Principal:  pulumi.String("123456789012"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSecuritylakeDataLake,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.CustomLogSource;
 * import com.pulumi.aws.securitylake.CustomLogSourceArgs;
 * import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationProviderIdentityArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomLogSource("example", CustomLogSourceArgs.builder()
 *             .sourceName("example-name")
 *             .sourceVersion("1.0")
 *             .eventClasses("FILE_ACTIVITY")
 *             .configuration(CustomLogSourceConfigurationArgs.builder()
 *                 .crawlerConfiguration(CustomLogSourceConfigurationCrawlerConfigurationArgs.builder()
 *                     .roleArn(customLog.arn())
 *                     .build())
 *                 .providerIdentity(CustomLogSourceConfigurationProviderIdentityArgs.builder()
 *                     .externalId("example-id")
 *                     .principal("123456789012")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSecuritylakeDataLake)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:CustomLogSource
 *     properties:
 *       sourceName: example-name
 *       sourceVersion: '1.0'
 *       eventClasses:
 *         - FILE_ACTIVITY
 *       configuration:
 *         crawlerConfiguration:
 *           roleArn: ${customLog.arn}
 *         providerIdentity:
 *           externalId: example-id
 *           principal: '123456789012'
 *     options:
 *       dependson:
 *         - ${exampleAwsSecuritylakeDataLake}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Custom log sources using the source name. For example:
 * ```sh
 * $ pulumi import aws:securitylake/customLogSource:CustomLogSource example example-name
 * ```
 */
public class CustomLogSource internal constructor(
    override val javaResource: com.pulumi.aws.securitylake.CustomLogSource,
) : KotlinCustomResource(javaResource, CustomLogSourceMapper) {
    /**
     * The attributes of a third-party custom source.
     */
    public val attributes: Output<List<CustomLogSourceAttribute>>
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customLogSourceAttributeToKotlin(args0)
                })
            })
        })

    /**
     * The configuration for the third-party custom source.
     */
    public val configuration: Output<CustomLogSourceConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customLogSourceConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
     */
    public val eventClasses: Output<List<String>>?
        get() = javaResource.eventClasses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The details of the log provider for a third-party custom source.
     */
    public val providerDetails: Output<List<CustomLogSourceProviderDetail>>
        get() = javaResource.providerDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customLogSourceProviderDetailToKotlin(args0) })
            })
        })

    /**
     * Specify the name for a third-party custom source.
     * This must be a Regionally unique value.
     * Has a maximum length of 20.
     */
    public val sourceName: Output<String>
        get() = javaResource.sourceName().applyValue({ args0 -> args0 })

    /**
     * Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
     */
    public val sourceVersion: Output<String>
        get() = javaResource.sourceVersion().applyValue({ args0 -> args0 })
}

public object CustomLogSourceMapper : ResourceMapper<CustomLogSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securitylake.CustomLogSource::class == javaResource::class

    override fun map(javaResource: Resource): CustomLogSource = CustomLogSource(
        javaResource as
            com.pulumi.aws.securitylake.CustomLogSource,
    )
}

/**
 * @see [CustomLogSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomLogSource].
 */
public suspend fun customLogSource(
    name: String,
    block: suspend CustomLogSourceResourceBuilder.() -> Unit,
): CustomLogSource {
    val builder = CustomLogSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomLogSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customLogSource(name: String): CustomLogSource {
    val builder = CustomLogSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
