@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.CustomLogSourceArgs.builder
import com.pulumi.aws.securitylake.kotlin.inputs.CustomLogSourceConfigurationArgs
import com.pulumi.aws.securitylake.kotlin.inputs.CustomLogSourceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Security Lake Custom Log Source.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating the `aws.securitylake.CustomLogSource`. Use a `depends_on` statement.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.CustomLogSource("example", {
 *     sourceName: "example-name",
 *     sourceVersion: "1.0",
 *     eventClasses: ["FILE_ACTIVITY"],
 *     configuration: {
 *         crawlerConfiguration: {
 *             roleArn: customLog.arn,
 *         },
 *         providerIdentity: {
 *             externalId: "example-id",
 *             principal: "123456789012",
 *         },
 *     },
 * }, {
 *     dependsOn: [exampleAwsSecuritylakeDataLake],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.CustomLogSource("example",
 *     source_name="example-name",
 *     source_version="1.0",
 *     event_classes=["FILE_ACTIVITY"],
 *     configuration={
 *         "crawler_configuration": {
 *             "role_arn": custom_log["arn"],
 *         },
 *         "provider_identity": {
 *             "external_id": "example-id",
 *             "principal": "123456789012",
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.CustomLogSource("example", new()
 *     {
 *         SourceName = "example-name",
 *         SourceVersion = "1.0",
 *         EventClasses = new[]
 *         {
 *             "FILE_ACTIVITY",
 *         },
 *         Configuration = new Aws.SecurityLake.Inputs.CustomLogSourceConfigurationArgs
 *         {
 *             CrawlerConfiguration = new Aws.SecurityLake.Inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs
 *             {
 *                 RoleArn = customLog.Arn,
 *             },
 *             ProviderIdentity = new Aws.SecurityLake.Inputs.CustomLogSourceConfigurationProviderIdentityArgs
 *             {
 *                 ExternalId = "example-id",
 *                 Principal = "123456789012",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSecuritylakeDataLake,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewCustomLogSource(ctx, "example", &securitylake.CustomLogSourceArgs{
 * 			SourceName:    pulumi.String("example-name"),
 * 			SourceVersion: pulumi.String("1.0"),
 * 			EventClasses: pulumi.StringArray{
 * 				pulumi.String("FILE_ACTIVITY"),
 * 			},
 * 			Configuration: &securitylake.CustomLogSourceConfigurationArgs{
 * 				CrawlerConfiguration: &securitylake.CustomLogSourceConfigurationCrawlerConfigurationArgs{
 * 					RoleArn: pulumi.Any(customLog.Arn),
 * 				},
 * 				ProviderIdentity: &securitylake.CustomLogSourceConfigurationProviderIdentityArgs{
 * 					ExternalId: pulumi.String("example-id"),
 * 					Principal:  pulumi.String("123456789012"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSecuritylakeDataLake,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.CustomLogSource;
 * import com.pulumi.aws.securitylake.CustomLogSourceArgs;
 * import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationCrawlerConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.CustomLogSourceConfigurationProviderIdentityArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomLogSource("example", CustomLogSourceArgs.builder()
 *             .sourceName("example-name")
 *             .sourceVersion("1.0")
 *             .eventClasses("FILE_ACTIVITY")
 *             .configuration(CustomLogSourceConfigurationArgs.builder()
 *                 .crawlerConfiguration(CustomLogSourceConfigurationCrawlerConfigurationArgs.builder()
 *                     .roleArn(customLog.arn())
 *                     .build())
 *                 .providerIdentity(CustomLogSourceConfigurationProviderIdentityArgs.builder()
 *                     .externalId("example-id")
 *                     .principal("123456789012")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSecuritylakeDataLake)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:CustomLogSource
 *     properties:
 *       sourceName: example-name
 *       sourceVersion: '1.0'
 *       eventClasses:
 *         - FILE_ACTIVITY
 *       configuration:
 *         crawlerConfiguration:
 *           roleArn: ${customLog.arn}
 *         providerIdentity:
 *           externalId: example-id
 *           principal: '123456789012'
 *     options:
 *       dependson:
 *         - ${exampleAwsSecuritylakeDataLake}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Custom log sources using the source name. For example:
 * ```sh
 * $ pulumi import aws:securitylake/customLogSource:CustomLogSource example example-name
 * ```
 * @property configuration The configuration for the third-party custom source.
 * @property eventClasses The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
 * @property sourceName Specify the name for a third-party custom source.
 * This must be a Regionally unique value.
 * Has a maximum length of 20.
 * @property sourceVersion Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
 */
public data class CustomLogSourceArgs(
    public val configuration: Output<CustomLogSourceConfigurationArgs>? = null,
    public val eventClasses: Output<List<String>>? = null,
    public val sourceName: Output<String>? = null,
    public val sourceVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.CustomLogSourceArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.CustomLogSourceArgs =
        com.pulumi.aws.securitylake.CustomLogSourceArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventClasses(eventClasses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceName(sourceName?.applyValue({ args0 -> args0 }))
            .sourceVersion(sourceVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLogSourceArgs].
 */
@PulumiTagMarker
public class CustomLogSourceArgsBuilder internal constructor() {
    private var configuration: Output<CustomLogSourceConfigurationArgs>? = null

    private var eventClasses: Output<List<String>>? = null

    private var sourceName: Output<String>? = null

    private var sourceVersion: Output<String>? = null

    /**
     * @param value The configuration for the third-party custom source.
     */
    @JvmName("wuqedfmhocyygqvk")
    public suspend fun configuration(`value`: Output<CustomLogSourceConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
     */
    @JvmName("tssaoowswnsmhdox")
    public suspend fun eventClasses(`value`: Output<List<String>>) {
        this.eventClasses = value
    }

    @JvmName("jhxclqhkwwybbclf")
    public suspend fun eventClasses(vararg values: Output<String>) {
        this.eventClasses = Output.all(values.asList())
    }

    /**
     * @param values The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
     */
    @JvmName("oyqbefcvkacbnqjx")
    public suspend fun eventClasses(values: List<Output<String>>) {
        this.eventClasses = Output.all(values)
    }

    /**
     * @param value Specify the name for a third-party custom source.
     * This must be a Regionally unique value.
     * Has a maximum length of 20.
     */
    @JvmName("pfcfpkdcdvcfshwc")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
     */
    @JvmName("qvysqfaxhptqfvco")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value The configuration for the third-party custom source.
     */
    @JvmName("epvkiihsykywpeqe")
    public suspend fun configuration(`value`: CustomLogSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument The configuration for the third-party custom source.
     */
    @JvmName("cmkhcikliraeeilv")
    public suspend fun configuration(argument: suspend CustomLogSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CustomLogSourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
     */
    @JvmName("qokiqophakowhppd")
    public suspend fun eventClasses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventClasses = mapped
    }

    /**
     * @param values The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake.
     */
    @JvmName("tyxyfxffolbyuyki")
    public suspend fun eventClasses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventClasses = mapped
    }

    /**
     * @param value Specify the name for a third-party custom source.
     * This must be a Regionally unique value.
     * Has a maximum length of 20.
     */
    @JvmName("qdcdwfxnftvpwdbe")
    public suspend fun sourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
     */
    @JvmName("roejbkjuijddmhds")
    public suspend fun sourceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    internal fun build(): CustomLogSourceArgs = CustomLogSourceArgs(
        configuration = configuration,
        eventClasses = eventClasses,
        sourceName = sourceName,
        sourceVersion = sourceVersion,
    )
}
