@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfiguration
import com.pulumi.aws.securitylake.kotlin.outputs.DataLakeTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.securitylake.kotlin.outputs.DataLakeConfiguration.Companion.toKotlin as dataLakeConfigurationToKotlin
import com.pulumi.aws.securitylake.kotlin.outputs.DataLakeTimeouts.Companion.toKotlin as dataLakeTimeoutsToKotlin

/**
 * Builder for [DataLake].
 */
@PulumiTagMarker
public class DataLakeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataLakeArgs = DataLakeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataLakeArgsBuilder.() -> Unit) {
        val builder = DataLakeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataLake {
        val builtJavaResource = com.pulumi.aws.securitylake.DataLake(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataLake(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Security Lake Data Lake.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating other Security Lake resources. Use a `depends_on` statement.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.DataLake("example", {
 *     metaStoreManagerRoleArn: metaStoreManager.arn,
 *     configuration: {
 *         region: "eu-west-1",
 *         encryptionConfigurations: [{
 *             kmsKeyId: "S3_MANAGED_KEY",
 *         }],
 *         lifecycleConfiguration: {
 *             transitions: [
 *                 {
 *                     days: 31,
 *                     storageClass: "STANDARD_IA",
 *                 },
 *                 {
 *                     days: 80,
 *                     storageClass: "ONEZONE_IA",
 *                 },
 *             ],
 *             expiration: {
 *                 days: 300,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.DataLake("example",
 *     meta_store_manager_role_arn=meta_store_manager["arn"],
 *     configuration={
 *         "region": "eu-west-1",
 *         "encryption_configurations": [{
 *             "kms_key_id": "S3_MANAGED_KEY",
 *         }],
 *         "lifecycle_configuration": {
 *             "transitions": [
 *                 {
 *                     "days": 31,
 *                     "storage_class": "STANDARD_IA",
 *                 },
 *                 {
 *                     "days": 80,
 *                     "storage_class": "ONEZONE_IA",
 *                 },
 *             ],
 *             "expiration": {
 *                 "days": 300,
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.DataLake("example", new()
 *     {
 *         MetaStoreManagerRoleArn = metaStoreManager.Arn,
 *         Configuration = new Aws.SecurityLake.Inputs.DataLakeConfigurationArgs
 *         {
 *             Region = "eu-west-1",
 *             EncryptionConfigurations = new[]
 *             {
 *                 new Aws.SecurityLake.Inputs.DataLakeConfigurationEncryptionConfigurationArgs
 *                 {
 *                     KmsKeyId = "S3_MANAGED_KEY",
 *                 },
 *             },
 *             LifecycleConfiguration = new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationArgs
 *             {
 *                 Transitions = new[]
 *                 {
 *                     new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs
 *                     {
 *                         Days = 31,
 *                         StorageClass = "STANDARD_IA",
 *                     },
 *                     new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs
 *                     {
 *                         Days = 80,
 *                         StorageClass = "ONEZONE_IA",
 *                     },
 *                 },
 *                 Expiration = new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs
 *                 {
 *                     Days = 300,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewDataLake(ctx, "example", &securitylake.DataLakeArgs{
 * 			MetaStoreManagerRoleArn: pulumi.Any(metaStoreManager.Arn),
 * 			Configuration: &securitylake.DataLakeConfigurationArgs{
 * 				Region: pulumi.String("eu-west-1"),
 * 				EncryptionConfigurations: securitylake.DataLakeConfigurationEncryptionConfigurationArray{
 * 					&securitylake.DataLakeConfigurationEncryptionConfigurationArgs{
 * 						KmsKeyId: pulumi.String("S3_MANAGED_KEY"),
 * 					},
 * 				},
 * 				LifecycleConfiguration: &securitylake.DataLakeConfigurationLifecycleConfigurationArgs{
 * 					Transitions: securitylake.DataLakeConfigurationLifecycleConfigurationTransitionArray{
 * 						&securitylake.DataLakeConfigurationLifecycleConfigurationTransitionArgs{
 * 							Days:         pulumi.Int(31),
 * 							StorageClass: pulumi.String("STANDARD_IA"),
 * 						},
 * 						&securitylake.DataLakeConfigurationLifecycleConfigurationTransitionArgs{
 * 							Days:         pulumi.Int(80),
 * 							StorageClass: pulumi.String("ONEZONE_IA"),
 * 						},
 * 					},
 * 					Expiration: &securitylake.DataLakeConfigurationLifecycleConfigurationExpirationArgs{
 * 						Days: pulumi.Int(300),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.DataLake;
 * import com.pulumi.aws.securitylake.DataLakeArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLake("example", DataLakeArgs.builder()
 *             .metaStoreManagerRoleArn(metaStoreManager.arn())
 *             .configuration(DataLakeConfigurationArgs.builder()
 *                 .region("eu-west-1")
 *                 .encryptionConfigurations(DataLakeConfigurationEncryptionConfigurationArgs.builder()
 *                     .kmsKeyId("S3_MANAGED_KEY")
 *                     .build())
 *                 .lifecycleConfiguration(DataLakeConfigurationLifecycleConfigurationArgs.builder()
 *                     .transitions(
 *                         DataLakeConfigurationLifecycleConfigurationTransitionArgs.builder()
 *                             .days(31)
 *                             .storageClass("STANDARD_IA")
 *                             .build(),
 *                         DataLakeConfigurationLifecycleConfigurationTransitionArgs.builder()
 *                             .days(80)
 *                             .storageClass("ONEZONE_IA")
 *                             .build())
 *                     .expiration(DataLakeConfigurationLifecycleConfigurationExpirationArgs.builder()
 *                         .days(300)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:DataLake
 *     properties:
 *       metaStoreManagerRoleArn: ${metaStoreManager.arn}
 *       configuration:
 *         region: eu-west-1
 *         encryptionConfigurations:
 *           - kmsKeyId: S3_MANAGED_KEY
 *         lifecycleConfiguration:
 *           transitions:
 *             - days: 31
 *               storageClass: STANDARD_IA
 *             - days: 80
 *               storageClass: ONEZONE_IA
 *           expiration:
 *             days: 300
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.DataLake("example", {
 *     metaStoreManagerRoleArn: metaStoreManager.arn,
 *     configuration: {
 *         region: "eu-west-1",
 *         encryptionConfigurations: [{
 *             kmsKeyId: "S3_MANAGED_KEY",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.DataLake("example",
 *     meta_store_manager_role_arn=meta_store_manager["arn"],
 *     configuration={
 *         "region": "eu-west-1",
 *         "encryption_configurations": [{
 *             "kms_key_id": "S3_MANAGED_KEY",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.DataLake("example", new()
 *     {
 *         MetaStoreManagerRoleArn = metaStoreManager.Arn,
 *         Configuration = new Aws.SecurityLake.Inputs.DataLakeConfigurationArgs
 *         {
 *             Region = "eu-west-1",
 *             EncryptionConfigurations = new[]
 *             {
 *                 new Aws.SecurityLake.Inputs.DataLakeConfigurationEncryptionConfigurationArgs
 *                 {
 *                     KmsKeyId = "S3_MANAGED_KEY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewDataLake(ctx, "example", &securitylake.DataLakeArgs{
 * 			MetaStoreManagerRoleArn: pulumi.Any(metaStoreManager.Arn),
 * 			Configuration: &securitylake.DataLakeConfigurationArgs{
 * 				Region: pulumi.String("eu-west-1"),
 * 				EncryptionConfigurations: securitylake.DataLakeConfigurationEncryptionConfigurationArray{
 * 					&securitylake.DataLakeConfigurationEncryptionConfigurationArgs{
 * 						KmsKeyId: pulumi.String("S3_MANAGED_KEY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.DataLake;
 * import com.pulumi.aws.securitylake.DataLakeArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLake("example", DataLakeArgs.builder()
 *             .metaStoreManagerRoleArn(metaStoreManager.arn())
 *             .configuration(DataLakeConfigurationArgs.builder()
 *                 .region("eu-west-1")
 *                 .encryptionConfigurations(DataLakeConfigurationEncryptionConfigurationArgs.builder()
 *                     .kmsKeyId("S3_MANAGED_KEY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:DataLake
 *     properties:
 *       metaStoreManagerRoleArn: ${metaStoreManager.arn}
 *       configuration:
 *         region: eu-west-1
 *         encryptionConfigurations:
 *           - kmsKeyId: S3_MANAGED_KEY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub standards subscriptions using the standards subscription ARN. For example:
 * ```sh
 * $ pulumi import aws:securitylake/dataLake:DataLake example arn:aws:securitylake:eu-west-1:123456789012:data-lake/default
 * ```
 */
public class DataLake internal constructor(
    override val javaResource: com.pulumi.aws.securitylake.DataLake,
) : KotlinCustomResource(javaResource, DataLakeMapper) {
    /**
     * ARN of the Data Lake.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specify the Region or Regions that will contribute data to the rollup region.
     */
    public val configuration: Output<DataLakeConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataLakeConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
     */
    public val metaStoreManagerRoleArn: Output<String>
        get() = javaResource.metaStoreManagerRoleArn().applyValue({ args0 -> args0 })

    /**
     * The ARN for the Amazon Security Lake Amazon S3 bucket.
     */
    public val s3BucketArn: Output<String>
        get() = javaResource.s3BucketArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<DataLakeTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataLakeTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DataLakeMapper : ResourceMapper<DataLake> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securitylake.DataLake::class == javaResource::class

    override fun map(javaResource: Resource): DataLake = DataLake(
        javaResource as
            com.pulumi.aws.securitylake.DataLake,
    )
}

/**
 * @see [DataLake].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataLake].
 */
public suspend fun dataLake(name: String, block: suspend DataLakeResourceBuilder.() -> Unit): DataLake {
    val builder = DataLakeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataLake].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataLake(name: String): DataLake {
    val builder = DataLakeResourceBuilder()
    builder.name(name)
    return builder.build()
}
