@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.DataLakeArgs.builder
import com.pulumi.aws.securitylake.kotlin.inputs.DataLakeConfigurationArgs
import com.pulumi.aws.securitylake.kotlin.inputs.DataLakeConfigurationArgsBuilder
import com.pulumi.aws.securitylake.kotlin.inputs.DataLakeTimeoutsArgs
import com.pulumi.aws.securitylake.kotlin.inputs.DataLakeTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Security Lake Data Lake.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating other Security Lake resources. Use a `depends_on` statement.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.DataLake("example", {
 *     metaStoreManagerRoleArn: metaStoreManager.arn,
 *     configuration: {
 *         region: "eu-west-1",
 *         encryptionConfigurations: [{
 *             kmsKeyId: "S3_MANAGED_KEY",
 *         }],
 *         lifecycleConfiguration: {
 *             transitions: [
 *                 {
 *                     days: 31,
 *                     storageClass: "STANDARD_IA",
 *                 },
 *                 {
 *                     days: 80,
 *                     storageClass: "ONEZONE_IA",
 *                 },
 *             ],
 *             expiration: {
 *                 days: 300,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.DataLake("example",
 *     meta_store_manager_role_arn=meta_store_manager["arn"],
 *     configuration={
 *         "region": "eu-west-1",
 *         "encryption_configurations": [{
 *             "kms_key_id": "S3_MANAGED_KEY",
 *         }],
 *         "lifecycle_configuration": {
 *             "transitions": [
 *                 {
 *                     "days": 31,
 *                     "storage_class": "STANDARD_IA",
 *                 },
 *                 {
 *                     "days": 80,
 *                     "storage_class": "ONEZONE_IA",
 *                 },
 *             ],
 *             "expiration": {
 *                 "days": 300,
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.DataLake("example", new()
 *     {
 *         MetaStoreManagerRoleArn = metaStoreManager.Arn,
 *         Configuration = new Aws.SecurityLake.Inputs.DataLakeConfigurationArgs
 *         {
 *             Region = "eu-west-1",
 *             EncryptionConfigurations = new[]
 *             {
 *                 new Aws.SecurityLake.Inputs.DataLakeConfigurationEncryptionConfigurationArgs
 *                 {
 *                     KmsKeyId = "S3_MANAGED_KEY",
 *                 },
 *             },
 *             LifecycleConfiguration = new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationArgs
 *             {
 *                 Transitions = new[]
 *                 {
 *                     new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs
 *                     {
 *                         Days = 31,
 *                         StorageClass = "STANDARD_IA",
 *                     },
 *                     new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationTransitionArgs
 *                     {
 *                         Days = 80,
 *                         StorageClass = "ONEZONE_IA",
 *                     },
 *                 },
 *                 Expiration = new Aws.SecurityLake.Inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs
 *                 {
 *                     Days = 300,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewDataLake(ctx, "example", &securitylake.DataLakeArgs{
 * 			MetaStoreManagerRoleArn: pulumi.Any(metaStoreManager.Arn),
 * 			Configuration: &securitylake.DataLakeConfigurationArgs{
 * 				Region: pulumi.String("eu-west-1"),
 * 				EncryptionConfigurations: securitylake.DataLakeConfigurationEncryptionConfigurationArray{
 * 					&securitylake.DataLakeConfigurationEncryptionConfigurationArgs{
 * 						KmsKeyId: pulumi.String("S3_MANAGED_KEY"),
 * 					},
 * 				},
 * 				LifecycleConfiguration: &securitylake.DataLakeConfigurationLifecycleConfigurationArgs{
 * 					Transitions: securitylake.DataLakeConfigurationLifecycleConfigurationTransitionArray{
 * 						&securitylake.DataLakeConfigurationLifecycleConfigurationTransitionArgs{
 * 							Days:         pulumi.Int(31),
 * 							StorageClass: pulumi.String("STANDARD_IA"),
 * 						},
 * 						&securitylake.DataLakeConfigurationLifecycleConfigurationTransitionArgs{
 * 							Days:         pulumi.Int(80),
 * 							StorageClass: pulumi.String("ONEZONE_IA"),
 * 						},
 * 					},
 * 					Expiration: &securitylake.DataLakeConfigurationLifecycleConfigurationExpirationArgs{
 * 						Days: pulumi.Int(300),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.DataLake;
 * import com.pulumi.aws.securitylake.DataLakeArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationLifecycleConfigurationExpirationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLake("example", DataLakeArgs.builder()
 *             .metaStoreManagerRoleArn(metaStoreManager.arn())
 *             .configuration(DataLakeConfigurationArgs.builder()
 *                 .region("eu-west-1")
 *                 .encryptionConfigurations(DataLakeConfigurationEncryptionConfigurationArgs.builder()
 *                     .kmsKeyId("S3_MANAGED_KEY")
 *                     .build())
 *                 .lifecycleConfiguration(DataLakeConfigurationLifecycleConfigurationArgs.builder()
 *                     .transitions(
 *                         DataLakeConfigurationLifecycleConfigurationTransitionArgs.builder()
 *                             .days(31)
 *                             .storageClass("STANDARD_IA")
 *                             .build(),
 *                         DataLakeConfigurationLifecycleConfigurationTransitionArgs.builder()
 *                             .days(80)
 *                             .storageClass("ONEZONE_IA")
 *                             .build())
 *                     .expiration(DataLakeConfigurationLifecycleConfigurationExpirationArgs.builder()
 *                         .days(300)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:DataLake
 *     properties:
 *       metaStoreManagerRoleArn: ${metaStoreManager.arn}
 *       configuration:
 *         region: eu-west-1
 *         encryptionConfigurations:
 *           - kmsKeyId: S3_MANAGED_KEY
 *         lifecycleConfiguration:
 *           transitions:
 *             - days: 31
 *               storageClass: STANDARD_IA
 *             - days: 80
 *               storageClass: ONEZONE_IA
 *           expiration:
 *             days: 300
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.DataLake("example", {
 *     metaStoreManagerRoleArn: metaStoreManager.arn,
 *     configuration: {
 *         region: "eu-west-1",
 *         encryptionConfigurations: [{
 *             kmsKeyId: "S3_MANAGED_KEY",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.DataLake("example",
 *     meta_store_manager_role_arn=meta_store_manager["arn"],
 *     configuration={
 *         "region": "eu-west-1",
 *         "encryption_configurations": [{
 *             "kms_key_id": "S3_MANAGED_KEY",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.DataLake("example", new()
 *     {
 *         MetaStoreManagerRoleArn = metaStoreManager.Arn,
 *         Configuration = new Aws.SecurityLake.Inputs.DataLakeConfigurationArgs
 *         {
 *             Region = "eu-west-1",
 *             EncryptionConfigurations = new[]
 *             {
 *                 new Aws.SecurityLake.Inputs.DataLakeConfigurationEncryptionConfigurationArgs
 *                 {
 *                     KmsKeyId = "S3_MANAGED_KEY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewDataLake(ctx, "example", &securitylake.DataLakeArgs{
 * 			MetaStoreManagerRoleArn: pulumi.Any(metaStoreManager.Arn),
 * 			Configuration: &securitylake.DataLakeConfigurationArgs{
 * 				Region: pulumi.String("eu-west-1"),
 * 				EncryptionConfigurations: securitylake.DataLakeConfigurationEncryptionConfigurationArray{
 * 					&securitylake.DataLakeConfigurationEncryptionConfigurationArgs{
 * 						KmsKeyId: pulumi.String("S3_MANAGED_KEY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.DataLake;
 * import com.pulumi.aws.securitylake.DataLakeArgs;
 * import com.pulumi.aws.securitylake.inputs.DataLakeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLake("example", DataLakeArgs.builder()
 *             .metaStoreManagerRoleArn(metaStoreManager.arn())
 *             .configuration(DataLakeConfigurationArgs.builder()
 *                 .region("eu-west-1")
 *                 .encryptionConfigurations(DataLakeConfigurationEncryptionConfigurationArgs.builder()
 *                     .kmsKeyId("S3_MANAGED_KEY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:DataLake
 *     properties:
 *       metaStoreManagerRoleArn: ${metaStoreManager.arn}
 *       configuration:
 *         region: eu-west-1
 *         encryptionConfigurations:
 *           - kmsKeyId: S3_MANAGED_KEY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Hub standards subscriptions using the standards subscription ARN. For example:
 * ```sh
 * $ pulumi import aws:securitylake/dataLake:DataLake example arn:aws:securitylake:eu-west-1:123456789012:data-lake/default
 * ```
 * @property configuration Specify the Region or Regions that will contribute data to the rollup region.
 * @property metaStoreManagerRoleArn The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class DataLakeArgs(
    public val configuration: Output<DataLakeConfigurationArgs>? = null,
    public val metaStoreManagerRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<DataLakeTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.securitylake.DataLakeArgs> {
    override fun toJava(): com.pulumi.aws.securitylake.DataLakeArgs =
        com.pulumi.aws.securitylake.DataLakeArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metaStoreManagerRoleArn(metaStoreManagerRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataLakeArgs].
 */
@PulumiTagMarker
public class DataLakeArgsBuilder internal constructor() {
    private var configuration: Output<DataLakeConfigurationArgs>? = null

    private var metaStoreManagerRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<DataLakeTimeoutsArgs>? = null

    /**
     * @param value Specify the Region or Regions that will contribute data to the rollup region.
     */
    @JvmName("njkrkyrmanppcgkc")
    public suspend fun configuration(`value`: Output<DataLakeConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
     */
    @JvmName("gwnfqdrgqbuxdfrj")
    public suspend fun metaStoreManagerRoleArn(`value`: Output<String>) {
        this.metaStoreManagerRoleArn = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("urbjqvaalltwflwy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("sxrddcippsdydsrj")
    public suspend fun timeouts(`value`: Output<DataLakeTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Specify the Region or Regions that will contribute data to the rollup region.
     */
    @JvmName("qbrhbvfyxjyanvwx")
    public suspend fun configuration(`value`: DataLakeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Specify the Region or Regions that will contribute data to the rollup region.
     */
    @JvmName("euqdbxvcstewtjsc")
    public suspend fun configuration(argument: suspend DataLakeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) used to create and update the AWS Glue table. This table contains partitions generated by the ingestion and normalization of AWS log sources and custom sources.
     */
    @JvmName("adbjgbuwikmcxjxc")
    public suspend fun metaStoreManagerRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metaStoreManagerRoleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fkgbkkvndterxmhn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ipmyxnvrftarcurb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("fahuuikvlilnbpkt")
    public suspend fun timeouts(`value`: DataLakeTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jehbvalyybjuemwb")
    public suspend fun timeouts(argument: suspend DataLakeTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DataLakeArgs = DataLakeArgs(
        configuration = configuration,
        metaStoreManagerRoleArn = metaStoreManagerRoleArn,
        tags = tags,
        timeouts = timeouts,
    )
}
