@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securitylake.kotlin

import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSource
import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSubscriberIdentity
import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSource.Companion.toKotlin as subscriberSourceToKotlin
import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberSubscriberIdentity.Companion.toKotlin as subscriberSubscriberIdentityToKotlin
import com.pulumi.aws.securitylake.kotlin.outputs.SubscriberTimeouts.Companion.toKotlin as subscriberTimeoutsToKotlin

/**
 * Builder for [Subscriber].
 */
@PulumiTagMarker
public class SubscriberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubscriberArgs = SubscriberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubscriberArgsBuilder.() -> Unit) {
        val builder = SubscriberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Subscriber {
        val builtJavaResource = com.pulumi.aws.securitylake.Subscriber(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subscriber(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Security Lake Subscriber.
 * > **NOTE:** The underlying `aws.securitylake.DataLake` must be configured before creating the `aws.securitylake.Subscriber`. Use a `depends_on` statement.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.securitylake.Subscriber("example", {
 *     subscriberName: "example-name",
 *     accessType: "S3",
 *     source: {
 *         awsLogSourceResource: {
 *             sourceName: "ROUTE53",
 *             sourceVersion: "1.0",
 *         },
 *     },
 *     subscriberIdentity: {
 *         externalId: "example",
 *         principal: "1234567890",
 *     },
 * }, {
 *     dependsOn: [exampleAwsSecuritylakeDataLake],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.securitylake.Subscriber("example",
 *     subscriber_name="example-name",
 *     access_type="S3",
 *     source={
 *         "aws_log_source_resource": {
 *             "source_name": "ROUTE53",
 *             "source_version": "1.0",
 *         },
 *     },
 *     subscriber_identity={
 *         "external_id": "example",
 *         "principal": "1234567890",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_securitylake_data_lake]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SecurityLake.Subscriber("example", new()
 *     {
 *         SubscriberName = "example-name",
 *         AccessType = "S3",
 *         Source = new Aws.SecurityLake.Inputs.SubscriberSourceArgs
 *         {
 *             AwsLogSourceResource = new Aws.SecurityLake.Inputs.SubscriberSourceAwsLogSourceResourceArgs
 *             {
 *                 SourceName = "ROUTE53",
 *                 SourceVersion = "1.0",
 *             },
 *         },
 *         SubscriberIdentity = new Aws.SecurityLake.Inputs.SubscriberSubscriberIdentityArgs
 *         {
 *             ExternalId = "example",
 *             Principal = "1234567890",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsSecuritylakeDataLake,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/securitylake"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := securitylake.NewSubscriber(ctx, "example", &securitylake.SubscriberArgs{
 * 			SubscriberName: pulumi.String("example-name"),
 * 			AccessType:     pulumi.String("S3"),
 * 			Source: &securitylake.SubscriberSourceArgs{
 * 				AwsLogSourceResource: &securitylake.SubscriberSourceAwsLogSourceResourceArgs{
 * 					SourceName:    pulumi.String("ROUTE53"),
 * 					SourceVersion: pulumi.String("1.0"),
 * 				},
 * 			},
 * 			SubscriberIdentity: &securitylake.SubscriberSubscriberIdentityArgs{
 * 				ExternalId: pulumi.String("example"),
 * 				Principal:  pulumi.String("1234567890"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsSecuritylakeDataLake,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securitylake.Subscriber;
 * import com.pulumi.aws.securitylake.SubscriberArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberSourceArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberSourceAwsLogSourceResourceArgs;
 * import com.pulumi.aws.securitylake.inputs.SubscriberSubscriberIdentityArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Subscriber("example", SubscriberArgs.builder()
 *             .subscriberName("example-name")
 *             .accessType("S3")
 *             .source(SubscriberSourceArgs.builder()
 *                 .awsLogSourceResource(SubscriberSourceAwsLogSourceResourceArgs.builder()
 *                     .sourceName("ROUTE53")
 *                     .sourceVersion("1.0")
 *                     .build())
 *                 .build())
 *             .subscriberIdentity(SubscriberSubscriberIdentityArgs.builder()
 *                 .externalId("example")
 *                 .principal("1234567890")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsSecuritylakeDataLake)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:securitylake:Subscriber
 *     properties:
 *       subscriberName: example-name
 *       accessType: S3
 *       source:
 *         awsLogSourceResource:
 *           sourceName: ROUTE53
 *           sourceVersion: '1.0'
 *       subscriberIdentity:
 *         externalId: example
 *         principal: '1234567890'
 *     options:
 *       dependson:
 *         - ${exampleAwsSecuritylakeDataLake}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Security Lake subscriber using the subscriber ID. For example:
 * ```sh
 * $ pulumi import aws:securitylake/subscriber:Subscriber example 9f3bfe79-d543-474d-a93c-f3846805d208
 * ```
 */
public class Subscriber internal constructor(
    override val javaResource: com.pulumi.aws.securitylake.Subscriber,
) : KotlinCustomResource(javaResource, SubscriberMapper) {
    /**
     * The Amazon S3 or Lake Formation access type.
     */
    public val accessType: Output<String>
        get() = javaResource.accessType().applyValue({ args0 -> args0 })

    /**
     * ARN of the Data Lake.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) which uniquely defines the AWS RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
     */
    public val resourceShareArn: Output<String>
        get() = javaResource.resourceShareArn().applyValue({ args0 -> args0 })

    /**
     * The name of the resource share.
     */
    public val resourceShareName: Output<String>
        get() = javaResource.resourceShareName().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The ARN for the Amazon Security Lake Amazon S3 bucket.
     */
    public val s3BucketArn: Output<String>
        get() = javaResource.s3BucketArn().applyValue({ args0 -> args0 })

    /**
     * The supported AWS services from which logs and events are collected. Security Lake supports log and event collection for natively supported AWS services. See `source` Blocks below.
     */
    public val source: Output<SubscriberSource>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subscriberSourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The description for your subscriber account in Security Lake.
     */
    public val subscriberDescription: Output<String>?
        get() = javaResource.subscriberDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subscriber endpoint to which exception messages are posted.
     */
    public val subscriberEndpoint: Output<String>
        get() = javaResource.subscriberEndpoint().applyValue({ args0 -> args0 })

    /**
     * The AWS identity used to access your data. See `subscriber_identity` Block below.
     */
    public val subscriberIdentity: Output<SubscriberSubscriberIdentity>?
        get() = javaResource.subscriberIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subscriberSubscriberIdentityToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of your Security Lake subscriber account.
     */
    public val subscriberName: Output<String>?
        get() = javaResource.subscriberName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The subscriber status of the Amazon Security Lake subscriber account.
     */
    public val subscriberStatus: Output<String>
        get() = javaResource.subscriberStatus().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<SubscriberTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subscriberTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object SubscriberMapper : ResourceMapper<Subscriber> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securitylake.Subscriber::class == javaResource::class

    override fun map(javaResource: Resource): Subscriber = Subscriber(
        javaResource as
            com.pulumi.aws.securitylake.Subscriber,
    )
}

/**
 * @see [Subscriber].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subscriber].
 */
public suspend fun subscriber(name: String, block: suspend SubscriberResourceBuilder.() -> Unit): Subscriber {
    val builder = SubscriberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subscriber].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subscriber(name: String): Subscriber {
    val builder = SubscriberResourceBuilder()
    builder.name(name)
    return builder.build()
}
